/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.editor.Lexer;
import com.imsweb.seerutilsgui.editor.LexerToken;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoManager;

public class SyntaxDocument
extends PlainDocument {
    private Lexer _lexer;
    private List<LexerToken> _tokens;
    private UndoManager _undoMgr = new UndoManager();
    private AbstractAction _keyAction;

    public SyntaxDocument(Lexer lexer) {
        this._lexer = lexer;
        this.addUndoableEditListener(evt -> {
            if (evt.getEdit().isSignificant()) {
                this._undoMgr.addEdit(evt.getEdit());
            }
        });
    }

    private void parse() {
        if (this._lexer == null) {
            this._tokens = null;
            return;
        }
        ArrayList<LexerToken> toks = new ArrayList<LexerToken>(this.getLength() / 10);
        try {
            LexerToken token;
            Segment seg = new Segment();
            this.getText(0, this.getLength(), seg);
            CharArrayReader reader = new CharArrayReader(seg.array, seg.offset, seg.count);
            this._lexer.yyreset(reader);
            while ((token = this._lexer.yylex()) != null) {
                toks.add(token);
            }
        }
        catch (IOException | BadLocationException ex) {
            throw new RuntimeException("unable to parse document", ex);
        }
        finally {
            this._tokens = toks;
        }
    }

    public void setKeyAction(AbstractAction e) {
        this._keyAction = e;
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        if (this._keyAction != null) {
            this._keyAction.actionPerformed(null);
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
        if (this._keyAction != null) {
            this._keyAction.actionPerformed(null);
        }
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent e) {
        this.parse();
        super.fireChangedUpdate(e);
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent e) {
        this.parse();
        super.fireInsertUpdate(e);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent e) {
        this.parse();
        super.fireRemoveUpdate(e);
    }

    public void replaceToken(LexerToken token, String replacement) {
        try {
            this.replace(token.start, token.length, replacement, null);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("unable to replace token: " + token, ex);
        }
    }

    public Iterator<LexerToken> getTokens(int start, int end) {
        return new TokenIterator(start, end);
    }

    public LexerToken getTokenAt(int pos) {
        if (this._tokens == null || this._tokens.isEmpty() || pos > this.getLength()) {
            return null;
        }
        LexerToken tok = null;
        LexerToken tKey = new LexerToken(LexerToken.TokenType.DEFAULT, pos, 1);
        int ndx = Collections.binarySearch(this._tokens, tKey);
        if (ndx < 0) {
            ndx = -ndx - 1 - 1 < 0 ? 0 : -ndx - 1 - 1;
            LexerToken t = this._tokens.get(ndx);
            if (t.start <= pos && pos <= t.end()) {
                tok = t;
            }
        } else {
            tok = this._tokens.get(ndx);
        }
        return tok;
    }

    public LexerToken getPairFor(LexerToken t) {
        if (this._tokens == null || t == null || t.pairValue == 0) {
            return null;
        }
        LexerToken p = null;
        int ndx = this._tokens.indexOf(t);
        int w = t.pairValue;
        int direction = t.pairValue > 0 ? 1 : -1;
        boolean done = false;
        int v = Math.abs(t.pairValue);
        while (!done && (ndx += direction) >= 0 && ndx < this._tokens.size()) {
            LexerToken current = this._tokens.get(ndx);
            if (Math.abs(current.pairValue) != v || (w += current.pairValue) != 0) continue;
            p = current;
            done = true;
        }
        return p;
    }

    public Matcher getMatcher(Pattern pattern) {
        return this.getMatcher(pattern, 0, this.getLength());
    }

    public Matcher getMatcher(Pattern pattern, int start) {
        return this.getMatcher(pattern, start, this.getLength() - start);
    }

    public Matcher getMatcher(Pattern pattern, int start, int length) {
        Matcher matcher;
        if (this.getLength() == 0) {
            return null;
        }
        try {
            Segment seg = new Segment();
            this.getText(start, length, seg);
            matcher = pattern.matcher(seg);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Requested offset: " + ex.offsetRequested(), ex);
        }
        return matcher;
    }

    public String getLineAt(int pos) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        Segment seg = new Segment();
        this.getText(e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), seg);
        char last = seg.last();
        if (last == '\n' || last == '\r') {
            return seg.subSequence(0, seg.length() - 1).toString();
        }
        return seg.toString();
    }

    public int getNumberOfLines() {
        return this.getDefaultRootElement().getElementCount();
    }

    public int getStartOfLineFromLineNumber(int lineNumber) {
        return this.getDefaultRootElement().getElement(lineNumber).getStartOffset();
    }

    public void removeLineAt(int pos) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        this.remove(e.getStartOffset(), this.getElementLength(e));
    }

    public void replaceLineAt(int pos, String newLines) throws BadLocationException {
        Element e = this.getParagraphElement(pos);
        this.replace(e.getStartOffset(), this.getElementLength(e), newLines, null);
    }

    private int getElementLength(Element e) {
        int end = e.getEndOffset();
        if (end >= this.getLength() - 1) {
            --end;
        }
        return end - e.getStartOffset();
    }

    public void doUndo() {
        if (this._undoMgr.canUndo()) {
            this._undoMgr.undo();
        }
    }

    public void doRedo() {
        if (this._undoMgr.canRedo()) {
            this._undoMgr.redo();
        }
    }

    public void resetUndoMgr() {
        this._undoMgr.discardAllEdits();
    }

    final class TokenIterator
    implements ListIterator<LexerToken> {
        int _start;
        int _end;
        int _ndx = 0;

        private TokenIterator(int start, int end) {
            this._start = start;
            this._end = end;
            if (SyntaxDocument.this._tokens != null && !SyntaxDocument.this._tokens.isEmpty()) {
                LexerToken token = new LexerToken(LexerToken.TokenType.COMMENT, start, end - start);
                this._ndx = Collections.binarySearch(SyntaxDocument.this._tokens, token);
                if (this._ndx < 0) {
                    this._ndx = -this._ndx - 1 - 1 < 0 ? 0 : -this._ndx - 1 - 1;
                    LexerToken t = (LexerToken)SyntaxDocument.this._tokens.get(this._ndx);
                    if (t.end() <= start) {
                        ++this._ndx;
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (SyntaxDocument.this._tokens == null) {
                return false;
            }
            if (this._ndx >= SyntaxDocument.this._tokens.size()) {
                return false;
            }
            LexerToken t = (LexerToken)SyntaxDocument.this._tokens.get(this._ndx);
            return t.start < this._end;
        }

        @Override
        public LexerToken next() {
            return (LexerToken)SyntaxDocument.this._tokens.get(this._ndx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            if (SyntaxDocument.this._tokens == null) {
                return false;
            }
            if (this._ndx <= 0) {
                return false;
            }
            LexerToken t = (LexerToken)SyntaxDocument.this._tokens.get(this._ndx);
            return t.end() > this._start;
        }

        @Override
        public LexerToken previous() {
            return (LexerToken)SyntaxDocument.this._tokens.get(this._ndx--);
        }

        @Override
        public int nextIndex() {
            return this._ndx + 1;
        }

        @Override
        public int previousIndex() {
            return this._ndx - 1;
        }

        @Override
        public void set(LexerToken e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(LexerToken e) {
            throw new UnsupportedOperationException();
        }
    }
}

