/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.editor.Lexer;
import com.imsweb.seerutilsgui.editor.LexerGroovy;
import com.imsweb.seerutilsgui.editor.LexerProperties;
import com.imsweb.seerutilsgui.editor.LexerSql;
import com.imsweb.seerutilsgui.editor.LexerToken;
import com.imsweb.seerutilsgui.editor.LexerXml;
import com.imsweb.seerutilsgui.editor.SyntaxDocument;
import com.imsweb.seerutilsgui.editor.SyntaxStyles;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class SyntaxKit
extends DefaultEditorKit
implements ViewFactory {
    public static final String SYNTAX_TYPE_PLAIN = "plain";
    public static final String SYNTAX_TYPE_PROPERTIES = "properties";
    public static final String SYNTAX_TYPE_XML = "xml";
    public static final String SYNTAX_TYPE_GROOVY = "groovy";
    public static final String SYNTAX_TYPE_SQL = "sql";
    private transient SyntaxStyles _style;
    private transient Lexer _lexer;

    public SyntaxKit(String type) {
        this(type, null);
    }

    public SyntaxKit(String type, Properties syntaxProperties) {
        if (SYNTAX_TYPE_PLAIN.equals(type)) {
            this._lexer = null;
        } else if (SYNTAX_TYPE_PROPERTIES.equals(type)) {
            this._lexer = new LexerProperties();
        } else if (SYNTAX_TYPE_XML.equals(type)) {
            this._lexer = new LexerXml();
        } else if (SYNTAX_TYPE_GROOVY.equals(type)) {
            this._lexer = new LexerGroovy();
        } else if (SYNTAX_TYPE_SQL.equals(type)) {
            this._lexer = new LexerSql();
        } else {
            throw new RuntimeException("Unsupported type: " + type);
        }
        this._style = new SyntaxStyles(syntaxProperties);
    }

    public void disable() {
        this._style.useDisabled(true);
    }

    public void enable() {
        this._style.useDisabled(false);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element element) {
        return new PlainView(element){

            @Override
            protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) {
                Font saveFont = graphics.getFont();
                Color saveColor = graphics.getColor();
                SyntaxDocument doc = (SyntaxDocument)this.getDocument();
                Segment segment = this.getLineBuffer();
                try {
                    Iterator<LexerToken> i = doc.getTokens(p0, p1);
                    int start = p0;
                    while (i.hasNext()) {
                        LexerToken t = i.next();
                        if (start < t.start) {
                            int length = t.start - start;
                            doc.getText(start, length, segment);
                            x = SyntaxKit.this._style.drawText(segment, x, y, graphics, this, new LexerToken(LexerToken.TokenType.DEFAULT, start, length));
                        }
                        int l = t.length;
                        int s = t.start;
                        if (s < p0) {
                            l -= p0 - s;
                            s = p0;
                        }
                        if (s + l > p1) {
                            l = p1 - s;
                        }
                        doc.getText(s, l, segment);
                        x = SyntaxKit.this._style.drawText(segment, x, y, graphics, this, t);
                        start = t.end();
                    }
                    if (start < p1) {
                        int length = p1 - start;
                        doc.getText(start, length, segment);
                        x = SyntaxKit.this._style.drawText(segment, x, y, graphics, this, new LexerToken(LexerToken.TokenType.DEFAULT, start, length));
                    }
                }
                catch (BadLocationException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    graphics.setFont(saveFont);
                    graphics.setColor(saveColor);
                }
                return x;
            }
        };
    }

    @Override
    public Document createDefaultDocument() {
        return new SyntaxDocument(this._lexer);
    }
}

