/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.editor.LexerToken;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public final class SyntaxStyles {
    private Map<LexerToken.TokenType, SyntaxStyle> _styles = new HashMap<LexerToken.TokenType, SyntaxStyle>();
    private SyntaxStyle _defaultStyle = new SyntaxStyle(Color.BLACK, 0);
    private SyntaxStyle _disabledStyle = new SyntaxStyle(Color.GRAY, 0);
    private boolean _useDisabled = false;

    public SyntaxStyles() {
        this(null);
    }

    public SyntaxStyles(Properties styles) {
        if (styles != null) {
            for (String token : styles.stringPropertyNames()) {
                String stv = styles.getProperty(token);
                try {
                    LexerToken.TokenType tt = LexerToken.TokenType.valueOf(token);
                    String[] parts = stv.split("\\s*,\\s*");
                    if (parts.length != 2) {
                        throw new IllegalArgumentException("style not correct format: " + stv);
                    }
                    this._styles.put(tt, new SyntaxStyle(new Color(Integer.decode(parts[0])), Integer.decode(parts[1])));
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException("illegal token type or style for: " + token);
                }
            }
        }
    }

    public void useDisabled(boolean disabled) {
        this._useDisabled = disabled;
    }

    public int drawText(Segment segment, int x, int y, Graphics graphics, TabExpander e, LexerToken token) {
        if (token == null) {
            throw new RuntimeException("Wasn't expecting a null token but got it");
        }
        SyntaxStyle style = this._useDisabled ? this._disabledStyle : this._styles.get((Object)token.type);
        if (style == null) {
            style = this._defaultStyle;
        }
        return style.drawText(segment, x, y, graphics, e, token.start);
    }

    private static final class SyntaxStyle {
        private Color _color;
        private int _fontStyle;

        public SyntaxStyle(Color color, int fontStyle) {
            this._color = color;
            this._fontStyle = fontStyle;
        }

        public Color getColor() {
            return this._color;
        }

        public int getFontStyle() {
            return this._fontStyle;
        }

        public int drawText(Segment segment, int x, int y, Graphics graphics, TabExpander e, int startOffset) {
            graphics.setFont(graphics.getFont().deriveFont(this.getFontStyle()));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int a = fontMetrics.getAscent();
            int h = a + fontMetrics.getDescent();
            int w = Utilities.getTabbedTextWidth(segment, fontMetrics, 0, e, startOffset);
            int rX = x - 1;
            int rY = y - a;
            int rW = w + 2;
            if ((this.getFontStyle() & 0x10) != 0) {
                graphics.setColor(Color.decode("#EEEEEE"));
                graphics.fillRect(rX, rY, rW, h);
            }
            graphics.setColor(this.getColor());
            x = Utilities.drawTabbedText(segment, x, y, graphics, e, startOffset);
            if ((this.getFontStyle() & 8) != 0) {
                graphics.setColor(Color.RED);
                graphics.drawRect(rX, rY, rW, h);
            }
            return x;
        }
    }
}

