/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.table;

import com.imsweb.seerutilsgui.table.SeerCellEvent;
import com.imsweb.seerutilsgui.table.SeerCellListener;
import com.imsweb.seerutilsgui.table.SeerTable;
import com.imsweb.seerutilsgui.table.SeerTableCheckBox;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class SeerTableCheckBoxEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private SeerTableCheckBox _box;
    private int _row;
    private int _col;
    private JTable _table;
    private boolean _editedByKey;
    private SeerCellListener _cellListener;

    public SeerTableCheckBoxEditor(SeerCellListener l) {
        this._cellListener = l;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e == null) {
            return true;
        }
        if (e instanceof MouseEvent) {
            this._editedByKey = false;
            return true;
        }
        if (e instanceof KeyEvent) {
            this._editedByKey = true;
            return ((KeyEvent)e).getKeyCode() == 10;
        }
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = table.convertRowIndexToModel(row);
        this._col = column;
        this._table = table;
        this._box = (SeerTableCheckBox)value;
        this._box.addActionListener(this);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(SeerTable.COLOR_TABLE_ROW_SELECTED);
        panel.setBorder(SeerTable.TABLE_FOCUSED_CELL_BORDER);
        panel.add(this._box);
        if (this._editedByKey && this._box.isEnabled()) {
            SwingUtilities.invokeLater(() -> {
                this._box.setSelected(this._box.isSelected() ? Boolean.FALSE : Boolean.TRUE);
                this.stopCellEditing();
            });
        }
        return panel;
    }

    @Override
    public boolean stopCellEditing() {
        super.stopCellEditing();
        this._box.removeActionListener(this);
        if (this._cellListener != null && this._box.isEnabled()) {
            this._cellListener.actionPerformed(new SeerCellEvent((Object)this._table, 1, this._box.getActionCommand(), this._row, this._col));
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this._box;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
    }
}

