/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.table;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.table.SeerCellEvent;
import com.imsweb.seerutilsgui.table.SeerCellListener;
import com.imsweb.seerutilsgui.table.SeerColumn;
import com.imsweb.seerutilsgui.table.SeerTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class SeerTableStringEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected JTextArea _field;
    protected int _row;
    protected int _col;
    protected JTable _table;
    protected SeerCellListener _cellListener;

    public SeerTableStringEditor() {
    }

    public SeerTableStringEditor(SeerCellListener l) {
        this();
        this._cellListener = l;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e == null) {
            return true;
        }
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() == 2;
        }
        if (e instanceof KeyEvent) {
            return ((KeyEvent)e).getKeyCode() == 10;
        }
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        int i;
        this._row = table.convertRowIndexToModel(row);
        this._col = column;
        this._table = table;
        this._field = new JTextArea((String)value);
        this._field.setFont(new JLabel().getFont());
        SwingUtilities.invokeLater(() -> {
            this._field.requestFocusInWindow();
            this._field.selectAll();
        });
        SeerColumn colInfo = ((SeerTable)table).getColumnInfo().get(table.convertColumnIndexToModel(column));
        if (!colInfo.getLongText().booleanValue() && (i = this._table.getRowHeight() - this._field.getFontMetrics(new JLabel().getFont()).getHeight()) > 0) {
            this._field.getMargin().top = i / 2;
            this._field.getMargin().bottom = i / 2;
        }
        JPanel panel = SeerGuiUtils.createPanel();
        panel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        panel.add(this._field);
        return panel;
    }

    @Override
    public boolean stopCellEditing() {
        super.stopCellEditing();
        if (this._cellListener != null) {
            this._cellListener.actionPerformed(new SeerCellEvent((Object)this._table, 1, "text-action", this._row, this._col));
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this._field.getText();
    }
}

