/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class SeerComboBox<E>
extends JComboBox<E> {
    private transient Object _currentValue;
    private transient ActionListener _listener;
    private final String _separatorStart;

    public SeerComboBox(List<E> elements) {
        this(elements, "===");
    }

    public SeerComboBox(List<E> elements, String separatorStart) {
        super(new Vector<E>(elements));
        this._separatorStart = separatorStart;
        this.setRenderer(new SeerComboBoxRenderer());
        this._currentValue = this.getSelectedItem();
        this.addActionListener(e -> {
            Object val = this.getSelectedItem();
            if (val != null && !val.equals(this._currentValue) && !Objects.toString(val).trim().startsWith(this._separatorStart)) {
                this._currentValue = val;
                if (this._listener != null) {
                    this._listener.actionPerformed(e);
                }
            } else {
                this.setSelectedItem(this._currentValue);
            }
        });
    }

    public E getSelectedValue() {
        Object val = this.getSelectedItem();
        return (E)(Objects.toString(val, "").trim().startsWith(this._separatorStart) ? null : val);
    }

    public void setActionListener(ActionListener l) {
        this._listener = l;
    }

    private class SeerComboBoxRenderer
    extends DefaultListCellRenderer {
        private SeerComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (Objects.toString(value, "").trim().startsWith(SeerComboBox.this._separatorStart)) {
                lbl.setForeground(Color.GRAY);
                lbl.setBorder(BorderFactory.createEmptyBorder());
            } else {
                lbl.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            }
            return lbl;
        }
    }
}

