/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;

public class SeerListModel<E>
extends AbstractListModel<E> {
    protected transient List<E> _originalData;
    protected transient List<E> _filteredData;
    protected transient Comparator<E> _comparator;
    protected int _filteringMode;
    protected String _currentFilter;

    public SeerListModel(List<E> data, int filteringMode, Comparator<E> comparator) {
        if (data == null) {
            throw new RuntimeException("Data list is required");
        }
        this._originalData = new ArrayList<E>(data);
        this._filteredData = new ArrayList(data.size());
        this._filteringMode = filteringMode;
        this._comparator = comparator;
        if (comparator != null) {
            this._originalData.sort(this._comparator);
        }
        this.filter(null);
    }

    public void removeElement(E elem) {
        int idx = this._originalData.indexOf(elem);
        if (idx > -1) {
            this._originalData.remove(elem);
            this.filter(this._currentFilter);
        }
    }

    public void addElement(E elem) {
        this.addElement(this._originalData.size(), elem);
    }

    public void addElement(int idx, E elem) {
        this._originalData.add(idx, elem);
        this.filter(this._currentFilter);
    }

    public void resetData(List<E> data) {
        int size = this._filteredData.size();
        this._filteredData.clear();
        this.fireIntervalRemoved(this, 0, size);
        this._originalData = data;
        this.filter(null);
    }

    public void filter(String filter) {
        int size = this._filteredData.size();
        this._filteredData.clear();
        this.fireIntervalRemoved(this, 0, size);
        for (E obj : this._originalData) {
            if (obj == null || !this.filterElement(obj, filter)) continue;
            this._filteredData.add(obj);
        }
        if (this._comparator != null) {
            this._filteredData.sort(this._comparator);
        }
        this._currentFilter = filter;
        this.fireIntervalAdded(this, 0, this._filteredData.size());
    }

    protected boolean filterElement(E element, String filter) {
        String s = element instanceof String ? ((String)element).toLowerCase() : element.toString().toLowerCase();
        boolean add = false;
        if (filter == null || filter.isEmpty()) {
            add = true;
        } else {
            String filterLower = filter.toLowerCase();
            if (this._filteringMode == 0 && s.equals(filterLower) || this._filteringMode == 1 && s.startsWith(filterLower) || this._filteringMode == 2 && s.contains(filterLower)) {
                add = true;
            }
        }
        return add;
    }

    @Override
    public E getElementAt(int index) {
        return this._filteredData.get(index);
    }

    @Override
    public int getSize() {
        return this._filteredData.size();
    }

    public int indexOf(E element) {
        return this._filteredData.indexOf(element);
    }

    public List<E> getOriginalData() {
        return Collections.unmodifiableList(this._originalData);
    }

    public List<E> getFilteredData() {
        return Collections.unmodifiableList(this._filteredData);
    }

    public Comparator<E> getComparator() {
        return this._comparator;
    }
}

