/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import com.imsweb.seerutilsgui.SeerList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class SeerMultiSelectComboBox<T>
extends JComboBox<SeerMultiSelectCheckBoxValue<T>> {
    public static final String NO_SELECTION_TEXT = "< No Value Selected >";
    public static final String MULTIPLE_SELECTION_TEXT = "< Multiple Values Selected >";
    public static final Color NO_SELECTION_COLOR = Color.DARK_GRAY;
    public static final Color MULTIPLE_SELECTION_COLOR = Color.DARK_GRAY;
    public static final Color ONE_SELECTION_COLOR = Color.BLACK;
    private String _multiSelectedTxt = "< Multiple Values Selected >";
    private String _noSelectedTxt = "< No Value Selected >";
    private Color _multiSelectedColor = MULTIPLE_SELECTION_COLOR;
    private Color _noSelectedColor = NO_SELECTION_COLOR;
    private Color _oneSelectedColor = ONE_SELECTION_COLOR;
    private final List<SeerMultiSelectCheckBoxValue<T>> _checkboxes = new ArrayList<SeerMultiSelectCheckBoxValue<T>>();

    public SeerMultiSelectComboBox(List<T> items) {
        int maxWidth = 0;
        for (T item : items) {
            SeerMultiSelectCheckBoxValue<T> checkBoxValue = new SeerMultiSelectCheckBoxValue<T>(item);
            this._checkboxes.add(checkBoxValue);
            this.addItem(checkBoxValue);
            maxWidth = Math.max(maxWidth, checkBoxValue.getPreferredSize().width);
        }
        this.setRenderer(new CheckBoxRenderer(this._checkboxes));
        maxWidth = Math.max(maxWidth, SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this._multiSelectedTxt) + 25);
        maxWidth = Math.max(maxWidth, SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this._noSelectedTxt) + 25);
        Dimension dim = this.getPreferredSize();
        this.setPreferredSize(new Dimension(maxWidth + 5, dim.height));
        this.addActionListener(this);
    }

    @Override
    public void setMaximumRowCount(int count) {
        super.setMaximumRowCount(count);
        if (count < this._checkboxes.size()) {
            Dimension dim = this.getPreferredSize();
            this.setPreferredSize(new Dimension(dim.width + 15, dim.height));
        }
    }

    public List<T> getSelectedItems() {
        ArrayList<T> selectedItems = new ArrayList<T>();
        for (SeerMultiSelectCheckBoxValue<T> dto : this._checkboxes) {
            if (dto.getItem() == null || !dto.isSelected()) continue;
            selectedItems.add(dto.getItem());
        }
        return selectedItems;
    }

    public void setSelectedItems(List<T> items) {
        for (SeerMultiSelectCheckBoxValue<T> checkBoxDto : this._checkboxes) {
            checkBoxDto.setSelected(false);
        }
        block1: for (SeerMultiSelectCheckBoxValue<T> option : items) {
            for (SeerMultiSelectCheckBoxValue<T> dto : this._checkboxes) {
                if (dto.getItem() == null || !dto.getItem().equals(option)) continue;
                dto.setSelected(true);
                continue block1;
            }
        }
        this.refreshComponent();
    }

    public void setMultipleSelectionText(String text) {
        this._multiSelectedTxt = text;
        Dimension dim = this.getPreferredSize();
        this.setPreferredSize(new Dimension(Math.max(dim.width, SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this._multiSelectedTxt) + 25), dim.height));
    }

    public void setNoSelectionText(String text) {
        this._noSelectedTxt = text;
        Dimension dim = this.getPreferredSize();
        this.setPreferredSize(new Dimension(Math.max(dim.width, SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this._noSelectedTxt) + 25), dim.height));
    }

    public void setMultipleSelectionForeground(Color color) {
        this._multiSelectedColor = color;
    }

    public void setOneForeground(Color color) {
        this._oneSelectedColor = color;
    }

    public void setNoSelectionForeground(Color color) {
        this._noSelectedColor = color;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this._checkboxes.size()) {
            return;
        }
        SeerMultiSelectCheckBoxValue<T> cb = this._checkboxes.get(index);
        if (cb.getItem() != null) {
            cb.setSelected(!cb.isSelected());
        }
        this.repaint();
    }

    @Override
    public void setPopupVisible(boolean flag) {
    }

    protected void refreshComponent() {
        this.repaint();
    }

    public static class SeerMultiSelectCheckBoxValue<V>
    extends JCheckBox
    implements Serializable {
        private final transient V _item;

        public SeerMultiSelectCheckBoxValue(V item) {
            super(item == null ? null : item.toString());
            this._item = item;
        }

        public V getItem() {
            return this._item;
        }
    }

    private class CheckBoxRenderer
    implements ListCellRenderer<SeerMultiSelectCheckBoxValue> {
        private final BasicComboBoxRenderer _defaultRenderer = new BasicComboBoxRenderer();
        private final List<SeerMultiSelectCheckBoxValue<T>> _componentList;
        private final JPanel _separator;

        public CheckBoxRenderer(List<SeerMultiSelectCheckBoxValue<T>> checkboxes) {
            this._componentList = checkboxes;
            this._separator = new JPanel();
            this._separator.setOpaque(true);
            this._separator.setBackground(Color.WHITE);
            this._separator.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10), BorderFactory.createLineBorder(Color.GRAY)));
            this._separator.setPreferredSize(new Dimension(this._separator.getPreferredSize().width, 1));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SeerMultiSelectCheckBoxValue> list, SeerMultiSelectCheckBoxValue value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = null;
            if (index >= 0 && index < this._componentList.size()) {
                SeerMultiSelectCheckBoxValue checkbox = this._componentList.get(index);
                if (checkbox.getItem() != null) {
                    checkbox.setBackground(isSelected ? SeerList.COLOR_LIST_ROW_SELECTED : Color.WHITE);
                    checkbox.setForeground(Color.BLACK);
                    result = checkbox;
                } else {
                    result = this._separator;
                }
            }
            if (index == -1) {
                String str;
                List selectedItems = SeerMultiSelectComboBox.this.getSelectedItems();
                if (selectedItems == null || selectedItems.isEmpty()) {
                    str = SeerMultiSelectComboBox.this._noSelectedTxt;
                    SeerMultiSelectComboBox.this.setForeground(SeerMultiSelectComboBox.this._noSelectedColor);
                } else if (selectedItems.size() == 1) {
                    str = selectedItems.toArray()[0].toString();
                    SeerMultiSelectComboBox.this.setForeground(SeerMultiSelectComboBox.this._oneSelectedColor);
                } else {
                    str = SeerMultiSelectComboBox.this._multiSelectedTxt;
                    SeerMultiSelectComboBox.this.setForeground(SeerMultiSelectComboBox.this._multiSelectedColor);
                }
                result = this._defaultRenderer.getListCellRendererComponent(list, str, index, isSelected, cellHasFocus);
            }
            return result;
        }
    }
}

