/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import com.imsweb.seerutilsgui.SeerCardPanel;
import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerProgressPanel;
import com.imsweb.seerutilsgui.SeerSpinningPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class SeerProgressDialog<T, V>
extends JDialog {
    private static final String _PROGRESS_PANEL_ID = "card-with-progress";
    private static final String _SPINNING_PANEL_ID = "card-with-spinner";
    private final SeerCardPanel _progressOrSpinnerPnl;
    private final SeerProgressPanel _progressPnl;
    private String _progressText;
    private final SeerSpinningPanel _spinnerPnl;
    private String _spinnerText;
    private JButton _cancelBtn;
    private transient SwingWorker<T, V> _worker;
    private boolean _canceled = false;

    public SeerProgressDialog(Window owner, int numberToProcess, String spinnerText, String progressText) {
        this(owner, numberToProcess, spinnerText, progressText, true);
    }

    public SeerProgressDialog(Window owner, int numberToProcess, String spinnerText, String progressText, boolean showCancel) {
        super(owner);
        this.setTitle("Progress");
        this.setName("progress-dlg");
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                SeerProgressDialog.this.cancel();
            }
        });
        this._spinnerText = spinnerText;
        this._progressText = progressText;
        this.setLayout(new BorderLayout());
        this._progressOrSpinnerPnl = new SeerCardPanel();
        this._progressPnl = new SeerProgressPanel(0, numberToProcess, 100, this._progressText, "", "", 20, 0, 0);
        JPanel progressPnl = SeerGuiUtils.createPanel();
        progressPnl.add((Component)this._progressPnl, "Center");
        this._spinnerPnl = new SeerSpinningPanel(24, this._spinnerText, "", "", 20, 0, 0);
        JPanel spinnerPnl = SeerGuiUtils.createPanel();
        spinnerPnl.add((Component)this._spinnerPnl, "Center");
        this._progressOrSpinnerPnl.add((Component)progressPnl, _PROGRESS_PANEL_ID);
        this._progressOrSpinnerPnl.add((Component)spinnerPnl, _SPINNING_PANEL_ID);
        this._progressOrSpinnerPnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (spinnerText != null) {
            this.showSpinner();
        } else {
            this.showProgress();
        }
        this.add((Component)this._progressOrSpinnerPnl, "Center");
        if (showCancel) {
            JPanel cancelBtnPnl = SeerGuiUtils.createPanel(new FlowLayout(1));
            cancelBtnPnl.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            this._cancelBtn = SeerGuiUtils.createButton("Cancel", "cancel", "Cancel", e -> this.cancel());
            cancelBtnPnl.add(this._cancelBtn);
            this.add((Component)cancelBtnPnl, "South");
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (SeerProgressDialog.this._worker != null) {
                    SeerProgressDialog.this._worker.execute();
                }
                if (SeerProgressDialog.this._cancelBtn != null) {
                    SeerProgressDialog.this._cancelBtn.requestFocusInWindow();
                }
                SeerProgressDialog.this.removeComponentListener(this);
            }
        });
    }

    public void setProgress(int n) {
        this._progressPnl.setProgress(n);
    }

    public void showSpinner() {
        this._spinnerPnl.startSpinning();
        this._progressOrSpinnerPnl.showPage(_SPINNING_PANEL_ID);
    }

    public void showProgress() {
        this._spinnerPnl.stopSpinning();
        this._progressOrSpinnerPnl.showPage(_PROGRESS_PANEL_ID);
    }

    public void setWorker(SwingWorker<T, V> worker) {
        this._worker = worker;
    }

    public void setProgressBarLabel(String text) {
        this._progressText = text;
        this._progressPnl.setTopLabel(this._progressText);
    }

    public void setSpinningLabel(String text) {
        this._spinnerText = text;
        this._spinnerPnl.setTopLabel(this._spinnerText);
    }

    public void cancel() {
        this._canceled = true;
        if (this._worker != null) {
            this._worker.cancel(true);
        }
        SeerGuiUtils.hideAndDestroy(this);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void close() {
        this.setVisible(false);
        SeerGuiUtils.hideAndDestroy(this);
    }
}

