/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerList;
import com.imsweb.seerutilsgui.SeerListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SeerTwoListsSelectionPanel<E>
extends JPanel
implements ActionListener {
    private final List<JButton> _orderedButtons;
    private final SeerList<E> _leftList;
    private final SeerList<E> _rightList;
    private final JScrollPane _leftPane;
    private final JScrollPane _rightPane;
    private final JButton _moveLeftBtn;
    private final JButton _moveRightBtn;
    private final JButton _moveAllLeftBtn;
    private final JButton _moveAllRightBtn;
    private JButton _moveUpBtn;
    private JButton _moveDownBtn;
    private JButton _moveFirstBtn;
    private JButton _moveLastBtn;
    private final JPanel _centerPnl;
    private final JPanel _leftPnl;
    private final JPanel _rightPnl;
    private JTextField _leftFilterFld;
    private JTextField _rightFilterFld;
    public static final int DEFAULT_FILTER = 2;

    public SeerTwoListsSelectionPanel(List<E> leftItems, List<E> rightItems) {
        this(leftItems, rightItems, null, null, null, null);
    }

    public SeerTwoListsSelectionPanel(List<E> leftItems, List<E> rightItems, String leftText, String rightText) {
        this(leftItems, rightItems, leftText == null ? null : SeerGuiUtils.createLabel(leftText), rightText == null ? null : SeerGuiUtils.createLabel(rightText));
    }

    public SeerTwoListsSelectionPanel(List<E> leftItems, List<E> rightItems, JLabel leftLbl, JLabel rightLbl) {
        this(leftItems, rightItems, leftLbl, rightLbl, null, null);
    }

    public SeerTwoListsSelectionPanel(List<E> leftItems, List<E> rightItems, JLabel leftLbl, JLabel rightLbl, Comparator<E> leftComp, Comparator<E> rightComp) {
        this(new SeerListModel<E>(leftItems, 2, leftComp), new SeerListModel<E>(rightItems, 2, rightComp), leftLbl, rightLbl, true, true);
    }

    public SeerTwoListsSelectionPanel(List<E> leftItems, List<E> rightItems, JLabel leftLbl, JLabel rightLbl, Comparator<E> leftComp, Comparator<E> rightComp, boolean showFilter, boolean addFocusBorder) {
        this(new SeerListModel<E>(leftItems, 2, leftComp), new SeerListModel<E>(rightItems, 2, rightComp), leftLbl, rightLbl, showFilter, addFocusBorder);
    }

    public SeerTwoListsSelectionPanel(SeerListModel<E> leftModel, SeerListModel<E> rightModel, JLabel leftLbl, JLabel rightLbl, boolean showFilter, final boolean addFocusBorder) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this._leftPnl = SeerGuiUtils.createPanel();
        this._leftPnl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        if (leftLbl != null) {
            this._leftPnl.add((Component)leftLbl, "North");
        }
        this._leftList = new SeerList<E>(leftModel, 0, false);
        this._leftList.setSelectionMode(2);
        this._leftList.getSelectionModel().addListSelectionListener(e -> this.enableButtons());
        this._leftList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SeerTwoListsSelectionPanel.this._rightList.clearSelection();
                if (addFocusBorder) {
                    SeerTwoListsSelectionPanel.this._leftPane.setBorder(SeerGuiUtils.BORDER_FOCUS_IN);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (addFocusBorder) {
                    SeerTwoListsSelectionPanel.this._leftPane.setBorder(SeerGuiUtils.BORDER_FOCUS_OUT);
                }
            }
        });
        this._leftPane = new JScrollPane(this._leftList);
        this._leftPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this._leftPnl.add((Component)this._leftPane, "Center");
        if (showFilter) {
            JPanel leftFilterPnl = SeerGuiUtils.createPanel();
            leftFilterPnl.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            leftFilterPnl.add((Component)SeerGuiUtils.createLabel("Filter"), "West");
            this._leftFilterFld = new JTextField();
            this._leftFilterFld.setBorder(SeerGuiUtils.BORDER_TEXT_FIELD_OUT);
            this._leftFilterFld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SeerTwoListsSelectionPanel.this.performApplyLeftFilter();
                }
            });
            if (addFocusBorder) {
                this._leftFilterFld.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        SeerTwoListsSelectionPanel.this._leftFilterFld.setBorder(SeerGuiUtils.BORDER_TEXT_FIELD_IN);
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        SeerTwoListsSelectionPanel.this._leftFilterFld.setBorder(SeerGuiUtils.BORDER_TEXT_FIELD_OUT);
                    }
                });
            }
            JPanel leftFilterWrapperPnl = SeerGuiUtils.createPanel();
            leftFilterWrapperPnl.add(Box.createVerticalStrut(2), "North");
            leftFilterWrapperPnl.add(Box.createHorizontalStrut(5), "West");
            leftFilterWrapperPnl.add((Component)this._leftFilterFld, "Center");
            leftFilterWrapperPnl.add(Box.createHorizontalStrut(5), "East");
            leftFilterWrapperPnl.add(Box.createVerticalStrut(2), "South");
            leftFilterPnl.add((Component)leftFilterWrapperPnl, "Center");
            leftFilterPnl.add((Component)SeerGuiUtils.createButton("Reset", "reset-left-filter", "Reset Filter", this), "East");
            this._leftPnl.add((Component)leftFilterPnl, "South");
        }
        this.add(this._leftPnl);
        this._orderedButtons = new ArrayList<JButton>();
        this._centerPnl = SeerGuiUtils.createPanel(new GridBagLayout());
        JPanel controlsPnl = SeerGuiUtils.createPanel();
        controlsPnl.setLayout(new BoxLayout(controlsPnl, 1));
        controlsPnl.add(Box.createVerticalStrut(15));
        this._moveLeftBtn = SeerGuiUtils.createButton("Move Left", "move-left", "Move Selected Items Left", this);
        this._orderedButtons.add(this._moveLeftBtn);
        controlsPnl.add(this._moveLeftBtn);
        controlsPnl.add(Box.createVerticalStrut(5));
        this._moveRightBtn = SeerGuiUtils.createButton("Move Right", "move-right", "Move Selected Items Right", this);
        this._orderedButtons.add(this._moveRightBtn);
        controlsPnl.add(this._moveRightBtn);
        controlsPnl.add(Box.createVerticalStrut(15));
        this._moveAllLeftBtn = SeerGuiUtils.createButton("Move All Left", "move-all-left", "Move All Items Left", this);
        this._orderedButtons.add(this._moveAllLeftBtn);
        controlsPnl.add(this._moveAllLeftBtn);
        controlsPnl.add(Box.createVerticalStrut(5));
        this._moveAllRightBtn = SeerGuiUtils.createButton("Move All Right", "move-all-right", "Move All Items Right", this);
        this._orderedButtons.add(this._moveAllRightBtn);
        controlsPnl.add(this._moveAllRightBtn);
        if (rightModel._comparator == null) {
            controlsPnl.add(Box.createVerticalStrut(20));
            this._moveUpBtn = SeerGuiUtils.createButton("Move Up", "move-up", "Move Selected Item Up", this);
            this._orderedButtons.add(this._moveUpBtn);
            controlsPnl.add(this._moveUpBtn);
            controlsPnl.add(Box.createVerticalStrut(5));
            this._moveDownBtn = SeerGuiUtils.createButton("Move Down", "move-down", "Move Selected Item Down", this);
            this._orderedButtons.add(this._moveDownBtn);
            controlsPnl.add(this._moveDownBtn);
            controlsPnl.add(Box.createVerticalStrut(15));
            this._moveFirstBtn = SeerGuiUtils.createButton("Move First", "move-first", "Move Selected Item First", this);
            this._orderedButtons.add(this._moveFirstBtn);
            controlsPnl.add(this._moveFirstBtn);
            controlsPnl.add(Box.createVerticalStrut(5));
            this._moveLastBtn = SeerGuiUtils.createButton("Move Last", "move-last", "Move Selected Item Last", this);
            this._orderedButtons.add(this._moveLastBtn);
            controlsPnl.add(this._moveLastBtn);
        }
        controlsPnl.add(Box.createVerticalStrut(15));
        this._centerPnl.add(controlsPnl);
        this._centerPnl.setMaximumSize(new Dimension(100, 400));
        if (rightModel._comparator == null) {
            SeerGuiUtils.synchronizedComponentsWidth(this._moveLeftBtn, this._moveRightBtn, this._moveAllLeftBtn, this._moveAllRightBtn, this._moveUpBtn, this._moveDownBtn, this._moveFirstBtn, this._moveLastBtn);
        } else {
            SeerGuiUtils.synchronizedComponentsWidth(this._moveLeftBtn, this._moveRightBtn, this._moveAllLeftBtn, this._moveAllRightBtn);
        }
        this.add(this._centerPnl);
        this._rightPnl = SeerGuiUtils.createPanel();
        this._rightPnl.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        if (rightLbl != null) {
            this._rightPnl.add((Component)rightLbl, "North");
        }
        this._rightList = new SeerList<E>(rightModel, 0, false);
        this._rightList.setSelectionMode(2);
        this._rightList.getSelectionModel().addListSelectionListener(e -> this.enableButtons());
        this._rightList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SeerTwoListsSelectionPanel.this._leftList.clearSelection();
                if (addFocusBorder) {
                    SeerTwoListsSelectionPanel.this._rightPane.setBorder(SeerGuiUtils.BORDER_FOCUS_IN);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (addFocusBorder) {
                    SeerTwoListsSelectionPanel.this._rightPane.setBorder(SeerGuiUtils.BORDER_FOCUS_OUT);
                }
            }
        });
        this._rightPane = new JScrollPane(this._rightList);
        this._rightPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this._rightPnl.add((Component)this._rightPane, "Center");
        if (showFilter) {
            JPanel rightFilterPnl = SeerGuiUtils.createPanel();
            rightFilterPnl.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            rightFilterPnl.add((Component)SeerGuiUtils.createLabel("Filter"), "West");
            this._rightFilterFld = new JTextField();
            this._rightFilterFld.setBorder(SeerGuiUtils.BORDER_TEXT_FIELD_OUT);
            this._rightFilterFld.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SeerTwoListsSelectionPanel.this.performApplyRightFilter();
                }
            });
            if (addFocusBorder) {
                this._rightFilterFld.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        SeerTwoListsSelectionPanel.this._rightFilterFld.setBorder(SeerGuiUtils.BORDER_TEXT_FIELD_IN);
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        SeerTwoListsSelectionPanel.this._rightFilterFld.setBorder(SeerGuiUtils.BORDER_TEXT_FIELD_OUT);
                    }
                });
            }
            JPanel rightFilterWrapperPnl = SeerGuiUtils.createPanel();
            rightFilterWrapperPnl.add(Box.createVerticalStrut(2), "North");
            rightFilterWrapperPnl.add(Box.createHorizontalStrut(5), "West");
            rightFilterWrapperPnl.add((Component)this._rightFilterFld, "Center");
            rightFilterWrapperPnl.add(Box.createHorizontalStrut(5), "East");
            rightFilterWrapperPnl.add(Box.createVerticalStrut(2), "South");
            rightFilterPnl.add((Component)rightFilterWrapperPnl, "Center");
            rightFilterPnl.add((Component)SeerGuiUtils.createButton("Reset", "reset-right-filter", "Reset Filter", this), "East");
            this._rightPnl.add((Component)rightFilterPnl, "South");
        }
        this.add(this._rightPnl);
        this.enableButtons();
        this.resizeLists();
        this._leftList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SeerTwoListsSelectionPanel.this.performMoveRight();
                }
            }
        });
        this._leftList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "switch-side-action");
        this._leftList.getActionMap().put("switch-side-action", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeerTwoListsSelectionPanel.this.performMoveRight();
            }
        });
        this._rightList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SeerTwoListsSelectionPanel.this.performMoveLeft();
                }
            }
        });
        this._rightList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "switch-side-action");
        this._rightList.getActionMap().put("switch-side-action", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeerTwoListsSelectionPanel.this.performMoveLeft();
            }
        });
    }

    public void resizeLists() {
        int width = (this.getPreferredSize().width - this._centerPnl.getPreferredSize().width) / 2;
        this._leftPnl.setPreferredSize(new Dimension(width, this._leftPnl.getPreferredSize().height));
        this._rightPnl.setPreferredSize(new Dimension(width, this._rightPnl.getPreferredSize().height));
    }

    public void enableButtons() {
        int numRightSelected = this._leftList.getSelectedIndices().length;
        int numLeftSelected = this._rightList.getSelectedIndices().length;
        int focusIdx = -1;
        for (int i = 0; i < this._orderedButtons.size(); ++i) {
            if (!this._orderedButtons.get(i).hasFocus()) continue;
            focusIdx = i;
        }
        this._moveRightBtn.setEnabled(numRightSelected > 0);
        this._moveLeftBtn.setEnabled(numLeftSelected > 0);
        this._moveAllRightBtn.setEnabled(this._leftList.getModel().getSize() > 0);
        this._moveAllLeftBtn.setEnabled(this._rightList.getModel().getSize() > 0);
        if (this._moveUpBtn != null) {
            this._moveUpBtn.setEnabled(numLeftSelected != 0 && this._rightList.getSelectedIndex() != 0);
        }
        if (this._moveDownBtn != null) {
            this._moveDownBtn.setEnabled(numLeftSelected != 0 && this._rightList.getSelectedIndices()[numLeftSelected - 1] != this._rightList.getModel().getSize() - 1);
        }
        if (this._moveFirstBtn != null) {
            this._moveFirstBtn.setEnabled(numLeftSelected != 0 && this._rightList.getSelectedIndex() != 0);
        }
        if (this._moveLastBtn != null) {
            this._moveLastBtn.setEnabled(numLeftSelected != 0 && this._rightList.getSelectedIndices()[numLeftSelected - 1] != this._rightList.getModel().getSize() - 1);
        }
        if (focusIdx != -1) {
            JButton btn;
            int i;
            boolean focusApplied = false;
            for (i = focusIdx; i < this._orderedButtons.size(); ++i) {
                btn = this._orderedButtons.get(i);
                if (!btn.isEnabled()) continue;
                btn.requestFocusInWindow();
                focusApplied = true;
                break;
            }
            if (!focusApplied) {
                for (i = 0; i < focusIdx; ++i) {
                    btn = this._orderedButtons.get(i);
                    if (!btn.isEnabled()) continue;
                    btn.requestFocusInWindow();
                    break;
                }
            }
        }
    }

    public void updateItemsFromModels() {
        int i;
        SeerListModel leftModel = (SeerListModel)this._leftList.getModel();
        SeerListModel rightModel = (SeerListModel)this._rightList.getModel();
        this._leftList.resetData(new ArrayList());
        for (i = 0; i < leftModel.getSize(); ++i) {
            ((SeerListModel)this._leftList.getModel()).addElement(leftModel.getElementAt(i));
        }
        this._rightList.resetData(new ArrayList());
        for (i = 0; i < rightModel.getSize(); ++i) {
            ((SeerListModel)this._rightList.getModel()).addElement(rightModel.getElementAt(i));
        }
    }

    public SeerList<E> getLeftList() {
        return this._leftList;
    }

    public List<E> getLeftListContent() {
        return this.getLeftListContent(false);
    }

    public List<E> getLeftListContent(boolean filtered) {
        if (filtered) {
            return ((SeerListModel)this._leftList.getModel()).getFilteredData();
        }
        return ((SeerListModel)this._leftList.getModel()).getOriginalData();
    }

    public SeerList<E> getRightList() {
        return this._rightList;
    }

    public List<E> getRightListContent() {
        return this.getRightListContent(false);
    }

    public List<E> getRightListContent(boolean filtered) {
        if (filtered) {
            return ((SeerListModel)this._rightList.getModel()).getFilteredData();
        }
        return ((SeerListModel)this._rightList.getModel()).getOriginalData();
    }

    public void performMoveLeft() {
        this.performResetLeftFilter();
        SeerListModel leftModel = (SeerListModel)this._leftList.getModel();
        SeerListModel rightModel = (SeerListModel)this._rightList.getModel();
        Object firstMoved = null;
        for (Object obj : this._rightList.getSelectedValuesList()) {
            if (firstMoved == null) {
                firstMoved = obj;
            }
            rightModel.removeElement(obj);
            leftModel.addElement(obj);
        }
        this._leftList.ensureIndexIsVisible(leftModel.indexOf(firstMoved));
        this.enableButtons();
    }

    public void performMoveAllLeft() {
        this.performResetLeftFilter();
        SeerListModel leftModel = (SeerListModel)this._leftList.getModel();
        SeerListModel rightModel = (SeerListModel)this._rightList.getModel();
        Object firstMoved = null;
        ArrayList itemsToMove = new ArrayList();
        for (int i = 0; i < rightModel.getSize(); ++i) {
            Object obj = rightModel.getElementAt(i);
            if (firstMoved == null) {
                firstMoved = obj;
            }
            itemsToMove.add(obj);
        }
        for (Object obj : itemsToMove) {
            rightModel.removeElement(obj);
            leftModel.addElement(obj);
        }
        this._leftList.ensureIndexIsVisible(leftModel.indexOf(firstMoved));
        this.enableButtons();
    }

    public void performMoveRight() {
        this.performResetRightFilter();
        SeerListModel leftModel = (SeerListModel)this._leftList.getModel();
        SeerListModel rightModel = (SeerListModel)this._rightList.getModel();
        Object firstMoved = null;
        for (Object obj : this._leftList.getSelectedValuesList()) {
            if (firstMoved == null) {
                firstMoved = obj;
            }
            leftModel.removeElement(obj);
            rightModel.addElement(obj);
        }
        this._rightList.ensureIndexIsVisible(leftModel.indexOf(firstMoved));
        this.enableButtons();
    }

    public void performMoveAllRight() {
        this.performResetRightFilter();
        SeerListModel leftModel = (SeerListModel)this._leftList.getModel();
        SeerListModel rightModel = (SeerListModel)this._rightList.getModel();
        Object firstMoved = null;
        ArrayList itemsToMove = new ArrayList();
        for (int i = 0; i < leftModel.getSize(); ++i) {
            Object obj = leftModel.getElementAt(i);
            if (firstMoved == null) {
                firstMoved = obj;
            }
            itemsToMove.add(obj);
        }
        for (Object obj : itemsToMove) {
            leftModel.removeElement(obj);
            rightModel.addElement(obj);
        }
        this._rightList.ensureIndexIsVisible(leftModel.indexOf(firstMoved));
        this.enableButtons();
    }

    public void performMoveUp() {
        SeerListModel selMod = (SeerListModel)this._rightList.getModel();
        int[] indices = this._rightList.getSelectedIndices();
        int counter = 0;
        for (int i : indices) {
            Object obj = selMod.getElementAt(i);
            selMod.removeElement(obj);
            selMod.addElement(i - 1, obj);
            indices[counter] = i - 1;
            ++counter;
        }
        this._rightList.setSelectedIndices(indices);
    }

    public void performMoveFirst() {
        SeerListModel selMod = (SeerListModel)this._rightList.getModel();
        int[] indices = this._rightList.getSelectedIndices();
        int index1 = indices[0];
        int counter = 0;
        for (int i : indices) {
            Object obj = selMod.getElementAt(i);
            selMod.removeElement(obj);
            selMod.addElement(i - index1, obj);
            indices[counter] = i - index1;
            ++counter;
        }
        this._rightList.setSelectedIndices(indices);
    }

    public void performMoveDown() {
        SeerListModel selMod = (SeerListModel)this._rightList.getModel();
        int[] indices = this._rightList.getSelectedIndices();
        int counter = indices.length - 1;
        for (int i = indices.length - 1; i >= 0; --i) {
            Object obj = selMod.getElementAt(indices[i]);
            selMod.removeElement(obj);
            selMod.addElement(indices[i] + 1, obj);
            indices[counter] = indices[i] + 1;
            --counter;
        }
        this._rightList.setSelectedIndices(indices);
    }

    public void performMoveLast() {
        SeerListModel selMod = (SeerListModel)this._rightList.getModel();
        int[] indices = this._rightList.getSelectedIndices();
        int counter = indices.length - 1;
        int indexLast = indices[indices.length - 1];
        for (int i = indices.length - 1; i >= 0; --i) {
            Object obj = selMod.getElementAt(indices[i]);
            selMod.removeElement(obj);
            selMod.addElement(indices[i] + (selMod.getSize() - indexLast), obj);
            indices[counter] = indices[i] + (selMod.getSize() - 1 - indexLast);
            --counter;
        }
        this._rightList.setSelectedIndices(indices);
    }

    public void performResetRightFilter() {
        if (this._rightFilterFld != null) {
            this._rightFilterFld.setText("");
        }
        this._rightList.resetFilter();
    }

    public void performApplyRightFilter() {
        if (this._rightFilterFld != null) {
            this._rightList.filter(this._rightFilterFld.getText());
        }
    }

    public void performResetLeftFilter() {
        if (this._leftFilterFld != null) {
            this._leftFilterFld.setText("");
        }
        this._leftList.resetFilter();
    }

    public void performApplyLeftFilter() {
        if (this._leftFilterFld != null) {
            this._leftList.filter(this._leftFilterFld.getText());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if ("move-left".equals(com)) {
            this.performMoveLeft();
        } else if ("move-right".equals(com)) {
            this.performMoveRight();
        } else if ("move-all-left".equals(com)) {
            this.performMoveAllLeft();
        } else if ("move-all-right".equals(com)) {
            this.performMoveAllRight();
        } else if ("move-up".equals(com)) {
            this.performMoveUp();
        } else if ("move-down".equals(com)) {
            this.performMoveDown();
        } else if ("move-first".equals(com)) {
            this.performMoveFirst();
        } else if ("move-last".equals(com)) {
            this.performMoveLast();
        } else if ("reset-left-filter".equals(com)) {
            this.performResetLeftFilter();
        } else if ("reset-right-filter".equals(com)) {
            this.performResetRightFilter();
        }
    }
}

