/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerWindow;
import com.imsweb.seerutilsgui.editor.SyntaxUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class GoToLineDialog
extends JDialog
implements ActionListener,
SeerWindow {
    private final JTextComponent _comp;
    private final int _maxLineNum;
    private final JTextField _field;
    private String _previousValue;

    public GoToLineDialog(Window owner, JTextComponent comp, int maxLineNum) {
        this(owner, comp, maxLineNum, SeerGuiUtils.COLOR_APPLICATION_BACKGROUND);
    }

    public GoToLineDialog(Window owner, JTextComponent comp, int maxLineNum, Color backgroundColor) {
        super(owner);
        this._comp = comp;
        this._maxLineNum = maxLineNum;
        this.setTitle("Go to Line");
        this.setModal(true);
        this.setResizable(false);
        this.setName("conf-file-editor-go-to-line-dlg");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GoToLineDialog.this.performCancel();
            }
        });
        JPanel contentPnl = SeerGuiUtils.createPanel();
        contentPnl.setLayout(new BoxLayout(contentPnl, 1));
        contentPnl.setOpaque(true);
        contentPnl.setBackground(backgroundColor);
        contentPnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)contentPnl, "Center");
        JPanel centerPnl = SeerGuiUtils.createPanel();
        centerPnl.setOpaque(true);
        centerPnl.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel labelPnl = SeerGuiUtils.createPanel(new FlowLayout(3, 0, 0));
        labelPnl.add(SeerGuiUtils.createLabel("Enter line number (1.." + maxLineNum + "):"));
        centerPnl.add((Component)labelPnl, "North");
        JPanel fieldPnl = SeerGuiUtils.createPanel(new FlowLayout(3, 0, 0));
        fieldPnl.setBorder(BorderFactory.createEmptyBorder(10, 15, 10, 15));
        this._field = new JTextField(20);
        this._field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GoToLineDialog.this.performOk();
                } else if (e.getKeyCode() == 27) {
                    GoToLineDialog.this.performCancel();
                }
            }
        });
        fieldPnl.add(this._field);
        centerPnl.add((Component)fieldPnl, "Center");
        contentPnl.add((Component)centerPnl, "Center");
        JPanel southPnl = SeerGuiUtils.createPanel();
        southPnl.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JPanel buttonsPnl = SeerGuiUtils.createPanel(new FlowLayout(1, 0, 0));
        JButton okBtn = SeerGuiUtils.createButton("OK", "ok", "OK", this);
        buttonsPnl.add(okBtn);
        buttonsPnl.add(Box.createHorizontalStrut(10));
        JButton cancelBtn = SeerGuiUtils.createButton("Cancel", "cancel", "Cancel", this);
        buttonsPnl.add(cancelBtn);
        southPnl.add((Component)buttonsPnl, "Center");
        contentPnl.add((Component)southPnl, "South");
        SeerGuiUtils.synchronizedComponentsWidth(okBtn, cancelBtn);
    }

    public void performCancel() {
        SeerGuiUtils.hideAndDestroy(this, null, false);
    }

    public void performOk() {
        if (this._field.getText() != null && this._field.getText().equals(this._previousValue)) {
            return;
        }
        this._previousValue = this._field.getText();
        int line = -1;
        if (this._field.getText() != null && this._field.getText().trim().matches("\\d+")) {
            line = Integer.parseInt(this._field.getText().trim());
        }
        if (line < 1 || line > this._maxLineNum) {
            line = -1;
        }
        if (line == -1) {
            JOptionPane.showMessageDialog(this, "Invalid line number.", "Error", 0);
            this._field.requestFocusInWindow();
            this._field.selectAll();
            return;
        }
        try {
            int start = SyntaxUtils.getSyntaxDocument(this._comp).getStartOfLineFromLineNumber(line - 1);
            this._comp.setCaretPosition(start);
            Rectangle rect = this._comp.modelToView(start);
            this._comp.scrollRectToVisible(rect);
        }
        catch (BadLocationException e1) {
            throw new RuntimeException("Unable to go to line", e1);
        }
        SeerGuiUtils.hideAndDestroy(this, null, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            this.performOk();
        } else if ("cancel".equals(e.getActionCommand())) {
            this.performCancel();
        }
    }

    @Override
    public boolean handleShortcut(int key) {
        return false;
    }

    @Override
    public String getWindowId() {
        return this.getName();
    }
}

