/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.editor.LexerToken;
import com.imsweb.seerutilsgui.editor.SyntaxDocument;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public final class SyntaxUtils {
    private SyntaxUtils() {
    }

    public static void removeMarkers(JTextComponent component, SimpleMarker marker) {
        Highlighter hihglighter = component.getHighlighter();
        for (Highlighter.Highlight h : hihglighter.getHighlights()) {
            if (!(h.getPainter() instanceof SimpleMarker)) continue;
            SimpleMarker hMarker = (SimpleMarker)h.getPainter();
            if (marker != null && !hMarker.equals(marker)) continue;
            hihglighter.removeHighlight(h);
        }
    }

    public static void removeMarkers(JTextComponent editorPane) {
        SyntaxUtils.removeMarkers(editorPane, null);
    }

    public static void markToken(JTextComponent pane, LexerToken token, SimpleMarker marker) {
        SyntaxUtils.markText(pane, token.start, token.end(), marker);
    }

    public static void markText(JTextComponent pane, int start, int end, SimpleMarker marker) {
        try {
            Highlighter hiliter = pane.getHighlighter();
            int selStart = pane.getSelectionStart();
            int selEnd = pane.getSelectionEnd();
            if (selStart == selEnd || end < selStart || start > selStart) {
                hiliter.addHighlight(start, end, marker);
                return;
            }
            if (selStart > start && selStart < end) {
                hiliter.addHighlight(start, selStart, marker);
            }
            if (selEnd > start && selEnd < end) {
                hiliter.addHighlight(selEnd, end, marker);
            }
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Unable to highlight text", ex);
        }
    }

    public static void markAll(JTextComponent pane, Pattern pattern, SimpleMarker marker) {
        SyntaxDocument sDoc = SyntaxUtils.getSyntaxDocument(pane);
        if (sDoc == null || pattern == null) {
            return;
        }
        Matcher matcher = sDoc.getMatcher(pattern);
        while (matcher.find()) {
            SyntaxUtils.markText(pane, matcher.start(), matcher.end(), marker);
        }
    }

    public static SyntaxDocument getSyntaxDocument(JTextComponent component) {
        if (component == null) {
            return null;
        }
        Document doc = component.getDocument();
        if (doc instanceof SyntaxDocument) {
            return (SyntaxDocument)doc;
        }
        return null;
    }

    public static String getLineAt(JTextComponent component, int pos) {
        String line = null;
        Document doc = component.getDocument();
        if (doc instanceof PlainDocument) {
            PlainDocument pDoc = (PlainDocument)doc;
            int start = pDoc.getParagraphElement(pos).getStartOffset();
            int end = pDoc.getParagraphElement(pos).getEndOffset();
            try {
                line = doc.getText(start, end - start);
                if (line != null && line.endsWith("\n")) {
                    line = line.substring(0, line.length() - 1);
                }
            }
            catch (BadLocationException ex) {
                throw new RuntimeException("Unable to get current line", ex);
            }
        }
        return line;
    }

    public static int getLineNumber(JTextComponent component, int pos) {
        try {
            Rectangle r = component.modelToView(pos);
            if (r == null) {
                return 0;
            }
            return r.y / component.getFontMetrics(component.getFont()).getHeight();
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Unable to get current line", ex);
        }
    }

    public static int getColumnNumber(JTextComponent component, int pos) {
        try {
            Rectangle r = component.modelToView(pos);
            if (r == null) {
                return 0;
            }
            return pos - component.viewToModel(new Point(0, r.y));
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Unable to get current line", ex);
        }
    }

    public static int getLineCount(JTextComponent component) {
        int count = 0;
        int p = component.getDocument().getLength() - 1;
        if (p > 0) {
            count = SyntaxUtils.getLineNumber(component, p);
        }
        return count;
    }

    public static class SimpleMarker
    extends DefaultHighlighter.DefaultHighlightPainter {
        public SimpleMarker(Color color) {
            super(color);
        }
    }
}

