/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.table;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.table.SeerCellListener;
import com.imsweb.seerutilsgui.table.SeerColumn;
import com.imsweb.seerutilsgui.table.SeerTableActionButton;
import com.imsweb.seerutilsgui.table.SeerTableActionEditor;
import com.imsweb.seerutilsgui.table.SeerTableActionRenderer;
import com.imsweb.seerutilsgui.table.SeerTableCheckBox;
import com.imsweb.seerutilsgui.table.SeerTableCheckBoxEditor;
import com.imsweb.seerutilsgui.table.SeerTableCheckBoxRenderer;
import com.imsweb.seerutilsgui.table.SeerTableStringEditor;
import com.imsweb.seerutilsgui.table.SeerTableStringRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class SeerTable
extends JTable {
    public static final int TABLE_ROW_HEIGHT = 18;
    public static final Color COLOR_TABLE_ROW_EVEN = new Color(224, 238, 255);
    public static final Color COLOR_TABLE_ROW_ODD = new Color(255, 255, 255);
    public static final Color COLOR_TABLE_ROW_LBL = new Color(0, 0, 0);
    public static final Color COLOR_TABLE_ROW_SELECTED = new Color(176, 211, 255);
    public static final Color COLOR_TABLE_ROW_SELECTED_LBL = new Color(0, 0, 0);
    public static final Color COLOR_TABLE_CELL_FOCUSED = new Color(136, 189, 255);
    public static final Color COLOR_TABLE_CELL_FOCUSED_LBL = new Color(0, 0, 0);
    public static final Border TABLE_BORDER_IN = BorderFactory.createLineBorder(SeerGuiUtils.COLOR_COMP_FOCUS_IN);
    public static final Border TABLE_BORDER_OUT = BorderFactory.createLineBorder(SeerGuiUtils.COLOR_COMP_FOCUS_OUT);
    public static final Border TABLE_DEFAULT_CELL_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final Border TABLE_FOCUSED_CELL_BORDER = UIManager.getBorder("Table.focusCellHighlightBorder");
    public static final String TABLE_ACTION_NEXT_COMP = "table-next-comp";
    public static final String TABLE_ACTION_PREVIOUS_COMP = "table-previous-comp";
    protected transient List<SeerColumn> _colInfo;
    protected transient TableRowSorter<TableModel> _sorter;
    protected int _defaultSortColumn = -1;
    protected SortOrder _defaultSortDirection;
    protected boolean _alternateColors = true;
    protected transient Map<String, Integer> _cachedLookupSize = new ConcurrentHashMap<String, Integer>(new HashMap());
    private static final Pattern _TOKEN_REGEX = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");

    public SeerTable(List<SeerColumn> colInfo, Vector<Vector<Object>> data, boolean selectable, boolean sortable, boolean addFocusListener, SeerCellListener l) {
        int i;
        this._colInfo = colInfo;
        SeerTableModel model = new SeerTableModel(colInfo, data);
        this.setModel(model);
        this.setRowHeight(18);
        this.setIntercellSpacing(new Dimension(1, 1));
        this.setAutoResizeMode(1);
        this.setGridColor(Color.LIGHT_GRAY);
        this.setShowGrid(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setRowSelectionAllowed(selectable);
        this.setPreferredScrollableViewportSize(new Dimension(-1, this.getModel().getRowCount() * this.getRowHeight()));
        this.setDefaultRenderer(String.class, new SeerTableStringRenderer());
        this.setDefaultRenderer(SeerTableActionButton.class, new SeerTableActionRenderer());
        this.setDefaultRenderer(SeerTableCheckBox.class, new SeerTableCheckBoxRenderer(colInfo));
        if (selectable) {
            this.setDefaultEditor(String.class, new SeerTableStringEditor(l));
            this.setDefaultEditor(SeerTableActionButton.class, new SeerTableActionEditor(l));
            this.setDefaultEditor(SeerTableCheckBox.class, new SeerTableCheckBoxEditor(l));
        }
        ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(1));
        this.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0), "none");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "none");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 64), "none");
        for (i = this._colInfo.size() - 1; i >= 0; --i) {
            SeerColumn dto = this._colInfo.get(i);
            this.getColumnModel().getColumn(i).setIdentifier(dto);
            if (Boolean.FALSE.equals(dto.getVisible())) {
                this.getColumnModel().removeColumn(this.getColumnModel().getColumn(i));
            }
            if (dto.getDefaultSort() != null) {
                this._defaultSortColumn = i;
                SortOrder sortOrder = this._defaultSortDirection = dto.getDefaultSort().equals((Object)SeerColumn.SeerColumnSortOrderType.ASCENDING) ? SortOrder.ASCENDING : SortOrder.DESCENDING;
            }
            if (dto.getContentType().equals(SeerTableActionButton.class)) {
                this.setRowHeight(32);
            }
            if (!dto.getContentType().equals(SeerTableActionButton.class) && !dto.getContentType().equals(SeerTableCheckBox.class)) continue;
            this.getColumnModel().getColumn(i).setResizable(false);
            if (i <= 0) continue;
            this.getColumnModel().getColumn(i - 1).setResizable(false);
        }
        if (sortable) {
            this._sorter = new TableRowSorter<TableModel>(this.getModel());
            this.setRowSorter(this._sorter);
            for (i = this._colInfo.size() - 1; i >= 0; --i) {
                if (!this._colInfo.get(i).getContentType().equals(JPanel.class)) continue;
                this._sorter.setSortable(i, false);
            }
            if (this._defaultSortColumn != -1) {
                this._sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(this._defaultSortColumn, this._defaultSortDirection)));
            }
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SeerTable.this.resizeColumns();
                SeerTable.this.resizeRows();
            }
        });
        if (addFocusListener) {
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    Container pane = SeerTable.this.getParent().getParent();
                    if (pane instanceof JScrollPane) {
                        ((JScrollPane)pane).setBorder(TABLE_BORDER_IN);
                    } else {
                        SeerTable.this.setBorder(TABLE_BORDER_IN);
                    }
                    if (SeerTable.this.getCellEditor() == null && (SeerTable.this.getSelectedColumn() == -1 || SeerTable.this.getSelectedRow() == -1) && SeerTable.this.getRowCount() > 0) {
                        SeerTable.this.changeSelection(0, 0, false, false);
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    Container pane = SeerTable.this.getParent().getParent();
                    if (pane instanceof JScrollPane) {
                        ((JScrollPane)pane).setBorder(TABLE_BORDER_OUT);
                    } else {
                        SeerTable.this.setBorder(TABLE_BORDER_OUT);
                    }
                }
            });
        }
        if (selectable) {
            this.setSelectionMode(0);
        }
    }

    public boolean getAlternateRowColors() {
        return this._alternateColors;
    }

    public void setAlternateRowColors(boolean alternate) {
        this._alternateColors = alternate;
    }

    public void setNextComponent(final JComponent comp) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), TABLE_ACTION_NEXT_COMP);
        this.getActionMap().put(TABLE_ACTION_NEXT_COMP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(comp::requestFocusInWindow);
            }
        });
    }

    public void setPreviousComponent(final JComponent comp) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 64), TABLE_ACTION_PREVIOUS_COMP);
        this.getActionMap().put(TABLE_ACTION_PREVIOUS_COMP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(comp::requestFocusInWindow);
            }
        });
    }

    public void setDefaultAction(final AbstractAction action) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    Class<?> clazz;
                    boolean hasSelectedColumn = SeerTable.this.getSelectedColumn() != -1;
                    SeerColumn info = hasSelectedColumn ? SeerTable.this._colInfo.get(SeerTable.this.convertColumnIndexToModel(SeerTable.this.getSelectedColumn())) : null;
                    Class<?> clazz2 = clazz = hasSelectedColumn && info != null ? info.getContentType() : null;
                    if (!hasSelectedColumn || info != null && !info.getEditable().booleanValue() && !SeerTableActionButton.class.equals(clazz) && !SeerTableCheckBox.class.equals(clazz)) {
                        action.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "default-action"));
                    }
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "default-action");
        this.getActionMap().put("default-action", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = SeerTable.this.getSelectedRow();
                int selectedCol = SeerTable.this.getSelectedColumn();
                if (selectedRow == -1 || selectedCol == -1) {
                    return;
                }
                int row = SeerTable.this.convertRowIndexToModel(selectedRow);
                int col = SeerTable.this.convertColumnIndexToModel(selectedCol);
                SeerColumn info = SeerTable.this._colInfo.get(col);
                Class<?> clazz = info.getContentType();
                if (SeerTableActionButton.class.equals(clazz)) {
                    SeerTableActionButton btn = (SeerTableActionButton)SeerTable.this.fetchValue(row, col);
                    if (btn.isEnabled()) {
                        SeerTable.this.editCellAt(SeerTable.this.getSelectedRow(), SeerTable.this.getSelectedColumn());
                        btn.doClick();
                    }
                } else if (SeerTableCheckBox.class.equals(clazz)) {
                    SeerTableCheckBox box = (SeerTableCheckBox)SeerTable.this.fetchValue(row, col);
                    if (box.isEnabled()) {
                        SeerTable.this.editCellAt(SeerTable.this.getSelectedRow(), SeerTable.this.getSelectedColumn());
                        box.setSelected(!box.isSelected());
                        SeerTable.this.getCellEditor().stopCellEditing();
                    }
                } else if (Boolean.TRUE.equals(info.getEditable())) {
                    SeerTable.this.editCellAt(SeerTable.this.getSelectedRow(), SeerTable.this.getSelectedColumn());
                } else {
                    action.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "default-action"));
                }
            }
        });
    }

    public List<SeerColumn> getColumnInfo() {
        return Collections.unmodifiableList(this._colInfo);
    }

    @Override
    public int convertRowIndexToModel(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            throw new RuntimeException("Bad row index requested for " + this.getName() + ": " + rowIndex);
        }
        return super.convertRowIndexToModel(rowIndex);
    }

    @Override
    public int convertColumnIndexToModel(int colIndex) {
        int numInvisible = 0;
        int numVisible = 0;
        for (SeerColumn info : this._colInfo) {
            if (Boolean.FALSE.equals(info.getVisible())) {
                ++numInvisible;
                continue;
            }
            if (numVisible == colIndex) {
                return numInvisible + numVisible;
            }
            ++numVisible;
        }
        throw new RuntimeException("Bad column index requested for " + this.getName() + ": " + colIndex);
    }

    public void resetSorting() {
        if (this._sorter != null) {
            this._sorter.setSortKeys(null);
        }
    }

    public void reapplyDefaultSorting() {
        if (this._sorter != null && this._defaultSortColumn != -1) {
            this._sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(this._defaultSortColumn, this._defaultSortDirection)));
        }
    }

    public void applySearchTextAsRowFilter(String searchText) {
        if (this._sorter != null) {
            TableCellRenderer renderer = this.getDefaultRenderer(String.class);
            if (renderer instanceof SeerTableStringRenderer) {
                ((SeerTableStringRenderer)renderer).setHighlighting(searchText);
            }
            final List<String> tokens = SeerTable.splitSearchString(searchText);
            this.setRowFilter(new RowFilter<Object, Object>(){

                @Override
                public boolean include(RowFilter.Entry<?, ?> entry) {
                    boolean include = true;
                    if (!tokens.isEmpty()) {
                        include = false;
                    }
                    for (int i = 0; i < entry.getValueCount(); ++i) {
                        if (!Boolean.TRUE.equals(SeerTable.this._colInfo.get(i).getVisible())) continue;
                        for (String token : tokens) {
                            if (!(include |= ((String)entry.getValue(i)).toUpperCase().contains(token))) continue;
                            break;
                        }
                        if (include) break;
                    }
                    return include;
                }
            });
        }
    }

    public void setRowFilter(RowFilter<Object, Object> filter) {
        if (this._sorter != null) {
            this._sorter.setRowFilter(filter);
            this._sorter.sort();
        }
    }

    public void resetRowFilter() {
        if (this._sorter != null) {
            this._sorter.setRowFilter(null);
            TableCellRenderer renderer = this.getDefaultRenderer(String.class);
            if (renderer instanceof SeerTableStringRenderer) {
                ((SeerTableStringRenderer)renderer).resetHighlighting();
            }
            this._sorter.sort();
        }
    }

    public void updateValue(Object value, int row, int col) {
        this.getModel().setValueAt(value, row, col);
    }

    public Object fetchValue(int row, int col) {
        return this.getModel().getValueAt(row, col);
    }

    public void addRow(Vector<Object> row) {
        ((SeerTableModel)this.getModel()).addRow(row);
    }

    public void addRowBefore(Vector<Object> row, int targetRow) {
        ((SeerTableModel)this.getModel()).addRowBefore(row, targetRow);
    }

    public void addRowAfter(Vector<Object> row, int targetRow) {
        ((SeerTableModel)this.getModel()).addRowAfter(row, targetRow);
    }

    public void addRows(Vector<Vector<Object>> rows) {
        ((SeerTableModel)this.getModel()).addRows(rows);
    }

    public void removeRow(int row) {
        ((SeerTableModel)this.getModel()).removeRow(row);
    }

    public void removeAllRows() {
        ((SeerTableModel)this.getModel()).removeAllRows();
    }

    public int getPreferredHeightNoScrolling() {
        return this.getPreferredHeightNoScrolling(0);
    }

    public int getPreferredHeightNoScrolling(int allowedWidth) {
        int h = 0;
        boolean inScrollPane = this.getParent() instanceof JViewport;
        for (int col = 0; col < this._colInfo.size(); ++col) {
            SeerColumn dto = this._colInfo.get(col);
            if (!Boolean.TRUE.equals(dto.getVisible())) continue;
            int colHeight = inScrollPane ? this.getTableHeader().getPreferredSize().height + 2 : 0;
            int colIdx = this.convertColumnIndexToView(col);
            Class<?> clazz = this.getModel().getColumnClass(col);
            for (int row = 0; row < this.getModel().getRowCount(); ++row) {
                int cellHeight;
                Component comp = this.getDefaultRenderer(clazz).getTableCellRendererComponent(this, this.fetchValue(row, col), false, false, row, colIdx);
                if (Boolean.TRUE.equals(dto.getLongText())) {
                    JPanel panel = (JPanel)comp;
                    JTextArea area = (JTextArea)panel.getComponent(0);
                    area.setSize(allowedWidth, Integer.MAX_VALUE);
                    cellHeight = Math.max(area.getPreferredSize().height, this.getRowHeight());
                } else {
                    cellHeight = Math.max(comp.getPreferredSize().height, this.getRowHeight());
                }
                colHeight += cellHeight;
            }
            h = Math.max(h, colHeight);
        }
        return h;
    }

    public int getPreferredWidthNoScrolling() {
        int w = 0;
        for (int col = 0; col < this._colInfo.size(); ++col) {
            SeerColumn dto = this._colInfo.get(col);
            if (!Boolean.TRUE.equals(dto.getVisible())) continue;
            TableCellRenderer renderer = this.getColumn(dto).getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getTableHeader().getDefaultRenderer();
            }
            Component header = renderer.getTableCellRendererComponent(this, dto.getHeader(), false, false, 0, 0);
            int colWidth = header.getPreferredSize().width;
            int colIdx = this.convertColumnIndexToView(col);
            Class<?> clazz = this.getModel().getColumnClass(col);
            for (int row = 0; row < this.getModel().getRowCount(); ++row) {
                Component comp = this.getDefaultRenderer(clazz).getTableCellRendererComponent(this, this.fetchValue(row, col), false, false, row, colIdx);
                int cellWidth = 0;
                if (Boolean.TRUE.equals(dto.getLongText())) {
                    JPanel panel = (JPanel)comp;
                    JTextArea area = (JTextArea)panel.getComponent(0);
                    if (area.getText() != null) {
                        for (String s : area.getText().split("\n")) {
                            cellWidth = Math.max(cellWidth, SwingUtilities.computeStringWidth(area.getFontMetrics(area.getFont()), s));
                        }
                    }
                    cellWidth += 20;
                } else {
                    cellWidth = comp.getPreferredSize().width + 10;
                }
                colWidth = Math.max(colWidth, cellWidth);
            }
            w += colWidth;
        }
        return w;
    }

    public synchronized void resizeColumns() {
        int tableWidth = this.getWidth();
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        int freeSizes = 0;
        int totalRequiredWith = 0;
        HashMap<SeerColumn, Integer> dataDrivenSizes = new HashMap<SeerColumn, Integer>();
        for (int col = 0; col < this._colInfo.size(); ++col) {
            SeerColumn dto = this._colInfo.get(col);
            if (!Boolean.TRUE.equals(dto.getVisible())) continue;
            if (dto.getWidth() == SeerColumn.SeerColumnWidthType.FIXED && dto.getFixedSize() != null && dto.getFixedSize() > 0) {
                totalRequiredWith += dto.getFixedSize().intValue();
                continue;
            }
            if (dto.getWidth() == SeerColumn.SeerColumnWidthType.MIN) {
                int w = 0;
                if (dto.getLookup() != null) {
                    Integer size = this._cachedLookupSize.get(dto.getLookup());
                    if (size == null || size <= 0) {
                        int count = 0;
                        int maxSize = 0;
                        for (Map.Entry<String, String> mapping : this.fetchLookup(dto.getLookup()).entrySet()) {
                            if (mapping.getValue() != null) {
                                maxSize = Math.max(w, SeerTableStringRenderer.getValueWidth(mapping.getValue(), g));
                            }
                            if (++count != 100) continue;
                            break;
                        }
                        size = maxSize;
                        this._cachedLookupSize.put(dto.getLookup(), size);
                    }
                    w = size;
                } else {
                    SeerTableModel model = (SeerTableModel)this.getModel();
                    for (int i = 0; i < this.getNumRowsToEvaluateForWidthComputation() && i < model.getRowCount(); ++i) {
                        Object val = model.getValueAt(i, col);
                        if (val == null) continue;
                        w = Math.max(w, SeerTableStringRenderer.getValueWidth(val.toString(), g));
                    }
                }
                TableCellRenderer headerRenderer = this.getColumn(dto).getHeaderRenderer();
                if (headerRenderer == null) {
                    headerRenderer = this.getTableHeader().getDefaultRenderer();
                }
                Component header = headerRenderer.getTableCellRendererComponent(this, dto.getHeader(), false, false, 0, 0);
                w = Math.max(w, header.getPreferredSize().width);
                dataDrivenSizes.put(dto, w);
                totalRequiredWith += w;
                continue;
            }
            ++freeSizes;
        }
        int freeSize = freeSizes == 0 ? 0 : (tableWidth - totalRequiredWith) / freeSizes;
        for (SeerColumn dto : this._colInfo) {
            if (!Boolean.TRUE.equals(dto.getVisible())) continue;
            TableColumn col = this.getColumn(dto);
            if (dto.getFixedSize() != null) {
                col.setPreferredWidth(dto.getFixedSize());
                continue;
            }
            col.setPreferredWidth(dataDrivenSizes.getOrDefault(dto, freeSize));
        }
    }

    protected int getNumRowsToEvaluateForWidthComputation() {
        return 500;
    }

    public synchronized void resizeRows() {
        ArrayList<Integer> colIndexes = new ArrayList<Integer>();
        for (int colIdx = 0; colIdx < this._colInfo.size(); ++colIdx) {
            SeerColumn dto = this._colInfo.get(colIdx);
            if (!dto.getVisible().booleanValue() || !dto.getLongText().booleanValue()) continue;
            colIndexes.add(colIdx);
        }
        if (!colIndexes.isEmpty()) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                int height = 0;
                for (Integer colIdx : colIndexes) {
                    int h;
                    int viewColIdx = this.convertColumnIndexToView(colIdx);
                    TableCellRenderer renderer = this.getCellRenderer(row, viewColIdx);
                    if (renderer instanceof SeerTableStringRenderer) {
                        Object val = this.getValueAt(row, viewColIdx);
                        if (val == null) {
                            val = this._colInfo.get(colIdx).getDefaultValue();
                        }
                        h = ((SeerTableStringRenderer)renderer).getTableCellRendererComponentHeight(this, val, false, false, row, viewColIdx);
                    } else {
                        h = this.getRowHeight();
                    }
                    height = Math.max(height, h);
                }
                this.setRowHeight(row, height);
            }
        }
    }

    public Map<String, String> fetchLookup(String id) {
        return Collections.emptyMap();
    }

    public static SeerColumn createSelectionColumn() {
        SeerColumn dto = new SeerColumn("");
        dto.setContentType(SeerTableCheckBox.class);
        dto.setEditable(true);
        dto.setWidth(SeerColumn.SeerColumnWidthType.FIXED);
        dto.setFixedSize(30);
        return dto;
    }

    public static SeerColumn createActionColumn(String tooltip) {
        SeerColumn dto = new SeerColumn("");
        dto.setContentType(SeerTableActionButton.class);
        dto.setEditable(true);
        dto.setTooltip(tooltip);
        dto.setWidth(SeerColumn.SeerColumnWidthType.FIXED);
        dto.setFixedSize(37);
        return dto;
    }

    public static SeerTableCheckBox createSelectionValue(String command) {
        return new SeerTableCheckBox(command);
    }

    public static SeerTableActionButton createActionValue(String icon, String command) {
        return new SeerTableActionButton(icon, command);
    }

    public static List<String> splitSearchString(String searchString) {
        ArrayList<String> result = new ArrayList<String>();
        if (searchString == null || searchString.trim().isEmpty()) {
            return result;
        }
        Matcher matcher = _TOKEN_REGEX.matcher(searchString);
        while (matcher.find()) {
            String s = matcher.group(1) != null ? matcher.group(1) : (matcher.group(2) != null ? matcher.group(2) : matcher.group());
            if (s == null || s.trim().isEmpty()) continue;
            result.add(s.toUpperCase());
        }
        return result;
    }

    public static List<List<Integer>> calculateHighlighting(String text, String searchString) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        if (text == null || text.isEmpty()) {
            return result;
        }
        text = text.toUpperCase();
        for (String searchText : SeerTable.splitSearchString(searchString)) {
            int start = text.indexOf(searchText);
            while (start != -1) {
                int end = start + searchText.length() - 1;
                ArrayList<Integer> list = new ArrayList<Integer>(2);
                list.add(start);
                list.add(end);
                result.add(list);
                start = text.indexOf(searchText, end + 1);
            }
        }
        result.sort(Comparator.comparing(l -> (Integer)l.get(0)));
        return result;
    }

    public class SeerTableModel
    extends AbstractTableModel {
        private final List<SeerColumn> _modelColInfo;
        private final transient Vector<Vector<Object>> _data;

        public SeerTableModel(List<SeerColumn> colInfo, Vector<Vector<Object>> data) {
            this._modelColInfo = colInfo;
            this._data = data;
        }

        @Override
        public int getColumnCount() {
            return this._modelColInfo.size();
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this._modelColInfo.get(col).getHeader();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this._data.size()) {
                throw new RuntimeException("Invalid row index, got " + row + " but table (" + SeerTable.this.getName() + ") has " + this._data.size() + " row(s)");
            }
            Vector<Object> objects = this._data.get(row);
            if (col < 0 || col >= objects.size()) {
                throw new RuntimeException("Invalid col index, got " + col + " but table (" + SeerTable.this.getName() + ") has " + objects.size() + " col(s)");
            }
            return objects.get(col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row < 0 || row >= this._data.size()) {
                throw new ArrayIndexOutOfBoundsException("Row index " + row + " out of range 0-" + (this._data.size() - 1));
            }
            Vector<Object> objects = this._data.get(row);
            if (col < 0 || col >= objects.size()) {
                throw new ArrayIndexOutOfBoundsException("Col index " + col + " out of range 0-" + (objects.size() - 1));
            }
            objects.set(col, value);
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this._modelColInfo.get(col).getContentType();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this._modelColInfo.get(col).getEditable();
        }

        public void addRow(Vector<Object> row) {
            this._data.add(row);
            this.fireTableDataChanged();
        }

        public void addRowBefore(Vector<Object> row, int targetRow) {
            this._data.add(targetRow - 1, row);
            this.fireTableDataChanged();
        }

        public void addRowAfter(Vector<Object> row, int targetRow) {
            this._data.add(targetRow, row);
            this.fireTableDataChanged();
        }

        public void removeRow(int row) {
            this._data.remove(row);
            this.fireTableDataChanged();
        }

        public void addRows(Vector<Vector<Object>> rows) {
            this._data.addAll(rows);
            this.fireTableDataChanged();
        }

        public void removeAllRows() {
            this._data.clear();
            this.fireTableDataChanged();
        }
    }
}

