/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.table;

import com.imsweb.seerutilsgui.table.SeerCellEvent;
import com.imsweb.seerutilsgui.table.SeerCellListener;
import com.imsweb.seerutilsgui.table.SeerTable;
import com.imsweb.seerutilsgui.table.SeerTableActionButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class SeerTableActionEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private SeerTableActionButton _btn;
    private int _row;
    private int _col;
    private JTable _table;
    private boolean _editedByKey;
    private final transient SeerCellListener _cellListener;

    public SeerTableActionEditor(SeerCellListener l) {
        this._cellListener = l;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e == null) {
            return true;
        }
        if (e instanceof MouseEvent) {
            this._editedByKey = false;
            return true;
        }
        if (e instanceof KeyEvent) {
            this._editedByKey = true;
            return ((KeyEvent)e).getKeyCode() == 10;
        }
        return false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._row = table.convertRowIndexToModel(row);
        this._col = column;
        this._table = table;
        this._btn = (SeerTableActionButton)value;
        if (this._btn != null) {
            this._btn.addActionListener(this);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(SeerTable.COLOR_TABLE_ROW_SELECTED);
        panel.setBorder(SeerTable.TABLE_FOCUSED_CELL_BORDER);
        if (this._btn != null) {
            panel.add(this._btn);
        } else {
            panel.add(Box.createRigidArea(new Dimension(28, 28)));
        }
        if (this._editedByKey) {
            SwingUtilities.invokeLater(this::stopCellEditing);
        }
        return panel;
    }

    @Override
    public boolean stopCellEditing() {
        super.stopCellEditing();
        if (this._btn != null) {
            this._btn.removeActionListener(this);
            if (this._cellListener != null && this._btn.isEnabled()) {
                this._cellListener.actionPerformed(new SeerCellEvent((Object)this._table, 1, this._btn.getActionCommand(), this._row, this._col));
            }
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this._btn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
    }
}

