/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.table;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerHighlightingEditorKit;
import com.imsweb.seerutilsgui.table.SeerColumn;
import com.imsweb.seerutilsgui.table.SeerTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

public class SeerTableStringRenderer
extends JPanel
implements TableCellRenderer {
    protected final JLabel _lbl;
    protected final JTextArea _area;
    protected final JTextPane _pane;
    protected final JTextArea _area2;
    private final Font _font;
    private boolean _usingLbl;
    private boolean _usingBorderLayout;
    protected boolean _allowHightlighting;
    private final Map<String, SeerHighlightingEditorKit> _highlights;
    private String _search = null;

    public SeerTableStringRenderer() {
        this(false);
    }

    public SeerTableStringRenderer(boolean allowHighlighting) {
        this.setOpaque(true);
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this._allowHightlighting = allowHighlighting;
        this._lbl = SeerGuiUtils.createLabel("");
        this._lbl.setOpaque(false);
        this._lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this._area = new JTextArea();
        this._area.setOpaque(false);
        this._area.setLineWrap(true);
        this._area.setWrapStyleWord(true);
        this._area.setEditable(false);
        this._area.setMargin(new Insets(0, 5, 3, 5));
        this._area.setFont(this._lbl.getFont());
        this._area2 = new JTextArea();
        this._area2.setOpaque(false);
        this._area2.setLineWrap(true);
        this._area2.setWrapStyleWord(true);
        this._area2.setEditable(false);
        this._area2.setMargin(new Insets(0, 5, 3, 5));
        this._area2.setFont(this._lbl.getFont());
        this._pane = new JTextPane();
        this._pane.setOpaque(false);
        this._pane.setEditable(false);
        this._pane.setFont(this._lbl.getFont());
        if (allowHighlighting) {
            this.add((Component)this._pane, "Center");
            this._usingBorderLayout = true;
        } else {
            this.add((Component)this._lbl, "Center");
            this._usingLbl = true;
        }
        this._font = this._lbl.getFont();
        this._highlights = new HashMap<String, SeerHighlightingEditorKit>();
    }

    @Override
    public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        SeerColumn colInfo = ((SeerTable)table).getColumnInfo().get(table.convertColumnIndexToModel(column));
        String text = value == null ? colInfo.getDefaultValue() : value.toString();
        Color foregroundColor = this.computeForegroundColor(table, value, isSelected, hasFocus, row, column);
        Font font = this.computeFontStyle(table, value, isSelected, hasFocus, row, column);
        if (this._allowHightlighting) {
            String key;
            SeerHighlightingEditorKit highlighting;
            if (Boolean.TRUE.equals(colInfo.getLongText())) {
                if (!this._usingBorderLayout) {
                    this.removeAll();
                    this.setLayout(new BorderLayout());
                    this.add((Component)this._pane, "Center");
                    this._usingBorderLayout = true;
                }
            } else if (this._usingBorderLayout) {
                this.removeAll();
                this.setLayout(new GridBagLayout());
                this.add(this._pane);
                this._usingBorderLayout = false;
            }
            if ((highlighting = this._highlights.get(key = text + foregroundColor.toString())) == null) {
                highlighting = new SeerHighlightingEditorKit(SeerTable.calculateHighlighting(text, this._search), Color.RED, foregroundColor, font);
                this._highlights.put(key, highlighting);
            }
            this._pane.setEditorKit(highlighting);
            if (!Boolean.TRUE.equals(colInfo.getLongText()) && Boolean.TRUE.equals(colInfo.getCenterContent())) {
                int colWidth = table.getColumnModel().getColumn(column).getWidth();
                int textWidth = SeerTableStringRenderer.getValueWidth(text, table.getGraphics());
                int w = (colWidth - textWidth) / 2;
                this._pane.setMargin(new Insets(0, 5 + w, 2, 5 + w));
            } else {
                this._pane.setMargin(new Insets(0, 5, 2, 5));
            }
            this._pane.setFont(font);
            this._pane.setText(text);
        } else if (Boolean.TRUE.equals(colInfo.getLongText())) {
            if (this._usingLbl) {
                this.removeAll();
                this.add((Component)this._area, "Center");
                this._usingLbl = false;
            }
            this._area.setFont(font);
            this._area.setForeground(foregroundColor);
            this._area.setText(text);
        } else {
            if (!this._usingLbl) {
                this.removeAll();
                this.add((Component)this._lbl, "Center");
                this._usingLbl = true;
            }
            this._lbl.setHorizontalAlignment(Boolean.TRUE.equals(colInfo.getCenterContent()) ? 0 : 2);
            this._lbl.setFont(font);
            this._lbl.setForeground(foregroundColor);
            this._lbl.setText(text);
        }
        this.setBackground(this.computeBackgroundColor(table, value, isSelected, hasFocus, row, column));
        if (isSelected && hasFocus) {
            this.setBorder(SeerTable.TABLE_FOCUSED_CELL_BORDER);
        } else {
            this.setBorder(SeerTable.TABLE_DEFAULT_CELL_BORDER);
        }
        return this;
    }

    protected Color computeBackgroundColor(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color color = isSelected ? SeerTable.COLOR_TABLE_ROW_SELECTED : (row % 2 == 0 || !((SeerTable)table).getAlternateRowColors() ? SeerTable.COLOR_TABLE_ROW_ODD : SeerTable.COLOR_TABLE_ROW_EVEN);
        return color;
    }

    protected Color computeForegroundColor(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color color = isSelected ? (hasFocus ? SeerTable.COLOR_TABLE_CELL_FOCUSED_LBL : SeerTable.COLOR_TABLE_ROW_SELECTED_LBL) : SeerTable.COLOR_TABLE_ROW_LBL;
        return color;
    }

    protected Font computeFontStyle(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this._font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableCellRendererComponentHeight(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JTextArea jTextArea = this._area2;
        synchronized (jTextArea) {
            this._area2.setText(value == null ? null : value.toString());
            this._area2.setFont(this.computeFontStyle(table, value, isSelected, hasFocus, row, column));
            this._area2.setSize(table.getColumnModel().getColumn(column).getWidth(), Integer.MAX_VALUE);
            return Math.max(this._area2.getPreferredSize().height, table.getRowHeight());
        }
    }

    public void setHighlighting(String search) {
        this._search = search;
        this._highlights.clear();
    }

    public void resetHighlighting() {
        this._search = null;
        this._highlights.clear();
    }

    public static int getValueWidth(String val, Graphics g) {
        if (val == null) {
            return 0;
        }
        return SwingUtilities.computeStringWidth(g.getFontMetrics(), val) + 14;
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }
}

