/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutils;

import java.util.List;

public final class SeerMath {
    private SeerMath() {
    }

    public static Double calculateRegression(List<? extends Number> input) {
        return SeerMath.calculateRegressionResult(input).getResult();
    }

    public static RegressionResult calculateRegressionResult(List<? extends Number> input) {
        RegressionResult result = new RegressionResult();
        if (input == null || input.isEmpty()) {
            return result;
        }
        int n = input.size();
        double[] x = new double[n];
        double[] y = new double[n];
        double sumx = 0.0;
        double sumy = 0.0;
        for (int i = 0; i < n; ++i) {
            x[i] = Integer.valueOf(i).doubleValue();
            y[i] = input.get(i).doubleValue();
            sumx += x[i];
            sumy += y[i];
        }
        double xbar = sumx / (double)n;
        double ybar = sumy / (double)n;
        double xxbar = 0.0;
        double yybar = 0.0;
        double xybar = 0.0;
        for (int i = 0; i < n; ++i) {
            xxbar += (x[i] - xbar) * (x[i] - xbar);
            yybar += (y[i] - ybar) * (y[i] - ybar);
            xybar += (x[i] - xbar) * (y[i] - ybar);
        }
        double slope = xxbar == 0.0 ? 0.0 : xybar / xxbar;
        double intercept = ybar - slope * xbar;
        result.setResult((double)n * slope + intercept);
        double ssr = 0.0;
        for (int i = 0; i < n; ++i) {
            double fit = slope * x[i] + intercept;
            ssr += (fit - ybar) * (fit - ybar);
        }
        double rSquare = yybar == 0.0 ? 0.0 : ssr / yybar;
        result.setRsquare(rSquare);
        if (rSquare < 0.5 && n > 1) {
            result.setResult((input.get(n - 1).doubleValue() + input.get(n - 2).doubleValue()) / 2.0);
            result.setUseAverage(true);
        }
        if (result.getResult() < 0.0) {
            result.setResult(0.0);
        }
        if (result.getResult() - Math.floor(result.getResult()) < 0.5) {
            result.setResult(Math.floor(result.getResult()));
        }
        return result;
    }

    public static class RegressionResult {
        private Double _result = 0.0;
        private Boolean _useAverage = Boolean.FALSE;
        private Double _rsquare = 0.0;

        public Double getResult() {
            return this._result;
        }

        public void setResult(Double result) {
            this._result = result;
        }

        public Boolean getUseAverage() {
            return this._useAverage;
        }

        public void setUseAverage(Boolean useAverage) {
            this._useAverage = useAverage;
        }

        public Double getRsquare() {
            return this._rsquare;
        }

        public void setRsquare(Double rsquare) {
            this._rsquare = rsquare;
        }
    }
}

