/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutils;

import com.imsweb.seerutils.zip.ZipSecureFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class SeerUtils {
    private static final Pattern _VERSIONS_PATTERN = Pattern.compile("^\\d+(\\.\\d+){0,3}$");

    private SeerUtils() {
    }

    public static int compareSeerVersions(String version1, String version2) {
        int i;
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        String v1 = version1.toLowerCase();
        if (v1.startsWith("v")) {
            v1 = v1.substring(1);
        }
        v1 = v1.replace("-snapshot", "").replace("-beta", "");
        String v2 = version2.toLowerCase();
        if (v2.startsWith("v")) {
            v2 = v2.substring(1);
        }
        v2 = v2.replace("-snapshot", "").replace("-beta", "");
        if (!_VERSIONS_PATTERN.matcher(v1).matches()) {
            throw new IllegalArgumentException("Invalid version format: " + v1);
        }
        if (!_VERSIONS_PATTERN.matcher(v2).matches()) {
            throw new IllegalArgumentException("Invalid version format: " + v2);
        }
        String[] parts1 = StringUtils.split((String)v1, (char)'.');
        String[] parts2 = StringUtils.split((String)v2, (char)'.');
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        for (i = 0; i < Math.max(parts1.length, parts2.length); ++i) {
            if (i < parts1.length) {
                list1.add(Integer.valueOf(parts1[i]));
                continue;
            }
            list1.add(0);
        }
        for (i = 0; i < Math.max(parts1.length, parts2.length); ++i) {
            if (i < parts2.length) {
                list2.add(Integer.valueOf(parts2[i]));
                continue;
            }
            list2.add(0);
        }
        for (i = 0; i < list1.size(); ++i) {
            int result = ((Integer)list2.get(i)).compareTo((Integer)list1.get(i)) * -1;
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public static boolean isPureAscii(String s) {
        return s == null || SeerUtils.isPureAscii(s.getBytes(StandardCharsets.US_ASCII), null);
    }

    public static boolean isPureAscii(byte[] bytes) {
        return SeerUtils.isPureAscii(bytes, null);
    }

    public static boolean isPureAscii(byte[] bytes, byte[] exceptions) {
        if (bytes == null) {
            return true;
        }
        for (byte b : bytes) {
            if ((b >= 32 || b == 9 || b == 10 || b == 13) && b != 127 || exceptions != null && exceptions.length != 0 && ArrayUtils.contains((byte[])exceptions, (byte)b)) continue;
            return false;
        }
        return true;
    }

    public static void copyInputStreamToOutputStream(InputStream input, OutputStream output) throws IOException {
        SeerUtils.copyInputStreamToOutputStream(input, output, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToOutputStream(InputStream input, OutputStream output, boolean closeOutput) throws IOException {
        if (input == null) {
            throw new IOException("Input Stream is null");
        }
        if (output == null) {
            throw new IOException("Output Stream is null");
        }
        try (InputStream inputStream = input;){
            IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            output.flush();
        }
        finally {
            if (closeOutput) {
                output.close();
            }
        }
    }

    public static void copyReaderToWriter(Reader reader, Writer writer) throws IOException {
        SeerUtils.copyReaderToWriter(reader, writer, true);
    }

    public static void copyReaderToWriter(Reader input, Writer output, boolean closeOutput) throws IOException {
        if (input == null) {
            throw new IOException("Input Reader is null");
        }
        if (output == null) {
            throw new IOException("Output Writer is null");
        }
        IOUtils.copyLarge((Reader)input, (Writer)output);
        output.flush();
        input.close();
        if (closeOutput) {
            output.close();
        }
    }

    public static String readFile(File file) throws IOException {
        return SeerUtils.readFile(file, null);
    }

    public static String readFile(File file, String encoding) throws IOException {
        if (file == null || !file.exists()) {
            throw new IOException("File does not exist.");
        }
        StringWriter writer = new StringWriter();
        try (InputStream is = SeerUtils.createInputStream(file);){
            IOUtils.copy((InputStream)is, (Writer)writer, (String)encoding);
        }
        return ((Object)writer).toString();
    }

    public static String readUrl(URL url) throws IOException {
        return SeerUtils.readUrl(url, null);
    }

    public static String readUrl(URL url, String encoding) throws IOException {
        if (url == null) {
            throw new IOException("URL is null");
        }
        StringWriter writer = new StringWriter();
        try (InputStream is = url.openStream();){
            IOUtils.copy((InputStream)is, (Writer)writer, (String)encoding);
        }
        return writer.toString();
    }

    public static void writeFile(String input, File file) throws IOException {
        SeerUtils.writeFile(input, file, null);
    }

    public static void writeFile(String input, File file, String encoding) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((Reader)new StringReader(input), (OutputStream)fos, (String)encoding);
        }
    }

    public static InputStream createInputStream(File file) throws IOException {
        return SeerUtils.createInputStream(file, null);
    }

    public static InputStream createInputStream(File file, String zipEntryToUse) throws IOException {
        InputStream is;
        if (file == null || !file.exists()) {
            throw new IOException("File does not exist.");
        }
        String name = file.getName().toLowerCase();
        if (name.endsWith(".gz") || name.endsWith(".gzip")) {
            is = new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        } else if (name.endsWith(".zip")) {
            ZipSecureFile zipFile = new ZipSecureFile(file);
            ArrayList<String> list = new ArrayList<String>();
            Enumeration<ZipArchiveEntry> entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                list.add(entries.nextElement().getName());
            }
            if (list.isEmpty()) {
                throw new IOException("Zip file is empty.");
            }
            if (list.size() == 1) {
                zipEntryToUse = (String)list.get(0);
            }
            if (!list.contains(zipEntryToUse)) {
                throw new IOException("Zip file contains more than one file.");
            }
            InputStream tmp = zipFile.getInputStream(zipFile.getEntry(zipEntryToUse));
            if (zipEntryToUse.endsWith(".gz") || zipEntryToUse.endsWith(".gzip")) {
                is = new GZIPInputStream(tmp);
            } else {
                if (zipEntryToUse.endsWith(".zip")) {
                    throw new IOException("Zip files inside zip files is not supported.");
                }
                is = tmp;
            }
        } else {
            is = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        return is;
    }

    public static OutputStream createOutputStream(File file) throws IOException {
        String name = file.getName().toLowerCase();
        OutputStream os = name.endsWith(".gz") || name.endsWith(".gzip") ? new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])) : (name.endsWith(".zip") ? new ZipOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])) : Files.newOutputStream(file.toPath(), new OpenOption[0]));
        return os;
    }

    public static String pad(String value, int length, String with, boolean leftPad) {
        if (value == null || value.length() >= length) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value);
        while (builder.length() < length) {
            if (leftPad) {
                builder.insert(0, with);
                continue;
            }
            builder.append(with);
        }
        return builder.toString();
    }

    public static String trimLeft(String value) {
        int st;
        if (value == null || value.isEmpty()) {
            return value;
        }
        char[] val = value.toCharArray();
        for (st = 0; st < val.length && val[st] <= ' '; ++st) {
        }
        return value.substring(st);
    }

    public static String trimRight(String value) {
        int end;
        if (value == null || value.isEmpty()) {
            return value;
        }
        char[] val = value.toCharArray();
        for (end = val.length; end > 0 && val[end - 1] <= ' '; --end) {
        }
        return value.substring(0, end);
    }

    public static String formatNumber(int num) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(num);
    }

    public static String formatTime(long timeInMilli) {
        long hourBasis = 60L;
        StringBuilder formattedTime = new StringBuilder();
        long secTmp = timeInMilli / 1000L;
        long sec = secTmp % hourBasis;
        long minTmp = secTmp / hourBasis;
        long min = minTmp % hourBasis;
        long hour = minTmp / hourBasis;
        if (hour > 0L) {
            formattedTime.append(hour).append(" hour");
            if (hour > 1L) {
                formattedTime.append("s");
            }
        }
        if (min > 0L) {
            if (formattedTime.length() > 0) {
                formattedTime.append(", ");
            }
            formattedTime.append(min).append(" minute");
            if (min > 1L) {
                formattedTime.append("s");
            }
        }
        if (sec > 0L) {
            if (formattedTime.length() > 0) {
                formattedTime.append(", ");
            }
            formattedTime.append(sec).append(" second");
            if (sec > 1L) {
                formattedTime.append("s");
            }
        }
        if (formattedTime.length() > 0) {
            return formattedTime.toString();
        }
        return "< 1 second";
    }

    public static String formatFileSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return new DecimalFormat("#.# KB").format((double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return new DecimalFormat("#.# MB").format((double)size / 1024.0 / 1024.0);
        }
        return new DecimalFormat("#.# GB").format((double)size / 1024.0 / 1024.0 / 1024.0);
    }

    public static void copyDirectory(File from, File to) throws IOException {
        if (!from.exists()) {
            throw new IOException("Source directory does not exist.");
        }
        if (!from.isDirectory()) {
            throw new IOException("Source is not a directory.");
        }
        if (!to.exists() && !to.mkdirs()) {
            throw new IOException("Unable to create '" + to.getPath() + "'");
        }
        if (!to.isDirectory()) {
            throw new IOException("Target is not a directory.");
        }
        File[] files = from.listFiles();
        if (files == null) {
            throw new IOException("Unable to read from source directory");
        }
        for (File f : files) {
            if (f.isFile()) {
                try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                    SeerUtils.copyInputStreamToOutputStream(is, Files.newOutputStream(new File(to, f.getName()).toPath(), new OpenOption[0]));
                    continue;
                }
            }
            SeerUtils.copyDirectory(f, new File(to, f.getName()));
        }
    }

    public static void deleteDirectory(File dir) throws IOException {
        SeerUtils.deleteDirectory(dir, true);
    }

    public static void emptyDirectory(File dir) throws IOException {
        SeerUtils.deleteDirectory(dir, false);
    }

    private static void deleteDirectory(File dir, boolean deleteRoot) throws IOException {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new IOException("File is not a directory.");
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Unable to read from source directory");
        }
        for (File f : files) {
            if (f.isFile()) {
                Files.delete(f.toPath());
                continue;
            }
            SeerUtils.deleteDirectory(f, true);
        }
        if (deleteRoot) {
            Files.delete(dir.toPath());
        }
    }

    public static void zipFile(File file, File to) throws IOException {
        SeerUtils.zipFiles(Collections.singletonList(file), to);
    }

    public static void zipFiles(List<File> files, File to) throws IOException {
        if (!to.getName().toLowerCase().endsWith(".zip")) {
            throw new IOException("Target file must end with 'zip'.");
        }
        try (FileOutputStream fos = new FileOutputStream(to);
             ZipOutputStream zipOutput = new ZipOutputStream(fos);){
            for (File file : files) {
                if (!file.exists()) {
                    throw new IOException("Source directory does not exist.");
                }
                SeerUtils.internalZip(file, zipOutput, file.getParentFile().getAbsolutePath().length());
            }
        }
    }

    private static void internalZip(File file, ZipOutputStream zipOutput, int topDirLength) throws IOException {
        Object relative = file.getAbsolutePath().substring(topDirLength).replace('\\', '/').substring(1);
        if (file.isDirectory() && !((String)relative).endsWith("/")) {
            relative = (String)relative + "/";
        }
        zipOutput.putNextEntry(new ZipEntry((String)relative));
        if (file.isFile()) {
            SeerUtils.copyInputStreamToOutputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), zipOutput, false);
        } else {
            File[] files = file.listFiles();
            if (files != null) {
                for (File f : files) {
                    SeerUtils.internalZip(f, zipOutput, topDirLength);
                }
            }
        }
    }

    public static void unzipFile(File from, File to) throws IOException {
        if (!from.exists()) {
            throw new IOException("Source file does not exist.");
        }
        if (!from.isFile()) {
            throw new IOException("Source is not a file.");
        }
        if (!to.exists() && !to.mkdirs()) {
            throw new IOException("Unable to create '" + to.getPath() + "'");
        }
        if (!to.isDirectory()) {
            throw new IOException("Target is not a directory.");
        }
        try (ZipSecureFile file = new ZipSecureFile(from);){
            Enumeration<ZipArchiveEntry> entries = file.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = entries.nextElement();
                File target = new File(to, entry.getName());
                if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                    throw new IOException("Unable to create '" + target.getParentFile().getPath() + "'");
                }
                if (entry.isDirectory()) {
                    if (target.mkdirs()) continue;
                    throw new IOException("Unable to create '" + target.getPath() + "'");
                }
                try (FileOutputStream fos = new FileOutputStream(target);){
                    SeerUtils.copyInputStreamToOutputStream(file.getInputStream(entry), fos);
                }
            }
        }
    }
}

