/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutils.zip;

import com.imsweb.seerutils.zip.ZipEntryTooLargeException;
import com.imsweb.seerutils.zip.ZipInvalidCompressionRatioException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.InputStreamStatistics;

public class ZipArchiveThresholdInputStream
extends FilterInputStream {
    private static final long _GRACE_ENTRY_SIZE = 102400L;
    private static final String _MAX_ENTRY_SIZE_MSG = "The file exceeded the maximum entry size allowed";
    private static final String _MIN_INFLATE_RATIO_MSG = "The file exceeded the maximum compression ratio allowed";
    private double _minInflateRatio = 0.01;
    private long _maxEntrySize = 0xFFFFFFFFL;
    private ZipArchiveEntry _entry;
    private boolean _guardState = true;

    public ZipArchiveThresholdInputStream(InputStream is) {
        super(is);
    }

    void setEntry(ZipArchiveEntry entry) {
        this._entry = entry;
    }

    void setMaxEntrySize(long maxEntrySize) {
        this._maxEntrySize = maxEntrySize;
    }

    void setMinInflateRatio(double ratio) {
        this._minInflateRatio = ratio;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b > -1) {
            this.checkThreshold();
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int cnt = super.read(b, off, len);
        if (cnt > -1) {
            this.checkThreshold();
        }
        return cnt;
    }

    @Override
    public long skip(long n) throws IOException {
        long cnt = ZipArchiveThresholdInputStream.skipFully(this.in, n);
        if (cnt > 0L) {
            this.checkThreshold();
        }
        return cnt;
    }

    public void setGuardState(boolean guardState) {
        this._guardState = guardState;
    }

    private void checkThreshold() throws IOException {
        long rawSize;
        if (!this._guardState) {
            return;
        }
        if (!(this.in instanceof InputStreamStatistics)) {
            throw new IllegalArgumentException("InputStream of class " + String.valueOf(this.in.getClass()) + " is not implementing InputStreamStatistics.");
        }
        InputStreamStatistics stats = (InputStreamStatistics)this.in;
        long payloadSize = stats.getUncompressedCount();
        try {
            rawSize = stats.getCompressedCount();
        }
        catch (NullPointerException e) {
            rawSize = 0L;
        }
        if (this._maxEntrySize > 0L && payloadSize > this._maxEntrySize) {
            throw new ZipEntryTooLargeException(_MAX_ENTRY_SIZE_MSG);
        }
        if (payloadSize <= 102400L) {
            return;
        }
        double ratio = (double)rawSize / (double)payloadSize;
        if (this._minInflateRatio > 0.0 && ratio >= this._minInflateRatio) {
            return;
        }
        throw new ZipInvalidCompressionRatioException(_MIN_INFLATE_RATIO_MSG);
    }

    ZipArchiveEntry getNextEntry() throws IOException {
        if (!(this.in instanceof ZipArchiveInputStream)) {
            throw new IllegalStateException("getNextEntry() is only allowed for stream based zip processing.");
        }
        try {
            this._entry = ((ZipArchiveInputStream)this.in).getNextEntry();
            return this._entry;
        }
        catch (ZipException ze) {
            if (ze.getMessage().startsWith("Unexpected record signature")) {
                throw new IllegalStateException("No valid entries or contents found, this is not a valid file", ze);
            }
            throw ze;
        }
        catch (EOFException e) {
            return null;
        }
    }

    static long skipFully(InputStream input, long toSkip) throws IOException {
        long remain;
        long n;
        int skipBufferSize = 2048;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (toSkip == 0L) {
            return 0L;
        }
        byte[] skipByteBuffer = new byte[2048];
        for (remain = toSkip; remain > 0L && (n = (long)input.read(skipByteBuffer, 0, (int)Math.min(remain, 2048L))) >= 0L; remain -= n) {
        }
        if (toSkip == remain) {
            return -1L;
        }
        return toSkip - remain;
    }
}

