/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutils.zip;

import com.imsweb.seerutils.zip.ZipArchiveThresholdInputStream;
import com.imsweb.seerutils.zip.ZipEntryTooLargeException;
import com.imsweb.seerutils.zip.ZipInvalidCompressionRatioException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class ZipSecureFile
implements AutoCloseable {
    private final ZipFile _zipFile;
    private final double _minInflateRatio;
    private final long _maxEntrySize;

    public ZipSecureFile(File file) throws IOException {
        this(file, 0.0075, 0x100000000L);
    }

    public ZipSecureFile(File file, double minInflationRatio, long maxEntrySize) throws IOException {
        this._zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(file)).get();
        this._minInflateRatio = minInflationRatio;
        this._maxEntrySize = maxEntrySize;
    }

    public double getMinInflateRatio() {
        return this._minInflateRatio;
    }

    public long getMaxEntrySize() {
        return this._maxEntrySize;
    }

    public ZipArchiveEntry getEntry(String name) {
        return this._zipFile.getEntry(name);
    }

    public Enumeration<ZipArchiveEntry> getEntries() {
        return this._zipFile.getEntries();
    }

    @Override
    public void close() throws IOException {
        this._zipFile.close();
    }

    public InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        ZipArchiveThresholdInputStream is = new ZipArchiveThresholdInputStream(this._zipFile.getInputStream(entry));
        is.setEntry(entry);
        is.setMinInflateRatio(this._minInflateRatio);
        is.setMaxEntrySize(this._maxEntrySize);
        return is;
    }

    public static boolean isZipBomb(URL url, int maxEntries) throws IOException {
        boolean detected = false;
        long numEntries = 0L;
        try (ZipSecureFile z = new ZipSecureFile(new File(url.getFile()));){
            Enumeration<ZipArchiveEntry> entries = z.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = entries.nextElement();
                if (++numEntries > (long)maxEntries) {
                    detected = true;
                    break;
                }
                InputStream inputStream = z.getInputStream(entry);
                try {
                    if (IOUtils.toByteArray((InputStream)inputStream).length != 0) continue;
                    throw new IllegalStateException("Error processing file");
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (ZipEntryTooLargeException | ZipInvalidCompressionRatioException e) {
            detected = true;
        }
        return detected;
    }
}

