/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation;

import com.imsweb.validation.ContextFunctionAliasAnnotation;
import com.imsweb.validation.ValidationContextFunctions;
import com.imsweb.validation.ValidationServices;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ForStatement;

public class EditCodeVisitor
extends CodeVisitorSupport {
    private static final List<String> _METHODS_AS_FIELDS = Arrays.asList("size", "empty", "trim", "toUpperCase", "toLowerCase");
    protected Set<String> _properties;
    protected Set<String> _contextEntries;
    protected Set<String> _lookups;
    protected Map<String, String> _variableAliases;
    protected List<String> _defVariables;

    public EditCodeVisitor(Set<String> properties, Set<String> contextEntries, Set<String> lookups) {
        this._properties = properties == null ? new HashSet() : properties;
        this._contextEntries = contextEntries == null ? new HashSet() : contextEntries;
        this._lookups = lookups == null ? new HashSet() : lookups;
        this._variableAliases = new HashMap<String, String>();
        this._defVariables = new ArrayList<String>();
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        if (expression.getProperty() instanceof ConstantExpression) {
            String prop = expression.getProperty().getText();
            String[] parts = StringUtils.split((String)StringUtils.replace((String)this.uncast(expression.getObjectExpression()).getText(), (String)"?", (String)""), (char)'.');
            if (parts.length > 0) {
                if ("Context".equals(parts[0])) {
                    this._contextEntries.add(prop);
                } else {
                    StringBuilder buf = new StringBuilder();
                    if (parts.length > 1 && parts[0].equals("lines") && parts[1].startsWith("get(")) {
                        buf.append("line");
                    } else if (parts.length > 1 && parts[0].equals("untrimmedlines") && parts[1].startsWith("get(")) {
                        buf.append("untrimmedline");
                    } else {
                        if (this._variableAliases.containsKey(parts[0])) {
                            buf.append(this._variableAliases.get(parts[0]));
                        } else if (parts[0].startsWith("lines[")) {
                            buf.append("line");
                        } else if (parts[0].startsWith("untrimmedlines[")) {
                            buf.append("untrimmedline");
                        } else {
                            buf.append(parts[0]);
                        }
                        for (int i = 1; i < parts.length; ++i) {
                            buf.append(".").append(parts[i]);
                        }
                    }
                    buf.append(".").append(prop);
                    String[] parts2 = StringUtils.split((String)buf.toString(), (char)'.');
                    if (ValidationServices.getInstance().getJavaPathForAlias(parts2[0]) != null) {
                        StringBuilder innerBuf = new StringBuilder(parts2[0]);
                        for (int i = 1; i < parts2.length; ++i) {
                            if (i == parts2.length - 1 && _METHODS_AS_FIELDS.contains(parts2[i])) continue;
                            innerBuf.append(".").append(parts2[i]);
                        }
                        String property = innerBuf.toString();
                        if (ValidationServices.getInstance().getAliasForJavaPath(property) == null) {
                            this._properties.add(innerBuf.toString());
                            return;
                        }
                    }
                }
            }
        }
        super.visitPropertyExpression(expression);
    }

    public void visitVariableExpression(VariableExpression expression) {
        String name = expression.getName();
        if (!("this".equals(name) || this._defVariables.contains(name) || ValidationServices.getInstance().getJavaPathForAlias(name) != null || this.isInternalContextName(name))) {
            this._contextEntries.add(name);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        this._defVariables.add(expression.getLeftExpression().getText());
        Expression rightExpression = this.uncast(expression.getRightExpression());
        if (rightExpression instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)rightExpression;
            for (Method m : ValidationContextFunctions.getInstance().getClass().getMethods()) {
                if (!m.getName().equals(call.getMethodAsString()) || m.getAnnotation(ContextFunctionAliasAnnotation.class) == null) continue;
                this._variableAliases.put(expression.getLeftExpression().getText(), m.getAnnotation(ContextFunctionAliasAnnotation.class).value());
                break;
            }
            rightExpression.visit((GroovyCodeVisitor)this);
        } else if (rightExpression instanceof VariableExpression) {
            this._variableAliases.put(expression.getLeftExpression().getText(), rightExpression.getText());
        } else if (rightExpression instanceof PropertyExpression) {
            this._variableAliases.put(expression.getLeftExpression().getText(), rightExpression.getText());
            rightExpression.visit((GroovyCodeVisitor)this);
        } else {
            rightExpression.visit((GroovyCodeVisitor)this);
        }
    }

    public void visitForLoop(ForStatement forLoop) {
        String alias = this.getAliasForPartialPath(this.uncast(forLoop.getCollectionExpression()));
        if (alias != null) {
            this._variableAliases.put(forLoop.getVariable().getName(), alias);
            forLoop.getLoopBlock().visit((GroovyCodeVisitor)this);
            this._variableAliases.remove(forLoop.getVariable().getName());
        } else {
            forLoop.getLoopBlock().visit((GroovyCodeVisitor)this);
        }
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        Expression objExpression;
        String caller;
        String method = call.getMethodAsString();
        String alias = this.getAliasForPartialPath(this.uncast(call.getObjectExpression()));
        if (alias != null && call.getArguments() instanceof ArgumentListExpression) {
            ArgumentListExpression list = (ArgumentListExpression)call.getArguments();
            if (list.getExpressions().size() == 1 && list.getExpression(0) instanceof ClosureExpression) {
                ClosureExpression closure = (ClosureExpression)list.getExpression(0);
                String groovyAlias = closure.getParameters().length > 0 ? closure.getParameters()[0].getName() : "it";
                this._variableAliases.put(groovyAlias, alias);
                call.getArguments().visit((GroovyCodeVisitor)this);
                this._variableAliases.remove(groovyAlias);
                return;
            }
            if ("get".equals(method) && !this._defVariables.isEmpty()) {
                this._variableAliases.put(this._defVariables.get(this._defVariables.size() - 1), alias);
            }
        }
        if ("Context".equals(caller = (objExpression = this.uncast(call.getObjectExpression())).getText())) {
            this._contextEntries.add(method);
        }
        if (objExpression instanceof VariableExpression && "this".equals(caller) && !this._defVariables.contains(method) && ValidationServices.getInstance().getJavaPathForAlias(method) == null && !this.isInternalContextName(method)) {
            this._contextEntries.add(method);
        }
        if (objExpression instanceof VariableExpression && !"this".equals(caller) && !this._defVariables.contains(caller) && ValidationServices.getInstance().getJavaPathForAlias(caller) == null && !this.isInternalContextName(caller)) {
            this._contextEntries.add(caller);
        }
        if ("fetchLookup".equals(method)) {
            String rawLkupId = call.getArguments().getText();
            this._lookups.add(rawLkupId.substring(1, rawLkupId.length() - 1));
        }
        super.visitMethodCallExpression(call);
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        String alias;
        if (expression.getOperation() != null && expression.getOperation().getText().equals("[") && (alias = this.getAliasForPartialPath(this.uncast(expression.getLeftExpression()))) != null && !this._defVariables.isEmpty()) {
            this._variableAliases.put(this._defVariables.get(this._defVariables.size() - 1), alias);
        }
        super.visitBinaryExpression(expression);
    }

    protected String getAliasForPartialPath(Expression expression) {
        String javaPath;
        String alias = null;
        String[] parts = StringUtils.split((String)expression.getText(), (char)'.');
        if (parts.length > 0 && (javaPath = ValidationServices.getInstance().getJavaPathForAlias(parts[0])) != null) {
            StringBuilder buf = new StringBuilder(javaPath);
            for (int i = 1; i < parts.length; ++i) {
                buf.append(".").append(parts[i]);
            }
            alias = ValidationServices.getInstance().getAliasForJavaPath(buf.toString());
            if ("lines".equals(alias)) {
                alias = "line";
            } else if ("untrimmedlines".equals(alias)) {
                alias = "untrimmedline";
            }
        }
        return alias;
    }

    private Expression uncast(Expression expression) {
        return expression instanceof CastExpression ? ((CastExpression)expression).getExpression() : expression;
    }

    protected boolean isInternalContextName(String name) {
        return "Functions".equals(name) || "Context".equals(name);
    }
}

