/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation;

import com.imsweb.validation.InitializationStatsPerValidator;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class InitializationStats {
    public static final String REASON_NOT_PROVIDED = "pre-compiled edits not provided";
    public static final String REASON_DIFFERENT_VERSION = "pre-compiled validator has version {0} but application expected {1}";
    public static final String REASON_DISABLED = "pre-compiled edits are disabled";
    private long _initializationDuration = 0L;
    private final AtomicInteger _numEditsLoaded = new AtomicInteger();
    private final AtomicInteger _numEditsCompiled = new AtomicInteger();
    private final AtomicInteger _numEditsPreCompiled = new AtomicInteger();
    private final Map<String, InitializationStatsPerValidator> _validatorStats = new ConcurrentHashMap<String, InitializationStatsPerValidator>();

    public long getInitializationDuration() {
        return this._initializationDuration;
    }

    public void setInitializationDuration(long initializationDuration) {
        this._initializationDuration = initializationDuration;
    }

    public int getNumEditsLoaded() {
        return this._numEditsLoaded.get();
    }

    public void incrementNumEditsLoaded(String validatorId) {
        this._numEditsLoaded.getAndIncrement();
        this._validatorStats.computeIfAbsent(validatorId, InitializationStatsPerValidator::new).incrementNumEditsLoaded();
    }

    public int getNumEditsCompiled() {
        return this._numEditsCompiled.get();
    }

    public void incrementNumEditsCompiled(String validatorId) {
        this._numEditsCompiled.getAndIncrement();
        this._validatorStats.computeIfAbsent(validatorId, InitializationStatsPerValidator::new).incrementNumEditsCompiled();
    }

    public int getNumEditsPreCompiled() {
        return this._numEditsPreCompiled.get();
    }

    public void incrementNumEditsPreCompiled(String validatorId) {
        this._numEditsPreCompiled.getAndIncrement();
        this._validatorStats.computeIfAbsent(validatorId, InitializationStatsPerValidator::new).incrementNumEditsPreCompiled();
    }

    public void setReasonNotPreCompiled(String validatorId, String reason) {
        this._validatorStats.computeIfAbsent(validatorId, InitializationStatsPerValidator::new).setReasonNotPreCompiled(reason);
    }

    public List<InitializationStatsPerValidator> getValidatorStats() {
        return this._validatorStats.values().stream().sorted(Comparator.comparing(InitializationStatsPerValidator::getValidatorId)).collect(Collectors.toList());
    }
}

