/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.EditCodeVisitor;
import com.imsweb.validation.ValidationContextFunctions;
import com.imsweb.validation.ValidationLookup;
import com.imsweb.validation.entities.ContextTable;
import com.imsweb.validation.entities.ContextTableIndex;
import com.imsweb.validation.entities.Validatable;
import com.imsweb.validation.internal.context.JavaContextParser;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;

public class ValidationServices {
    private static final AtomicInteger _RULE_SEQ = new AtomicInteger(0);
    private static final AtomicInteger _CATEGORY_SEQ = new AtomicInteger(0);
    private static final AtomicInteger _CONDITION_SEQ = new AtomicInteger(0);
    private static final AtomicInteger _VALIDATOR_SEQ = new AtomicInteger(0);
    private static final AtomicInteger _CONTEXT_ENTRY_SEQ = new AtomicInteger(0);
    private static final AtomicInteger _SET_SEQ = new AtomicInteger(0);
    private static final AtomicInteger _RULE_HISTORY_SEQ = new AtomicInteger(0);
    private static ValidationServices _INSTANCE = new ValidationServices();
    private static final Pattern _PROP_REPLACEMENT_PATTERN = Pattern.compile("(\\$\\{(.+?)})");
    private static final Map<String, String> _ALIASES = new HashMap<String, String>();
    private static final Pattern _VERSIONS_PATTERN;

    public static void initialize(ValidationServices instance) {
        _INSTANCE = instance;
    }

    public static ValidationServices getInstance() {
        return _INSTANCE;
    }

    public String getAliasForJavaPath(String javaPath) {
        return _ALIASES.get(javaPath);
    }

    public String getJavaPathForAlias(String alias) {
        for (Map.Entry<String, String> entry : _ALIASES.entrySet()) {
            if (!entry.getValue().equals(alias)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Map<String, String> getAllJavaPaths() {
        return Collections.unmodifiableMap(_ALIASES);
    }

    public ValidationLookup getLookupById(String id) {
        return null;
    }

    public Object getConfVariable(String id) {
        return null;
    }

    public void log(Object message) {
    }

    public void logWarning(Object message) {
    }

    public void logError(Object message) {
    }

    public Long getNextRuleSequence() {
        return _RULE_SEQ.incrementAndGet();
    }

    public Long getNextCategorySequence() {
        return _CATEGORY_SEQ.incrementAndGet();
    }

    public Long getNextConditionSequence() {
        return _CONDITION_SEQ.incrementAndGet();
    }

    public Long getNextValidatorSequence() {
        return _VALIDATOR_SEQ.incrementAndGet();
    }

    public Long getNextContextEntrySequence() {
        return _CONTEXT_ENTRY_SEQ.incrementAndGet();
    }

    public Long getNextSetSequence() {
        return _SET_SEQ.incrementAndGet();
    }

    public Long getNextRuleHistorySequence() {
        return _RULE_HISTORY_SEQ.incrementAndGet();
    }

    public Object addContextExpression(String expression, Map<String, Object> context, String entryId, String type) throws ConstructionException {
        Object result;
        if ("groovy".equals(type)) {
            result = this.addGroovyContextExpression(expression, context, entryId);
        } else if ("java".equals(type)) {
            result = this.addJavaContextExpression(expression, context, entryId);
        } else if ("table".equals(type)) {
            result = this.addTableContextExpression(expression, context, entryId);
        } else if ("table-index-def".equals(type)) {
            result = this.addTableIndexDefContextExpression(expression, context, entryId);
        } else {
            throw new ConstructionException("Unsupported context type: " + type);
        }
        return result;
    }

    Object addGroovyContextExpression(String expression, Map<String, Object> context, String entryId) throws ConstructionException {
        Object result;
        try {
            Script script = new GroovyShell().parse(expression);
            Binding binding = new Binding();
            binding.setVariable("Functions", (Object)ValidationContextFunctions.getInstance());
            binding.setVariable("Context", context);
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                binding.setVariable(entry.getKey(), entry.getValue());
            }
            script.setBinding(binding);
            result = script.run();
            if (result == null) {
                throw new ConstructionException("Context expression '" + entryId + "' evaluated to 'null'");
            }
            if (result instanceof Closure) {
                this.validateExpression(entryId, expression);
            }
            context.put(entryId, result);
        }
        catch (RuntimeException e) {
            throw new ConstructionException("Unable to evaluate context for key '" + entryId + "'", e);
        }
        return result;
    }

    private void validateExpression(String entryId, String expression) throws ConstructionException {
        try {
            this.parseExpression(entryId, expression, null, null, null);
        }
        catch (Exception e) {
            throw new ConstructionException("Error in context '" + entryId + "': " + e.getMessage());
        }
    }

    Object addJavaContextExpression(String expression, Map<String, Object> context, String entryId) throws ConstructionException {
        Object result;
        try {
            result = JavaContextParser.parseContext(expression, context);
            context.put(entryId, result);
        }
        catch (RuntimeException e) {
            throw new ConstructionException("Unable to evaluate context for key '" + entryId + "'", e);
        }
        return result;
    }

    ContextTable addTableContextExpression(String expression, Map<String, Object> context, String entryId) throws ConstructionException {
        ContextTable result;
        try {
            Object data = JavaContextParser.parseContext(expression, context);
            if (!(data instanceof List)) {
                throw new ConstructionException("Unable to evaluate context for key '" + entryId + "'; bad format for a table");
            }
            for (List row : (List)data) {
                for (Object obj : row) {
                    if (obj instanceof String) continue;
                    throw new IllegalStateException("Tables only support String values; found " + obj.getClass().getSimpleName());
                }
            }
            result = new ContextTable(entryId, (List)data);
            context.put(entryId, result);
        }
        catch (RuntimeException e) {
            throw new ConstructionException("Unable to evaluate context for key '" + entryId + "'", e);
        }
        return result;
    }

    ContextTableIndex addTableIndexDefContextExpression(String expression, Map<String, Object> context, String entryId) throws ConstructionException {
        ContextTableIndex result;
        try {
            Object data = JavaContextParser.parseContext(expression, context);
            if (!(data instanceof Map)) {
                throw new ConstructionException("Unable to evaluate context for key '" + entryId + "'; bad format for a table");
            }
            Map indexInfo = (Map)data;
            String table = (String)indexInfo.get("table");
            if (!context.containsKey(table)) {
                throw new ConstructionException("Unable to evaluate context for key '" + entryId + "'; unknown referenced table '" + table + "'");
            }
            result = new ContextTableIndex(entryId, (ContextTable)context.get(table), Arrays.asList(StringUtils.split((String)((String)indexInfo.get("columns")), (char)',')));
            context.put(entryId, result);
        }
        catch (RuntimeException e) {
            throw new ConstructionException("Unable to evaluate context for key '" + entryId + "'", e);
        }
        return result;
    }

    public void parseExpression(String id, String expression, Set<String> properties, Set<String> contextEntries, Set<String> lookups) throws CompilationFailedException {
        if (expression == null || expression.trim().isEmpty()) {
            expression = "return true";
        }
        SourceUnit su = SourceUnit.create((String)id, (String)expression);
        su.parse();
        su.completePhase();
        su.convert();
        ModuleNode tree = su.getAST();
        EditCodeVisitor visitor = new EditCodeVisitor(properties, contextEntries, lookups);
        tree.getStatementBlock().visit((GroovyCodeVisitor)visitor);
        for (MethodNode method : tree.getMethods()) {
            method.getCode().visit((GroovyCodeVisitor)visitor);
        }
    }

    public Script compileExpression(String expression) throws CompilationFailedException {
        if (expression == null || expression.trim().isEmpty()) {
            expression = "return true";
        }
        return new GroovyShell().parse(expression);
    }

    public List<String> fillInMessages(List<String> originalMessages, Validatable validatable) {
        if (originalMessages == null) {
            return null;
        }
        ArrayList<String> filledInMessages = new ArrayList<String>();
        for (String message : originalMessages) {
            filledInMessages.add(this.fillInMessage(message, validatable));
        }
        return filledInMessages;
    }

    public String fillInMessage(String msg, Validatable validatable) {
        if (msg == null) {
            return "";
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> ends = new ArrayList<Integer>();
        ArrayList<String> values = new ArrayList<String>();
        Matcher matcher = _PROP_REPLACEMENT_PATTERN.matcher(msg);
        while (matcher.find()) {
            String value;
            String[] parts = StringUtils.split((String)matcher.group(2), (char)'.');
            if (parts.length < 2) continue;
            String prefix = parts[0];
            String propertyName = parts[1];
            String suffix = parts.length == 3 ? parts[2] : null;
            boolean error = false;
            Object replacement = null;
            try {
                replacement = this.getMessageValueReplacement(validatable.getScope().get(prefix), propertyName);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                error = true;
            }
            starts.add(matcher.start());
            ends.add(matcher.end());
            value = replacement != null && "formatDate()".equals(suffix) ? ((value = replacement.toString().trim()).length() == 8 ? "Y:" + value.substring(0, 4) + " M:" + value.substring(4, 6) + " D:" + value.substring(6) : (value.length() == 6 ? "Y:" + value.substring(0, 4) + " M:" + value.substring(4, 6) + " D:" : (value.length() == 4 ? "Y:" + value + " M:   D:" : "Y:     M:   D:"))) : (error ? "<ERROR>" : (replacement == null || replacement.toString().trim().isEmpty() ? "<BLANK>" : replacement.toString().trim()));
            values.add(value);
        }
        StringBuilder buf = new StringBuilder(msg);
        for (int i = starts.size() - 1; i >= 0; --i) {
            buf.replace((Integer)starts.get(i), (Integer)ends.get(i), (String)values.get(i));
        }
        return buf.toString();
    }

    Object getMessageValueReplacement(Object object, String propertyName) throws IllegalAccessException, NoSuchFieldException {
        Object replacement;
        if (object instanceof Map) {
            replacement = ((Map)object).get(propertyName);
        } else {
            try {
                replacement = object.getClass().getMethod("get" + StringUtils.capitalize((String)propertyName), new Class[0]).invoke(object, new Object[0]);
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                try {
                    replacement = object.getClass().getDeclaredField(propertyName).get(object);
                }
                catch (IllegalAccessException | NoSuchFieldException e2) {
                    replacement = object.getClass().getDeclaredField("_" + propertyName).get(object);
                }
            }
        }
        return replacement;
    }

    public int compareEngineVersions(String version1, String version2) {
        int i;
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        if (!_VERSIONS_PATTERN.matcher(version1).matches() || !_VERSIONS_PATTERN.matcher(version2).matches()) {
            return version1.compareTo(version2);
        }
        String[] parts1 = StringUtils.split((String)version1, (char)'.');
        String[] parts2 = StringUtils.split((String)version2, (char)'.');
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        for (i = 0; i < Math.max(parts1.length, parts2.length); ++i) {
            if (i < parts1.length) {
                list1.add(Integer.valueOf(parts1[i]));
                continue;
            }
            list1.add(0);
        }
        for (i = 0; i < Math.max(parts1.length, parts2.length); ++i) {
            if (i < parts2.length) {
                list2.add(Integer.valueOf(parts2[i]));
                continue;
            }
            list2.add(0);
        }
        for (i = 0; i < list1.size(); ++i) {
            int result = ((Integer)list2.get(i)).compareTo((Integer)list1.get(i)) * -1;
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    static {
        _ALIASES.put("record", "record");
        _ALIASES.put("lines", "lines");
        _ALIASES.put("lines.line", "line");
        _ALIASES.put("untrimmedlines", "untrimmedlines");
        _ALIASES.put("untrimmedlines.untrimmedline", "untrimmedline");
        _VERSIONS_PATTERN = Pattern.compile("\\d+(\\.\\d++)++");
    }
}

