/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.entities;

import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.Validatable;
import com.imsweb.validation.internal.ExtraPropertyEntityHandlerDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class SimpleMapValidatable
implements Validatable {
    public static final String ROOT_PREFIX = "record";
    private String _displayId;
    private final String _prefix;
    private final String _alias;
    private final Map<String, Object> _current;
    private final SimpleMapValidatable _parent;
    private final Map<String, String> _prefixes;
    private final Map<String, Object> _scopes;
    private final Set<String> _propertiesWithError;

    public SimpleMapValidatable(Map<String, Object> map) {
        this("?", ROOT_PREFIX, map, null);
    }

    public SimpleMapValidatable(String rootPrefix, Map<String, Object> map) {
        this("?", rootPrefix, map, null);
    }

    public SimpleMapValidatable(String displayId, String rootPrefix, Map<String, Object> map) {
        this(displayId, rootPrefix, map, null);
    }

    public SimpleMapValidatable(String displayId, String rootPrefix, Map<String, Object> map, Map<String, Object> context) {
        if (map == null) {
            throw new IllegalStateException("map cannot be null");
        }
        this._displayId = displayId;
        this._prefix = rootPrefix;
        this._alias = rootPrefix;
        this._current = map;
        this._parent = null;
        this._prefixes = Collections.singletonMap(rootPrefix, rootPrefix);
        this._scopes = new HashMap<String, Object>();
        this._scopes.put(rootPrefix, map);
        if (context != null) {
            this._scopes.putAll(context);
        }
        this._propertiesWithError = new HashSet<String>();
    }

    private SimpleMapValidatable(SimpleMapValidatable parent, String prefix, Map<String, Object> map) {
        this._prefix = prefix;
        this._alias = ValidationServices.getInstance().getAliasForJavaPath(prefix.replaceAll("\\[\\d+]", ""));
        this._current = map;
        this._parent = parent;
        this._prefixes = new HashMap<String, String>(this._parent.getPrefixes());
        this._prefixes.put(this._alias, prefix);
        this._scopes = new HashMap<String, Object>(this._parent.getScope());
        this._scopes.put(this._alias, map);
        this._propertiesWithError = new HashSet<String>();
    }

    @Override
    public List<Validatable> followCollection(String collection) throws IllegalAccessException {
        ArrayList<Validatable> result = new ArrayList<Validatable>();
        Object val = this._current.get(collection);
        if (val != null) {
            if (!(val instanceof List)) {
                throw new IllegalAccessException("Unable to follow '" + collection + "', value is not a list");
            }
            List values = (List)val;
            for (int i = 0; i < values.size(); ++i) {
                result.add(new SimpleMapValidatable(this, this._prefix + "." + collection + "[" + i + "]", (Map<String, Object>)((Map)values.get(i))));
            }
        }
        return result;
    }

    @Override
    public String getDisplayId() {
        String result = this._displayId;
        for (SimpleMapValidatable validatable = this.getParent(); validatable != null; validatable = validatable.getParent()) {
            result = validatable._displayId;
        }
        return result;
    }

    @Override
    public Long getCurrentTumorId() {
        return null;
    }

    @Override
    public String getRootLevel() {
        String result = this.getCurrentLevel();
        for (SimpleMapValidatable validatable = this.getParent(); validatable != null; validatable = validatable.getParent()) {
            result = validatable.getCurrentLevel();
        }
        return result;
    }

    @Override
    public String getCurrentLevel() {
        return this._prefix;
    }

    @Override
    public Map<String, Object> getScope() {
        return this._scopes;
    }

    @Override
    public void reportFailureForProperty(String propertyName) {
        int pos;
        if (propertyName != null && (pos = propertyName.indexOf(46)) >= 0) {
            String alias = propertyName.substring(0, pos);
            String name = propertyName.substring(pos + 1);
            String prefix = this._prefixes.get(alias);
            if (prefix != null) {
                this._propertiesWithError.add(prefix + "." + name);
            }
        }
    }

    @Override
    public void forceFailureForProperties(Set<ExtraPropertyEntityHandlerDto> toReport, Set<String> rawProperties) {
        for (ExtraPropertyEntityHandlerDto extra : toReport) {
            Set<String> props = extra.getProperties();
            if (props == null) {
                props = rawProperties;
            }
            for (String prop : props) {
                String collectionName;
                Object collection;
                int colPos;
                int pos = prop.indexOf(46);
                if (pos < 0) continue;
                String javaPath = ValidationServices.getInstance().getJavaPathForAlias(prop.substring(0, pos));
                int n = colPos = javaPath == null ? -1 : javaPath.lastIndexOf(".");
                if (javaPath == null || colPos < 0 || (collection = this._current.get(collectionName = javaPath.substring(colPos + 1))) == null) continue;
                int index = -1;
                if (collection instanceof List) {
                    index = ((List)collection).indexOf(extra.getEntity());
                } else if (collection instanceof SortedSet) {
                    index = new ArrayList((SortedSet)collection).indexOf(extra.getEntity());
                }
                if (index == -1) continue;
                this._propertiesWithError.add(this._prefix + "." + collectionName + "[" + index + "]." + prop.substring(pos + 1));
            }
        }
    }

    @Override
    public Set<String> getPropertiesWithError() {
        return this._propertiesWithError;
    }

    @Override
    public void clearPropertiesWithError() {
        this._propertiesWithError.clear();
    }

    private Map<String, String> getPrefixes() {
        return this._prefixes;
    }

    private SimpleMapValidatable getParent() {
        return this._parent;
    }
}

