/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.entities;

import com.imsweb.validation.entities.Category;
import com.imsweb.validation.entities.Condition;
import com.imsweb.validation.entities.ContextEntry;
import com.imsweb.validation.entities.DeletedRuleHistory;
import com.imsweb.validation.entities.EmbeddedSet;
import com.imsweb.validation.entities.Rule;
import com.imsweb.validation.entities.ValidatorRelease;
import com.imsweb.validation.runtime.CompiledRules;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class Validator {
    protected Long _validatorId;
    protected String _id;
    protected String _name;
    protected String _version;
    protected String _minEngineVersion;
    protected String _translatedFrom;
    protected NavigableSet<ValidatorRelease> _releases = new TreeSet<ValidatorRelease>();
    protected String _hash;
    protected Set<Category> _categories;
    protected Set<Condition> _conditions;
    protected Set<Rule> _rules;
    protected Set<ContextEntry> _rawContext = new HashSet<ContextEntry>();
    protected Set<DeletedRuleHistory> _deletedRuleHistories = new HashSet<DeletedRuleHistory>();
    protected Set<EmbeddedSet> _sets;
    private CompiledRules _compiledRules;

    public Validator() {
        this._conditions = new HashSet<Condition>();
        this._categories = new HashSet<Category>();
        this._rules = new HashSet<Rule>();
        this._sets = new HashSet<EmbeddedSet>();
    }

    public Long getValidatorId() {
        return this._validatorId;
    }

    public void setValidatorId(Long id) {
        this._validatorId = id;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getMinEngineVersion() {
        return this._minEngineVersion;
    }

    public void setMinEngineVersion(String minEngineVersion) {
        this._minEngineVersion = minEngineVersion;
    }

    public String getTranslatedFrom() {
        return this._translatedFrom;
    }

    public void setTranslatedFrom(String translatedFrom) {
        this._translatedFrom = translatedFrom;
    }

    public NavigableSet<ValidatorRelease> getReleases() {
        return this._releases;
    }

    public void setReleases(NavigableSet<ValidatorRelease> releases) {
        this._releases = releases;
    }

    public String getHash() {
        return this._hash;
    }

    public void setHash(String hash) {
        this._hash = hash;
    }

    public Set<ContextEntry> getRawContext() {
        return this._rawContext;
    }

    public ContextEntry getRawContext(String key) {
        if (key == null) {
            return null;
        }
        for (ContextEntry entry : this._rawContext) {
            if (!key.equalsIgnoreCase(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    public void setRawContext(Set<ContextEntry> rawContext) {
        this._rawContext = rawContext;
    }

    public Set<Category> getCategories() {
        return this._categories;
    }

    public void setCategories(Set<Category> categories) {
        this._categories = categories;
    }

    public Category getCategory(String id) {
        if (id == null) {
            return null;
        }
        for (Category cat : this._categories) {
            if (!id.equalsIgnoreCase(cat.getId())) continue;
            return cat;
        }
        return null;
    }

    public Set<Condition> getConditions() {
        return this._conditions;
    }

    public void setConditions(Set<Condition> conditions) {
        this._conditions = conditions;
    }

    public Condition getCondition(String id) {
        if (id == null) {
            return null;
        }
        for (Condition cond : this._conditions) {
            if (!id.equalsIgnoreCase(cond.getId())) continue;
            return cond;
        }
        return null;
    }

    public Set<Rule> getRules() {
        return this._rules;
    }

    public void setRules(Set<Rule> rules) {
        this._rules = rules;
    }

    public Rule getRule(String ruleId) {
        if (ruleId == null) {
            return null;
        }
        for (Rule rule : this._rules) {
            if (!ruleId.equalsIgnoreCase(rule.getId())) continue;
            return rule;
        }
        return null;
    }

    public void setDeletedRuleHistories(Set<DeletedRuleHistory> deletedRuleHistories) {
        this._deletedRuleHistories = deletedRuleHistories;
    }

    public Set<DeletedRuleHistory> getDeletedRuleHistories() {
        return this._deletedRuleHistories;
    }

    public Set<EmbeddedSet> getSets() {
        return this._sets;
    }

    public void setSets(Set<EmbeddedSet> sets) {
        this._sets = sets;
    }

    public EmbeddedSet getSet(String id) {
        if (id == null) {
            return null;
        }
        for (EmbeddedSet set : this._sets) {
            if (!id.equalsIgnoreCase(set.getId())) continue;
            return set;
        }
        return null;
    }

    public CompiledRules getCompiledRules() {
        return this._compiledRules;
    }

    public void setCompiledRules(CompiledRules compiledRules) {
        this._compiledRules = compiledRules;
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Validator)) {
            return false;
        }
        Validator validator = (Validator)o;
        if (this._validatorId != null && validator._validatorId != null) {
            return Objects.equals(this._validatorId, validator._validatorId);
        }
        return Objects.equals(this._id, validator._id);
    }

    public int hashCode() {
        if (this._validatorId != null) {
            return Objects.hash(this._validatorId);
        }
        return Objects.hash(this._id);
    }
}

