/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.entities;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ValidatorVersion
implements Comparable<ValidatorVersion> {
    protected String _rawString;
    protected String _prefix;
    protected Integer _major;
    protected Integer _minor;
    protected Integer _suffix;

    public ValidatorVersion(String rawString) {
        if (!ValidatorVersion.validateVersionFormat(rawString)) {
            throw new IllegalStateException("provided raw version does not have a valid format: " + rawString);
        }
        String[] parts = StringUtils.split((String)rawString, (char)'-');
        this._rawString = rawString;
        this._prefix = parts[0];
        this._major = Integer.valueOf(parts[1]);
        this._minor = Integer.valueOf(parts[2]);
        this._suffix = parts.length == 4 ? Integer.valueOf(parts[3]) : Integer.valueOf(0);
    }

    public String getRawString() {
        return this._rawString;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public Integer getMajor() {
        return this._major;
    }

    public Integer getMinor() {
        return this._minor;
    }

    public Integer getSuffix() {
        return this._suffix;
    }

    public String toString() {
        return this._rawString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidatorVersion)) {
            return false;
        }
        ValidatorVersion that = (ValidatorVersion)o;
        return Objects.equals(this._major, that._major) && Objects.equals(this._minor, that._minor) && Objects.equals(this._suffix, that._suffix);
    }

    public int hashCode() {
        return Objects.hash(this._major, this._minor, this._suffix);
    }

    @Override
    public int compareTo(ValidatorVersion o) {
        int comp = this.getMajor().compareTo(o.getMajor());
        if (comp != 0) {
            return comp;
        }
        comp = this.getMinor().compareTo(o.getMinor());
        if (comp != 0) {
            return comp;
        }
        return this.getSuffix().compareTo(o.getSuffix());
    }

    public static boolean validateVersionFormat(String rawVersion) {
        if (rawVersion == null) {
            return false;
        }
        String[] parts = StringUtils.split((String)rawVersion, (char)'-');
        if (parts.length == 3) {
            return NumberUtils.isDigits((String)parts[1]) && parts[1].length() == 3 && NumberUtils.isDigits((String)parts[2]) && parts[2].length() == 2;
        }
        if (parts.length == 4) {
            return NumberUtils.isDigits((String)parts[1]) && parts[1].length() == 3 && NumberUtils.isDigits((String)parts[2]) && parts[2].length() == 2 && NumberUtils.isDigits((String)parts[3]) && parts[3].length() == 1;
        }
        return false;
    }

    public static int compareVersions(String rawVersion1, String rawVersion2) {
        if (!ValidatorVersion.validateVersionFormat(rawVersion1)) {
            return -1;
        }
        if (!ValidatorVersion.validateVersionFormat(rawVersion2)) {
            return 1;
        }
        return new ValidatorVersion(rawVersion1).compareTo(new ValidatorVersion(rawVersion2));
    }
}

