/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.functions;

import com.imsweb.staging.Staging;
import com.imsweb.staging.entities.ColumnDefinition;
import com.imsweb.staging.entities.Input;
import com.imsweb.staging.entities.Metadata;
import com.imsweb.staging.entities.Schema;
import com.imsweb.staging.entities.SchemaLookup;
import com.imsweb.staging.entities.Table;
import com.imsweb.validation.ContextFunctionDocAnnotation;
import com.imsweb.validation.ValidationContextFunctions;
import com.imsweb.validation.ValidationStagingUtils;
import groovy.lang.IntRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class StagingContextFunctions
extends ValidationContextFunctions {
    public static final String CSTAGE_INPUT_PROP_SITE = "primarySite";
    public static final String CSTAGE_INPUT_PROP_HIST = "histologicTypeIcdO3";
    public static final String CSTAGE_INPUT_PROP_DISC = "csSiteSpecificFactor25";
    public static final String CSTAGE_INPUT_PROP_DX_DATE = "dateOfDiagnosis";
    public static final String CSTAGE_INPUT_PROP_DX_DATE_YEAR = "dateOfDiagnosisYear";
    public static final Map<Integer, String> CSTAGE_TABLE_NUMBERS;
    public static final Map<String, String> CSTAGE_OBSOLETE_REASONS;
    public static final String CSTAGE_TAG_ALREADY_COLLECTED_SEER = "SEER_ALREADY_COLLECTED";
    public static final String CSTAGE_TAG_CLINICALLY_SIGNIFICANT_SEER = "SEER_CLINICALLY_SIGNIFICANT";
    public static final String CSTAGE_TAG_REQUIRED_PRE_2010_SEER = "SEER_REQUIRED_PRE_2010";
    public static final String CSTAGE_TAG_ALREADY_COLLECTED_COC = "COC_ALREADY_COLLECTED";
    public static final String CSTAGE_TAG_CLINICALLY_SIGNIFICANT_COC = "COC_CLINICALLY_SIGNIFICANT";
    public static final String CSTAGE_TAG_REQUIRED_PRE_2010_COC = "COC_REQUIRED_PRE_2010";
    public static final String CSTAGE_TAG_UNDEFINED_SSF = "UNDEFINED_SSF";
    public static final String TNM_INPUT_PROP_SITE = "primarySite";
    public static final String TNM_INPUT_PROP_HIST = "histologicTypeIcdO3";
    public static final String TNM_INPUT_PROP_SSF25 = "csSiteSpecificFactor25";
    public static final String TNM_INPUT_PROP_SEX = "sex";
    public static final String TNM_TAG_SEER_REQUIRED = "SEER_REQUIRED";
    public static final String TNM_TAG_COC_REQUIRED = "COC_REQUIRED";
    public static final String TNM_TAG_NPCR_REQUIRED = "NPCR_REQUIRED";
    public static final String TNM_TAG_CCCR_REQUIRED = "CCCR_REQUIRED";
    public static final String EOD_INPUT_PROP_SITE = "primarySite";
    public static final String EOD_INPUT_PROP_HIST = "histologicTypeIcdO3";
    public static final String EOD_INPUT_PROP_SEX = "sex";
    public static final String EOD_INPUT_PROP_DISC_1 = "schemaDiscriminator1";
    public static final String EOD_INPUT_PROP_DISC_2 = "schemaDiscriminator2";
    public static final String EOD_INPUT_PROP_BEHAV = "behaviorCodeIcdO3";
    public static final String EOD_INPUT_PROP_DX_YEAR = "dateOfDiagnosisYear";
    public static final String EOD_TAG_SEER_REQUIRED = "SEER_REQUIRED";
    public static final String EOD_TAG_COC_REQUIRED = "COC_REQUIRED";
    public static final String EOD_TAG_NPCR_REQUIRED = "NPCR_REQUIRED";
    public static final String EOD_TAG_CCCR_REQUIRED = "CCCR_REQUIRED";
    public static final String EOD_TAG_SSDI = "SSDI";
    protected Staging _csStaging;
    protected Staging _tnmStaging;
    protected Staging _eodStaging;
    protected Map<Integer, String> _csSchemaIdByNumber = new HashMap<Integer, String>();

    public StagingContextFunctions(Staging csStaging, Staging tnmStaging, Staging eodStaging) {
        this._csStaging = csStaging;
        this._tnmStaging = tnmStaging;
        this._eodStaging = eodStaging;
        if (this._csStaging != null) {
            for (String schemaId : this._csStaging.getSchemaIds()) {
                Schema schema = this._csStaging.getSchema(schemaId);
                if (schema.getSchemaNum() == null) continue;
                this._csSchemaIdByNumber.put(schema.getSchemaNum(), schemaId);
            }
        }
    }

    @ContextFunctionDocAnnotation(desc="Returns the CS version as provided by the CS library.", example="def csVersion = Functions.getCsVersion()")
    public String getCsVersion() {
        if (this._csStaging == null) {
            return null;
        }
        return this._csStaging.getVersion().replace(".", "");
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", desc="Returns the CS schema name corresponding to the inputs; those inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the key 'csSiteSpecificFactor25'. Returns null if the schema can't be determined.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\ndef schemaName = Functions.getCsSchemaName(inputs)")
    public String getCsSchemaName(Map<String, String> input) {
        if (this._csStaging == null) {
            return null;
        }
        Schema schema = this.getCsStagingSchema(input);
        return schema == null ? null : schema.getName();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", desc="Returns the CS schema ID corresponding to the inputs; those inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the key 'csSiteSpecificFactor25'. Returns null if the schema can't be determined.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\ndef schemaId = Functions.getCsSchemaId(inputs)")
    public String getCsSchemaId(Map<String, String> input) {
        if (this._csStaging == null) {
            return null;
        }
        Schema schema = this.getCsStagingSchema(input);
        return schema == null ? null : schema.getId();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="field", param2="field NAACCR XML ID", paramName3="valueToCheck", param3="value to validate", desc="Returns true if the provided value is valid for the CS schema corresponding to the inputs and the CS field, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isAcceptableCsCode(inputs, 'csSiteSpecificFactor1', record.csSiteSpecificFactor1)")
    public boolean isAcceptableCsCode(Map<String, String> input, String field, String valueToCheck) {
        if (this._csStaging == null || input == null || field == null || valueToCheck == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input inputField = schema.getInputs().stream().filter(i -> field.equals(i.getNaaccrXmlId())).findFirst().orElse(null);
        if (inputField == null) {
            return false;
        }
        return this._csStaging.isCodeValid(schema.getId(), inputField.getKey(), valueToCheck);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="field", param2="field NAACCR XML ID", paramName3="valueToCheck", param3="value to check", desc="Returns true if the provided value is obsolete for the CS schema corresponding to the inputs and the CS field, false otherwise. The value is obsolete if its description in the CS table starts with OBSOLETE. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isObsoleteCsCode(inputs, 'csSiteSpecificFactor1', record.csSiteSpecificFactor1)")
    public boolean isObsoleteCsCode(Map<String, String> input, String field, String valueToCheck) {
        if (this._csStaging == null || input == null || field == null || valueToCheck == null) {
            return false;
        }
        String description = this.getDescriptionForCode(input, field, valueToCheck);
        return description != null && description.trim().toUpperCase().startsWith("OBSOLETE");
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="field", param2="field NAACCR XML ID", paramName3="valueToCheck", param3="value to check", desc="Returns the reason why a particular code is obsolete.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.getCsObsoleteReason(inputs, 'csSiteSpecificFactor1', record.csSiteSpecificFactor1)")
    public String getCsObsoleteReason(Map<String, String> input, String field, String valueToCheck) {
        if (this._csStaging == null || input == null || field == null || valueToCheck == null) {
            return null;
        }
        String description = this.getDescriptionForCode(input, field, valueToCheck);
        if (description == null) {
            return null;
        }
        String desc = description.trim().toUpperCase();
        for (Map.Entry<String, String> entry : CSTAGE_OBSOLETE_REASONS.entrySet()) {
            if (!desc.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required for SEER for the schema corresponding to the passed input, false otherwise. Required means either 'already-collected', 'needed-for-staging' or 'clinically significant'. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isRequiredCsCode(inputs, 1)")
    public boolean isRequiredCsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging() != false || this.checkMetaData(input, schemaInput, CSTAGE_TAG_ALREADY_COLLECTED_SEER, CSTAGE_TAG_CLINICALLY_SIGNIFICANT_SEER);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (needed-for-staging) for SEER for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isNeededForStagingCsCode(inputs, 1)")
    public boolean isNeededForStagingCsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (already-collected) for SEER for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isAlreadyCollectedCsCode(inputs, 1)")
    public boolean isAlreadyCollectedCsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return this.checkMetaData(input, schemaInput, CSTAGE_TAG_ALREADY_COLLECTED_SEER);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (clinically-significant) for SEER for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isClinicallySignificantCsCode(inputs, 1)")
    public boolean isClinicallySignificantCsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return this.checkMetaData(input, schemaInput, CSTAGE_TAG_CLINICALLY_SIGNIFICANT_SEER);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (pre-2010) for SEER for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isRequiredPre2010CsCode(inputs, 1)")
    public boolean isRequiredPre2010CsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return this.checkMetaData(input, schemaInput, CSTAGE_TAG_REQUIRED_PRE_2010_SEER);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required for CoC for the schema corresponding to the passed input, false otherwise. Required means either 'already-collected', 'needed-for-staging' or 'clinically significant'. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isRequiredCsCode(inputs, 1)")
    public boolean isCocRequiredCsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging() != false || this.checkMetaData(input, schemaInput, CSTAGE_TAG_ALREADY_COLLECTED_COC, CSTAGE_TAG_CLINICALLY_SIGNIFICANT_COC);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (already-collected) for CoC for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isAlreadyCollectedCsCode(inputs, 1)")
    public boolean isCocAlreadyCollectedCsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return this.checkMetaData(input, schemaInput, CSTAGE_TAG_ALREADY_COLLECTED_COC);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (needed-for-staging) for CoC for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isNeededForStagingCsCode(inputs, 1)")
    public boolean isCocNeededForStagingCsCode(Map<String, String> input, Integer ssfIndex) {
        return this.isNeededForStagingCsCode(input, ssfIndex);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (clinically-significant) for CoC for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isClinicallySignificantCsCode(inputs, 1)")
    public boolean isCocClinicallySignificantCsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return this.checkMetaData(input, schemaInput, CSTAGE_TAG_CLINICALLY_SIGNIFICANT_COC);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (pre-2010) for CoC for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the key 'csSiteSpecificFactor25'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isRequiredPre2010CsCode(inputs, 1)")
    public boolean isCocRequiredPre2010CsCode(Map<String, String> input, Integer ssfIndex) {
        if (this._csStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return this.checkMetaData(input, schemaInput, CSTAGE_TAG_REQUIRED_PRE_2010_COC);
    }

    @ContextFunctionDocAnnotation(desc="Returns the TNM version as provided by the TNM library.", example="def tnmVersion = Functions.getTnmVersion()")
    public String getTnmVersion() {
        if (this._tnmStaging == null) {
            return null;
        }
        return this._tnmStaging.getVersion();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", desc="Returns the TNM schema name corresponding to the inputs; those inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the key 'csSiteSpecificFactor25' or 'sex'. Returns null if the schema can't be determined.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\ndef schemaName = Functions.getTnmSchemaName(inputs)")
    public String getTnmSchemaName(Map<String, String> input) {
        if (this._tnmStaging == null) {
            return null;
        }
        Schema schema = this.getTnmStagingSchema(input);
        return schema == null ? null : schema.getName();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", desc="Returns the TNM schema ID corresponding to the inputs; those inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the key 'csSiteSpecificFactor25' or 'sex'. Returns null if the schema can't be determined.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\ndef schemaId = Functions.getTnmSchemaId(inputs)")
    public String getTnmSchemaId(Map<String, String> input) {
        if (this._tnmStaging == null) {
            return null;
        }
        Schema schema = this.getTnmStagingSchema(input);
        return schema == null ? null : schema.getId();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="field", param2="field NAACCR XML ID", paramName3="valueToCheck", param3="value to validate", desc="Returns true if the provided value is valid for the TNM schema corresponding to the inputs and the TNM field, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the keys 'csSiteSpecificFactor25' and 'sex'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isAcceptableTnmCode(inputs, 'csSiteSpecificFactor1', record.csSiteSpecificFactor1)")
    public boolean isAcceptableTnmCode(Map<String, String> input, String field, String valueToCheck) {
        if (this._tnmStaging == null || input == null || field == null) {
            return false;
        }
        Schema schema = this.getTnmStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input inputField = schema.getInputs().stream().filter(i -> field.equals(i.getNaaccrXmlId())).findFirst().orElse(null);
        if (inputField == null) {
            return false;
        }
        return this._tnmStaging.isCodeValid(schema.getId(), inputField.getKey(), valueToCheck);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required for SEER for the schema corresponding to the passed input, false otherwise. Required means either 'seer-required' or 'needed-for-staging'. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the keys 'csSiteSpecificFactor25' or 'sex'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isRequiredTnmCode(inputs, 1)")
    public boolean isRequiredTnmCode(Map<String, String> input, Integer ssfIndex) {
        if (this._tnmStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getTnmStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging() != false || this.checkMetaData(input, schemaInput, "SEER_REQUIRED");
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required (needed-for-staging) for SEER for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the keys 'csSiteSpecificFactor25' or 'sex'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isNeededForStagingTnmCode(inputs, 1)")
    public boolean isNeededForStagingTnmCode(Map<String, String> input, Integer ssfIndex) {
        if (this._tnmStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getTnmStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="ssfIndex", param2="site specific factor index (Integer)", desc="Returns true if the passed Site Specific Factor index is required for COC for the schema corresponding to the passed input, false otherwise. Required means either 'coc-required' or 'needed-for-staging'. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the keys 'csSiteSpecificFactor25' or 'sex'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isCocRequiredTnmCode(inputs, 1)")
    public boolean isCocRequiredTnmCode(Map<String, String> input, Integer ssfIndex) {
        if (this._tnmStaging == null || input == null || ssfIndex == null) {
            return false;
        }
        Schema schema = this.getTnmStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = (Input)schema.getInputMap().get("ssf" + ssfIndex);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging() != false || this.checkMetaData(input, schemaInput, "COC_REQUIRED");
    }

    @ContextFunctionDocAnnotation(desc="Returns the EOD version as provided by the EOD library.", example="def eodVersion = Functions.getEodVersion()")
    public String getEodVersion() {
        if (this._eodStaging == null) {
            return null;
        }
        return this._eodStaging.getVersion();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", desc="Returns the EOD schema name corresponding to the inputs; those inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the key 'schemaDiscriminator1', 'schemaDiscriminator2 ', or 'sex'. Returns null if the schema can't be determined.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\ndef schemaName = Functions.getEodSchemaName(inputs)")
    public String getEodSchemaName(Map<String, String> input) {
        if (this._eodStaging == null) {
            return null;
        }
        Schema schema = this.getEodStagingSchema(input);
        return schema == null ? null : schema.getName();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", desc="Returns the TNM schema ID corresponding to the inputs; those inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the keys 'schemaDiscriminator1', 'schemaDiscriminator2', or 'sex'. Returns null if the schema can't be determined.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\ndef schemaId = Functions.getEodSchemaId(inputs)")
    public String getEodSchemaId(Map<String, String> input) {
        if (this._eodStaging == null) {
            return null;
        }
        Schema schema = this.getEodStagingSchema(input);
        return schema == null ? null : schema.getId();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="field", param2="field NAACCR XML ID", paramName3="valueToCheck", param3="value to validate", desc="Returns true if the provided value is valid for the EOD schema corresponding to the inputs and the EOD field, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the keys 'schemaDiscriminator1', 'schemaDiscriminator2', or 'sex'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isAcceptableEodCode(inputs, 'eodPrimaryTumor', record.eodPrimaryTumor)")
    public boolean isAcceptableEodCode(Map<String, String> input, String field, String valueToCheck) {
        if (this._eodStaging == null || input == null || field == null) {
            return false;
        }
        Schema schema = this.getEodStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input inputField = schema.getInputs().stream().filter(i -> field.equals(i.getNaaccrXmlId())).findFirst().orElse(null);
        if (inputField == null) {
            return false;
        }
        return this._eodStaging.isCodeValid(schema.getId(), inputField.getKey(), valueToCheck);
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="field", param2="field NAACCR XML ID", desc="Returns true if the passed EOD field is required for SEER for the schema corresponding to the passed input, false otherwise. Required means either 'seer-required' or 'needed-for-staging'. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionaly contain the keys 'schemaDiscriminator1', 'schemaDiscriminator2', or 'sex'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isRequiredEodField(inputs, ''eodPrimaryTumor')")
    public boolean isRequiredEodField(Map<String, String> input, String field) {
        if (this._eodStaging == null || input == null || field == null) {
            return false;
        }
        Schema schema = this.getEodStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = schema.getInputs().stream().filter(i -> field.equals(i.getNaaccrXmlId())).findFirst().orElse(null);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging() != false || this.checkMetaData(input, schemaInput, "SEER_REQUIRED");
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="field", param2="field NAACCR XML ID", desc="Returns true if the passed EOD field is required (needed-for-staging) for SEER for the schema corresponding to the passed input, false otherwise. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the keys 'schemaDiscriminator1', 'schemaDiscriminator2', or 'sex'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isNeededForStagingEodField(inputs, 'eodPrimaryTumor')")
    public boolean isNeededForStagingEodField(Map<String, String> input, String field) {
        if (this._eodStaging == null || input == null || field == null) {
            return false;
        }
        Schema schema = this.getEodStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = schema.getInputs().stream().filter(i -> field.equals(i.getNaaccrXmlId())).findFirst().orElse(null);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging();
    }

    @ContextFunctionDocAnnotation(paramName1="input", param1="map of inputs", paramName2="field", param2="field NAACCR XML ID", desc="Returns true if the passed EOD field is required for COC for the schema corresponding to the passed input, false otherwise. Required means either 'coc-required' or 'needed-for-staging'. The inputs must contain the keys 'primarySite' and 'histologicTypeIcdO3'; they can optionally contain the keys 'schemaDiscriminator1', 'schemaDiscriminator2', or 'sex'.", example="def inputs = [\n 'primarySite' : record.primarySite,\n 'histologicTypeIcdO3' : record.histologicTypeIcdO3\n]\n\nreturn Functions.isCocRequiredEodField(inputs, 'eodPrimaryTumor')")
    public boolean isCocRequiredEodField(Map<String, String> input, String field) {
        if (this._eodStaging == null || input == null || field == null) {
            return false;
        }
        Schema schema = this.getEodStagingSchema(input);
        if (schema == null) {
            return false;
        }
        Input schemaInput = schema.getInputs().stream().filter(i -> field.equals(i.getNaaccrXmlId())).findFirst().orElse(null);
        if (schemaInput == null) {
            return false;
        }
        return schemaInput.getUsedForStaging() != false || this.checkMetaData(input, schemaInput, "COC_REQUIRED");
    }

    public Schema getCsStagingSchema(Map<String, String> input) {
        if (this._csStaging == null || input == null) {
            return null;
        }
        String site = input.get("primarySite");
        String hist = input.get("histologicTypeIcdO3");
        String ssf25 = input.get("csSiteSpecificFactor25");
        SchemaLookup lkup = new SchemaLookup(site, hist);
        lkup.setInput("ssf25", ssf25);
        List schemas = this._csStaging.lookupSchema(lkup);
        if (schemas.size() == 1) {
            return this._csStaging.getSchema(((Schema)schemas.get(0)).getId());
        }
        return null;
    }

    public Schema getTnmStagingSchema(Map<String, String> input) {
        if (this._tnmStaging == null || input == null) {
            return null;
        }
        String site = input.get("primarySite");
        String hist = input.get("histologicTypeIcdO3");
        String ssf25 = input.get("csSiteSpecificFactor25");
        String sex = input.get("sex");
        SchemaLookup lkup = new SchemaLookup(site, hist);
        lkup.setInput("ssf25", ssf25);
        lkup.setInput("sex", sex);
        List schemas = this._tnmStaging.lookupSchema(lkup);
        if (schemas.size() == 1) {
            return this._tnmStaging.getSchema(((Schema)schemas.get(0)).getId());
        }
        return null;
    }

    public Schema getEodStagingSchema(Map<String, String> input) {
        if (this._eodStaging == null || input == null) {
            return null;
        }
        String site = input.get("primarySite");
        String hist = input.get("histologicTypeIcdO3");
        String disc1 = input.get(EOD_INPUT_PROP_DISC_1);
        String disc2 = input.get(EOD_INPUT_PROP_DISC_2);
        String sex = input.get("sex");
        String behav = input.get(EOD_INPUT_PROP_BEHAV);
        String dxYear = input.get("dateOfDiagnosisYear");
        SchemaLookup lkup = new SchemaLookup(site, hist);
        lkup.setInput("discriminator_1", disc1);
        lkup.setInput("discriminator_2", disc2);
        lkup.setInput("sex", sex);
        lkup.setInput("behavior", behav);
        lkup.setInput("year_dx", dxYear);
        List schemas = this._eodStaging.lookupSchema(lkup);
        if (schemas.size() == 1) {
            return this._eodStaging.getSchema(((Schema)schemas.get(0)).getId());
        }
        return null;
    }

    private Schema getCsStagingSchema(int schemaNumber) {
        if (this._csStaging == null || schemaNumber == -1) {
            return null;
        }
        return this._csStaging.getSchema(this._csSchemaIdByNumber.get(schemaNumber));
    }

    private String getDescriptionForCode(Map<String, String> input, String naaccrXmlId, String code) {
        if (this._csStaging == null || input == null || code == null) {
            return null;
        }
        Schema schema = this.getCsStagingSchema(input);
        if (schema == null) {
            return null;
        }
        Input schemaInput = schema.getInputs().stream().filter(i -> naaccrXmlId.equals(i.getNaaccrXmlId())).findFirst().orElse(null);
        if (schemaInput == null) {
            return null;
        }
        Table table = this._csStaging.getTable(schemaInput.getTable());
        if (table == null) {
            return null;
        }
        int colIndex = -1;
        for (int i2 = 0; i2 < table.getColumnDefinitions().size(); ++i2) {
            if (((ColumnDefinition)table.getColumnDefinitions().get(i2)).getType() != ColumnDefinition.ColumnType.DESCRIPTION) continue;
            colIndex = i2;
            break;
        }
        if (colIndex == -1) {
            return null;
        }
        Integer rowIndex = this._csStaging.findMatchingTableRow(table.getId(), schemaInput.getKey(), code);
        if (rowIndex == null) {
            return null;
        }
        return (String)((List)table.getRawRows().get(rowIndex)).get(colIndex);
    }

    protected int getCsNumSchemas() {
        if (this._csStaging == null) {
            return -1;
        }
        return this._csStaging.getSchemaIds().size();
    }

    protected int getCsSchemaNumber(Map<String, String> input) {
        if (this._csStaging == null) {
            return -1;
        }
        Schema schema = this.getCsStagingSchema(input);
        return schema == null || schema.getSchemaNum() == null ? -1 : schema.getSchemaNum();
    }

    protected String getCsSchemaName(int schemaNum) {
        if (this._csStaging == null) {
            return null;
        }
        Schema schema = this.getCsStagingSchema(schemaNum);
        return schema == null ? null : schema.getName();
    }

    protected boolean isAcceptableCsCode(int schemaNumber, int tableNumber, String valueToCheck) {
        if (this._csStaging == null) {
            return false;
        }
        Schema schema = this.getCsStagingSchema(schemaNumber);
        return schema != null && this._csStaging.isCodeValid(schema.getId(), CSTAGE_TABLE_NUMBERS.get(tableNumber), valueToCheck);
    }

    protected boolean checkMetaData(Map<String, String> input, Input schemaInput, String ... tags) {
        if (schemaInput == null || schemaInput.getMetadata() == null || schemaInput.getMetadata().isEmpty()) {
            return false;
        }
        for (Metadata data : schemaInput.getMetadata()) {
            if (!ArrayUtils.contains((Object[])tags, (Object)data.getName())) continue;
            if (data.getStart() == null && data.getEnd() == null) {
                return true;
            }
            Integer inputDxYear = this.extractDxYear(input);
            return !(inputDxYear == null || data.getStart() != null && inputDxYear < data.getStart() || data.getEnd() != null && inputDxYear > data.getEnd());
        }
        return false;
    }

    protected Integer extractDxYear(Map<String, String> input) {
        String fullVal;
        if (input == null) {
            return null;
        }
        String val = input.get("dateOfDiagnosisYear");
        if (StringUtils.isBlank((CharSequence)val) && (fullVal = input.get(CSTAGE_INPUT_PROP_DX_DATE)) != null && fullVal.length() >= 4) {
            val = fullVal.substring(0, 4);
        }
        return NumberUtils.isDigits((String)val) ? Integer.valueOf(val) : null;
    }

    @ContextFunctionDocAnnotation(paramName1="map", param1="Map to expand", desc="Expands the keys of the provided map, replacing all the ranges by their actual values", example="Functions.expandKeys ( [ 1..3 : '1' ] ) returns [ 1 : '1', 2 : '1', 3 : '1' ]")
    public Map<Object, Object> expandKeys(Map<Object, Object> map) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            int i;
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (key instanceof List) {
                List list = (List)key;
                for (Object obj : list) {
                    if (obj instanceof IntRange) {
                        for (i = ((IntRange)obj).getFromInt(); i <= ((IntRange)obj).getToInt(); ++i) {
                            result.put(i, val);
                        }
                        continue;
                    }
                    if (obj instanceof String && ((String)obj).contains("..")) {
                        String[] parts = StringUtils.split((String)((String)obj), (String)"..");
                        if (parts.length != 2) {
                            throw new IllegalStateException("Bad range: " + obj);
                        }
                        Integer low = this.asInt(parts[0]);
                        Integer high = this.asInt(parts[1]);
                        if (low == null || high == null || low >= high) {
                            throw new IllegalStateException("Bad range: " + obj);
                        }
                        for (int i2 = low.intValue(); i2 <= high; ++i2) {
                            result.put(String.valueOf(i2), val);
                        }
                        continue;
                    }
                    result.put(obj, val);
                }
                continue;
            }
            if (key instanceof String && ((String)key).contains("..")) {
                String[] parts = StringUtils.split((String)((String)key), (String)"..");
                if (parts.length != 2) {
                    throw new IllegalStateException("Bad range: " + key);
                }
                Integer low = this.asInt(parts[0]);
                Integer high = this.asInt(parts[1]);
                if (low == null || high == null || low >= high) {
                    throw new IllegalStateException("Bad range: " + key);
                }
                for (i = low.intValue(); i <= high; ++i) {
                    result.put(String.valueOf(i), val);
                }
                continue;
            }
            result.put(key, val);
        }
        return result;
    }

    @ContextFunctionDocAnnotation(paramName1="list", param1="List to expand", desc="Expands the values of the provided list, replacing all the ranges by their actual values", example="Functions.expandList ( [ 1..3, 4, 5..6 ] ) returns [ 1, 2, 3, 4, 5, 6]")
    public List<Object> expandList(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : list) {
            if (obj instanceof IntRange) {
                for (int i = ((IntRange)obj).getFromInt(); i <= ((IntRange)obj).getToInt(); ++i) {
                    result.add(i);
                }
                continue;
            }
            if (obj instanceof String && ((String)obj).contains("..")) {
                String[] parts = StringUtils.split((String)((String)obj), (String)"..");
                if (parts.length != 2) {
                    throw new IllegalStateException("Bad range: " + obj);
                }
                Integer low = this.asInt(parts[0]);
                Integer high = this.asInt(parts[1]);
                if (low == null || high == null || low >= high) {
                    throw new IllegalStateException("Bad range: " + obj);
                }
                for (int i = low.intValue(); i <= high; ++i) {
                    result.add(String.valueOf(i));
                }
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public String getSsf25FromSex(String ssf25, String sex, String hist, String dxYear, String tnmSchemaId) {
        return ValidationStagingUtils.getSsf25FromSex(ssf25, sex, hist, dxYear, tnmSchemaId);
    }

    static {
        HashMap<Object, String> tmpMap = new HashMap<Object, String>();
        tmpMap.put(1, "size");
        tmpMap.put(2, "extension");
        tmpMap.put(3, "extension_eval");
        tmpMap.put(4, "nodes");
        tmpMap.put(5, "nodes_eval");
        tmpMap.put(6, "nodes_pos");
        tmpMap.put(7, "nodes_exam");
        tmpMap.put(8, "mets");
        tmpMap.put(9, "mets_eval");
        tmpMap.put(10, "ssf1");
        tmpMap.put(11, "ssf2");
        tmpMap.put(12, "ssf3");
        tmpMap.put(13, "ssf4");
        tmpMap.put(14, "ssf5");
        tmpMap.put(15, "ssf6");
        tmpMap.put(16, "ssf7");
        tmpMap.put(17, "ssf8");
        tmpMap.put(18, "ssf9");
        tmpMap.put(19, "ssf10");
        tmpMap.put(20, "ssf11");
        tmpMap.put(21, "ssf12");
        tmpMap.put(22, "ssf13");
        tmpMap.put(23, "ssf14");
        tmpMap.put(24, "ssf15");
        tmpMap.put(25, "ssf16");
        tmpMap.put(26, "ssf17");
        tmpMap.put(27, "ssf18");
        tmpMap.put(28, "ssf19");
        tmpMap.put(29, "ssf20");
        tmpMap.put(30, "ssf21");
        tmpMap.put(31, "ssf22");
        tmpMap.put(32, "ssf23");
        tmpMap.put(33, "ssf24");
        tmpMap.put(34, "ssf25");
        CSTAGE_TABLE_NUMBERS = Collections.unmodifiableMap(tmpMap);
        tmpMap = new HashMap();
        tmpMap.put("OBSOLETE DATA CONVERTED AND RETAINED V0200", "1");
        tmpMap.put("OBSOLETE DATA CONVERTED V0102", "2");
        tmpMap.put("OBSOLETE DATA CONVERTED V0104", "3");
        tmpMap.put("OBSOLETE DATA CONVERTED V0200", "4");
        tmpMap.put("OBSOLETE DATA RETAINED V0100", "5");
        tmpMap.put("OBSOLETE DATA RETAINED V0102", "6");
        tmpMap.put("OBSOLETE DATA RETAINED V0200", "7");
        tmpMap.put("OBSOLETE DATA REVIEWED AND CHANGED V0102", "8");
        tmpMap.put("OBSOLETE DATA REVIEWED AND CHANGED V0103", "9");
        tmpMap.put("OBSOLETE DATA REVIEWED AND CHANGED V0200", "10");
        tmpMap.put("OBSOLETE DATA CONVERTED V0203", "11");
        tmpMap.put("OBSOLETE DATA REVIEWED AND CHANGED V0203", "12");
        tmpMap.put("OBSOLETE DATA REVIEWED V0203", "13");
        tmpMap.put("OBSOLETE DATA RETAINED AND REVIEWED V0203", "14");
        tmpMap.put("OBSOLETE DATA RETAINED V0203", "15");
        tmpMap.put("OBSOLETE DATA RETAINED V0104", "16");
        tmpMap.put("OBSOLETE DATA RETAINED V0202", "17");
        tmpMap.put("OBSOLETE DATA RETAINED AND REVIEWED V0200", "18");
        tmpMap.put("OBSOLETE DATA CONVERTED V0204", "19");
        tmpMap.put("OBSOLETE DATA REVIEWED AND CHANGED V0204", "20");
        tmpMap.put("OBSOLETE DATA RETAINED AND REVIEWED V0204", "21");
        tmpMap.put("OBSOLETE DATA RETAINED V0204", "22");
        CSTAGE_OBSOLETE_REASONS = Collections.unmodifiableMap(tmpMap);
    }
}

