/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.internal;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.ValidationException;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.Condition;
import com.imsweb.validation.entities.Validatable;
import groovy.lang.Binding;
import groovy.lang.Script;
import org.codehaus.groovy.control.CompilationFailedException;

public class ExecutableCondition {
    private final Condition _condition;
    private String _id;
    private final Long _internalId;
    private String _javaPath;
    private Script _script;
    private final Object _scriptLock = new Object();

    public ExecutableCondition(Condition condition) throws ConstructionException {
        this._condition = condition;
        this._id = condition.getId();
        this._internalId = condition.getConditionId();
        this._javaPath = condition.getJavaPath();
        try {
            this._script = ValidationServices.getInstance().compileExpression(condition.getExpression());
        }
        catch (CompilationFailedException e) {
            this._script = null;
            throw new ConstructionException("Unable to compile expression for condition " + this._condition.getId(), e);
        }
    }

    public ExecutableCondition(ExecutableCondition condition) {
        this._condition = condition._condition;
        this._id = condition._id;
        this._internalId = condition._internalId;
        this._javaPath = condition._javaPath;
        this._script = condition._script;
    }

    public Condition getCondition() {
        return this._condition;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Long getInternalId() {
        return this._internalId;
    }

    public String getJavaPath() {
        return this._javaPath;
    }

    public void setJavaPath(String javaPath) {
        this._javaPath = javaPath;
    }

    public void setExpression(String expression) throws ConstructionException {
        try {
            this._script = ValidationServices.getInstance().compileExpression(expression);
        }
        catch (CompilationFailedException e) {
            throw new ConstructionException("Unable to compile expression for condition " + this._condition.getId(), e);
        }
    }

    public String toString() {
        return this._id;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(Validatable validatable, Binding binding) throws ValidationException {
        boolean success;
        if (this._script == null) {
            return true;
        }
        Object object = this._scriptLock;
        synchronized (object) {
            block14: {
                this._script.setBinding(binding);
                try {
                    Object result = this._script.run();
                    if (result instanceof Boolean) {
                        success = (Boolean)result;
                        break block14;
                    }
                    throw new ValidationException("result is not a boolean");
                }
                catch (Exception e) {
                    StringBuilder buf = new StringBuilder();
                    if (this._id != null) {
                        buf.append("Unable to execute condition '").append(this._id).append("'");
                        String validated = validatable.getDisplayId();
                        if (validated != null) {
                            buf.append(" on ").append(validatable.getDisplayId()).append(": ");
                        } else {
                            buf.append(": ");
                        }
                    } else {
                        buf.append("Unable to execute condition: ");
                    }
                    buf.append(e.getMessage() == null ? "null reference" : e.getMessage());
                    throw new ValidationException(buf.toString(), e);
                }
                finally {
                    this._script.setBinding(null);
                }
            }
        }
        return success;
    }
}

