/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.internal;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.ValidatingContext;
import com.imsweb.validation.ValidationContextFunctions;
import com.imsweb.validation.ValidationException;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.RuleFailure;
import com.imsweb.validation.entities.Validatable;
import com.imsweb.validation.internal.ExecutableCondition;
import com.imsweb.validation.internal.ExecutableRule;
import com.imsweb.validation.internal.IterativeProcessor;
import com.imsweb.validation.internal.Processor;
import com.imsweb.validation.internal.ValidationLRUCache;
import com.imsweb.validation.runtime.RuntimeUtils;
import groovy.lang.Binding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;

public class ValidatingProcessor
implements Processor {
    private final String _currentJavaPath;
    private final Collection<IterativeProcessor> _processors = new ArrayList<IterativeProcessor>();
    private final List<ExecutableCondition> _conditions = new CopyOnWriteArrayList<ExecutableCondition>();
    private final List<ExecutableRule> _rules = new CopyOnWriteArrayList<ExecutableRule>();
    private final Map<String, Object> _contexts = new ConcurrentHashMap<String, Object>();
    private final ValidationLRUCache<String, ExecutableRule> _cachedForcedRules = new ValidationLRUCache(10);

    public ValidatingProcessor(String javaPath) {
        this._currentJavaPath = javaPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RuleFailure> process(Validatable validatable, ValidatingContext vContext) throws ValidationException {
        ArrayList<RuleFailure> results = new ArrayList<RuleFailure>();
        ExecutableRule toForce = null;
        if (vContext.getToForce() != null && this._currentJavaPath.equals(vContext.getToForce().getJavaPath())) {
            try {
                String key = vContext.getToForce().getId() + "|" + vContext.getToForce().getExpression().hashCode();
                toForce = (ExecutableRule)this._cachedForcedRules.get(key);
                if (toForce == null) {
                    toForce = new ExecutableRule(vContext.getToForce(), RuntimeUtils.findCompileRules(vContext.getToForce().getValidator(), null), null);
                    this._cachedForcedRules.put(key, toForce);
                }
            }
            catch (ConstructionException e) {
                throw new ValidationException(e);
            }
        }
        Binding binding = null;
        if (vContext.getToForce() == null) {
            binding = this.buildBinding(validatable);
            HashSet<String> currentConditionFailures = new HashSet<String>();
            vContext.getFailedConditionIds().put(validatable.getCurrentLevel(), currentConditionFailures);
            for (ExecutableCondition executableCondition : this._conditions) {
                if (executableCondition.check(validatable, binding)) continue;
                currentConditionFailures.add(executableCondition.getId());
            }
        }
        if (!this._rules.isEmpty() || toForce != null) {
            if (binding == null) {
                binding = this.buildBinding(validatable);
            }
            ArrayList<String> validatablePaths = new ArrayList<String>();
            StringBuilder buf = new StringBuilder();
            for (String validatablePath : StringUtils.split((String)validatable.getCurrentLevel(), (char)'.')) {
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(validatablePath);
                validatablePaths.add(buf.toString());
            }
            HashSet<String> hashSet = new HashSet<String>();
            vContext.getFailedRuleIds().put(validatable.getCurrentLevel(), hashSet);
            List<Object> toExecute = toForce != null ? Collections.singletonList(toForce) : (vContext.getToForce() != null ? Collections.emptyList() : this._rules);
            for (ExecutableRule rule : toExecute) {
                String id = rule.getId();
                if (toForce == null) {
                    if (vContext.getToExecute() != null && !vContext.getToExecute().contains(id) || vContext.getToIgnore() != null && vContext.getToIgnore().contains(id)) {
                        hashSet.add(id);
                        continue;
                    }
                    if (rule.getIgnored() != null && rule.getIgnored().booleanValue()) {
                        hashSet.add(id);
                        continue;
                    }
                    if (rule.getConditions() != null && !rule.getConditions().isEmpty()) {
                        boolean conditionFailed = rule.getUseAndForConditions() == false;
                        for (String conditionId : rule.getConditions()) {
                            boolean thisConditionFailed = vContext.conditionFailed(validatablePaths, conditionId);
                            if (Boolean.TRUE.equals(rule.getUseAndForConditions())) {
                                if (!thisConditionFailed) continue;
                                conditionFailed = true;
                                break;
                            }
                            if (thisConditionFailed) continue;
                            conditionFailed = false;
                            break;
                        }
                        if (conditionFailed) {
                            hashSet.add(id);
                            continue;
                        }
                    }
                    if (vContext.atLeastOneDependencyFailed(validatablePaths, rule.getDependencies())) {
                        hashSet.add(id);
                        continue;
                    }
                }
                try {
                    long startTime = System.currentTimeMillis();
                    boolean success = rule.validate(validatable, binding);
                    long endTime = System.currentTimeMillis();
                    if (vContext.computeEditsStats() && id != null && !id.isEmpty()) {
                        vContext.reportEditDuration(this._currentJavaPath, id, endTime - startTime);
                    }
                    if (success) continue;
                    String message = ValidationServices.getInstance().fillInMessage(rule.getMessage(), validatable);
                    String overriddenError = (String)binding.getVariable("__error_message");
                    if (overriddenError != null) {
                        message = ValidationServices.getInstance().fillInMessage(overriddenError, validatable);
                    }
                    RuleFailure failure = new RuleFailure(rule.getRule(), message, validatable);
                    failure.setExtraErrorMessages(ValidationServices.getInstance().fillInMessages((List)binding.getVariable("__extra_error_messages"), validatable));
                    failure.setInformationMessages(ValidationServices.getInstance().fillInMessages((List)binding.getVariable("__information_messages"), validatable));
                    failure.setOriginalResult((Boolean)binding.getVariable("__original_result"));
                    results.add(failure);
                    hashSet.add(id);
                }
                catch (ValidationException e) {
                    results.add(new RuleFailure(rule.getRule(), "Edit failed with exception.", validatable, e.getCause()));
                }
                catch (RuntimeException e) {
                    results.add(new RuleFailure(rule.getRule(), "Edit failed with exception.", validatable, e));
                }
                finally {
                    validatable.clearPropertiesWithError();
                }
            }
        }
        for (IterativeProcessor p : this._processors) {
            results.addAll(p.process(validatable, vContext));
        }
        return results;
    }

    protected Binding buildBinding(Validatable validatable) {
        Binding binding = new Binding();
        binding.setVariable("Functions", (Object)ValidationContextFunctions.getInstance());
        binding.setVariable("Context", this._contexts);
        for (Map.Entry<String, Object> entry : validatable.getScope().entrySet()) {
            binding.setVariable(entry.getKey(), entry.getValue());
        }
        return binding;
    }

    public String getJavaPath() {
        return this._currentJavaPath;
    }

    public void addNested(IterativeProcessor processor) {
        this._processors.add(processor);
    }

    public synchronized void setRules(List<ExecutableRule> rules) {
        this._rules.clear();
        this._rules.addAll(rules);
    }

    public synchronized void setConditions(Collection<ExecutableCondition> conditions) {
        this._conditions.clear();
        this._conditions.addAll(conditions);
    }

    public void setContexts(Map<Long, Map<String, Object>> allContexts) {
        this._contexts.clear();
        if (allContexts != null) {
            for (Map.Entry<Long, Map<String, Object>> entry : allContexts.entrySet()) {
                this._contexts.putAll(entry.getValue());
            }
        }
    }

    public void dumpCache(StringBuilder buffer, String path) {
        buffer.append("\n").append(path).append(": ");
        for (ExecutableRule r : this._rules) {
            buffer.append(r.getId()).append(",");
        }
        if (!this._rules.isEmpty()) {
            buffer.setLength(buffer.length() - 1);
        }
    }

    public String toString() {
        return this._currentJavaPath + " [" + this._rules.size() + " rule(s)]";
    }
}

