/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.internal.context;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.internal.context.JavaContextLexer;
import com.imsweb.validation.internal.context.JavaContextSymbol;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang3.math.NumberUtils;

public final class JavaContextParser {
    private JavaContextParser() {
    }

    public static Object parseContext(String expression, Map<String, Object> currentContext) throws ConstructionException {
        Object result;
        block17: {
            String content;
            String typeHint = null;
            int typeHintIdx = expression.lastIndexOf(" as ");
            if (typeHintIdx > 0 && (content = expression.substring(0, typeHintIdx)).endsWith("]")) {
                typeHint = expression.substring(typeHintIdx + 4);
                expression = content;
            }
            JavaContextLexer lexer = new JavaContextLexer(new StringReader(expression));
            try {
                JavaContextSymbol token = lexer.next_token();
                LinkedList<JavaContextSymbol> queue = new LinkedList<JavaContextSymbol>();
                queue.add(token);
                if (token.getType() == JavaContextSymbol.JavaContextSymbolType.NUMBER || token.getType() == JavaContextSymbol.JavaContextSymbolType.STRING_VAL) {
                    JavaContextSymbol nextToken = lexer.next_token();
                    if (nextToken == null) {
                        return token.getValue();
                    }
                    if (nextToken.getType() != JavaContextSymbol.JavaContextSymbolType.RANGE) {
                        throw new ConstructionException("Invalid syntax.");
                    }
                    queue.add(nextToken);
                }
                while (token != null) {
                    token = lexer.next_token();
                    queue.add(token);
                }
                result = JavaContextParser.buildListOrMapFromQueue(queue, currentContext, false);
                if (typeHint == null) break block17;
                try {
                    Class<?> typeClazz = Class.forName(typeHint);
                    Object obj = typeClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (result instanceof List) {
                        if (!(obj instanceof List) && !(obj instanceof Set)) {
                            throw new ConstructionException("Unable to assign list to type " + typeHint);
                        }
                        if (obj instanceof List) {
                            ((List)obj).addAll((List)result);
                        } else {
                            ((Set)obj).addAll((List)result);
                        }
                        result = obj;
                    } else if (result instanceof Map) {
                        if (!(obj instanceof Map)) {
                            throw new ConstructionException("Unable to assign map to type " + typeHint);
                        }
                        ((Map)obj).putAll((Map)result);
                        result = obj;
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new ConstructionException(e);
                }
            }
            catch (IOException e) {
                throw new ConstructionException("Invalid syntax.", e);
            }
            catch (RuntimeException e2) {
                throw new ConstructionException(e2.getMessage(), e2);
            }
        }
        return result;
    }

    private static Object buildListOrMapFromQueue(Queue<JavaContextSymbol> queue, Map<String, Object> currentContext, boolean containsListBeginToken) throws ConstructionException {
        Stack<Object> stack = new Stack<Object>();
        ArrayList returnValue = null;
        JavaContextSymbol s = queue.remove();
        while (!queue.isEmpty() && s != null) {
            if (s.getType() == JavaContextSymbol.JavaContextSymbolType.NUMBER || s.getType() == JavaContextSymbol.JavaContextSymbolType.STRING_VAL) {
                stack.add(s.getValue());
            } else if (s.getType() == JavaContextSymbol.JavaContextSymbolType.LEFT_BRACKET) {
                stack.add(JavaContextParser.buildListOrMapFromQueue(queue, currentContext, true));
            } else if (s.getType() == JavaContextSymbol.JavaContextSymbolType.COLON) {
                returnValue = new HashMap();
            } else if (s.getType() == JavaContextSymbol.JavaContextSymbolType.COMMA) {
                returnValue = new ArrayList();
            } else if (s.getType() == JavaContextSymbol.JavaContextSymbolType.VARIABLE) {
                if (s.getValue() != null && currentContext.containsKey(s.getValue().toString())) {
                    stack.add(currentContext.get(s.getValue().toString()));
                } else if (!"Context".equals(s.getValue())) {
                    throw new ConstructionException("Could not find key '" + s.getValue() + "' in current contexts.");
                }
            } else if (s.getType() == JavaContextSymbol.JavaContextSymbolType.RANGE) {
                if (stack.isEmpty() || queue.isEmpty()) {
                    throw new ConstructionException("Invalid range syntax.");
                }
                stack.add(JavaContextParser.createRange(stack.pop(), queue));
            } else if (s.getType() == JavaContextSymbol.JavaContextSymbolType.RIGHT_BRACKET) break;
            s = queue.remove();
        }
        if (returnValue == null) {
            if (!stack.isEmpty()) {
                returnValue = (ArrayList)stack.pop();
            }
            if (containsListBeginToken && !(returnValue instanceof RangeObject) && !(returnValue instanceof List) && !(returnValue instanceof Map)) {
                List<Object> list = returnValue = returnValue == null ? new ArrayList() : Collections.singletonList(returnValue);
            }
            if (returnValue instanceof RangeObject) {
                returnValue = ((RangeObject)((Object)returnValue)).getRangeList();
            }
        } else if (returnValue instanceof ArrayList) {
            while (!stack.isEmpty()) {
                Object item = stack.pop();
                if (item instanceof RangeObject) {
                    for (int i = ((RangeObject)item).getRangeList().size() - 1; i >= 0; --i) {
                        ((ArrayList)returnValue).add(((RangeObject)item).getRangeList().get(i));
                    }
                    continue;
                }
                ((ArrayList)returnValue).add(item);
            }
            Collections.reverse(returnValue);
        } else {
            while (!stack.isEmpty()) {
                Object value = stack.pop();
                Object key = stack.pop();
                ((HashMap)((Object)returnValue)).put(key, value);
            }
            returnValue = JavaContextParser.explodeMap((HashMap)((Object)returnValue));
        }
        return returnValue;
    }

    private static Map<Object, Object> explodeMap(Map<Object, Object> map) {
        HashMap<Object, Object> tempMap = new HashMap<Object, Object>();
        ArrayList<Object> keysToDelete = new ArrayList<Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (!(key instanceof List)) continue;
            Object value = entry.getValue();
            keysToDelete.add(key);
            for (Object element : (List)key) {
                tempMap.put(element, value);
                if (!(element instanceof List)) continue;
                JavaContextParser.explodeMap(tempMap);
            }
        }
        for (Map.Entry<Object, Object> entry : keysToDelete) {
            map.remove(entry);
        }
        map.putAll(tempMap);
        return map;
    }

    private static RangeObject createRange(Object lowValue, Queue queue) throws ConstructionException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        String nextValue = ((JavaContextSymbol)queue.remove()).getValue().toString();
        if (lowValue == null || !NumberUtils.isDigits((String)lowValue.toString()) || !NumberUtils.isDigits((String)nextValue)) {
            throw new ConstructionException("Invalid range syntax.");
        }
        int low = Integer.parseInt(lowValue.toString());
        int high = Integer.parseInt(nextValue);
        for (int i = low; i <= high; ++i) {
            list.add(i);
        }
        return new RangeObject(list);
    }

    private static class RangeObject {
        private final List<Integer> _rangeList;

        public RangeObject(List<Integer> rangeList) {
            this._rangeList = rangeList;
        }

        public List<Integer> getRangeList() {
            return this._rangeList;
        }
    }
}

