/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.runtime;

import com.imsweb.validation.InitializationStats;
import com.imsweb.validation.entities.Validator;
import com.imsweb.validation.runtime.CompiledRules;
import com.imsweb.validation.runtime.ParsedContexts;
import com.imsweb.validation.runtime.ParsedLookups;
import com.imsweb.validation.runtime.ParsedProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class RuntimeUtils {
    private static final Pattern _P1 = Pattern.compile("\\s+|-+|/|\\.");
    private static final Pattern _P2 = Pattern.compile("[()]");
    private static final Pattern _P3 = Pattern.compile("[\\W&&[^\\s]]");
    private static final Pattern _P4 = Pattern.compile("(^_)|(_$)");

    private RuntimeUtils() {
    }

    public static String createMethodName(String ruleId) {
        if (ruleId == null || ruleId.isEmpty()) {
            throw new IllegalStateException("Rule ID cannot be blank!");
        }
        ruleId = _P1.matcher(ruleId).replaceAll(" ");
        ruleId = _P2.matcher(ruleId).replaceAll("_");
        ruleId = _P3.matcher(ruleId).replaceAll("");
        ruleId = _P4.matcher(ruleId).replaceAll("");
        String[] parts = StringUtils.split((String)ruleId, (char)' ');
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtils.uncapitalize((String)parts[0].toLowerCase()));
        for (int i = 1; i < parts.length; ++i) {
            buf.append(StringUtils.capitalize((String)parts[i].toLowerCase()));
        }
        return buf.toString();
    }

    public static String createCompiledRulesClassName(String validatorId) {
        StringBuilder result = new StringBuilder();
        for (String s : StringUtils.split((String)validatorId, (String)"-")) {
            result.append(StringUtils.capitalize((String)s));
        }
        return result + "CompiledRules";
    }

    public static CompiledRules findCompileRules(Validator validator, InitializationStats stats) {
        if (validator == null) {
            return null;
        }
        CompiledRules compiledRules = validator.getCompiledRules();
        if (compiledRules != null) {
            if (!StringUtils.isBlank((CharSequence)validator.getVersion()) && !validator.getVersion().equals(compiledRules.getValidatorVersion())) {
                if (stats != null) {
                    stats.setReasonNotPreCompiled(validator.getId(), "pre-compiled validator has version {0} but application expected {1}".replace("{0}", compiledRules.getValidatorVersion()).replace("{1}", validator.getVersion()));
                }
                compiledRules = null;
            }
        } else if (stats != null) {
            stats.setReasonNotPreCompiled(validator.getId(), "pre-compiled edits not provided");
        }
        return compiledRules;
    }

    public static Method findCompiledMethod(CompiledRules compiledRules, String ruleId, List<Class<?>> parameters) {
        if (ruleId == null || compiledRules == null) {
            return null;
        }
        if (parameters == null) {
            throw new IllegalStateException("Got null parameters for rule ID '" + ruleId + "'");
        }
        try {
            return compiledRules.getClass().getMethod(RuntimeUtils.createMethodName(ruleId), parameters.toArray(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static String createParsedPropertiesClassName(String validatorId) {
        StringBuilder result = new StringBuilder();
        for (String s : StringUtils.split((String)validatorId, (String)"-")) {
            result.append(StringUtils.capitalize((String)s));
        }
        return result + "ParsedProperties";
    }

    public static Set<String> getParsedProperties(ParsedProperties properties, String ruleId) {
        if (properties == null || ruleId == null) {
            return null;
        }
        try {
            return (Set)properties.getClass().getMethod(RuntimeUtils.createMethodName(ruleId), new Class[0]).invoke((Object)properties, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public static String createParsedContextsClassName(String validatorId) {
        StringBuilder result = new StringBuilder();
        for (String s : StringUtils.split((String)validatorId, (String)"-")) {
            result.append(StringUtils.capitalize((String)s));
        }
        return result + "ParsedContexts";
    }

    public static Set<String> getParsedContexts(ParsedContexts contexts, String ruleId) {
        if (contexts == null || ruleId == null) {
            return null;
        }
        try {
            return (Set)contexts.getClass().getMethod(RuntimeUtils.createMethodName(ruleId), new Class[0]).invoke((Object)contexts, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public static String createParsedLookupsClassName(String validatorId) {
        StringBuilder result = new StringBuilder();
        for (String s : StringUtils.split((String)validatorId, (String)"-")) {
            result.append(StringUtils.capitalize((String)s));
        }
        return result + "ParsedLookups";
    }

    public static Set<String> getParsedLookups(ParsedLookups lookups, String ruleId) {
        if (lookups == null || ruleId == null) {
            return null;
        }
        try {
            return (Set)lookups.getClass().getMethod(RuntimeUtils.createMethodName(ruleId), new Class[0]).invoke((Object)lookups, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

