/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation;

import com.imsweb.validation.entities.Rule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValidatingContext {
    protected Collection<String> _toIgnore;
    protected Collection<String> _toExecute;
    protected Rule _toForce;
    protected Map<String, Set<String>> _failedRuleIds = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> _failedConditionIds = new HashMap<String, Set<String>>();
    private final Map<String, Map<String, Long>> _editsStats = new HashMap<String, Map<String, Long>>();
    private boolean _computeEditsStats = false;

    public Collection<String> getToIgnore() {
        return this._toIgnore;
    }

    public void setToIgnore(Collection<String> toIgnore) {
        this._toIgnore = toIgnore;
    }

    public Collection<String> getToExecute() {
        return this._toExecute;
    }

    public void setToExecute(Collection<String> toExecute) {
        this._toExecute = toExecute;
    }

    public Rule getToForce() {
        return this._toForce;
    }

    public void setToForce(Rule toForce) {
        this._toForce = toForce;
    }

    public Map<String, Set<String>> getFailedRuleIds() {
        return this._failedRuleIds;
    }

    public Map<String, Set<String>> getFailedConditionIds() {
        return this._failedConditionIds;
    }

    public boolean computeEditsStats() {
        return this._computeEditsStats;
    }

    public void setComputeEditsStats(boolean computeEditsStats) {
        this._computeEditsStats = computeEditsStats;
    }

    public void reportEditDuration(String path, String id, long duration) {
        this._editsStats.computeIfAbsent(path, k -> new HashMap()).put(id, duration);
    }

    public Map<String, Long> getEditDurations() {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        this._editsStats.values().forEach(stats::putAll);
        return stats;
    }

    public void resetFailures() {
        this._failedRuleIds.clear();
        this._failedConditionIds.clear();
    }

    public boolean conditionFailed(List<String> validatablePaths, String conditionId) {
        if (validatablePaths == null || conditionId == null) {
            return false;
        }
        for (String validatablePath : validatablePaths) {
            Set<String> failedIds = this._failedConditionIds.get(validatablePath);
            if (failedIds == null || !failedIds.contains(conditionId)) continue;
            return true;
        }
        return false;
    }

    public boolean atLeastOneDependencyFailed(List<String> validatablePaths, Set<String> dependencies) {
        if (validatablePaths == null || dependencies == null) {
            return false;
        }
        for (String validatablePath : validatablePaths) {
            Set<String> failedIds = this._failedRuleIds.get(validatablePath);
            if (failedIds == null || Collections.disjoint(failedIds, dependencies)) continue;
            return true;
        }
        return false;
    }
}

