/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation;

import com.imsweb.validation.ContextFunctionDocAnnotation;
import com.imsweb.validation.ContextFunctionDocDto;
import com.imsweb.validation.ValidationEngine;
import com.imsweb.validation.ValidationException;
import com.imsweb.validation.ValidationLookup;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.internal.ExtraPropertyEntityHandlerDto;
import groovy.lang.Binding;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ValidationContextFunctions {
    private static ValidationContextFunctions _INSTANCE = new ValidationContextFunctions();
    private Map<String, Pattern> _regexCache;
    private int _regexCacheSize;
    private AtomicLong _numRegexCacheHit;
    private AtomicLong _numRegexCacheMiss;

    public static void initialize(ValidationContextFunctions instance) {
        _INSTANCE = instance;
    }

    public static ValidationContextFunctions getInstance() {
        return _INSTANCE;
    }

    public static List<ContextFunctionDocDto> getMethodsDocumentation() {
        if (_INSTANCE == null) {
            throw new IllegalStateException("Validation Context Functions have not been initialized!");
        }
        ArrayList<ContextFunctionDocDto> dtos = new ArrayList<ContextFunctionDocDto>();
        for (Method m : _INSTANCE.getClass().getMethods()) {
            ContextFunctionDocAnnotation annotation = m.getAnnotation(ContextFunctionDocAnnotation.class);
            if (annotation == null) continue;
            ContextFunctionDocDto dto = new ContextFunctionDocDto();
            dto.setMethodName(m.getName());
            if (!StringUtils.isEmpty((CharSequence)annotation.param1())) {
                dto.getParams().add(annotation.param1());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param2())) {
                dto.getParams().add(annotation.param2());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param3())) {
                dto.getParams().add(annotation.param3());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param4())) {
                dto.getParams().add(annotation.param4());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param5())) {
                dto.getParams().add(annotation.param5());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param6())) {
                dto.getParams().add(annotation.param6());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param7())) {
                dto.getParams().add(annotation.param7());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param8())) {
                dto.getParams().add(annotation.param8());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param9())) {
                dto.getParams().add(annotation.param9());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.param10())) {
                dto.getParams().add(annotation.param10());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName1())) {
                dto.getParamNames().add(annotation.paramName1());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName2())) {
                dto.getParamNames().add(annotation.paramName2());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName3())) {
                dto.getParamNames().add(annotation.paramName3());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName4())) {
                dto.getParamNames().add(annotation.paramName4());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName5())) {
                dto.getParamNames().add(annotation.paramName5());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName6())) {
                dto.getParamNames().add(annotation.paramName6());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName7())) {
                dto.getParamNames().add(annotation.paramName7());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName8())) {
                dto.getParamNames().add(annotation.paramName8());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName9())) {
                dto.getParamNames().add(annotation.paramName9());
            }
            if (!StringUtils.isEmpty((CharSequence)annotation.paramName10())) {
                dto.getParamNames().add(annotation.paramName10());
            }
            dto.setDescription(annotation.desc());
            dto.setExample(annotation.example());
            dtos.add(dto);
        }
        return dtos;
    }

    @ContextFunctionDocAnnotation(paramName1="binding", param1="Groovy binding (always called 'binding')", paramName2="entity", param2="entity to force the failure on; what entity means is application-dependent", paramName3="properties", param3="optional properties (with alias prefix) to report the failure on; if none are provided, the failure will be reported for all properties used in the edit", desc="Forces a failure on the provided entity, this can be useful in situations where an edits iterates over sub-entities and a failure needs to be reported on some of those sub-entities.", example="Functions.forceFailureOnEntity(binding, line)\nFunctions.forceFailureOnEntity(binding, line, 'line.nameLast')\nFunctions.forceFailureOnEntity(binding, line, 'line.nameLast', 'line.nameFirst')")
    public void forceFailureOnEntity(Binding binding, Object entity, String ... properties) {
        if (binding == null || entity == null) {
            return;
        }
        HashSet<ExtraPropertyEntityHandlerDto> forcedEntities = (HashSet<ExtraPropertyEntityHandlerDto>)binding.getVariable("__force_failure_on_entity_key");
        if (forcedEntities == null) {
            forcedEntities = new HashSet<ExtraPropertyEntityHandlerDto>();
            binding.setVariable("__force_failure_on_entity_key", forcedEntities);
        }
        forcedEntities.add(new ExtraPropertyEntityHandlerDto(entity, properties));
    }

    @ContextFunctionDocAnnotation(paramName1="binding", param1="Groovy binding (always called 'binding')", paramName2="properties", param2="properties (with alias prefix) to report the failure on; if none are provided, this function does nothing", desc="Forces the provided properties to be reported when a failure happens; the properties will be reported on the current entity being validated (what entity means is application-dependent).", example="Functions.forceFailureOnProperty(binding, 'line.nameLast')\nFunctions.forceFailureOnProperty(binding, 'line.nameLast', 'line.nameFirst')")
    public void forceFailureOnProperty(Binding binding, String ... properties) {
        if (properties == null || properties.length == 0) {
            return;
        }
        HashSet<String> forcedProperties = (HashSet<String>)binding.getVariable("__force_failure_on_property_key");
        if (forcedProperties == null) {
            forcedProperties = new HashSet<String>();
            binding.setVariable("__force_failure_on_property_key", forcedProperties);
        }
        forcedProperties.addAll(Arrays.asList(properties));
    }

    @ContextFunctionDocAnnotation(paramName1="binding", param1="Groovy binding (always called 'binding')", paramName2="properties", param2="properties (with alias prefix) to ignore; if none are provided, this function does nothing", desc="Ignores the provided properties when reporting a failure for the edit.", example="Functions.ignoreFailureOnProperty(binding, 'line.nameLast')\nFunctions.ignoreFailureOnProperty(binding, 'line.nameLast', 'line.nameFirst')")
    public void ignoreFailureOnProperty(Binding binding, String ... properties) {
        if (properties == null || properties.length == 0) {
            return;
        }
        HashSet<String> ignoredProperties = (HashSet<String>)binding.getVariable("__ignore_failure_on_property_key");
        if (ignoredProperties == null) {
            ignoredProperties = new HashSet<String>();
            binding.setVariable("__ignore_failure_on_property_key", ignoredProperties);
        }
        ignoredProperties.addAll(Arrays.asList(properties));
    }

    @ContextFunctionDocAnnotation(paramName1="validatorId", param1="validator ID", paramName2="contextKey", param2="context key", desc="Returns the value of the requested context key, throws an exception if the context is not found.", example="Functions.getContext('seer', 'Birthplace_Table')")
    public Object getContext(String validatorId, String contextKey) throws ValidationException {
        if (validatorId == null) {
            throw new ValidationException("Group is required when accessing a context entry.");
        }
        if (contextKey == null) {
            throw new ValidationException("Context key is required when accessing a context entry.");
        }
        Object context = ValidationEngine.getInstance().getContext(contextKey, validatorId);
        if (context == null) {
            throw new ValidationException("Unknown context key '" + contextKey + "' from group '" + validatorId + "'");
        }
        return context;
    }

    @ContextFunctionDocAnnotation(paramName1="id", param1="Lookup ID", desc="Returns the lookup corresponding to the requested ID.\n\nThe returned object is a ValidationLookup on which the following methods are available:\n    String getId()\n    String getByKey(String key)\n    String getByKeyWithCase(String key)\n    Set<String> getAllByKey(String key)\n    Set<String> getAllByKeyWithCase(String key)\n    Set<String> getAllKeys()\n    String getByValue(String value)\n    String getByValueWithCase(String value)\n    Set<String> getAllByValue(String value)\n    Set<String> getAllByValueWithCase(String value)\n    Set<String> getAllValues()\n    boolean containsKey(Object key)\n    boolean containsKeyWithCase(Object key)\n    boolean containsValue(Object value)\n    boolean containsValueWithCase(Object value)\n    boolean containsPair(String key, String value)\n    boolean containsPairWithCase(String key, String value)\n", example="Functions.fetchLookup('lookup_id').containsKey(value)")
    public ValidationLookup fetchLookup(String id) throws ValidationException {
        if (id == null) {
            throw new ValidationException("Unable to load lookup <null>");
        }
        ValidationLookup lookup = ValidationServices.getInstance().getLookupById(id);
        if (lookup == null) {
            throw new ValidationException("Unable to load lookup '" + id + "'");
        }
        return lookup;
    }

    @ContextFunctionDocAnnotation(paramName1="id", param1="Configuration variable ID", desc="Returns the value of the requested configuration variable.", example="Functions.fetchConfVariable('id')")
    public Object fetchConfVariable(String id) throws ValidationException {
        if (id == null) {
            throw new ValidationException("Unable to fetch configuration variable for null value");
        }
        return ValidationServices.getInstance().getConfVariable(id);
    }

    @ContextFunctionDocAnnotation(paramName1="message", param1="Message", desc="Logs the given message.", example="Functions.log('message')")
    public void log(String message) {
        ValidationServices.getInstance().log(message);
    }

    @ContextFunctionDocAnnotation(paramName1="message", param1="Message", desc="Logs the given message as a warning.", example="Functions.logWarning('warning message')")
    public void logWarning(String message) {
        ValidationServices.getInstance().logWarning(message);
    }

    @ContextFunctionDocAnnotation(paramName1="message", param1="Message", desc="Logs the given message as a error.", example="Functions.logError('error message')")
    public void logError(String message) {
        ValidationServices.getInstance().logError(message);
    }

    @ContextFunctionDocAnnotation(paramName1="value", param1="value to convert to an Integer", desc="Converts the passed value to an Integer, returns null if it can't be converted.", example="Functions.asInt(record.ageAtDx)\nFunctions.asInt(25)\nFunctions.asInt('25')\nFunctions.asInt('whatever') would return null")
    public Integer asInt(Object value) {
        Integer result = null;
        if (value != null) {
            if (value instanceof Integer) {
                result = (Integer)value;
            } else if (value instanceof Number) {
                result = ((Number)value).intValue();
            } else {
                String str;
                String string = str = value instanceof String ? (String)value : value.toString();
                if (NumberUtils.isDigits((String)str)) {
                    result = Integer.valueOf(str);
                }
            }
        }
        return result;
    }

    @ContextFunctionDocAnnotation(paramName1="value", param1="value to compare", paramName2="low", param2="low limit", paramName3="high", param3="high limit", desc="Returns true if the value is between the low and hight limit (inclusive), false it is not or cannot be determined.", example="Functions.between(2, 1, 3) -> true\nFunctions.between('B', 'A', 'C') -> true")
    public boolean between(Object value, Object low, Object high) {
        if (value == null || low == null || high == null) {
            return false;
        }
        if (value instanceof String) {
            String val = (String)value;
            String l = low.toString();
            String h = high.toString();
            if (NumberUtils.isDigits((String)val) && NumberUtils.isDigits((String)l) && NumberUtils.isDigits((String)h)) {
                long lVal = Long.parseLong(val);
                long lLow = Long.parseLong(l);
                long lHigh = Long.parseLong(h);
                return lVal >= lLow && lVal <= lHigh;
            }
            return val.compareTo(l) >= 0 && val.compareTo(h) <= 0;
        }
        if (value instanceof Number && low instanceof Number && high instanceof Number) {
            double val = ((Number)value).doubleValue();
            double l = ((Number)low).doubleValue();
            double h = ((Number)high).doubleValue();
            return val >= l && val <= h;
        }
        return false;
    }

    @ContextFunctionDocAnnotation(desc="Returns the current day as an integer.", example="Functions.getCurrentDay()")
    public int getCurrentDay() {
        return LocalDate.now().getDayOfMonth();
    }

    @ContextFunctionDocAnnotation(desc="Returns the current month as an integer.", example="Functions.getCurrentMonth()")
    public int getCurrentMonth() {
        return LocalDate.now().getMonthValue();
    }

    @ContextFunctionDocAnnotation(desc="Returns the current year as an integer.", example="Functions.getCurrentYear()")
    public int getCurrentYear() {
        return LocalDate.now().getYear();
    }

    public void enableRegexCaching() {
        this.enableRegexCaching(Integer.MAX_VALUE);
    }

    public void enableRegexCaching(int cacheSize) {
        if (cacheSize < 0) {
            throw new IllegalStateException("Cache size must be greater than 0!");
        }
        this._regexCache = new ConcurrentHashMap<String, Pattern>();
        this._regexCacheSize = cacheSize;
        this._numRegexCacheHit = new AtomicLong();
        this._numRegexCacheMiss = new AtomicLong();
    }

    public void disableRegexCaching() {
        this._regexCache = null;
        this._regexCacheSize = Integer.MAX_VALUE;
        this._numRegexCacheHit = null;
        this._numRegexCacheMiss = null;
    }

    @ContextFunctionDocAnnotation(paramName1="value", param1="value to use with the regular expression", paramName2="regex", param2="regular expression", desc="Returns true if the provided value matches the provided Java regular expression.", example="Functions.matches('123', /\\d+/) -> true")
    public boolean matches(Object value, Object regex) {
        Pattern pattern;
        String reg;
        if (value == null || regex == null) {
            return false;
        }
        String val = value instanceof String ? (String)value : value.toString();
        String string = reg = regex instanceof String ? (String)regex : regex.toString();
        if (this._regexCache != null) {
            pattern = this._regexCache.get(reg);
            if (pattern == null) {
                this._numRegexCacheMiss.incrementAndGet();
                pattern = Pattern.compile(reg);
                if (this._regexCache.size() < this._regexCacheSize) {
                    this._regexCache.put(reg, pattern);
                }
            } else {
                this._numRegexCacheHit.incrementAndGet();
            }
        } else {
            pattern = Pattern.compile(reg);
        }
        return pattern.matcher(val).matches();
    }

    public long getNumRegexCacheHit() {
        return this._numRegexCacheHit == null ? 0L : this._numRegexCacheHit.get();
    }

    public long getNumRegexCacheMiss() {
        return this._numRegexCacheMiss == null ? 0L : this._numRegexCacheMiss.get();
    }
}

