/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.entities;

import com.imsweb.validation.entities.ContextTable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ContextTableIndex {
    private final String _name;
    private NavigableMap<String, Integer> _uniqueKeysData;
    private List<Pair<String, Integer>> _nonUniqueKeysData;

    public ContextTableIndex(String name, ContextTable table, List<String> indexedColumns) {
        this._name = name;
        ArrayList<Integer> colIdx = new ArrayList<Integer>();
        for (String column : indexedColumns) {
            int idx = table.getHeaders().indexOf(column.trim());
            if (idx == -1) {
                throw new IllegalStateException("Unable to find column \"" + column + "\" to index on table \"" + table.getName() + "\"");
            }
            colIdx.add(idx);
        }
        HashSet<String> keysAdded = new HashSet<String>();
        boolean keysAreUnique = true;
        Pattern pattern = Pattern.compile("\\s+$");
        this._nonUniqueKeysData = new ArrayList<Pair<String, Integer>>();
        for (int rowIdx = 0; rowIdx < table.getData().size(); ++rowIdx) {
            List<String> row = table.getData().get(rowIdx);
            String key = pattern.matcher(StringUtils.join((Object[])((String[])colIdx.stream().map(row::get).toArray(String[]::new)))).replaceAll("");
            if (keysAdded.contains(key)) {
                keysAreUnique = false;
            }
            keysAdded.add(key);
            this._nonUniqueKeysData.add((Pair<String, Integer>)new ImmutablePair((Object)key, (Object)rowIdx));
        }
        if (keysAreUnique) {
            this._uniqueKeysData = new TreeMap<String, Integer>();
            for (Pair<String, Integer> pair : this._nonUniqueKeysData) {
                this._uniqueKeysData.put((String)pair.getKey(), (Integer)pair.getValue());
            }
            this._nonUniqueKeysData = null;
        } else {
            this._nonUniqueKeysData.sort(Comparator.comparing(Pair::getKey).thenComparingInt(Pair::getValue));
        }
    }

    public int find(String value) {
        if (value == null) {
            return -1;
        }
        int result = -1;
        if (this._uniqueKeysData != null) {
            result = this._uniqueKeysData.getOrDefault(value, -1);
        } else {
            for (Pair<String, Integer> pair : this._nonUniqueKeysData) {
                int comp = value.compareTo((String)pair.getKey());
                if (comp == 0) {
                    result = (Integer)pair.getValue();
                    break;
                }
                if (comp >= 0) continue;
                break;
            }
        }
        return result;
    }

    public int findFloor(String value) {
        if (value == null) {
            return -1;
        }
        int result = -1;
        if (this._uniqueKeysData != null) {
            if (value.compareTo((String)this._uniqueKeysData.firstKey()) >= 0) {
                Map.Entry<String, Integer> entry = this._uniqueKeysData.floorEntry(value);
                result = entry != null ? entry.getValue().intValue() : this._uniqueKeysData.lastEntry().getValue().intValue();
            }
        } else if (value.compareTo((String)this._nonUniqueKeysData.get(0).getKey()) >= 0) {
            for (int indexIdx = 0; indexIdx < this._nonUniqueKeysData.size(); ++indexIdx) {
                Pair<String, Integer> pair = this._nonUniqueKeysData.get(indexIdx);
                int comp = value.compareTo((String)pair.getKey());
                if (comp == 0 && (indexIdx == this._nonUniqueKeysData.size() - 1 || value.compareTo((String)this._nonUniqueKeysData.get(indexIdx + 1).getKey()) < 0)) {
                    result = (Integer)pair.getValue();
                    break;
                }
                if (comp >= 0) continue;
                result = (Integer)this._nonUniqueKeysData.get(indexIdx - 1).getValue();
                break;
            }
            if (result == -1) {
                result = (Integer)this._nonUniqueKeysData.get(this._nonUniqueKeysData.size() - 1).getValue();
            }
        }
        return result;
    }

    public boolean hasUniqueKeys() {
        return this._uniqueKeysData != null;
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContextTableIndex)) {
            return false;
        }
        ContextTableIndex that = (ContextTableIndex)o;
        return Objects.equals(this._name, that._name);
    }

    public int hashCode() {
        return Objects.hash(this._name);
    }
}

