/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.functions;

import com.imsweb.staging.Staging;
import com.imsweb.validation.entities.ContextTable;
import com.imsweb.validation.entities.ContextTableIndex;
import com.imsweb.validation.functions.StagingContextFunctions;
import groovy.lang.Binding;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MetafileContextFunctions
extends StagingContextFunctions {
    public static final int DT_VALID = 0x4FFFFFFF;
    public static final int DT_MISSING = 0x5FFFFFFF;
    public static final int DT_ERROR = 0x6FFFFFFF;
    public static final int DT_UNKNOWN = Integer.MAX_VALUE;
    public static final int DT_EMPTY = 0x3FFFFFFF;
    public static final int DT_DAY_EMPTY = 0x2FFFFFFF;
    public static final int DT_MONTH_EMPTY = 0x1FFFFFFF;
    public static final int SENTINEL_TRESHOLD = 0x1FFFFFFF;
    public static final int DT_MIN = 1;
    public static final int DT_MAX = 2;
    public static final int DT_EXACT = 3;
    public static final int TRIM_RIGHT = 0;
    public static final int TRIM_LEFT = 1;
    public static final int TRIM_BOTH = 2;
    public static final int JUSTIFIED_RIGHT = 0;
    public static final int JUSTIFIED_LEFT = 1;
    public static final String BINDING_KEY_FUTURE_DATE = "__years_into_future";
    public static final String BINDING_KEY_DATE_COMPONENT = "__date_component";
    private static final Pattern _GEN_VAL_P1 = Pattern.compile("(-?\\d++)(.*+)");
    private static final Pattern _GEN_VALID_DATE_IOP_P1 = Pattern.compile("(\\d{8}|\\d{6}\\s{2}|\\d{4}\\s{4})");
    private static final DateTimeFormatter _GEN_DATECMP_IOP_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final Pattern _GEN_TRIM_P1 = Pattern.compile("^\\s+");
    private static final Pattern _GEN_TRIM_P2 = Pattern.compile("\\s+$");
    private static final Pattern _GEN_TRIM_P3 = Pattern.compile("((^\\s+)|(\\s+$))");
    private static final Pattern _GEN_FMTSTR_P1 = Pattern.compile("%(.*)ld");
    private boolean _failWarnings = false;

    public MetafileContextFunctions(Staging csStaging) {
        super(csStaging, null, null);
    }

    public MetafileContextFunctions(Staging csStaging, Staging tnmStaging, Staging eodStaging) {
        super(csStaging, tnmStaging, eodStaging);
    }

    public void setFailWarnings(boolean failWarnings) {
        this._failWarnings = failWarnings;
    }

    public boolean isFailWarnings() {
        return this._failWarnings;
    }

    public void GEN_NOOP() {
    }

    public void GEN_RESET_LOCAL_CONTEXT(Binding binding) {
        binding.setVariable(BINDING_KEY_FUTURE_DATE, null);
        binding.setVariable(BINDING_KEY_DATE_COMPONENT, null);
    }

    public boolean GEN_EMPTY(Object value) {
        if (value == null) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)this.GEN_TO_STRING(value));
    }

    public int GEN_VAL(Object value) {
        int result = 0;
        String val = value == null ? "" : this.GEN_TO_STRING(value).trim();
        Matcher match = _GEN_VAL_P1.matcher(val);
        if (match.matches()) {
            result = Integer.parseInt(match.group(1));
        }
        return result;
    }

    public boolean GEN_VALID_DATE_IOP(Binding binding, Object value) {
        int month;
        int year;
        String val = this.GEN_TO_STRING(value);
        if (val == null || val.isEmpty()) {
            binding.setVariable(BINDING_KEY_DATE_COMPONENT, (Object)"date is an empty string");
            return false;
        }
        if (!_GEN_VALID_DATE_IOP_P1.matcher(val).matches()) {
            binding.setVariable(BINDING_KEY_DATE_COMPONENT, (Object)"date format must be CCYYMMDD");
            return false;
        }
        LocalDate currentTime = LocalDate.now();
        int maxYear = currentTime.getYear();
        Integer futureYears = null;
        if (binding.hasVariable(BINDING_KEY_FUTURE_DATE)) {
            futureYears = (Integer)binding.getVariable(BINDING_KEY_FUTURE_DATE);
        }
        if (futureYears != null) {
            maxYear += futureYears.intValue();
        }
        if ((year = Integer.parseInt(val.substring(0, 4))) < 1850 || year > maxYear) {
            binding.setVariable(BINDING_KEY_DATE_COMPONENT, (Object)"invalid as to year");
            return false;
        }
        int n = month = val.trim().length() >= 6 ? Integer.parseInt(val.substring(4, 6)) : 1;
        if (month <= 0 || month > 12) {
            binding.setVariable(BINDING_KEY_DATE_COMPONENT, (Object)"invalid as to month");
            return false;
        }
        try {
            int day;
            int n2 = day = val.trim().length() == 8 ? Integer.parseInt(val.substring(6, 8)) : 1;
            if (day <= 0 || day > 31) {
                binding.setVariable(BINDING_KEY_DATE_COMPONENT, (Object)"invalid as to day");
                return false;
            }
            LocalDate toCheck = LocalDate.of(year, month, day);
            int actualMaxDay = YearMonth.of(year, month).lengthOfMonth();
            if (day <= 0 || day > actualMaxDay) {
                binding.setVariable(BINDING_KEY_DATE_COMPONENT, (Object)"invalid as to day");
                return false;
            }
            if (futureYears != null) {
                currentTime = currentTime.plusYears(futureYears.intValue());
            }
            if (toCheck.compareTo(currentTime) > 0) {
                binding.setVariable(BINDING_KEY_DATE_COMPONENT, (Object)"future date");
                return false;
            }
        }
        catch (DateTimeException e) {
            binding.setVariable(BINDING_KEY_DATE_COMPONENT, (Object)"invalid as to day");
            return false;
        }
        return true;
    }

    public void GEN_ALLOW_FUTURE_DATE_IOP(Binding binding, Object yearsIntoFuture) {
        binding.setVariable(BINDING_KEY_FUTURE_DATE, yearsIntoFuture);
    }

    public int GEN_DATE_YEAR_IOP(Binding binding, Object value) {
        String val = this.GEN_TO_STRING(value);
        if (val == null || val.trim().isEmpty()) {
            return 0x3FFFFFFF;
        }
        if (!this.GEN_VALID_DATE_IOP(binding, value)) {
            return 0x6FFFFFFF;
        }
        return Integer.parseInt(val.substring(0, 4));
    }

    public int GEN_DATE_MONTH_IOP(Binding binding, Object value) {
        String val = this.GEN_TO_STRING(value);
        if (val == null || val.length() < 5 || val.length() >= 6 && val.substring(4, 6).trim().isEmpty()) {
            return 0x1FFFFFFF;
        }
        if (!this.GEN_VALID_DATE_IOP(binding, value)) {
            return 0x6FFFFFFF;
        }
        return Integer.parseInt(val.substring(4, 6));
    }

    public int GEN_DATE_DAY_IOP(Binding binding, Object value) {
        String val = this.GEN_TO_STRING(value);
        if (val == null || val.length() < 7 || val.substring(6).trim().isEmpty()) {
            return 0x2FFFFFFF;
        }
        if (!this.GEN_VALID_DATE_IOP(binding, value)) {
            return 0x6FFFFFFF;
        }
        return Integer.parseInt(val.substring(6));
    }

    public int GEN_DATECMP_IOP(Binding binding, Object value1, Object value2, Object minMaxFlagObj) {
        LocalDate date2;
        StringBuilder buf1 = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        int minMaxFlag = (Integer)minMaxFlagObj;
        if (minMaxFlag == 1 && !this.runMinFlagLogic(binding, value1, value2, minMaxFlag, value1, value2)) {
            return 0;
        }
        int result = this.applyMinMaxFlag(binding, value1, value2, minMaxFlag, buf1, buf2);
        if (result != 0) {
            return result;
        }
        LocalDate date1 = LocalDate.parse(buf1.toString(), _GEN_DATECMP_IOP_FORMAT);
        if (date1.compareTo(date2 = LocalDate.parse(buf2.toString(), _GEN_DATECMP_IOP_FORMAT)) > 0) {
            return 1;
        }
        if (date1.compareTo(date2) < 0) {
            return -1;
        }
        return 0;
    }

    public int GEN_YEARDIFF_IOP(Binding binding, String value1, String value2, Object minMaxFlagObj) {
        int dayDiff = this.GEN_DAYDIFF_IOP(binding, value1, value2, minMaxFlagObj);
        if (dayDiff > 0x1FFFFFFF) {
            return dayDiff;
        }
        return (int)Math.floor((double)dayDiff / 365.0);
    }

    public int GEN_YEARINTERNAL_IOP(Binding binding, String value1, String value2, Integer minInt, Integer maxInt, Object minMaxFlagObj) {
        return this.GEN_YEARINTERVAL_IOP(binding, value1, value2, minInt, maxInt, minMaxFlagObj);
    }

    public int GEN_YEARINTERVAL_IOP(Binding binding, String value1, String value2, Integer minInt, Integer maxInt, Object minMaxFlagObj) {
        int yearDiff = this.GEN_YEARDIFF_IOP(binding, value1, value2, minMaxFlagObj);
        if (yearDiff > 0x1FFFFFFF) {
            return yearDiff;
        }
        return yearDiff >= minInt && yearDiff <= maxInt ? 1 : 0;
    }

    public int GEN_MONTHDIFF_IOP(Binding binding, String value1, String value2, Object minMaxFlagObj) {
        int dayDiff = this.GEN_DAYDIFF_IOP(binding, value1, value2, minMaxFlagObj);
        if (dayDiff > 0x1FFFFFFF) {
            return dayDiff;
        }
        return dayDiff < 0 ? (int)Math.ceil((double)dayDiff / 30.0) : (int)Math.floor((double)dayDiff / 30.0);
    }

    public int GEN_MONTHINTERNAL_IOP(Binding binding, String value1, String value2, Integer minInt, Integer maxInt, Object minMaxFlagObj) {
        return this.GEN_MONTHINTERVAL_IOP(binding, value1, value2, minInt, maxInt, minMaxFlagObj);
    }

    public int GEN_MONTHINTERVAL_IOP(Binding binding, String value1, String value2, Integer minInt, Integer maxInt, Object minMaxFlagObj) {
        int monthDiff = this.GEN_MONTHDIFF_IOP(binding, value1, value2, minMaxFlagObj);
        if (monthDiff > 0x1FFFFFFF) {
            return monthDiff;
        }
        return monthDiff >= minInt && monthDiff <= maxInt ? 1 : 0;
    }

    public int GEN_DAYDIFF_IOP(Binding binding, String value1, String value2, Object minMaxFlagObj) {
        StringBuilder buf1 = new StringBuilder();
        StringBuilder buf2 = new StringBuilder();
        int minMaxFlag = (Integer)minMaxFlagObj;
        int result = this.applyMinMaxDayDiffFlag(binding, value1, value2, minMaxFlag, buf1, buf2);
        if (result != 0) {
            return result;
        }
        LocalDate date1 = LocalDate.parse(buf1.toString(), _GEN_DATECMP_IOP_FORMAT);
        LocalDate date2 = LocalDate.parse(buf2.toString(), _GEN_DATECMP_IOP_FORMAT);
        return (int)ChronoUnit.DAYS.between(date1, date2);
    }

    public int GEN_DAYINTERNAL_IOP(Binding binding, String value1, String value2, Integer minInt, Integer maxInt, Object minMaxFlagObj) {
        return this.GEN_DAYINTERVAL_IOP(binding, value1, value2, minInt, maxInt, minMaxFlagObj);
    }

    public int GEN_DAYINTERVAL_IOP(Binding binding, String value1, String value2, Integer minInt, Integer maxInt, Object minMaxFlagObj) {
        int dayDiff = this.GEN_DAYDIFF_IOP(binding, value1, value2, minMaxFlagObj);
        if (dayDiff > 0x1FFFFFFF) {
            return dayDiff;
        }
        return dayDiff >= minInt && dayDiff <= maxInt ? 1 : 0;
    }

    private boolean runMinFlagLogic(Binding binding, Object value1, Object value2, Object minMaxFlagObj, Object date1, Object date2) {
        String val1 = this.GEN_TO_STRING(value1);
        String val2 = this.GEN_TO_STRING(value2);
        if (val1 == null || val1.trim().isEmpty() || val2 == null || val2.trim().isEmpty()) {
            return true;
        }
        if (!this.GEN_VALID_DATE_IOP(binding, val1) || !this.GEN_VALID_DATE_IOP(binding, val2)) {
            return true;
        }
        int y1 = this.GEN_DATE_YEAR_IOP(binding, val1);
        int y2 = this.GEN_DATE_YEAR_IOP(binding, val2);
        int m1 = this.GEN_DATE_MONTH_IOP(binding, val1);
        int m2 = this.GEN_DATE_MONTH_IOP(binding, val2);
        int d1 = this.GEN_DATE_DAY_IOP(binding, val1);
        int d2 = this.GEN_DATE_DAY_IOP(binding, val2);
        if (y1 == y2 && (m1 == 0x1FFFFFFF || m2 == 0x1FFFFFFF)) {
            return false;
        }
        return y1 != y2 || m1 != m2 || d1 != 0x2FFFFFFF && d2 != 0x2FFFFFFF;
    }

    private int applyMinMaxDayDiffFlag(Binding binding, Object value1, Object value2, Object minMaxFlagObj, StringBuilder date1Buf, StringBuilder date2Buf) {
        String val1 = this.GEN_TO_STRING(value1);
        String val2 = this.GEN_TO_STRING(value2);
        if (val1 == null || val1.trim().isEmpty() || val2 == null || val2.trim().isEmpty()) {
            return 0x3FFFFFFF;
        }
        if (!this.GEN_VALID_DATE_IOP(binding, val1) || !this.GEN_VALID_DATE_IOP(binding, val2)) {
            return 0x6FFFFFFF;
        }
        int y1 = this.GEN_DATE_YEAR_IOP(binding, val1);
        int y2 = this.GEN_DATE_YEAR_IOP(binding, val2);
        int m1 = this.GEN_DATE_MONTH_IOP(binding, val1);
        int m2 = this.GEN_DATE_MONTH_IOP(binding, val2);
        int d1 = this.GEN_DATE_DAY_IOP(binding, val1);
        int d2 = this.GEN_DATE_DAY_IOP(binding, val2);
        date1Buf.append(MetafileContextFunctions.pad(String.valueOf(y1), 4, "0", true));
        date2Buf.append(MetafileContextFunctions.pad(String.valueOf(y2), 4, "0", true));
        int minMaxFlag = (Integer)minMaxFlagObj;
        int safeBeginningMonth = m1;
        if (m1 == 0x1FFFFFFF) {
            if (minMaxFlag == 1) {
                safeBeginningMonth = y1 == y2 && m2 != 0x1FFFFFFF ? m2 : (y1 < y2 ? 12 : 1);
            } else if (minMaxFlag == 2) {
                safeBeginningMonth = 1;
            } else {
                return Integer.MAX_VALUE;
            }
        }
        date1Buf.append(MetafileContextFunctions.pad(String.valueOf(safeBeginningMonth), 2, "0", true));
        int safeEndMonth = m2;
        if (m2 == 0x1FFFFFFF) {
            if (minMaxFlag == 1) {
                safeEndMonth = y1 == y2 ? safeBeginningMonth : (m1 == 0x1FFFFFFF && m2 == 0x1FFFFFFF && y1 > y2 ? 12 : (y1 > y2 ? 12 : 1));
            } else if (minMaxFlag == 2) {
                safeEndMonth = 12;
            } else {
                return Integer.MAX_VALUE;
            }
        }
        date2Buf.append(MetafileContextFunctions.pad(String.valueOf(safeEndMonth), 2, "0", true));
        int numDaysInBeginningMonth = YearMonth.of(y1, safeBeginningMonth).lengthOfMonth();
        int numDaysInEndMonth = YearMonth.of(y2, safeEndMonth).lengthOfMonth();
        int safeBeginningDay = d1;
        if (d1 == 0x2FFFFFFF) {
            if (minMaxFlag == 1) {
                safeBeginningDay = y1 == y2 && m1 != 0x1FFFFFFF && m2 != 0x1FFFFFFF && d2 != 0x2FFFFFFF ? 1 : (y1 == y2 && m1 == 0x1FFFFFFF && d2 != 0x2FFFFFFF ? d2 : (y1 < y2 ? numDaysInBeginningMonth : (y1 > y2 || m1 == 0x1FFFFFFF ? 1 : numDaysInBeginningMonth)));
            } else if (minMaxFlag == 2) {
                safeBeginningDay = 1;
            } else {
                return Integer.MAX_VALUE;
            }
        }
        date1Buf.append(MetafileContextFunctions.pad(String.valueOf(safeBeginningDay), 2, "0", true));
        int safeEndDay = d2;
        if (d2 == 0x2FFFFFFF) {
            if (minMaxFlag == 1) {
                safeEndDay = y1 == y2 && safeBeginningMonth == safeEndMonth ? safeBeginningDay : (m1 == 0x1FFFFFFF && m2 == 0x1FFFFFFF && y1 > y2 ? numDaysInEndMonth : (y1 > y2 ? numDaysInEndMonth : 1));
            } else if (minMaxFlag == 2) {
                safeEndDay = numDaysInEndMonth;
            } else {
                return Integer.MAX_VALUE;
            }
        }
        date2Buf.append(MetafileContextFunctions.pad(String.valueOf(safeEndDay), 2, "0", true));
        return 0;
    }

    private int applyMinMaxFlag(Binding binding, Object value1, Object value2, Object minMaxFlagObj, StringBuilder date1Buf, StringBuilder date2Buf) {
        String val1 = this.GEN_TO_STRING(value1);
        String val2 = this.GEN_TO_STRING(value2);
        if (val1 == null || val1.trim().isEmpty() || val2 == null || val2.trim().isEmpty()) {
            return 0x3FFFFFFF;
        }
        if (!this.GEN_VALID_DATE_IOP(binding, val1) || !this.GEN_VALID_DATE_IOP(binding, val2)) {
            return 0x6FFFFFFF;
        }
        int y1 = this.GEN_DATE_YEAR_IOP(binding, val1);
        int y2 = this.GEN_DATE_YEAR_IOP(binding, val2);
        int m1 = this.GEN_DATE_MONTH_IOP(binding, val1);
        int m2 = this.GEN_DATE_MONTH_IOP(binding, val2);
        int d1 = this.GEN_DATE_DAY_IOP(binding, val1);
        int d2 = this.GEN_DATE_DAY_IOP(binding, val2);
        date1Buf.append(MetafileContextFunctions.pad(String.valueOf(y1), 4, "0", true));
        date2Buf.append(MetafileContextFunctions.pad(String.valueOf(y2), 4, "0", true));
        int minMaxFlag = (Integer)minMaxFlagObj;
        int safeBeginningMonth = m1;
        if (m1 == 0x1FFFFFFF) {
            if (minMaxFlag == 1) {
                safeBeginningMonth = 12;
            } else if (minMaxFlag == 2) {
                safeBeginningMonth = 1;
            } else {
                return Integer.MAX_VALUE;
            }
        }
        date1Buf.append(MetafileContextFunctions.pad(String.valueOf(safeBeginningMonth), 2, "0", true));
        int safeEndMonth = m2;
        if (m2 == 0x1FFFFFFF) {
            if (minMaxFlag == 1) {
                safeEndMonth = y1 == y2 ? safeBeginningMonth : 1;
            } else if (minMaxFlag == 2) {
                safeEndMonth = 12;
            } else {
                return Integer.MAX_VALUE;
            }
        }
        date2Buf.append(MetafileContextFunctions.pad(String.valueOf(safeEndMonth), 2, "0", true));
        int numDaysInBeginningMonth = YearMonth.of(y1, safeBeginningMonth).lengthOfMonth();
        int numDaysInEndMonth = YearMonth.of(y2, safeEndMonth).lengthOfMonth();
        int safeBeginningDay = d1;
        if (d1 == 0x2FFFFFFF) {
            if (minMaxFlag == 1) {
                safeBeginningDay = numDaysInBeginningMonth;
            } else if (minMaxFlag == 2) {
                safeBeginningDay = 1;
            } else {
                return Integer.MAX_VALUE;
            }
        }
        date1Buf.append(MetafileContextFunctions.pad(String.valueOf(safeBeginningDay), 2, "0", true));
        int safeEndDay = d2;
        if (d2 == 0x2FFFFFFF) {
            if (minMaxFlag == 1) {
                safeEndDay = y1 == y2 && safeBeginningMonth == safeEndMonth ? safeBeginningDay : 1;
            } else if (minMaxFlag == 2) {
                safeEndDay = numDaysInEndMonth;
            } else {
                return Integer.MAX_VALUE;
            }
        }
        date2Buf.append(MetafileContextFunctions.pad(String.valueOf(safeEndDay), 2, "0", true));
        return 0;
    }

    public String GEN_TRIM(Object value, Object typeObj) {
        String result;
        String val = this.GEN_TO_STRING(value);
        if (val == null || val.isEmpty()) {
            return val;
        }
        int type = (Integer)typeObj;
        switch (type) {
            case 1: {
                result = _GEN_TRIM_P1.matcher(val).replaceAll("");
                break;
            }
            case 0: {
                result = _GEN_TRIM_P2.matcher(val).replaceAll("");
                if (!result.isEmpty()) break;
                result = " ";
                break;
            }
            case 2: {
                result = _GEN_TRIM_P3.matcher(val).replaceAll("");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type: " + type);
            }
        }
        return result;
    }

    public int GEN_STRLEN(Object value) {
        String val = this.GEN_TO_STRING(value);
        return val == null ? 0 : val.length();
    }

    public boolean GEN_INLIST(Object value, Object list) {
        return this.GEN_INLIST(value, list, null, null, null);
    }

    public boolean GEN_INLIST(Object value, Object list, Object regex) {
        return this.GEN_INLIST(value, list, regex, null, null);
    }

    public boolean GEN_INLIST(Object value, Object list, Object regex, Integer startPos, Integer length) {
        String val = this.GEN_TO_STRING(value);
        String l = this.GEN_TO_STRING(list);
        if (val == null || val.isEmpty() || l == null || l.isEmpty()) {
            return false;
        }
        if (regex != null && !this.GEN_MATCH(val, regex)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)l)) {
            return list.equals(val);
        }
        if (StringUtils.isBlank((CharSequence)val) && regex != null) {
            return true;
        }
        if (startPos != null && length != null) {
            int end;
            int start = startPos - 1;
            if (start >= (end = Math.min(startPos - 1 + length, val.length()))) {
                return false;
            }
            val = val.substring(start, end);
        }
        for (String term : StringUtils.split((String)StringUtils.replace((String)l, (String)" ", (String)""), (char)',')) {
            String[] parts = StringUtils.split((String)term, (char)'-');
            if (parts.length == 1 && val.equals(term) || parts.length == 2 && val.compareTo(parts[0]) >= 0 && val.compareTo(parts[1]) <= 0) {
                return true;
            }
            val = StringUtils.stripEnd((String)val, null);
            if ((parts.length != 1 || !val.equals(term)) && (parts.length != 2 || val.compareTo(parts[0]) < 0 || val.compareTo(parts[1]) > 0)) continue;
            return true;
        }
        return false;
    }

    public boolean GEN_MATCH(Object value, Object regex) {
        return this.matches(this.GEN_TO_STRING(value), this.GEN_TO_STRING(regex));
    }

    public boolean GEN_LOOKUP(Object value, Object tableObj, Object indexObj, Map<?, char[]> tableVars) {
        String val = this.GEN_TO_STRING(value);
        if (val == null || tableObj == null && indexObj == null) {
            return false;
        }
        if (tableObj instanceof ContextTable || indexObj instanceof ContextTableIndex) {
            return this.GEN_LOOKUP_V5(val, (ContextTable)tableObj, (ContextTableIndex)indexObj, tableVars);
        }
        return this.GEN_LOOKUP_V4(val, (List)tableObj, indexObj, tableVars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean GEN_LOOKUP_V4(String val, List<List<String>> table, Object indexObj, Map<Integer, char[]> tableVars) {
        String trimmedVal = MetafileContextFunctions.trimRight(val);
        boolean found = false;
        Integer valIndex = null;
        if (indexObj != null) {
            if (indexObj instanceof List) {
                for (Object elem : (List)indexObj) {
                    if (elem instanceof List) {
                        List indexAndRecNum = (List)elem;
                        if (indexAndRecNum.size() != 2) {
                            throw new IllegalStateException("List elements of indexes must be of size 2 (index value and row number)");
                        }
                        Object indexStr = indexAndRecNum.get(0);
                        if (!(indexStr instanceof String)) {
                            throw new IllegalStateException("Index values must be Strings; got " + indexStr.getClass().getSimpleName());
                        }
                        int comp = trimmedVal.compareTo((String)indexStr);
                        if (comp == 0) {
                            found = true;
                            valIndex = (Integer)indexAndRecNum.get(1);
                        } else if (comp >= 0) continue;
                    } else {
                        if (!(elem instanceof String)) throw new IllegalStateException("Index elements must be Strings or Lists; got " + elem.getClass().getSimpleName());
                        int comp = trimmedVal.compareTo((String)elem);
                        if (comp == 0) {
                            found = true;
                        } else if (comp >= 0) continue;
                    }
                    break;
                }
            } else if (indexObj instanceof Map) {
                Object rowNumObject = ((Map)indexObj).get(trimmedVal);
                if (rowNumObject != null) {
                    found = true;
                    if (!(rowNumObject instanceof Integer)) throw new IllegalStateException("Row numbers in indexes have to be Integers, got " + rowNumObject.getClass().getSimpleName());
                    valIndex = (Integer)rowNumObject;
                }
            } else {
                if (!(indexObj instanceof Set)) throw new IllegalStateException("Unsupported index type: " + indexObj.getClass().getSimpleName());
                found = ((Set)indexObj).contains(trimmedVal);
            }
        } else if (table != null) {
            for (int i = 1; i < table.size(); ++i) {
                StringBuilder buf = new StringBuilder();
                for (String cell : table.get(i)) {
                    buf.append((Object)cell);
                }
                if (!trimmedVal.equals(MetafileContextFunctions.trimRight(buf.toString()))) continue;
                found = true;
                valIndex = i;
                break;
            }
        }
        if (tableVars == null || table == null) return found;
        List<String> row = found && valIndex != null ? table.get(valIndex) : null;
        for (Map.Entry<Integer, char[]> entry : tableVars.entrySet()) {
            if (row == null) {
                this.GEN_STRCPY(entry.getValue(), "");
                continue;
            }
            if (entry.getKey() < 0 || entry.getKey() >= row.size()) continue;
            this.GEN_STRCPY(entry.getValue(), MetafileContextFunctions.trimRight(Objects.toString(row.get(entry.getKey()), "")));
        }
        return found;
    }

    private boolean GEN_LOOKUP_V5(String val, ContextTable table, ContextTableIndex index, Map<String, char[]> tableVars) {
        if (index == null) {
            return false;
        }
        int idx = index.find(MetafileContextFunctions.trimRight(val));
        if (tableVars != null && table != null) {
            List<String> row = idx != -1 ? table.getData().get(idx) : null;
            for (Map.Entry<String, char[]> entry : tableVars.entrySet()) {
                if (row == null) {
                    this.GEN_STRCPY(entry.getValue(), "");
                    continue;
                }
                int colIdx = table.getHeaders().indexOf(entry.getKey());
                if (colIdx == -1) continue;
                this.GEN_STRCPY(entry.getValue(), MetafileContextFunctions.trimRight(Objects.toString(row.get(colIdx), "")));
            }
        }
        return idx != -1;
    }

    public boolean GEN_RLOOKUP(Object value, Object tableObj, Object indexObj, Map<?, char[]> tableVars) {
        String val = this.GEN_TO_STRING(value);
        if (val == null || tableObj == null && indexObj != null) {
            return false;
        }
        if (tableObj instanceof ContextTable || indexObj instanceof ContextTableIndex) {
            return this.GEN_RLOOKUP_V5(val, (ContextTable)tableObj, (ContextTableIndex)indexObj, tableVars);
        }
        return this.GEN_RLOOKUP_V4(val, (List)tableObj, indexObj, tableVars);
    }

    public boolean GEN_RLOOKUP_V4(String val, List<List<String>> table, Object indexObj, Map<Integer, char[]> tableVars) {
        boolean found;
        Integer valIndex = null;
        if (indexObj == null) {
            return false;
        }
        if (indexObj instanceof List) {
            List indexList = (List)indexObj;
            List firstIndexAndRecNum = (List)indexList.get(0);
            if (val.compareTo((String)firstIndexAndRecNum.get(0)) >= 0) {
                List lastIndexAndRecNum;
                String indexVal;
                for (int indexIdx = 0; indexIdx < indexList.size(); ++indexIdx) {
                    List indexAndRecNum = (List)indexList.get(indexIdx);
                    String indexVal2 = (String)indexAndRecNum.get(0);
                    int comp = val.compareTo(indexVal2);
                    if (comp == 0) {
                        valIndex = (Integer)indexAndRecNum.get(1);
                        break;
                    }
                    if (comp >= 0) continue;
                    valIndex = (Integer)((List)indexList.get(indexIdx - 1)).get(1);
                    break;
                }
                if (valIndex == null && val.compareTo(indexVal = (String)(lastIndexAndRecNum = (List)indexList.get(indexList.size() - 1)).get(0)) > 0) {
                    valIndex = (Integer)lastIndexAndRecNum.get(1);
                }
            }
        } else if (indexObj instanceof TreeMap) {
            TreeMap indexTree = (TreeMap)indexObj;
            if (val.compareTo((String)indexTree.firstKey()) >= 0) {
                Map.Entry entry = indexTree.floorEntry(val);
                if (entry != null) {
                    valIndex = (Integer)entry.getValue();
                } else if (val.compareTo((String)indexTree.lastKey()) > 0) {
                    valIndex = (Integer)indexTree.lastEntry().getValue();
                }
            }
        } else {
            throw new IllegalStateException("Unsupported index type: " + indexObj.getClass().getSimpleName());
        }
        boolean bl = found = valIndex != null && valIndex >= 0;
        if (tableVars != null && table != null) {
            List<String> row = found && valIndex != null ? table.get(valIndex) : null;
            for (Map.Entry<Integer, char[]> entry : tableVars.entrySet()) {
                if (row == null) {
                    this.GEN_STRCPY(entry.getValue(), "");
                    continue;
                }
                if (entry.getKey() < 0 || entry.getKey() >= row.size()) continue;
                this.GEN_STRCPY(entry.getValue(), MetafileContextFunctions.trimRight(Objects.toString(row.get(entry.getKey()), "")));
            }
        }
        return found;
    }

    private boolean GEN_RLOOKUP_V5(String val, ContextTable table, ContextTableIndex index, Map<String, char[]> tableVars) {
        if (index == null) {
            return false;
        }
        int idx = index.findFloor(MetafileContextFunctions.trimRight(val));
        if (tableVars != null && table != null) {
            List<String> row = idx != -1 ? table.getData().get(idx) : null;
            for (Map.Entry<String, char[]> entry : tableVars.entrySet()) {
                if (row == null) {
                    this.GEN_STRCPY(entry.getValue(), "");
                    continue;
                }
                int colIdx = table.getHeaders().indexOf(entry.getKey());
                if (colIdx == -1) continue;
                this.GEN_STRCPY(entry.getValue(), MetafileContextFunctions.trimRight(Objects.toString(row.get(colIdx), "")));
            }
        }
        return idx != -1;
    }

    public boolean GEN_ILOOKUP(Object value, Object indexObj) {
        String val = this.GEN_TO_STRING(value);
        if (val == null || indexObj == null) {
            return false;
        }
        String trimmedVal = MetafileContextFunctions.trimRight(val);
        boolean found = false;
        if (indexObj instanceof List) {
            for (Object elem : (List)indexObj) {
                if (elem instanceof List) {
                    List indexAndRecNum = (List)elem;
                    if (indexAndRecNum.size() != 2) {
                        throw new IllegalStateException("List elements of indexes must be of size 2 (index value and row number)");
                    }
                    Object indexStr = indexAndRecNum.get(0);
                    if (!(indexStr instanceof String)) {
                        throw new IllegalStateException("Index values must be Strings; got " + indexStr.getClass().getSimpleName());
                    }
                    int comp = trimmedVal.compareTo((String)indexStr);
                    if (comp == 0) {
                        found = true;
                    } else if (comp >= 0) continue;
                    break;
                }
                if (elem instanceof String) {
                    int comp = trimmedVal.compareTo((String)elem);
                    if (comp == 0) {
                        found = true;
                    } else if (comp >= 0) continue;
                    break;
                }
                throw new IllegalStateException("Index elements must be Strings or Lists; got " + elem.getClass().getSimpleName());
            }
        } else if (indexObj instanceof Map) {
            found = ((Map)indexObj).containsKey(trimmedVal);
        } else if (indexObj instanceof Set) {
            found = ((Set)indexObj).contains(trimmedVal);
        } else {
            throw new IllegalStateException("Unsupported index type: " + indexObj.getClass().getSimpleName());
        }
        return found;
    }

    public boolean GEN_ILOOKUP(Object value, Object table, Object index, Map<?, char[]> tableVars) {
        return this.GEN_LOOKUP(value, table, index, tableVars);
    }

    public Integer GEN_BINLOOKUP(List<List<Integer>> table, Object indexObj) {
        if (table == null || table.isEmpty()) {
            return null;
        }
        int index = (Integer)indexObj - 1;
        int rowSize = table.get(0).size();
        int row = index / rowSize;
        int col = index % rowSize;
        if (row < 0 || row >= table.size()) {
            return 0;
        }
        List<Integer> rowData = table.get(row);
        if (col < 0 || col >= rowData.size()) {
            return 0;
        }
        return rowData.get(col);
    }

    public Integer GEN_BINLOOKUP(List<List<Integer>> table, Object rowObj, Object colObj) {
        int row = (Integer)rowObj - 1;
        int col = (Integer)colObj - 1;
        if (row < 0 || row >= table.size()) {
            return 0;
        }
        List<Integer> rowData = table.get(row);
        if (col < 0 || col >= rowData.size()) {
            return 0;
        }
        return rowData.get(col);
    }

    public boolean GEN_SQLLOOKUP(ContextTable table, ContextTableIndex index, Object value, Map<String, char[]> tableVars) {
        if (index == null) {
            return false;
        }
        int idx = index.find(this.GEN_TO_STRING(value));
        if (tableVars != null && table != null) {
            List<String> row = idx != -1 ? table.getData().get(idx) : null;
            for (Map.Entry<String, char[]> entry : tableVars.entrySet()) {
                if (row == null) {
                    this.GEN_STRCPY(entry.getValue(), "");
                    continue;
                }
                int colIdx = table.getHeaders().indexOf(entry.getKey());
                if (colIdx == -1) continue;
                this.GEN_STRCPY(entry.getValue(), MetafileContextFunctions.trimRight(Objects.toString(row.get(colIdx), "")));
            }
        }
        return idx != -1;
    }

    public boolean GEN_SQLRANGELOOKUP(ContextTable table, ContextTableIndex index, Object value, Map<String, char[]> tableVars) {
        if (index == null) {
            return false;
        }
        int idx = index.findFloor(this.GEN_TO_STRING(value));
        if (tableVars != null && table != null) {
            List<String> row = idx != -1 ? table.getData().get(idx) : null;
            for (Map.Entry<String, char[]> entry : tableVars.entrySet()) {
                if (row == null) {
                    this.GEN_STRCPY(entry.getValue(), "");
                    continue;
                }
                int colIdx = table.getHeaders().indexOf(entry.getKey());
                if (colIdx == -1) continue;
                this.GEN_STRCPY(entry.getValue(), MetafileContextFunctions.trimRight(Objects.toString(row.get(colIdx), "")));
            }
        }
        return idx != -1;
    }

    public char[] GEN_SUBSTR(Object value, Integer start) {
        if (value == null) {
            return new char[0];
        }
        String str = this.GEN_TO_STRING(value);
        if (str.length() >= start) {
            str = MetafileContextFunctions.trimRight(str.substring(start - 1));
        }
        return str == null ? new char[]{} : str.toCharArray();
    }

    public char[] GEN_SUBSTR(Object value, Integer start, Integer length) {
        if (value == null) {
            return new char[0];
        }
        String str = this.GEN_TO_STRING(value);
        if (str.length() >= start && (str = str.substring(start - 1)).length() > length) {
            str = str.substring(0, length);
        }
        return str.toCharArray();
    }

    public void GEN_STRCPY(char[] target, Object value) {
        this.GEN_STRCPY(target, value, value == null ? 0 : this.GEN_TO_STRING(value).length());
    }

    public void GEN_STRCPY(char[] target, Object value, Integer num) {
        int i;
        if (value == null) {
            return;
        }
        String val = this.GEN_TO_STRING(value);
        boolean pad = false;
        if (num < 0) {
            num = num * -1;
            pad = true;
        }
        for (i = 0; i < num && i < val.length() && i < target.length; ++i) {
            target[i] = val.charAt(i);
        }
        if (pad) {
            for (i = val.length(); i < num && i < target.length; ++i) {
                target[i] = 32;
            }
        }
        if (num < target.length) {
            target[num.intValue()] = '\u0000';
        }
    }

    public char[] GEN_STRCAT(char[] target, Object value) {
        return this.GEN_STRCAT(target, value, value == null ? 0 : this.GEN_TO_STRING(value).length());
    }

    public char[] GEN_STRCAT(char[] target, Object value, Integer num) {
        if (value == null || num <= 0) {
            return target;
        }
        String val = this.GEN_TO_STRING(value);
        int idx = -1;
        for (idx = 0; idx < target.length && target[idx] != '\u0000'; ++idx) {
        }
        for (int i = 0; i < num && i < val.length() && idx < target.length; ++i) {
            target[idx++] = val.charAt(i);
        }
        if (idx < target.length) {
            target[idx] = '\u0000';
        }
        return target;
    }

    public int GEN_STRCMP(Object value1, Object value2) {
        return this.GEN_STRCMP(value1, value2, null);
    }

    public int GEN_STRCMP(Object value1, Object value2, Integer length) {
        int comp;
        if (value1 == null || value2 == null) {
            return -1;
        }
        String s1 = this.GEN_TO_STRING(value1);
        String s2 = this.GEN_TO_STRING(value2);
        if (length != null) {
            s1 = this.GEN_TO_STRING(this.GEN_SUBSTR(value1, 1, length));
            s2 = this.GEN_TO_STRING(this.GEN_SUBSTR(value2, 1, length));
        }
        if ((comp = s1.compareTo(s2)) < 0) {
            return -1;
        }
        if (comp > 0) {
            return 1;
        }
        return 0;
    }

    public void GEN_FMTSTR(char[] target, Object format, Object value) {
        if (target == null || format == null || value == null) {
            return;
        }
        this.GEN_STRCPY(target, String.format(_GEN_FMTSTR_P1.matcher(this.GEN_TO_STRING(format)).replaceAll("%$1d"), value));
    }

    public int GEN_AT(Object value, Object text) {
        return this.GEN_AT(value, text, 1);
    }

    public int GEN_AT(Object value, Object text, Integer width) {
        int i;
        int w;
        if (value == null || text == null) {
            return 0;
        }
        String val = this.GEN_TO_STRING(value);
        String txt = this.GEN_TO_STRING(text);
        if (val.isEmpty() || txt.isEmpty()) {
            return 0;
        }
        int n = w = width == null ? 1 : Math.max(1, width);
        if (w == 1) {
            return txt.indexOf(val) + 1;
        }
        int loopCounter = 1;
        for (i = w; i < txt.length(); i += w) {
            if (txt.substring(i - w, i).indexOf(val) > -1) {
                return loopCounter;
            }
            ++loopCounter;
        }
        if (i - w < txt.length() && txt.substring(i - w, Math.min(i, txt.length())).indexOf(val) > -1) {
            return loopCounter;
        }
        return 0;
    }

    public boolean GEN_JUSTIFIED(Object value, Object justifiedObj) {
        String val = this.GEN_TO_STRING(value);
        int justified = (Integer)justifiedObj;
        if (justified == 1) {
            return val != null && val.length() > 0 && val.charAt(0) != ' ';
        }
        if (justified == 0) {
            return val != null && val.length() > 0 && value.toString().charAt(val.length() - 1) != ' ';
        }
        throw new IllegalStateException("Bad parameter to GEN_JUSTIFIED: " + justified);
    }

    public char[] GEN_RIGHT(Object value, Integer numChars) {
        String val = this.GEN_TO_STRING(value);
        if (val == null) {
            return new char[0];
        }
        if (val.length() <= numChars) {
            return val.toCharArray();
        }
        return val.substring(val.length() - numChars).toCharArray();
    }

    public char[] GEN_LEFT(Object value, Integer numChars) {
        String val = this.GEN_TO_STRING(value);
        if (val == null) {
            return new char[0];
        }
        if (val.length() <= numChars) {
            return val.toCharArray();
        }
        return val.substring(0, numChars).toCharArray();
    }

    public char[] GEN_LOWER(Object value) {
        String val = this.GEN_TO_STRING(value);
        if (val == null) {
            return new char[0];
        }
        return val.toLowerCase().toCharArray();
    }

    public char[] GEN_UPPER(Object value) {
        String val = this.GEN_TO_STRING(value);
        if (val == null) {
            return new char[0];
        }
        return val.toUpperCase().toCharArray();
    }

    public boolean GEN_ERROR_TEXT(Binding binding, Object obj) {
        String text = this.GEN_TO_STRING(obj);
        if (text != null) {
            text = MetafileContextFunctions.trimRight(text);
        }
        if (binding.hasVariable(BINDING_KEY_DATE_COMPONENT)) {
            String dateComp = (String)binding.getVariable(BINDING_KEY_DATE_COMPONENT);
            if (text != null && text.contains("%DC") && dateComp != null) {
                text = text.replace("%DC", dateComp);
            }
        }
        binding.setVariable("__error_message", (Object)text);
        return false;
    }

    public boolean GEN_ERROR_MSG(Binding binding, Object obj) {
        return this.GEN_ERROR_TEXT(binding, obj);
    }

    public boolean GEN_SAVE_TEXT(Binding binding, Object text) {
        if (text == null) {
            return false;
        }
        ArrayList<String> extraErrorMsgs = (ArrayList<String>)binding.getVariable("__information_messages");
        if (extraErrorMsgs == null) {
            extraErrorMsgs = new ArrayList<String>();
            binding.setVariable("__information_messages", extraErrorMsgs);
        }
        extraErrorMsgs.add(MetafileContextFunctions.trimRight(this.GEN_TO_STRING(text)));
        binding.setVariable("__failing_flag", (Object)Boolean.TRUE);
        return false;
    }

    public boolean GEN_SAVE_ERROR_TEXT(Binding binding, Object ... texts) {
        ArrayList<String> extraErrorMsgs = (ArrayList<String>)binding.getVariable("__information_messages");
        if (extraErrorMsgs == null) {
            extraErrorMsgs = new ArrayList<String>();
            binding.setVariable("__information_messages", extraErrorMsgs);
        }
        for (Object text : texts) {
            if (text == null) continue;
            extraErrorMsgs.add(MetafileContextFunctions.trimRight(this.GEN_TO_STRING(text)));
        }
        binding.setVariable("__failing_flag", (Object)Boolean.TRUE);
        return false;
    }

    public boolean GEN_SAVE_WARNING_TEXT(Binding binding, Object ... texts) {
        if (this._failWarnings) {
            return this.GEN_SAVE_ERROR_TEXT(binding, texts);
        }
        return true;
    }

    public boolean GEN_SET_WARNING(Binding binding, Object ... texts) {
        if (this._failWarnings) {
            return this.GEN_SET_ERROR(binding, texts);
        }
        return true;
    }

    public boolean GEN_SET_ERROR(Binding binding, Object ... texts) {
        ArrayList<String> extraErrorMsgs = (ArrayList<String>)binding.getVariable("__extra_error_messages");
        if (extraErrorMsgs == null) {
            extraErrorMsgs = new ArrayList<String>();
            binding.setVariable("__extra_error_messages", extraErrorMsgs);
        }
        for (Object text : texts) {
            if (text == null) continue;
            extraErrorMsgs.add(MetafileContextFunctions.trimRight(this.GEN_TO_STRING(text)));
        }
        binding.setVariable("__failing_flag", (Object)Boolean.TRUE);
        return false;
    }

    public boolean GEN_USR2(Object ... params) {
        if (params.length > 0 && params[0] instanceof Binding) {
            String msg;
            Binding binding = (Binding)params[0];
            binding.setVariable("__failing_flag", (Object)Boolean.TRUE);
            if (params.length > 1 && (msg = this.GEN_TO_STRING(params[1])) != null && !msg.matches("\\d+")) {
                ArrayList<String> extraErrorMsgs = (ArrayList<String>)binding.getVariable("__extra_error_messages");
                if (extraErrorMsgs == null) {
                    extraErrorMsgs = new ArrayList<String>();
                    binding.setVariable("__extra_error_messages", extraErrorMsgs);
                }
                extraErrorMsgs.add(MetafileContextFunctions.trimRight(msg));
            }
        }
        return false;
    }

    public boolean GEN_USR4(Object ... params) {
        return true;
    }

    public boolean GEN_GETFIELD(Object ... params) {
        throw new IllegalStateException("GEN_GETFIELD method is currently not supported!");
    }

    public boolean GEN_PUTFIELD(Object ... params) {
        throw new IllegalStateException("GEN_PUTFIELD method is currently not supported!");
    }

    public boolean GEN_GETVAR(Object ... params) {
        throw new IllegalStateException("GEN_GETVAR method is currently not supported!");
    }

    public boolean GEN_SETVAR(Object ... params) {
        throw new IllegalStateException("GEN_PUTFIELD method is currently not supported!");
    }

    public boolean GEN_NAMEEXPR(Object ... params) {
        throw new IllegalStateException("GEN_NAMEEXPR method is currently not supported!");
    }

    public int GEN_EXTERNALDLL(String dll, String method) {
        return this.GEN_EXTERNALDLL(dll, method, null, null, null, null, null);
    }

    public int GEN_EXTERNALDLL(String dll, String method, Object param1) {
        return this.GEN_EXTERNALDLL(dll, method, param1, null, null, null, null);
    }

    public int GEN_EXTERNALDLL(String dll, String method, Object param1, Object param2) {
        return this.GEN_EXTERNALDLL(dll, method, param1, param2, null, null, null);
    }

    public int GEN_EXTERNALDLL(String dll, String method, Object param1, Object param2, Object param3) {
        return this.GEN_EXTERNALDLL(dll, method, param1, param2, param3, null, null);
    }

    public int GEN_EXTERNALDLL(String dll, String method, Object param1, Object param2, Object param3, Object param4) {
        return this.GEN_EXTERNALDLL(dll, method, param1, param2, param3, param4, null);
    }

    public int GEN_EXTERNALDLL(String dll, String method, Object param1, Object param2, Object param3, Object param4, Object param5) {
        if (!"Cstage.dll".equalsIgnoreCase(dll) && !"Cstage0205.dll".equalsIgnoreCase(dll)) {
            throw new IllegalStateException("Only cstage.dll and cstage0205.dll are currently supported!");
        }
        if ("CStage_get_version".equalsIgnoreCase(method)) {
            this.GEN_STRCPY((char[])param1, this.getCsVersion());
        } else {
            if ("CStage_get_number_of_schemas".equalsIgnoreCase(method)) {
                return this.getCsNumSchemas();
            }
            if ("CStage_get_schema_number".equalsIgnoreCase(method)) {
                String site = this.GEN_TO_STRING(param1);
                String hist = this.GEN_TO_STRING(param2);
                if (site == null || site.trim().isEmpty() || hist == null || hist.trim().isEmpty()) {
                    return -1;
                }
                HashMap<String, String> input = new HashMap<String, String>();
                input.put("primarySite", site);
                input.put("histologicTypeIcdO3", hist);
                input.put("csSiteSpecificFactor25", this.GEN_TO_STRING(param3));
                return this.getCsSchemaNumber(input);
            }
            if ("CStage_get_schema_name".equalsIgnoreCase(method)) {
                this.GEN_STRCPY((char[])param2, this.GEN_TRIM(this.getCsSchemaName((Integer)param1), 0));
            } else {
                if ("CStage_code_is_valid".equalsIgnoreCase(method)) {
                    Integer schemaNumber = (Integer)param1;
                    Integer tableNumber = (Integer)param2;
                    String valueToCheck = this.GEN_TO_STRING(param4);
                    return this.isAcceptableCsCode(schemaNumber, tableNumber, valueToCheck) ? 1 : 0;
                }
                throw new IllegalStateException("Unsupported method: " + method);
            }
        }
        return 0;
    }

    public String GEN_TO_STRING(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof char[]) {
            char[] array = (char[])obj;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < array.length && array[i] != '\u0000'; ++i) {
                buf.append(array[i]);
            }
            return buf.toString();
        }
        return obj.toString();
    }

    public String GEN_DT_TODAY() {
        StringBuilder buf = new StringBuilder();
        LocalDate now = LocalDate.now();
        buf.append(now.getYear());
        buf.append(MetafileContextFunctions.pad(String.valueOf(now.getMonthValue()), 2, "0", true));
        buf.append(MetafileContextFunctions.pad(String.valueOf(now.getDayOfMonth()), 2, "0", true));
        return buf.toString();
    }

    private static String pad(String value, int length, String with, boolean leftPad) {
        if (value == null || value.length() >= length) {
            return value;
        }
        StringBuilder builder = new StringBuilder(value);
        while (builder.length() < length) {
            if (leftPad) {
                builder.insert(0, with);
                continue;
            }
            builder.append(with);
        }
        return builder.toString();
    }

    private static String trimRight(String value) {
        int end;
        if (value == null || value.isEmpty()) {
            return value;
        }
        char[] val = value.toCharArray();
        for (end = val.length; end > 0 && val[end - 1] <= ' '; --end) {
        }
        return value.substring(0, end);
    }

    public boolean GEN_WARNING_RESULT() {
        return !this._failWarnings;
    }
}

