/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.internal;

import com.imsweb.validation.ValidatingContext;
import com.imsweb.validation.ValidationException;
import com.imsweb.validation.entities.RuleFailure;
import com.imsweb.validation.entities.Validatable;
import com.imsweb.validation.internal.Processor;
import java.util.ArrayList;
import java.util.Collection;

public class IterativeProcessor
implements Processor {
    private final String _collectionName;
    private final Processor _processor;

    public IterativeProcessor(Processor processor, String collectionName) {
        if (processor == null) {
            throw new IllegalStateException("Cannot create an iterative processor from a null processor!");
        }
        if (collectionName == null) {
            throw new IllegalStateException("Cannot create an iterative processor from a null collection name!");
        }
        this._processor = processor;
        this._collectionName = collectionName;
    }

    @Override
    public Collection<RuleFailure> process(Validatable validatable, ValidatingContext procCtx) throws ValidationException {
        ArrayList<RuleFailure> results = new ArrayList<RuleFailure>();
        try {
            for (Validatable childValidatable : validatable.followCollection(this._collectionName)) {
                results.addAll(this._processor.process(childValidatable, procCtx));
            }
        }
        catch (IllegalAccessException e) {
            throw new ValidationException(e);
        }
        return results;
    }
}

