/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.internal.callable;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.ValidationXmlUtils;
import com.imsweb.validation.entities.Rule;
import com.imsweb.validation.entities.RuleHistory;
import com.imsweb.validation.entities.Validator;
import com.imsweb.validation.entities.ValidatorVersion;
import com.imsweb.validation.entities.xml.HistoryEventXmlDto;
import com.imsweb.validation.entities.xml.RuleXmlDto;
import com.imsweb.validation.runtime.ParsedContexts;
import com.imsweb.validation.runtime.ParsedLookups;
import com.imsweb.validation.runtime.ParsedProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;

public class RuleParsingCallable
implements Callable<Void> {
    private RuleXmlDto _xmlRule;
    private Long _ruleId;
    private Validator _validator;
    private Map<String, ValidatorVersion> _versions;
    private Map<String, Rule> _rules;
    private ParsedProperties _parsedProperties;
    private ParsedContexts _parsedContexts;
    private ParsedLookups _parsedLookups;

    public RuleParsingCallable(RuleXmlDto xmlRule, Long ruleId, Validator validator, Map<String, ValidatorVersion> versions, Map<String, Rule> rules, ParsedProperties props, ParsedContexts contexts, ParsedLookups lkups) {
        this._xmlRule = xmlRule;
        this._ruleId = ruleId;
        this._validator = validator;
        this._versions = versions;
        this._rules = rules;
        this._parsedProperties = props;
        this._parsedContexts = contexts;
        this._parsedLookups = lkups;
    }

    @Override
    public Void call() throws Exception {
        Rule rule = new Rule();
        rule.setRuleId(this._ruleId);
        rule.setValidator(this._validator);
        if (this._xmlRule.getId() == null) {
            throw new IOException("Rule ID is required");
        }
        rule.setId(this._xmlRule.getId().trim());
        if (this._xmlRule.getName() != null) {
            rule.setName(this._xmlRule.getName().trim());
        }
        rule.setTag(this._xmlRule.getTag());
        if (this._xmlRule.getJavaPath() == null) {
            throw new IOException("Unable to load " + this._xmlRule.getId() + " in " + this._validator.getId() + "; java-path is missing");
        }
        rule.setJavaPath(this._xmlRule.getJavaPath());
        rule.setCategory(this._xmlRule.getCategory());
        if (rule.getCategory() != null && this._validator.getCategory(rule.getCategory()) == null) {
            throw new IOException("Unknown category '" + this._xmlRule.getCategory() + "' defined for " + this._xmlRule.getId() + " in " + this._validator.getId());
        }
        if (this._xmlRule.getCondition() != null) {
            boolean useAnds = this._xmlRule.getCondition().indexOf(38) != -1;
            HashSet<String> conditions = new HashSet<String>();
            for (String s : Arrays.asList(StringUtils.split((String)this._xmlRule.getCondition(), (char)(useAnds ? (char)'&' : '|')))) {
                conditions.add(s.trim());
            }
            for (String condition : conditions) {
                if (this._validator.getCondition(condition) != null) continue;
                throw new IOException("Unknown condition '" + condition + "' defined for " + this._xmlRule.getId() + " in " + this._validator.getId());
            }
            rule.setConditions(conditions);
            rule.setUseAndForConditions(useAnds);
        }
        rule.setSeverity(this._xmlRule.getSeverity());
        rule.setAgency(this._xmlRule.getAgency());
        if (this._xmlRule.getExpression() == null) {
            throw new IOException("Unable to load '" + rule.getId() + "' in " + this._validator.getId() + "; no expression provided");
        }
        try {
            rule.setExpression(ValidationXmlUtils.reAlign(this._xmlRule.getExpression()), this._parsedProperties, this._parsedContexts, this._parsedLookups);
        }
        catch (ConstructionException e) {
            throw new IOException("Unable to load '" + rule.getId() + "' in " + this._validator.getId() + "; it contain an invalid expression", e);
        }
        if (this._xmlRule.getMessage() == null) {
            throw new IOException("Unable to load '" + rule.getId() + "' in " + this._validator.getId() + "; no message provided");
        }
        rule.setMessage(ValidationXmlUtils.trimEmptyLines(this._xmlRule.getMessage(), true));
        if (this._xmlRule.getDepends() != null && !this._xmlRule.getDepends().isEmpty()) {
            HashSet<String> dependencies = new HashSet<String>();
            for (String s : StringUtils.split((String)this._xmlRule.getDepends(), (char)',')) {
                if (s == null) continue;
                dependencies.add(s.trim());
            }
            rule.setDependencies(dependencies);
        }
        if (this._xmlRule.getDescription() != null) {
            rule.setDescription(ValidationXmlUtils.reAlign(this._xmlRule.getDescription()));
        }
        if (this._xmlRule.getHistoryEvents() != null && !this._xmlRule.getHistoryEvents().isEmpty()) {
            HashSet<RuleHistory> history = new HashSet<RuleHistory>();
            for (HistoryEventXmlDto event : this._xmlRule.getHistoryEvents()) {
                if (event.getValue() == null) continue;
                RuleHistory rh = new RuleHistory();
                rh.setRuleHistoryId(ValidationServices.getInstance().getNextRuleHistorySequence());
                rh.setRule(rule);
                if (event.getVersion() == null) {
                    throw new IOException("Unable to load '" + rule.getId() + "' in " + this._validator.getId() + "; no version provided in history entry");
                }
                ValidatorVersion version = this._versions.get(event.getVersion());
                if (version == null) {
                    throw new IOException("Unable to load '" + rule.getId() + "' in " + this._validator.getId() + "; history entry references unknown version: " + event.getVersion());
                }
                rh.setVersion(version);
                if (event.getUser() == null) {
                    throw new IOException("Unable to load '" + rule.getId() + "' in " + this._validator.getId() + "; no user provided in history entry");
                }
                rh.setUsername(event.getUser().trim());
                if (event.getDate() == null) {
                    throw new IOException("Unable to load '" + rule.getId() + "' in " + this._validator.getId() + "; no date provided in history entry");
                }
                rh.setDate(event.getDate());
                rh.setReference(event.getRef());
                if (event.getValue() == null) {
                    throw new IOException("Unable to load '" + rule.getId() + "' in " + this._validator.getId() + "; no content provided in history entry");
                }
                rh.setMessage(ValidationXmlUtils.trimEmptyLines(event.getValue(), true));
                history.add(rh);
            }
            rule.setHistories(history);
        }
        this._rules.put(rule.getId(), rule);
        return null;
    }
}

