/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.EngineStats;
import com.imsweb.validation.InitializationOptions;
import com.imsweb.validation.InitializationStats;
import com.imsweb.validation.ValidatingContext;
import com.imsweb.validation.ValidationException;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.Category;
import com.imsweb.validation.entities.Condition;
import com.imsweb.validation.entities.ContextEntry;
import com.imsweb.validation.entities.EditableCondition;
import com.imsweb.validation.entities.EditableRule;
import com.imsweb.validation.entities.EditableValidator;
import com.imsweb.validation.entities.EmbeddedSet;
import com.imsweb.validation.entities.Rule;
import com.imsweb.validation.entities.RuleFailure;
import com.imsweb.validation.entities.RuleHistory;
import com.imsweb.validation.entities.Validatable;
import com.imsweb.validation.entities.Validator;
import com.imsweb.validation.entities.ValidatorRelease;
import com.imsweb.validation.internal.ExecutableCondition;
import com.imsweb.validation.internal.ExecutableRule;
import com.imsweb.validation.internal.IterativeProcessor;
import com.imsweb.validation.internal.Processor;
import com.imsweb.validation.internal.ValidatingProcessor;
import com.imsweb.validation.internal.callable.RuleCompilingCallable;
import com.imsweb.validation.runtime.CompiledRules;
import com.imsweb.validation.runtime.RuntimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ValidationEngine {
    private static final String _ENGINE_VERSION = "6.8";
    public static final String CONTEXT_TYPE_GROOVY = "groovy";
    public static final String CONTEXT_TYPE_JAVA = "java";
    public static final String CONTEXT_TYPE_TABLE = "table";
    public static final String CONTEXT_TYPE_TABLE_INDEX_DEF = "table-index-def";
    public static final String VALIDATOR_FUNCTIONS_KEY = "Functions";
    public static final String VALIDATOR_CONTEXT_KEY = "Context";
    public static final String VALIDATOR_TESTING_FUNCTIONS_KEY = "Testing";
    public static final String VALIDATOR_FORCE_FAILURE_ENTITY_KEY = "__force_failure_on_entity_key";
    public static final String VALIDATOR_FORCE_FAILURE_PROPERTY_KEY = "__force_failure_on_property_key";
    public static final String VALIDATOR_IGNORE_FAILURE_PROPERTY_KEY = "__ignore_failure_on_property_key";
    public static final String VALIDATOR_ERROR_MESSAGE = "__error_message";
    public static final String VALIDATOR_EXTRA_ERROR_MESSAGES = "__extra_error_messages";
    public static final String VALIDATOR_INFORMATION_MESSAGES = "__information_messages";
    public static final String VALIDATOR_FAILING_FLAG = "__failing_flag";
    public static final String VALIDATOR_ORIGINAL_RESULT = "__original_result";
    public static final String EXCEPTION_MSG = "Edit failed with exception.";
    public static final String NO_MESSAGE_DEFINED_MSG = "No default error message defined.";
    private static final ValidationEngine _INSTANCE = new ValidationEngine();
    protected Map<String, Validator> _validators = new HashMap<String, Validator>();
    protected Map<String, ValidatingProcessor> _processors = new HashMap<String, ValidatingProcessor>();
    protected Map<String, AtomicInteger> _processorRoots = new HashMap<String, AtomicInteger>();
    protected Map<Long, ExecutableRule> _executableRules = new HashMap<Long, ExecutableRule>();
    protected Map<Long, ExecutableCondition> _executableConditions = new HashMap<Long, ExecutableCondition>();
    protected Map<Long, Map<String, Object>> _contexts = new HashMap<Long, Map<String, Object>>();
    private ValidationEngineStatus _status = ValidationEngineStatus.NOT_INITIALIZED;
    protected InitializationOptions _options;
    private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    protected Map<String, EngineStats> _editsStats = new HashMap<String, EngineStats>();
    protected boolean _computeEditsStats = false;
    private final ReentrantReadWriteLock _statsLock = new ReentrantReadWriteLock();

    public static ValidationEngine getInstance() {
        return _INSTANCE;
    }

    public boolean isInitialized() {
        return this._status == ValidationEngineStatus.INITIALIZED;
    }

    public void initialize() {
        try {
            this.initialize(new InitializationOptions(), Collections.emptyList());
        }
        catch (ConstructionException e) {
            throw new IllegalStateException(e);
        }
    }

    public InitializationStats initialize(InitializationOptions options) {
        try {
            return this.initialize(options, Collections.emptyList());
        }
        catch (ConstructionException e) {
            throw new IllegalStateException(e);
        }
    }

    public InitializationStats initialize(Validator validator) throws ConstructionException {
        return this.initialize(new InitializationOptions(), Collections.singletonList(validator));
    }

    public InitializationStats initialize(InitializationOptions options, Validator validator) throws ConstructionException {
        return this.initialize(options, Collections.singletonList(validator));
    }

    public InitializationStats initialize(List<Validator> validators) throws ConstructionException {
        return this.initialize(new InitializationOptions(), validators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitializationStats initialize(InitializationOptions options, List<Validator> validators) throws ConstructionException {
        this._status = ValidationEngineStatus.INITIALIZING;
        InitializationStats stats = new InitializationStats();
        long start = System.currentTimeMillis();
        this._lock.writeLock().lock();
        try {
            this.uninitialize();
            this._options = options == null ? new InitializationOptions() : options;
            this._computeEditsStats = this._options.isEngineStatsEnabled();
            if (validators != null) {
                this.checkValidatorConstraints(validators);
                ConcurrentHashMap<Long, ExecutableRule> rules = new ConcurrentHashMap<Long, ExecutableRule>();
                ConcurrentHashMap<Long, ExecutableCondition> conditions = new ConcurrentHashMap<Long, ExecutableCondition>();
                ConcurrentHashMap<Long, HashMap<String, Object>> allContexts = new ConcurrentHashMap<Long, HashMap<String, Object>>();
                for (Validator v : validators) {
                    HashMap<String, Object> contexts = new HashMap<String, Object>();
                    this.internalizeValidator(v, conditions, rules, contexts, stats);
                    allContexts.put(v.getValidatorId(), contexts);
                }
                List<ExecutableRule> sortedRules = this.getRulesSortedByDependencies(rules, conditions);
                this._executableConditions.putAll(conditions);
                this._executableRules.putAll(rules);
                this._contexts.putAll(allContexts);
                this.populateProcessors(sortedRules);
                for (Validator v : validators) {
                    this._validators.put(v.getId(), v);
                }
            } else {
                this.populateProcessors(null);
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
        this._status = ValidationEngineStatus.INITIALIZED;
        stats.setInitializationDuration(System.currentTimeMillis() - start);
        return stats;
    }

    public void uninitialize() {
        this._status = ValidationEngineStatus.NOT_INITIALIZED;
        this._lock.writeLock().lock();
        try {
            this._validators.clear();
            this._processors.clear();
            this._processorRoots.clear();
            this._executableRules.clear();
            this._executableConditions.clear();
            this._contexts.clear();
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public Map<String, Validator> getValidators() {
        this._lock.readLock().lock();
        try {
            Map<String, Validator> map = Collections.unmodifiableMap(this._validators);
            return map;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Validator getValidator(String validatorId) {
        if (validatorId == null) {
            return null;
        }
        this._lock.readLock().lock();
        try {
            Validator validator = this._validators.get(validatorId);
            return validator;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Condition getCondition(String conditionId) {
        return this.getCondition(conditionId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Condition getCondition(String conditionId, String validatorId) {
        if (conditionId == null) {
            return null;
        }
        this._lock.readLock().lock();
        try {
            if (validatorId != null) {
                Validator v = this._validators.get(validatorId);
                if (v == null) {
                    Condition condition = null;
                    return condition;
                }
                Condition condition = v.getCondition(conditionId);
                return condition;
            }
            for (Validator v : this._validators.values()) {
                Condition c = v.getCondition(conditionId);
                if (c == null) continue;
                Condition condition = c;
                return condition;
            }
            Iterator<Validator> iterator = null;
            return iterator;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Category getCategory(String categoryId) {
        return this.getCategory(categoryId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category getCategory(String categoryId, String validatorId) {
        if (categoryId == null) {
            return null;
        }
        this._lock.readLock().lock();
        try {
            if (validatorId != null) {
                Validator v = this._validators.get(validatorId);
                if (v == null) {
                    Category category = null;
                    return category;
                }
                Category category = v.getCategory(categoryId);
                return category;
            }
            for (Validator v : this._validators.values()) {
                Category c = v.getCategory(categoryId);
                if (c == null) continue;
                Category category = c;
                return category;
            }
            Iterator<Validator> iterator = null;
            return iterator;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Rule getRule(String ruleId) {
        return this.getRule(ruleId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rule getRule(String ruleId, String validatorId) {
        if (ruleId == null) {
            return null;
        }
        this._lock.readLock().lock();
        try {
            if (validatorId != null) {
                Validator v = this._validators.get(validatorId);
                if (v == null) {
                    Rule rule = null;
                    return rule;
                }
                Rule rule = v.getRule(ruleId);
                return rule;
            }
            for (Validator v : this._validators.values()) {
                Rule r = v.getRule(ruleId);
                if (r == null) continue;
                Rule rule = r;
                return rule;
            }
            Iterator<Validator> iterator = null;
            return iterator;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Object getContext(String contextKey) {
        return this.getContext(contextKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContext(String contextKey, String validatorId) {
        if (contextKey == null) {
            return null;
        }
        this._lock.readLock().lock();
        try {
            if (validatorId != null) {
                Validator v = this._validators.get(validatorId);
                if (v == null) {
                    Object var4_5 = null;
                    return var4_5;
                }
                Object object = this._contexts.get(v.getValidatorId()).get(contextKey);
                return object;
            }
            for (Map<String, Object> context : this._contexts.values()) {
                Object c = context.get(contextKey);
                if (c == null) continue;
                Object object = c;
                return object;
            }
            Iterator<Map<String, Object>> iterator = null;
            return iterator;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RuleFailure> validate(Validatable validatable) throws ValidationException {
        this._lock.readLock().lock();
        try {
            ValidatingContext vContext = new ValidatingContext();
            vContext.setComputeEditsStats(this._computeEditsStats);
            Collection<RuleFailure> collection = this.internalValidate(validatable, vContext);
            return collection;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RuleFailure> validate(Validatable validatable, Collection<String> ruleIdsToIgnore) throws ValidationException {
        this._lock.readLock().lock();
        try {
            ValidatingContext vContext = new ValidatingContext();
            vContext.setToIgnore(ruleIdsToIgnore);
            vContext.setComputeEditsStats(this._computeEditsStats);
            Collection<RuleFailure> collection = this.internalValidate(validatable, vContext);
            return collection;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RuleFailure> validate(Validatable validatable, Collection<String> ruleIdsToIgnore, Collection<String> ruleIdsToExecute) throws ValidationException {
        this._lock.readLock().lock();
        try {
            ValidatingContext vContext = new ValidatingContext();
            vContext.setToIgnore(ruleIdsToIgnore);
            vContext.setToExecute(ruleIdsToExecute);
            vContext.setComputeEditsStats(this._computeEditsStats);
            Collection<RuleFailure> collection = this.internalValidate(validatable, vContext);
            return collection;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RuleFailure> validate(Validatable validatable, String ruleId) throws ValidationException {
        this._lock.readLock().lock();
        try {
            Rule rule = this.getRule(ruleId);
            if (rule == null) {
                throw new IllegalStateException("Unknown rule ID: " + ruleId);
            }
            ValidatingContext vContext = new ValidatingContext();
            vContext.setToForce(rule);
            vContext.setComputeEditsStats(this._computeEditsStats);
            Collection<RuleFailure> collection = this.internalValidate(validatable, vContext);
            return collection;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RuleFailure> validate(Validatable validatable, Rule rule) throws ValidationException {
        this._lock.readLock().lock();
        try {
            if (rule == null) {
                throw new IllegalStateException("This method requires a non-null rule!");
            }
            if (rule.getJavaPath() == null) {
                throw new IllegalStateException("The provided rule must have a java-path!");
            }
            ValidatingContext vContext = new ValidatingContext();
            vContext.setToForce(rule);
            vContext.setComputeEditsStats(this._computeEditsStats);
            Collection<RuleFailure> collection = this.internalValidate(validatable, vContext);
            return collection;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RuleFailure> validate(Validatable validatable, ValidatingContext vContext) throws ValidationException {
        this._lock.readLock().lock();
        try {
            vContext.setComputeEditsStats(this._computeEditsStats);
            Collection<RuleFailure> collection = this.internalValidate(validatable, vContext);
            return collection;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rule addRule(EditableRule editableRule) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Category category;
            if (editableRule == null) {
                throw new ConstructionException("An editable rule is required for adding a new edit");
            }
            if (editableRule.getId() == null) {
                throw new ConstructionException("An edit ID is required when adding a new edit");
            }
            if (editableRule.getJavaPath() == null) {
                throw new ConstructionException("A java-path is required when adding a new edit");
            }
            if (editableRule.getValidatorId() == null) {
                throw new ConstructionException("A group is required when adding a new edit");
            }
            if (editableRule.getMessage() == null) {
                throw new ConstructionException("A message is required when adding a new edit");
            }
            if (this.getRule(editableRule.getId()) != null) {
                throw new ConstructionException("Edit IDs must be unique within the edits engine, cannot add '" + editableRule.getId() + "'");
            }
            if (!this._validators.containsKey(editableRule.getValidatorId())) {
                throw new ConstructionException("Unknown group: " + editableRule.getValidatorId());
            }
            if (!ValidationServices.getInstance().getAllJavaPaths().containsKey(editableRule.getJavaPath())) {
                throw new ConstructionException("Unknown java-path: " + editableRule.getJavaPath());
            }
            if (editableRule.getConditions() != null) {
                for (String conditionId : editableRule.getConditions()) {
                    Condition condition = this.getCondition(conditionId, null);
                    if (condition != null) continue;
                    throw new ConstructionException("Unknown condition: " + conditionId);
                }
            }
            if (editableRule.getCategory() != null && (category = this.getCategory(editableRule.getCategory(), null)) == null) {
                throw new ConstructionException("Unknown category: " + editableRule.getCategory());
            }
            Rule rule = new Rule();
            rule.setId(editableRule.getId());
            rule.setRuleId(editableRule.getRuleId());
            if (rule.getRuleId() == null) {
                rule.setRuleId(ValidationServices.getInstance().getNextRuleSequence());
            }
            rule.setName(editableRule.getName());
            rule.setJavaPath(editableRule.getJavaPath());
            rule.setExpression(editableRule.getExpression());
            rule.setMessage(editableRule.getMessage());
            if (editableRule.getIgnored() != null) {
                rule.setIgnored(editableRule.getIgnored());
            }
            if (editableRule.getSeverity() != null) {
                rule.setSeverity(editableRule.getSeverity());
            }
            rule.setConditions(editableRule.getConditions());
            rule.setUseAndForConditions(editableRule.getUseAndForConditions());
            rule.setCategory(editableRule.getCategory());
            rule.setTag(editableRule.getTag());
            rule.setAgency(editableRule.getAgency());
            rule.setAllowOverride(editableRule.getAllowOverride());
            rule.setNeedsReview(editableRule.getNeedsReview());
            rule.setImportEditFlag(editableRule.getImportEditFlag());
            rule.setDataEntryTypes(editableRule.getDataEntryTypes());
            rule.setDataLevel(editableRule.getDataLevel());
            rule.setDescription(editableRule.getDescription());
            rule.setDependencies(editableRule.getDependencies());
            rule.setHistories(editableRule.getHistories());
            rule.setValidator(this._validators.get(editableRule.getValidatorId()));
            ExecutableRule execRule = new ExecutableRule(rule);
            HashMap<Long, ExecutableRule> rules = new HashMap<Long, ExecutableRule>(this._executableRules);
            rules.put(execRule.getInternalId(), execRule);
            List<ExecutableRule> sortedRules = this.getRulesSortedByDependencies(rules, this._executableConditions);
            this._executableRules.put(execRule.getInternalId(), execRule);
            if (!this._processors.containsKey(editableRule.getJavaPath())) {
                this.populateProcessors(sortedRules);
            } else {
                this.updateProcessorsRules(sortedRules);
            }
            this._validators.get(editableRule.getValidatorId()).getRules().add(rule);
            if (editableRule.getDependencies() != null && !editableRule.getDependencies().isEmpty()) {
                for (Rule r : rule.getValidator().getRules()) {
                    if (!rule.getDependencies().contains(r.getId())) continue;
                    r.getInvertedDependencies().add(rule.getId());
                }
            }
            Rule rule2 = rule;
            return rule2;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRule(EditableRule editableRule) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Category category;
            if (editableRule == null) {
                throw new ConstructionException("An editable rule is required for modifying an edit");
            }
            if (editableRule.getRuleId() == null) {
                throw new ConstructionException("An internal ID is required when modifying an edit");
            }
            if (editableRule.getId() == null) {
                throw new ConstructionException("An edit ID is required when modifying an edit");
            }
            if (editableRule.getValidatorId() == null) {
                throw new ConstructionException("A group is required when modifying an edit");
            }
            if (editableRule.getMessage() == null) {
                throw new ConstructionException("A message is required when modifying an edit");
            }
            if (!this._validators.containsKey(editableRule.getValidatorId())) {
                throw new ConstructionException("Unknown group: " + editableRule.getValidatorId());
            }
            if (!ValidationServices.getInstance().getAllJavaPaths().containsKey(editableRule.getJavaPath())) {
                throw new ConstructionException("Unknown java-path: " + editableRule.getJavaPath());
            }
            ExecutableRule originalExecRule = this._executableRules.get(editableRule.getRuleId());
            if (originalExecRule == null) {
                throw new ConstructionException("Validation Engine does not contain requested edit");
            }
            Rule rule = this.getRule(originalExecRule.getId());
            if (rule == null) {
                throw new ConstructionException("Validation Engine does not contain requested edit");
            }
            if (editableRule.getConditions() != null) {
                for (String conditionId : editableRule.getConditions()) {
                    Condition condition = this.getCondition(conditionId, null);
                    if (condition != null) continue;
                    throw new ConstructionException("Unknown condition: " + conditionId);
                }
            }
            if (editableRule.getCategory() != null && (category = this.getCategory(editableRule.getCategory(), null)) == null) {
                throw new ConstructionException("Unknown category: " + editableRule.getCategory());
            }
            if (!editableRule.getId().equals(rule.getId()) && this.getRule(editableRule.getId()) != null) {
                throw new ConstructionException("Edit IDs must be unique within the edits engine, cannot add '" + editableRule.getId() + "'");
            }
            boolean idUpdated = !editableRule.getId().equals(rule.getId());
            boolean expressionUpdated = editableRule.getExpression() == null || !editableRule.getExpression().equals(rule.getExpression());
            boolean dependenciesUpdated = editableRule.getDependencies() == null || !editableRule.getDependencies().equals(rule.getDependencies());
            boolean historiesUpdated = editableRule.getHistories() == null || !editableRule.getHistories().equals(rule.getHistories());
            ExecutableRule execRule = new ExecutableRule(originalExecRule);
            if (idUpdated) {
                execRule.setId(editableRule.getId());
            }
            if (expressionUpdated) {
                execRule.setExpression(editableRule.getExpression());
            }
            execRule.setMessage(editableRule.getMessage());
            execRule.setIgnored(editableRule.getIgnored() == null ? Boolean.FALSE : editableRule.getIgnored());
            if (dependenciesUpdated) {
                execRule.setDependencies(editableRule.getDependencies() == null ? Collections.emptySet() : editableRule.getDependencies());
            }
            execRule.setConditions(editableRule.getConditions());
            execRule.setUseAndForConditions(editableRule.getUseAndForConditions());
            execRule.setJavaPath(editableRule.getJavaPath());
            HashMap<Long, ExecutableRule> rules = new HashMap<Long, ExecutableRule>(this._executableRules);
            rules.put(execRule.getInternalId(), execRule);
            List<ExecutableRule> sortedRules = this.getRulesSortedByDependencies(rules, this._executableConditions);
            this._executableRules.put(execRule.getInternalId(), execRule);
            if (!this._processors.containsKey(editableRule.getJavaPath())) {
                this.populateProcessors(sortedRules);
            } else {
                this.updateProcessorsRules(sortedRules);
            }
            rule.setId(editableRule.getId());
            rule.setName(editableRule.getName());
            rule.setExpression(editableRule.getExpression());
            rule.setMessage(editableRule.getMessage());
            rule.setIgnored(editableRule.getIgnored() == null ? Boolean.FALSE : editableRule.getIgnored());
            rule.setDescription(editableRule.getDescription());
            rule.setJavaPath(editableRule.getJavaPath());
            rule.setConditions(editableRule.getConditions());
            rule.setUseAndForConditions(editableRule.getUseAndForConditions());
            rule.setCategory(editableRule.getCategory());
            rule.setTag(editableRule.getTag());
            rule.setAgency(editableRule.getAgency());
            rule.setAllowOverride(editableRule.getAllowOverride());
            rule.setNeedsReview(editableRule.getNeedsReview());
            rule.setImportEditFlag(editableRule.getImportEditFlag());
            rule.setDataEntryTypes(editableRule.getDataEntryTypes());
            rule.setDataLevel(editableRule.getDataLevel());
            if (editableRule.getSeverity() != null) {
                rule.setSeverity(editableRule.getSeverity());
            }
            if (dependenciesUpdated) {
                HashSet<String> dependencies = new HashSet<String>();
                if (editableRule.getDependencies() != null) {
                    dependencies.addAll(editableRule.getDependencies());
                }
                rule.setDependencies(new HashSet<String>(dependencies));
            }
            if (historiesUpdated) {
                HashSet<RuleHistory> histories = new HashSet<RuleHistory>();
                if (editableRule.getHistories() != null) {
                    for (RuleHistory hist : editableRule.getHistories()) {
                        hist.setRule(rule);
                        histories.add(hist);
                    }
                }
                rule.setHistories(histories);
            }
            if (dependenciesUpdated) {
                for (Rule r : rule.getValidator().getRules()) {
                    if (rule.getDependencies().contains(r.getId())) {
                        r.getInvertedDependencies().add(rule.getId());
                        continue;
                    }
                    r.getInvertedDependencies().remove(rule.getId());
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void deleteRule(String ruleId) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Rule r = this.getRule(ruleId);
            if (r == null) {
                throw new ConstructionException("Unknown edit: " + ruleId);
            }
            this.deleteRule(new EditableRule(r));
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRule(EditableRule editableRule) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            if (editableRule == null) {
                throw new ConstructionException("An editable rule is required for deleting an edit");
            }
            if (editableRule.getRuleId() == null) {
                throw new ConstructionException("An internal edit ID is required when deleting an edit");
            }
            if (editableRule.getId() == null) {
                throw new ConstructionException("An edit ID is required when deleting an edit");
            }
            if (editableRule.getValidatorId() == null) {
                throw new ConstructionException("A group is required when deleting an edit");
            }
            if (!this._validators.containsKey(editableRule.getValidatorId())) {
                throw new ConstructionException("Unknown group: " + editableRule.getValidatorId());
            }
            for (Rule r : this._validators.get(editableRule.getValidatorId()).getRules()) {
                if (!r.getDependencies().contains(editableRule.getId())) continue;
                throw new ConstructionException(editableRule.getId() + " cannot be deleted, " + r.getId() + " depends on it");
            }
            Rule rule = this.getRule(editableRule.getId(), editableRule.getValidatorId());
            if (rule == null) {
                throw new ConstructionException("Validation Engine does not contain requested edit");
            }
            this._executableRules.remove(rule.getRuleId());
            this.updateProcessorsRules(this.getRulesSortedByDependencies(this._executableRules, this._executableConditions));
            this._validators.get(editableRule.getValidatorId()).getRules().remove(rule);
            for (Rule r : rule.getValidator().getRules()) {
                if (!rule.getDependencies().contains(r.getId())) continue;
                r.getInvertedDependencies().remove(rule.getId());
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Condition addCondition(EditableCondition editableCondition) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            if (editableCondition == null) {
                throw new ConstructionException("An editable condition is required for adding a new condition");
            }
            if (editableCondition.getId() == null) {
                throw new ConstructionException("A condition ID is required when adding a new condition");
            }
            if (editableCondition.getValidatorId() == null) {
                throw new ConstructionException("A group is required when adding a new condition");
            }
            if (editableCondition.getJavaPath() == null) {
                throw new ConstructionException("A java-path is required when adding a new condition");
            }
            if (this.getCondition(editableCondition.getId()) != null) {
                throw new ConstructionException("Condition IDs must be unique within the edits engine, cannot add '" + editableCondition.getId() + "'");
            }
            if (!this._validators.containsKey(editableCondition.getValidatorId())) {
                throw new ConstructionException("Unknown group: " + editableCondition.getValidatorId());
            }
            if (!ValidationServices.getInstance().getAllJavaPaths().containsKey(editableCondition.getJavaPath())) {
                throw new ConstructionException("Unknown java-path: " + editableCondition.getJavaPath());
            }
            Condition condition = new Condition();
            condition.setId(editableCondition.getId());
            condition.setConditionId(editableCondition.getConditionId());
            if (condition.getConditionId() == null) {
                condition.setConditionId(ValidationServices.getInstance().getNextConditionSequence());
            }
            condition.setId(editableCondition.getId());
            condition.setName(editableCondition.getName());
            condition.setDescription(editableCondition.getDescription());
            condition.setJavaPath(editableCondition.getJavaPath());
            condition.setExpression(editableCondition.getExpression());
            condition.setValidator(this._validators.get(editableCondition.getValidatorId()));
            ExecutableCondition execCondition = new ExecutableCondition(condition);
            this._executableConditions.put(execCondition.getInternalId(), execCondition);
            if (!this._processors.containsKey(editableCondition.getJavaPath())) {
                this.populateProcessors(this.getRulesSortedByDependencies(this._executableRules, this._executableConditions));
            } else {
                this.updateProcessorsConditions(this._executableConditions.values());
            }
            this._validators.get(editableCondition.getValidatorId()).getConditions().add(condition);
            Condition condition2 = condition;
            return condition2;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCondition(EditableCondition editableCondition) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            if (editableCondition == null) {
                throw new ConstructionException("An editable condition is required for modifying an condition");
            }
            if (editableCondition.getConditionId() == null) {
                throw new ConstructionException("An internal ID is required when modifying a condition");
            }
            if (editableCondition.getId() == null) {
                throw new ConstructionException("A category ID is required when modifying a condition");
            }
            if (editableCondition.getValidatorId() == null) {
                throw new ConstructionException("A group is required when modifying a condition");
            }
            if (editableCondition.getJavaPath() == null) {
                throw new ConstructionException("A java-path is required when adding a condition");
            }
            if (!this._processorRoots.containsKey(StringUtils.split((String)editableCondition.getJavaPath(), (char)'.')[0])) {
                throw new ConstructionException("Invalid java-path");
            }
            if (!this._validators.containsKey(editableCondition.getValidatorId())) {
                throw new ConstructionException("Unknown group: " + editableCondition.getValidatorId());
            }
            if (!ValidationServices.getInstance().getAllJavaPaths().containsKey(editableCondition.getJavaPath())) {
                throw new ConstructionException("Unknown java-path: " + editableCondition.getJavaPath());
            }
            ExecutableCondition originalExecCondition = this._executableConditions.get(editableCondition.getConditionId());
            if (originalExecCondition == null) {
                throw new ConstructionException("Unknown condition: " + editableCondition.getId());
            }
            Condition condition = this.getCondition(originalExecCondition.getId());
            if (condition == null) {
                throw new ConstructionException("Unknown condition: " + editableCondition.getId());
            }
            if (!condition.getId().equals(editableCondition.getId()) && this.getCondition(editableCondition.getId()) != null) {
                throw new ConstructionException("Condition IDs must be unique within the edits engine, cannot update ID to '" + editableCondition.getId() + "'");
            }
            ExecutableCondition execCondition = new ExecutableCondition(originalExecCondition);
            execCondition.setId(editableCondition.getId());
            execCondition.setJavaPath(editableCondition.getJavaPath());
            if (condition.getExpression() == null && editableCondition.getExpression() != null || condition.getExpression() != null && !condition.getExpression().equals(editableCondition.getExpression())) {
                execCondition.setExpression(editableCondition.getExpression());
            }
            this._executableConditions.put(execCondition.getInternalId(), execCondition);
            if (!this._processors.containsKey(editableCondition.getJavaPath())) {
                this.populateProcessors(this.getRulesSortedByDependencies(this._executableRules, this._executableConditions));
            } else {
                this.updateProcessorsConditions(this._executableConditions.values());
            }
            condition.setId(editableCondition.getId());
            condition.setValidator(this._validators.get(editableCondition.getValidatorId()));
            condition.setName(editableCondition.getName());
            condition.setDescription(editableCondition.getDescription());
            condition.setJavaPath(editableCondition.getJavaPath());
            condition.setExpression(editableCondition.getExpression());
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void deleteCondition(String conditionId) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Condition condition = this.getCondition(conditionId);
            if (condition == null) {
                throw new ConstructionException("Unknown condition: " + conditionId);
            }
            this.deleteCondition(new EditableCondition(condition));
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void deleteCondition(EditableCondition editableCondition) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Condition condition = this.getCondition(editableCondition.getId());
            if (condition == null) {
                throw new ConstructionException("Unknown condition: " + editableCondition.getId());
            }
            this._executableConditions.remove(editableCondition.getConditionId());
            this.updateProcessorsConditions(this._executableConditions.values());
            this._validators.get(editableCondition.getValidatorId()).getConditions().remove(condition);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Validator addValidator(EditableValidator editableValidator) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            if (this.getValidator(editableValidator.getId()) != null) {
                throw new ConstructionException("Group IDs must be unique within the edits engine, cannot add '" + editableValidator.getId() + "'");
            }
            Validator v = new Validator();
            v.setValidatorId(editableValidator.getValidatorId());
            if (v.getValidatorId() == null) {
                v.setValidatorId(ValidationServices.getInstance().getNextValidatorSequence());
            }
            v.setId(editableValidator.getId());
            v.setName(editableValidator.getName());
            v.setReleases(editableValidator.getReleases());
            v.setVersion(v.getReleases() == null || v.getReleases().isEmpty() ? null : ((ValidatorRelease)v.getReleases().last()).getVersion().getRawString());
            v.setHash(v.getHash());
            v.setRawContext(editableValidator.getRawContext());
            v.setCategories(editableValidator.getCategories());
            v.setConditions(editableValidator.getConditions());
            v.setRules(editableValidator.getRules());
            ConcurrentHashMap<Long, ExecutableCondition> conditions = new ConcurrentHashMap<Long, ExecutableCondition>();
            ConcurrentHashMap<Long, ExecutableRule> rules = new ConcurrentHashMap<Long, ExecutableRule>();
            ConcurrentHashMap<String, Object> contexts = new ConcurrentHashMap<String, Object>();
            this.internalizeValidator(v, conditions, rules, contexts, null);
            conditions.putAll(this._executableConditions);
            rules.putAll(this._executableRules);
            List<ExecutableRule> sortedRules = this.getRulesSortedByDependencies(rules, conditions);
            this._executableConditions.putAll(conditions);
            this._executableRules.putAll(rules);
            this._contexts.put(v.getValidatorId(), contexts);
            this.populateProcessors(sortedRules);
            this._validators.put(v.getId(), v);
            Validator validator = v;
            return validator;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValidator(EditableValidator editableValidator) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Validator v = null;
            for (Validator val : this._validators.values()) {
                if (!val.getValidatorId().equals(editableValidator.getValidatorId())) continue;
                v = val;
            }
            if (v == null) {
                throw new ConstructionException("Unknown group: " + editableValidator.getId());
            }
            this.deleteValidator(v.getId());
            this.addValidator(editableValidator);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void deleteValidator(String validatorId) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Validator v = this.getValidator(validatorId);
            if (v == null) {
                throw new ConstructionException("Unknown group: " + validatorId);
            }
            this.deleteValidator(new EditableValidator(v));
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValidator(EditableValidator editableValidator) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Validator v = this.getValidator(editableValidator.getId());
            if (v == null) {
                throw new ConstructionException("Unknown group: " + editableValidator.getId());
            }
            for (Condition condition : v.getConditions()) {
                this._executableConditions.remove(condition.getConditionId());
            }
            for (Rule r : v.getRules()) {
                this._executableRules.remove(r.getRuleId());
            }
            this._contexts.remove(editableValidator.getValidatorId());
            List<ExecutableRule> sortedRules = this.getRulesSortedByDependencies(this._executableRules, this._executableConditions);
            this.populateProcessors(sortedRules);
            this._validators.remove(editableValidator.getId());
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextEntry addContext(Long contextEntryId, String contextKey, String validatorId, String expression, String type) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Validator v = this.getValidator(validatorId);
            if (v == null) {
                throw new ConstructionException("Invalid group: " + validatorId);
            }
            if (this._contexts.get(v.getValidatorId()).containsKey(contextKey)) {
                throw new ConstructionException("Context key '" + contextKey + "' already exists; context keys must be unique within a group");
            }
            Map<String, Object> contexts = this._contexts.get(v.getValidatorId());
            if (contexts == null) {
                throw new ConstructionException("Invalid group: " + validatorId);
            }
            ValidationServices.getInstance().addContextExpression(expression, contexts, contextKey, type);
            this.updateProcessorsContexts(this._contexts);
            ContextEntry entry = new ContextEntry();
            entry.setContextEntryId(contextEntryId);
            entry.setKey(contextKey);
            entry.setExpression(expression);
            entry.setType(type);
            v.getRawContext().add(entry);
            ContextEntry contextEntry = entry;
            return contextEntry;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContext(String contextKey, String validatorId, String expression, String type) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Validator v = this.getValidator(validatorId);
            if (v == null) {
                throw new ConstructionException("Invalid group: " + validatorId);
            }
            ContextEntry entry = v.getRawContext(contextKey);
            if (entry == null) {
                throw new ConstructionException("Invalid key: " + contextKey);
            }
            Map<String, Object> contexts = this._contexts.get(v.getValidatorId());
            if (contexts == null) {
                throw new ConstructionException("Invalid group: " + validatorId);
            }
            if (!contexts.containsKey(contextKey)) {
                throw new ConstructionException("Group " + validatorId + " does not contain a context for key " + contextKey);
            }
            ValidationServices.getInstance().addContextExpression(expression, contexts, contextKey, type);
            this.updateProcessorsContexts(this._contexts);
            entry.setExpression(expression);
            entry.setType(type);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContext(String contextKey, String validatorId) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Validator v = this.getValidator(validatorId);
            if (v == null) {
                throw new ConstructionException("Invalid group: " + validatorId);
            }
            ContextEntry entry = v.getRawContext(contextKey);
            if (entry == null) {
                throw new ConstructionException("Invalid key: " + contextKey);
            }
            Map<String, Object> contexts = this._contexts.get(v.getValidatorId());
            if (contexts == null) {
                throw new ConstructionException("Invalid group: " + validatorId);
            }
            if (!contexts.containsKey(contextKey)) {
                throw new ConstructionException("Group " + validatorId + " does not contain a context for key " + contextKey);
            }
            contexts.remove(contextKey);
            this.updateProcessorsContexts(this._contexts);
            v.getRawContext().remove(entry);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void massUpdateIgnoreFlags(Collection<String> idsToIgnore, Collection<String> idsToStopIgnoring) {
        this._lock.writeLock().lock();
        try {
            for (ExecutableRule execRule : this._executableRules.values()) {
                String id = execRule.getId();
                if (idsToIgnore != null && idsToIgnore.contains(id)) {
                    execRule.setIgnored(Boolean.TRUE);
                    continue;
                }
                if (idsToStopIgnoring == null || !idsToStopIgnoring.contains(id)) continue;
                execRule.setIgnored(Boolean.FALSE);
            }
            try {
                this.updateProcessorsRules(this.getRulesSortedByDependencies(this._executableRules, this._executableConditions));
            }
            catch (ConstructionException e) {
                throw new IllegalStateException("Internal state has not changed, this exception should not happen!", e);
            }
            for (Validator v : this._validators.values()) {
                for (Rule r : v.getRules()) {
                    String id = r.getId();
                    if (idsToIgnore != null && idsToIgnore.contains(id)) {
                        r.setIgnored(Boolean.TRUE);
                        continue;
                    }
                    if (idsToStopIgnoring == null || !idsToStopIgnoring.contains(id)) continue;
                    r.setIgnored(Boolean.FALSE);
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableEmbeddedSet(String validatorId, String setId) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Validator v = this.getValidator(validatorId);
            if (v == null) {
                throw new ConstructionException("Invalid group: " + validatorId);
            }
            EmbeddedSet s = v.getSet(setId);
            if (s == null) {
                throw new ConstructionException("Invalid set: " + setId);
            }
            s.setIgnored(false);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableEmbeddedSet(String validatorId, String setId) throws ConstructionException {
        this._lock.writeLock().lock();
        try {
            Validator v = this.getValidator(validatorId);
            if (v == null) {
                throw new ConstructionException("Invalid group: " + validatorId);
            }
            EmbeddedSet s = v.getSet(setId);
            if (s == null) {
                throw new ConstructionException("Invalid set: " + setId);
            }
            s.setIgnored(true);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public String getEngineVersion() {
        return _ENGINE_VERSION;
    }

    public Set<String> getSupportedJavaPathRoots() {
        return this.getSupportedJavaPathRoots(false);
    }

    public Set<String> getSupportedJavaPathRoots(boolean filterEmptyPaths) {
        this._lock.readLock().lock();
        try {
            if (filterEmptyPaths) {
                Set<String> set = this._processorRoots.entrySet().stream().filter(e -> ((AtomicInteger)e.getValue()).get() > 0).map(Map.Entry::getKey).collect(Collectors.toSet());
                return set;
            }
            Set<String> set = Collections.unmodifiableSet(this._processorRoots.keySet());
            return set;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Map<String, EngineStats> getStats() {
        this._statsLock.readLock().lock();
        try {
            Map<String, EngineStats> map = this._editsStats;
            return map;
        }
        finally {
            this._statsLock.readLock().unlock();
        }
    }

    public void resetStats() {
        this._statsLock.writeLock().lock();
        try {
            this._editsStats.clear();
        }
        finally {
            this._statsLock.writeLock().unlock();
        }
    }

    public void setEditsStatsEnabled(boolean enabled) {
        this._computeEditsStats = enabled;
    }

    public boolean isEditsStatsEnabled() {
        return this._computeEditsStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpInternalState() {
        this._lock.readLock().lock();
        try {
            StringBuilder result = new StringBuilder();
            for (String key : new TreeSet<String>(this._processors.keySet())) {
                this._processors.get(key).dumpCache(result, key);
            }
            String string = result.toString();
            return string;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    private void internalizeValidator(Validator validator, Map<Long, ExecutableCondition> conditions, Map<Long, ExecutableRule> rules, Map<String, Object> contexts, InitializationStats stats) throws ConstructionException {
        if (validator.getValidatorId() == null) {
            validator.setValidatorId(ValidationServices.getInstance().getNextValidatorSequence());
        }
        if (validator.getValidatorId() == null) {
            throw new ConstructionException("Validator must have a non-null internal ID to be registered in the engine");
        }
        CompiledRules compiledRules = null;
        if (this._options.isPreCompiledEditsEnabled()) {
            compiledRules = RuntimeUtils.findCompileRules(validator, stats);
        } else if (stats != null) {
            stats.setReasonNotPreCompiled(validator.getId(), "pre-compiled edits are disabled");
        }
        try (ExecutorService service = Executors.newFixedThreadPool(this._options.getNumCompilationThreads());){
            ArrayList<Future<Void>> results = new ArrayList<Future<Void>>(validator.getRules().size());
            if (validator.getRules() != null) {
                for (Rule rule : validator.getRules()) {
                    if (rule.getRuleId() == null) {
                        rule.setRuleId(ValidationServices.getInstance().getNextRuleSequence());
                    }
                    if (rule.getRuleId() == null) {
                        throw new ConstructionException("Edits must have a non-null internal ID to be registered in the engine");
                    }
                    results.add(service.submit(new RuleCompilingCallable(rule, rules, compiledRules, stats)));
                }
                validator.setRules(new HashSet<Rule>(validator.getRules()));
            }
            if (validator.getConditions() != null) {
                for (Condition condition : validator.getConditions()) {
                    if (condition.getConditionId() == null) {
                        condition.setConditionId(ValidationServices.getInstance().getNextConditionSequence());
                    }
                    if (condition.getConditionId() == null) {
                        throw new ConstructionException("Conditions must have a non-null internal ID to be registered in the engine");
                    }
                    conditions.put(condition.getConditionId(), new ExecutableCondition(condition));
                }
                validator.setConditions(new HashSet<Condition>(validator.getConditions()));
            }
            if (validator.getCategories() != null) {
                for (Category category : validator.getCategories()) {
                    if (category.getCategoryId() != null) continue;
                    category.setCategoryId(ValidationServices.getInstance().getNextCategorySequence());
                }
                validator.setCategories(new HashSet<Category>(validator.getCategories()));
            }
            if (validator.getRawContext() != null) {
                Iterator<ContextEntry> reRun = new HashSet();
                for (ContextEntry entry : validator.getRawContext()) {
                    if (entry.getContextEntryId() == null) {
                        entry.setContextEntryId(ValidationServices.getInstance().getNextContextEntrySequence());
                    }
                    try {
                        if (entry.getExpression().contains("Context.")) {
                            reRun.add(entry);
                            continue;
                        }
                        ValidationServices.getInstance().addContextExpression(entry.getExpression(), contexts, entry.getKey(), entry.getType());
                    }
                    catch (ConstructionException e) {
                        reRun.add(entry);
                    }
                }
                Iterator iterator = reRun.iterator();
                while (iterator.hasNext()) {
                    ContextEntry entry;
                    entry = (ContextEntry)iterator.next();
                    ValidationServices.getInstance().addContextExpression(entry.getExpression(), contexts, entry.getKey(), entry.getType());
                }
                validator.setRawContext(new HashSet<ContextEntry>(validator.getRawContext()));
            }
            if (validator.getSets() != null) {
                for (EmbeddedSet embeddedSet : validator.getSets()) {
                    if (embeddedSet.getSetId() != null) continue;
                    embeddedSet.setSetId(ValidationServices.getInstance().getNextSetSequence());
                }
                validator.setSets(new HashSet<EmbeddedSet>(validator.getSets()));
            }
            service.shutdown();
            for (Future future : results) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ConstructionException) {
                        throw (ConstructionException)e.getCause();
                    }
                    throw new IllegalStateException(e);
                }
            }
            try {
                if (!service.awaitTermination(30L, TimeUnit.SECONDS)) {
                    throw new IllegalStateException("Background compilation took too long to complete");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void checkValidatorConstraints(List<Validator> validators) throws ConstructionException {
        HashSet<String> validatorIds = new HashSet<String>();
        HashSet<String> conditionIds = new HashSet<String>();
        HashSet<String> categoryIds = new HashSet<String>();
        HashSet<String> ruleIds = new HashSet<String>();
        for (Validator v : validators) {
            if (validatorIds.contains(v.getId())) {
                throw new ConstructionException("Group ID '" + v.getId() + "' is not unique");
            }
            if (v.getMinEngineVersion() != null && ValidationServices.getInstance().compareEngineVersions(v.getMinEngineVersion(), _ENGINE_VERSION) > 0) {
                throw new ConstructionException("Group ID '" + v.getId() + "' requires version " + v.getMinEngineVersion() + "; current version is 6.8");
            }
            validatorIds.add(v.getId());
            if (v.getConditions() != null) {
                for (Condition condition : v.getConditions()) {
                    if (conditionIds.contains(condition.getId())) {
                        throw new ConstructionException("Condition ID '" + condition.getId() + "' (from group '" + v.getId() + "') is not unique across all groups");
                    }
                    conditionIds.add(condition.getId());
                }
            }
            if (v.getCategories() != null) {
                for (Category category : v.getCategories()) {
                    if (categoryIds.contains(category.getId())) {
                        throw new ConstructionException("Category ID '" + category.getId() + "' (from group '" + v.getId() + "') is not unique across all groups");
                    }
                    categoryIds.add(category.getId());
                }
            }
            for (Rule rule : v.getRules()) {
                if (ruleIds.contains(rule.getId())) {
                    throw new ConstructionException("Edit ID '" + rule.getId() + "' (from group '" + v.getId() + "') is not unique across all groups");
                }
                ruleIds.add(rule.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RuleFailure> internalValidate(Validatable validatable, ValidatingContext vContext) throws ValidationException {
        if (this._status == ValidationEngineStatus.NOT_INITIALIZED) {
            return new HashSet<RuleFailure>();
        }
        Processor processor = this._processors.get(validatable.getRootLevel());
        if (processor == null) {
            return new HashSet<RuleFailure>();
        }
        if (vContext.getToForce() != null && !ValidationServices.getInstance().getAllJavaPaths().containsKey(vContext.getToForce().getJavaPath())) {
            throw new ValidationException("Unknown java path for forced edit: " + vContext.getToForce().getJavaPath());
        }
        Collection<RuleFailure> failures = processor.process(validatable, vContext);
        if (this._computeEditsStats) {
            this._statsLock.writeLock().lock();
            try {
                for (Map.Entry<String, Long> entry : vContext.getEditDurations().entrySet()) {
                    this._editsStats.computeIfAbsent(entry.getKey(), EngineStats::new).reportStat(entry.getValue());
                }
            }
            finally {
                this._statsLock.writeLock().unlock();
            }
        }
        return failures;
    }

    private void populateProcessors(List<ExecutableRule> sortedRules) {
        this._processors.clear();
        this._processorRoots.clear();
        for (String javaPath : ValidationServices.getInstance().getAllJavaPaths().keySet()) {
            String[] parts = StringUtils.split((String)javaPath, (char)'.');
            this._processorRoots.put(parts[0], new AtomicInteger());
            StringBuilder partialPath = new StringBuilder(parts[0]);
            ValidatingProcessor current = this._processors.computeIfAbsent(partialPath.toString(), k -> new ValidatingProcessor(partialPath.toString()));
            for (int i = 1; i < parts.length; ++i) {
                partialPath.append(".").append(parts[i]);
                ValidatingProcessor vProcessor = this._processors.get(partialPath.toString());
                if (vProcessor == null) {
                    vProcessor = new ValidatingProcessor(partialPath.toString());
                    IterativeProcessor iProcessor = new IterativeProcessor(vProcessor, parts[i]);
                    this._processors.put(partialPath.toString(), vProcessor);
                    current.addNested(iProcessor);
                }
                current = vProcessor;
            }
        }
        if (sortedRules != null) {
            this.updateProcessorsRules(sortedRules);
        }
        this.updateProcessorsConditions(this._executableConditions.values());
        this.updateProcessorsContexts(this._contexts);
    }

    private void updateProcessorsRules(List<ExecutableRule> sortedRules) {
        HashMap rules = new HashMap();
        for (ExecutableRule rule : sortedRules) {
            rules.computeIfAbsent(rule.getJavaPath(), k -> new ArrayList()).add(rule);
        }
        this._processorRoots.values().forEach(i -> i.set(0));
        for (ValidatingProcessor p : this._processors.values()) {
            List<ExecutableRule> rulesForCurrentProcessor = rules.getOrDefault(p.getJavaPath(), Collections.emptyList());
            p.setRules(rulesForCurrentProcessor);
            this._processorRoots.get(StringUtils.split((String)p.getJavaPath(), (char)'.')[0]).addAndGet(rulesForCurrentProcessor.size());
        }
    }

    private void updateProcessorsConditions(Collection<ExecutableCondition> allConditions) {
        HashMap conditions = new HashMap();
        for (ExecutableCondition condition : allConditions) {
            conditions.computeIfAbsent(condition.getJavaPath(), k -> new ArrayList()).add(condition);
        }
        for (ValidatingProcessor p : this._processors.values()) {
            p.setConditions(conditions.getOrDefault(p.getJavaPath(), Collections.emptyList()));
        }
    }

    private void updateProcessorsContexts(Map<Long, Map<String, Object>> allContexts) {
        for (ValidatingProcessor p : this._processors.values()) {
            p.setContexts(allContexts);
        }
    }

    private List<ExecutableRule> getRulesSortedByDependencies(Map<Long, ExecutableRule> rules, Map<Long, ExecutableCondition> conditions) throws ConstructionException {
        ArrayList<ExecutableRule> rulesQueue = new ArrayList<ExecutableRule>();
        HashMap<String, ExecutableRule> ruleCache = new HashMap<String, ExecutableRule>(rules.size() + 1);
        HashMap<String, String> pathCache = new HashMap<String, String>(rules.size() + 1);
        HashMap<String, String> validatorCache = new HashMap<String, String>(rules.size() + 1);
        HashMap<String, String> conditionPaths = new HashMap<String, String>();
        for (ExecutableCondition condition : conditions.values()) {
            conditionPaths.put(condition.getId(), condition.getJavaPath());
        }
        for (ExecutableRule rule : rules.values()) {
            this.addToRuleCache(pathCache, validatorCache, rule, ruleCache);
            if (rule.getConditions() == null) continue;
            for (String conditionId : rule.getConditions()) {
                String conditionPath = (String)conditionPaths.get(conditionId);
                if (conditionPath == null) {
                    throw new ConstructionException("Edit '" + rule.getId() + "' references unknown condition: " + conditionId, rule.getId());
                }
                if (!conditionPath.startsWith(rule.getJavaPath()) || conditionPath.equals(rule.getJavaPath())) continue;
                throw new ConstructionException("Edit '" + rule.getId() + "' references condition '" + conditionId + "' which is defined lower in the data structure tree.", rule.getId());
            }
        }
        HashSet<String> currents = new HashSet<String>();
        while (!ruleCache.isEmpty()) {
            this.addToRuleQueue((ExecutableRule)ruleCache.remove(ruleCache.keySet().iterator().next()), ruleCache, currents, rulesQueue, pathCache, validatorCache);
        }
        return rulesQueue;
    }

    private void addToRuleCache(Map<String, String> pathCache, Map<String, String> validatorCache, ExecutableRule rule, Map<String, ExecutableRule> ruleCache) throws ConstructionException {
        String ruleId = rule.getId();
        pathCache.put(ruleId, rule.getJavaPath());
        validatorCache.put(ruleId, rule.getRule().getValidator().getId());
        if (rule.getDependencies().contains(ruleId)) {
            throw new ConstructionException("Edit '" + ruleId + "' cannot depend on itself", ruleId);
        }
        ruleCache.put(ruleId, rule);
    }

    private void addToRuleQueue(ExecutableRule rule, Map<String, ExecutableRule> cache, Set<String> currents, List<ExecutableRule> queue, Map<String, String> pathCache, Map<String, String> validatorCache) throws ConstructionException {
        if (rule.getDependencies() != null && !rule.getDependencies().isEmpty()) {
            String rId = rule.getId();
            String rPath = rule.getJavaPath();
            String vId = rule.getRule().getValidator().getId();
            for (String depId : rule.getDependencies()) {
                String validatorCachedId = validatorCache.get(depId);
                if (validatorCachedId == null) {
                    throw new ConstructionException("Unable to resolve dependency '" + depId + "' for edit '" + rId + "' (" + vId + ")");
                }
                String depPath = pathCache.get(depId);
                if (rPath == null) {
                    throw new ConstructionException("Got a null java-path for edit '" + rId + "' (" + vId + ")");
                }
                if (depPath == null) {
                    throw new ConstructionException("Got a null java-path for edit '" + depId + "' (on which '" + rId + "' depends)");
                }
                if (!rPath.startsWith(depPath) || rPath.length() < depPath.length()) {
                    throw new ConstructionException("Edit '" + rId + "' cannot depend on '" + depId + "' which is lower in the data structure tree.");
                }
                if (!vId.equals(validatorCachedId)) {
                    throw new ConstructionException("No cross-group dependency is allowed, edit '" + rId + "' (" + vId + ") cannot depend on '" + depId + "' (" + validatorCachedId + ")", rId);
                }
                if (currents.contains(depId)) {
                    throw new ConstructionException("Circular dependency detected between '" + depId + "' and '" + rId + "'", depId, rId);
                }
                if (!cache.containsKey(depId)) continue;
                currents.add(rule.getId());
                this.addToRuleQueue(cache.remove(depId), cache, currents, queue, pathCache, validatorCache);
            }
        }
        queue.add(rule);
        currents.clear();
    }

    private static enum ValidationEngineStatus {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED;

    }
}

