/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.Category;
import com.imsweb.validation.entities.Condition;
import com.imsweb.validation.entities.ContextEntry;
import com.imsweb.validation.entities.DeletedRuleHistory;
import com.imsweb.validation.entities.EmbeddedSet;
import com.imsweb.validation.entities.Rule;
import com.imsweb.validation.entities.RuleHistory;
import com.imsweb.validation.entities.RuleTest;
import com.imsweb.validation.entities.StandaloneSet;
import com.imsweb.validation.entities.Validator;
import com.imsweb.validation.entities.ValidatorRelease;
import com.imsweb.validation.entities.ValidatorTests;
import com.imsweb.validation.entities.ValidatorVersion;
import com.imsweb.validation.entities.xml.CategoryXmlDto;
import com.imsweb.validation.entities.xml.ConditionXmlDto;
import com.imsweb.validation.entities.xml.ContextEntryXmlDto;
import com.imsweb.validation.entities.xml.DeletedRuleXmlDto;
import com.imsweb.validation.entities.xml.HistoryEventXmlDto;
import com.imsweb.validation.entities.xml.ReleaseXmlDto;
import com.imsweb.validation.entities.xml.RuleXmlDto;
import com.imsweb.validation.entities.xml.SetXmlDto;
import com.imsweb.validation.entities.xml.StandaloneSetValidatorXmlDto;
import com.imsweb.validation.entities.xml.StandaloneSetXmlDto;
import com.imsweb.validation.entities.xml.TestXmlDto;
import com.imsweb.validation.entities.xml.TestedValidatorXmlDto;
import com.imsweb.validation.entities.xml.ValidatorXmlDto;
import com.imsweb.validation.internal.callable.RuleParsingCallable;
import com.imsweb.validation.internal.xml.StandaloneSetXmlDriver;
import com.imsweb.validation.internal.xml.TestsXmlDriver;
import com.imsweb.validation.internal.xml.ValidatorXmlDriver;
import com.imsweb.validation.runtime.ParsedContexts;
import com.imsweb.validation.runtime.ParsedLookups;
import com.imsweb.validation.runtime.ParsedProperties;
import com.imsweb.validation.runtime.RuntimeEdits;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public final class ValidationXmlUtils {
    public static final String ROOT_ATTR_ID = "id";
    public static final String ROOT_ATTR_NAME = "name";
    public static final String ROOT_ATTR_VERSION = "version";
    public static final String ROOT_ATTR_MIN_ENGINE_VERSION = "min-engine-version";
    public static final String ROOT_ATTR_TRANSLATED_FROM = "translated-from";
    private static final Pattern _PATTERN_TAB = Pattern.compile("\\t");
    private static final Pattern _CONTROL_CHARACTERS_PATTERN = Pattern.compile("[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F]");
    private static final Pattern _PATTERN_RULE_ID = Pattern.compile("^(\\D*+)(\\d++)(.*+)$");
    private static boolean _REALIGNMENT_ENABLED = false;

    private ValidationXmlUtils() {
    }

    private static XStream createValidatorXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new ValidatorXmlDriver()){

            protected void setupConverters() {
                this.registerConverter((Converter)new NullConverter(), 10000);
                this.registerConverter((SingleValueConverter)new IntConverter(), 0);
                this.registerConverter((SingleValueConverter)new FloatConverter(), 0);
                this.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
                this.registerConverter((SingleValueConverter)new LongConverter(), 0);
                this.registerConverter((SingleValueConverter)new ShortConverter(), 0);
                this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
                this.registerConverter((SingleValueConverter)new ByteConverter(), 0);
                this.registerConverter((SingleValueConverter)new StringConverter(), 0);
                this.registerConverter((SingleValueConverter)new DateConverter(), 0);
                this.registerConverter((Converter)new CollectionConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new ReflectionConverter(this.getMapper(), this.getReflectionProvider()), -20);
            }
        };
        xstream.autodetectAnnotations(true);
        xstream.alias("validator", ValidatorXmlDto.class);
        xstream.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class type) {
                return type.equals(Date.class);
            }

            public Object fromString(String str) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(str);
                }
                catch (ParseException e) {
                    throw new ConversionException("Cannot parse date " + str);
                }
            }

            public String toString(Object obj) {
                return new SimpleDateFormat("yyyy-MM-dd").format((Date)obj);
            }
        });
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.validation.**"}));
        return xstream;
    }

    public static Validator loadValidatorFromXml(File file) throws IOException {
        return ValidationXmlUtils.loadValidatorFromXml(file, null);
    }

    public static Validator loadValidatorFromXml(File file, RuntimeEdits runtime) throws IOException {
        if (file == null) {
            throw new IOException("Unable to load validator, target file is null");
        }
        if (!file.exists()) {
            throw new IOException("Unable to load validator, target file doesn't exist");
        }
        try (InputStream is = file.getName().toLowerCase().endsWith(".gz") ? new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])) : Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Validator validator = ValidationXmlUtils.loadValidatorFromXml(is, runtime);
            return validator;
        }
    }

    public static Validator loadValidatorFromXml(URL url) throws IOException {
        return ValidationXmlUtils.loadValidatorFromXml(url, null);
    }

    public static Validator loadValidatorFromXml(URL url, RuntimeEdits runtime) throws IOException {
        if (url == null) {
            throw new IOException("Unable to load validator, target URL is null");
        }
        try (InputStream is = url.getPath().toLowerCase().endsWith(".gz") ? new GZIPInputStream(url.openStream()) : url.openStream();){
            Validator validator = ValidationXmlUtils.loadValidatorFromXml(is, runtime);
            return validator;
        }
    }

    public static Validator loadValidatorFromXml(InputStream is) throws IOException {
        return ValidationXmlUtils.loadValidatorFromXml(is, null);
    }

    public static Validator loadValidatorFromXml(InputStream is, RuntimeEdits runtime) throws IOException {
        if (is == null) {
            throw new IOException("Unable to load validator, target input stream is null");
        }
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            Validator validator = ValidationXmlUtils.loadValidatorFromXml(reader, runtime);
            return validator;
        }
    }

    public static Validator loadValidatorFromXml(Reader reader) throws IOException {
        return ValidationXmlUtils.loadValidatorFromXml(reader, null);
    }

    public static Validator loadValidatorFromXml(Reader reader, RuntimeEdits runtime) throws IOException {
        if (reader == null) {
            throw new IOException("Unable to load validator, target reader is null");
        }
        try {
            ValidatorXmlDto validatorType = (ValidatorXmlDto)ValidationXmlUtils.createValidatorXStream().fromXML(reader);
            Validator validator = new Validator();
            validator.setValidatorId(ValidationServices.getInstance().getNextValidatorSequence());
            if (validatorType.getId() == null) {
                throw new IOException("Validator ID is required");
            }
            validator.setId(validatorType.getId());
            validator.setName(validatorType.getName());
            validator.setVersion(validatorType.getVersion());
            validator.setMinEngineVersion(validatorType.getMinEngineVersion());
            validator.setTranslatedFrom(validatorType.getTranslatedFrom());
            ValidationXmlUtils.readValidatorReleases(validator, validatorType.getReleases());
            ValidationXmlUtils.readValidatorDeletedRuleHistories(validator, validatorType.getDeletedRules());
            ValidationXmlUtils.readValidatorContext(validator, validatorType.getContextEntries());
            ValidationXmlUtils.readValidatorCategories(validator, validatorType.getCategories());
            ValidationXmlUtils.readValidatorConditions(validator, validatorType.getConditions());
            ValidationXmlUtils.readValidatorRules(validator, validatorType.getRules(), runtime);
            ValidationXmlUtils.readValidatorSets(validator, validatorType.getSets());
            HashMap<String, Set> invertedDependencies = new HashMap<String, Set>();
            for (Rule r : validator.getRules()) {
                for (String id : r.getDependencies()) {
                    invertedDependencies.computeIfAbsent(id, k -> new HashSet()).add(r.getId());
                }
            }
            for (Rule r : validator.getRules()) {
                r.setInvertedDependencies((Set)invertedDependencies.get(r.getId()));
            }
            if (runtime != null) {
                validator.setCompiledRules(runtime.getCompiledRules());
            }
            return validator;
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to construct new validator instance", e);
        }
    }

    public static void writeValidatorToXml(Validator validator, File file) throws IOException {
        if (file == null) {
            throw new IOException("Unable to write validator, target file is null");
        }
        try (OutputStream os = file.getName().toLowerCase().endsWith(".gz") ? new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])) : Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ValidationXmlUtils.writeValidatorToXml(validator, os);
        }
    }

    public static void writeValidatorToXml(Validator validator, OutputStream os) throws IOException {
        if (os == null) {
            throw new IOException("Unable to write validator '" + validator.getId() + "', target output stream is null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            ValidationXmlUtils.writeValidatorToXml(validator, writer);
        }
    }

    public static void writeValidatorToXml(Validator validator, Writer writer) throws IOException {
        if (validator == null) {
            throw new IOException("Unable to write NULL validator");
        }
        if (writer == null) {
            throw new IOException("Unable to write validator '" + validator.getId() + "', target writer is null");
        }
        try {
            ValidatorXmlDto validatorType = new ValidatorXmlDto();
            validatorType.setId(validator.getId());
            validatorType.setName(validator.getName());
            validatorType.setVersion(validator.getVersion());
            validatorType.setMinEngineVersion(validator.getMinEngineVersion());
            validatorType.setTranslatedFrom(validator.getTranslatedFrom());
            validatorType.setReleases(ValidationXmlUtils.writeValidatorReleases(validator));
            validatorType.setDeletedRules(ValidationXmlUtils.writeValidatorDeletedRuleHistories(validator));
            validatorType.setContextEntries(ValidationXmlUtils.writeValidatorContext(validator));
            validatorType.setCategories(ValidationXmlUtils.writeValidatorCategories(validator));
            validatorType.setConditions(ValidationXmlUtils.writeValidatorConditions(validator));
            validatorType.setRules(ValidationXmlUtils.writeValidatorRules(validator));
            validatorType.setSets(ValidationXmlUtils.writeValidatorSets(validator));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(System.lineSeparator());
            ValidationXmlUtils.createValidatorXStream().toXML((Object)validatorType, writer);
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to write validator", e);
        }
    }

    private static void readValidatorReleases(Validator validator, List<ReleaseXmlDto> releasesType) throws IOException {
        if (releasesType != null && !releasesType.isEmpty()) {
            for (ReleaseXmlDto release : releasesType) {
                if (release.getVersion() == null) {
                    throw new IOException("Release version is required");
                }
                if (release.getDate() == null) {
                    throw new IOException("Release date is required");
                }
                validator.getReleases().add(new ValidatorRelease(new ValidatorVersion(release.getVersion()), release.getDate(), release.getDesc()));
            }
        }
    }

    private static void readValidatorDeletedRuleHistories(Validator validator, List<DeletedRuleXmlDto> deletedRulesType) throws IOException {
        HashSet<DeletedRuleHistory> histories = new HashSet<DeletedRuleHistory>();
        if (deletedRulesType != null && !deletedRulesType.isEmpty()) {
            HashMap<String, ValidatorVersion> versions = new HashMap<String, ValidatorVersion>();
            if (validator.getReleases() != null) {
                for (ValidatorRelease release : validator.getReleases()) {
                    versions.put(release.getVersion().getRawString(), release.getVersion());
                }
            }
            for (DeletedRuleXmlDto event : deletedRulesType) {
                DeletedRuleHistory rh = new DeletedRuleHistory();
                rh.setRuleHistoryId(ValidationServices.getInstance().getNextRuleHistorySequence());
                if (event.getId() == null) {
                    throw new IOException("Deleted rule ID is required");
                }
                rh.setDeletedRuleId(event.getId());
                rh.setDeletedRuleName(event.getName());
                rh.setValidator(validator);
                if (event.getVersion() != null) {
                    ValidatorVersion version = (ValidatorVersion)versions.get(event.getVersion());
                    if (version == null) {
                        throw new IOException("Deleted Rule '" + event.getId() + "' in validator '" + validator.getId() + "' defines a bad version: " + event.getVersion());
                    }
                    rh.setVersion(version);
                }
                if (event.getUser() == null) {
                    throw new IOException("Deleted rule user is required");
                }
                rh.setUsername(event.getUser().trim());
                if (event.getDate() == null) {
                    throw new IOException("Deleted rule date is required");
                }
                rh.setDate(event.getDate());
                rh.setReference(event.getRef());
                rh.setReplacedBy(event.getReplacedBy());
                rh.setMessage(ValidationXmlUtils.trimEmptyLines(event.getValue(), true));
                histories.add(rh);
            }
        }
        validator.setDeletedRuleHistories(histories);
    }

    private static void readValidatorContext(Validator validator, List<ContextEntryXmlDto> contextEntries) throws IOException {
        HashSet<ContextEntry> rawContext = new HashSet<ContextEntry>();
        if (contextEntries != null && !contextEntries.isEmpty()) {
            for (ContextEntryXmlDto entryType : contextEntries) {
                ContextEntry entry = new ContextEntry();
                entry.setContextEntryId(ValidationServices.getInstance().getNextContextEntrySequence());
                entry.setValidator(validator);
                if (entryType.getId() == null) {
                    throw new IOException("Context entry ID is required");
                }
                entry.setKey(entryType.getId());
                String contextType = entryType.getType() == null ? "groovy" : entryType.getType();
                List<String> allowed = Arrays.asList("groovy", "java", "table", "table-index-def");
                if (!allowed.contains(contextType)) {
                    throw new IOException("Unable to load context '" + entryType.getId() + "' in " + validator.getId() + "; type must be in " + String.valueOf(allowed));
                }
                entry.setType(contextType);
                entry.setExpression(ValidationXmlUtils.reAlign(entryType.getValue()));
                rawContext.add(entry);
            }
        }
        validator.setRawContext(rawContext);
    }

    private static void readValidatorCategories(Validator validator, List<CategoryXmlDto> categoriesType) throws IOException {
        HashSet<Category> categories = new HashSet<Category>();
        if (categoriesType != null && !categoriesType.isEmpty()) {
            HashSet<String> usedIds = new HashSet<String>();
            for (CategoryXmlDto type : categoriesType) {
                if (type.getId() == null) {
                    throw new IOException("Category ID is required");
                }
                if (usedIds.contains(type.getId())) {
                    throw new IOException("Category '" + type.getId() + "' is defined more than once");
                }
                usedIds.add(type.getId());
                Category category = new Category();
                category.setCategoryId(ValidationServices.getInstance().getNextCategorySequence());
                category.setId(type.getId().trim());
                category.setValidator(validator);
                if (type.getName() != null) {
                    category.setName(type.getName().trim());
                }
                if (type.getDescription() != null) {
                    category.setDescription(ValidationXmlUtils.reAlign(type.getDescription()));
                }
                categories.add(category);
            }
        }
        validator.setCategories(categories);
    }

    private static void readValidatorConditions(Validator validator, List<ConditionXmlDto> conditionsType) throws IOException {
        HashSet<Condition> conditions = new HashSet<Condition>();
        if (conditionsType != null && !conditionsType.isEmpty()) {
            HashSet<String> usedIds = new HashSet<String>();
            for (ConditionXmlDto type : conditionsType) {
                if (type.getId() == null) {
                    throw new IOException("Condition ID is required");
                }
                if (usedIds.contains(type.getId())) {
                    throw new IOException("Condition '" + type.getId() + "' is defined more than once");
                }
                usedIds.add(type.getId());
                Condition condition = new Condition();
                condition.setConditionId(ValidationServices.getInstance().getNextConditionSequence());
                condition.setId(type.getId().trim());
                condition.setValidator(validator);
                if (type.getName() != null) {
                    condition.setName(type.getName().trim());
                }
                condition.setJavaPath(type.getJavaPath().trim());
                try {
                    condition.setExpression(ValidationXmlUtils.reAlign(type.getExpression()));
                }
                catch (ConstructionException e) {
                    throw new IOException("Unable to load condition '" + condition.getId() + "'; it contain an invalid expression", e);
                }
                if (type.getDescription() != null) {
                    condition.setDescription(ValidationXmlUtils.reAlign(type.getDescription()));
                }
                conditions.add(condition);
            }
        }
        validator.setConditions(conditions);
    }

    private static void readValidatorRules(Validator validator, List<RuleXmlDto> rulesType, RuntimeEdits runtime) throws IOException {
        ConcurrentHashMap<String, Rule> rules = new ConcurrentHashMap<String, Rule>();
        if (rulesType != null && !rulesType.isEmpty()) {
            HashMap<String, ValidatorVersion> versions = new HashMap<String, ValidatorVersion>();
            if (validator.getReleases() != null) {
                for (ValidatorRelease release : validator.getReleases()) {
                    versions.put(release.getVersion().getRawString(), release.getVersion());
                }
            }
            ParsedProperties props = null;
            ParsedContexts contexts = null;
            ParsedLookups lookups = null;
            if (runtime != null) {
                props = runtime.getParsedProperties();
                contexts = runtime.getParsedContexts();
                lookups = runtime.getParsedLookups();
            }
            try (ExecutorService service = Executors.newFixedThreadPool(2);){
                ArrayList<Future<Void>> results = new ArrayList<Future<Void>>(rulesType.size());
                for (RuleXmlDto ruleXmlDto : rulesType) {
                    if (rules.containsKey(ruleXmlDto.getId())) {
                        throw new IOException("Edit '" + ruleXmlDto.getId() + "' defined more than once in group " + validator.getId());
                    }
                    results.add(service.submit(new RuleParsingCallable(ruleXmlDto, ValidationServices.getInstance().getNextRuleSequence(), validator, versions, rules, props, contexts, lookups)));
                }
                service.shutdown();
                for (Future future : results) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                        throw new IllegalStateException(e);
                    }
                }
                try {
                    if (!service.awaitTermination(5L, TimeUnit.MINUTES)) {
                        throw new IllegalStateException("Edits compilation took too long to complete");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        validator.setRules(new HashSet<Rule>(rules.values()));
    }

    private static void readValidatorSets(Validator validator, List<SetXmlDto> setsType) throws IOException {
        HashSet<EmbeddedSet> sets = new HashSet<EmbeddedSet>();
        if (setsType != null && !setsType.isEmpty()) {
            HashSet<String> usedIds = new HashSet<String>();
            for (SetXmlDto type : setsType) {
                if (type.getId() == null) {
                    throw new IOException("Set ID is required");
                }
                if (usedIds.contains(type.getId())) {
                    throw new IOException("Set '" + type.getId() + "' defined more than once in " + validator.getId());
                }
                usedIds.add(type.getId());
                EmbeddedSet set = new EmbeddedSet();
                set.setSetId(ValidationServices.getInstance().getNextSetSequence());
                set.setId(type.getId().trim());
                set.setValidator(validator);
                if (type.getName() != null) {
                    set.setName(type.getName().trim());
                }
                set.setTag(type.getTag());
                if (type.getDescription() != null) {
                    set.setDescription(ValidationXmlUtils.reAlign(type.getDescription()));
                }
                String include = type.getInclude();
                HashSet<String> inclusions = new HashSet<String>();
                if (include != null && !include.trim().isEmpty()) {
                    for (String s : StringUtils.split((String)include, (char)',')) {
                        inclusions.add(s.trim());
                    }
                }
                set.setInclusions(inclusions);
                String exclude = type.getExclude();
                HashSet<String> exclusions = new HashSet<String>();
                if (exclude != null && !exclude.trim().isEmpty()) {
                    for (String s : StringUtils.split((String)exclude, (char)',')) {
                        exclusions.add(s.trim());
                    }
                }
                set.setExclusions(exclusions);
                sets.add(set);
            }
        }
        validator.setSets(sets);
    }

    private static List<ReleaseXmlDto> writeValidatorReleases(Validator validator) {
        if (validator.getReleases() == null || validator.getReleases().isEmpty()) {
            return null;
        }
        ArrayList<ReleaseXmlDto> releases = new ArrayList<ReleaseXmlDto>();
        for (ValidatorRelease r : validator.getReleases()) {
            ReleaseXmlDto release = new ReleaseXmlDto();
            release.setVersion(r.getVersion().getRawString());
            release.setDate(r.getDate());
            release.setDesc(r.getDescription());
            releases.add(release);
        }
        releases.sort((o1, o2) -> {
            if (o1.getDate() == null) {
                return -1;
            }
            if (o2.getDate() == null) {
                return 1;
            }
            return -1 * o1.getDate().compareTo(o2.getDate());
        });
        return releases;
    }

    private static List<DeletedRuleXmlDto> writeValidatorDeletedRuleHistories(Validator validator) {
        if (validator.getDeletedRuleHistories() == null || validator.getDeletedRuleHistories().isEmpty()) {
            return null;
        }
        ArrayList<DeletedRuleXmlDto> deletedRules = new ArrayList<DeletedRuleXmlDto>();
        for (DeletedRuleHistory history : validator.getDeletedRuleHistories()) {
            DeletedRuleXmlDto eventType = new DeletedRuleXmlDto();
            eventType.setId(history.getDeletedRuleId());
            eventType.setName(history.getDeletedRuleName());
            if (history.getVersion() != null) {
                eventType.setVersion(history.getVersion().getRawString());
            }
            eventType.setUser(history.getUsername());
            eventType.setValue(history.getMessage());
            eventType.setDate(history.getDate());
            eventType.setRef(history.getReference());
            eventType.setReplacedBy(history.getReplacedBy());
            deletedRules.add(eventType);
        }
        deletedRules.sort((o1, o2) -> {
            Calendar c1 = Calendar.getInstance();
            c1.setTime(o1.getDate());
            Calendar c2 = Calendar.getInstance();
            c2.setTime(o2.getDate());
            if (c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5)) {
                if (o1.getRef() != null && o2.getRef() != null && !o1.getRef().equals(o2.getRef())) {
                    return o1.getRef().compareTo(o2.getRef());
                }
                return o1.getId().compareTo(o2.getId());
            }
            return o1.getDate().compareTo(o2.getDate());
        });
        return deletedRules;
    }

    private static List<ContextEntryXmlDto> writeValidatorContext(Validator validator) {
        if (validator.getRawContext() == null || validator.getRawContext().isEmpty()) {
            return null;
        }
        ArrayList<ContextEntry> list = new ArrayList<ContextEntry>(validator.getRawContext());
        list.sort((o1, o2) -> o1.getKey().compareToIgnoreCase(o2.getKey()));
        ArrayList<ContextEntryXmlDto> contextEntries = new ArrayList<ContextEntryXmlDto>();
        for (ContextEntry contextEntry : list) {
            ContextEntryXmlDto contextEntryType = new ContextEntryXmlDto();
            contextEntryType.setId(contextEntry.getKey());
            contextEntryType.setValue(contextEntry.getExpression());
            contextEntryType.setType(contextEntry.getType());
            contextEntries.add(contextEntryType);
        }
        return contextEntries;
    }

    private static List<CategoryXmlDto> writeValidatorCategories(Validator validator) {
        if (validator.getCategories() == null || validator.getCategories().isEmpty()) {
            return null;
        }
        ArrayList<Category> list = new ArrayList<Category>();
        if (validator.getCategories() != null) {
            list.addAll(validator.getCategories());
        }
        list.sort((o1, o2) -> o1.getId().compareToIgnoreCase(o2.getId()));
        ArrayList<CategoryXmlDto> categoriesType = new ArrayList<CategoryXmlDto>();
        for (Category category : list) {
            CategoryXmlDto categoryType = new CategoryXmlDto();
            categoryType.setId(category.getId());
            categoryType.setName(category.getName());
            categoryType.setDescription(category.getDescription());
            categoriesType.add(categoryType);
        }
        return categoriesType;
    }

    private static List<ConditionXmlDto> writeValidatorConditions(Validator validator) {
        if (validator.getConditions() == null || validator.getConditions().isEmpty()) {
            return null;
        }
        ArrayList<Condition> list = new ArrayList<Condition>();
        if (validator.getConditions() != null) {
            list.addAll(validator.getConditions());
        }
        list.sort((o1, o2) -> o1.getId().compareToIgnoreCase(o2.getId()));
        ArrayList<ConditionXmlDto> conditionsType = new ArrayList<ConditionXmlDto>();
        for (Condition condition : list) {
            ConditionXmlDto conditionType = new ConditionXmlDto();
            conditionType.setId(condition.getId());
            conditionType.setName(condition.getName());
            conditionType.setJavaPath(condition.getJavaPath());
            conditionType.setExpression(ValidationXmlUtils.reAlign(condition.getExpression()));
            conditionType.setDescription(condition.getDescription());
            conditionsType.add(conditionType);
        }
        return conditionsType;
    }

    private static List<RuleXmlDto> writeValidatorRules(Validator validator) {
        if (validator.getRules() == null || validator.getRules().isEmpty()) {
            return null;
        }
        ArrayList<Rule> list = new ArrayList<Rule>(validator.getRules());
        list.sort((o1, o2) -> {
            String id1 = o1.getId();
            String id2 = o2.getId();
            Matcher m1 = _PATTERN_RULE_ID.matcher(id1);
            Matcher m2 = _PATTERN_RULE_ID.matcher(id2);
            if (m1.matches() && m2.matches()) {
                String prefix1 = m1.group(1);
                String prefix2 = m2.group(1);
                String integerPart1 = m1.group(2);
                String integerPart2 = m2.group(2);
                String suffix1 = m1.group(3);
                String suffix2 = m2.group(3);
                int result = prefix1.compareToIgnoreCase(prefix2);
                if (result == 0) {
                    Integer i2;
                    Integer i1 = Integer.valueOf(integerPart1);
                    result = i1.compareTo(i2 = Integer.valueOf(integerPart2));
                    if (result == 0) {
                        if (suffix1 == null) {
                            return -1;
                        }
                        if (suffix2 == null) {
                            return 1;
                        }
                        return suffix1.compareToIgnoreCase(suffix2);
                    }
                    return result;
                }
                return result;
            }
            return id1.toUpperCase().compareTo(id2.toUpperCase());
        });
        ArrayList<RuleXmlDto> rulesType = new ArrayList<RuleXmlDto>();
        for (Rule rule : list) {
            RuleXmlDto ruleType = new RuleXmlDto();
            if (rule.getDependencies() != null && !rule.getDependencies().isEmpty()) {
                ArrayList<String> sortedDep = new ArrayList<String>(rule.getDependencies());
                Collections.sort(sortedDep);
                StringBuilder buf = new StringBuilder();
                for (String dep : sortedDep) {
                    buf.append(dep).append(",");
                }
                buf.setLength(buf.length() - 1);
                ruleType.setDepends(buf.toString());
            }
            ruleType.setDescription(rule.getDescription());
            ruleType.setExpression(ValidationXmlUtils.reAlign(rule.getExpression()));
            ruleType.setId(rule.getId());
            ruleType.setMessage(rule.getMessage());
            ruleType.setName(rule.getName());
            ruleType.setTag(rule.getTag());
            ruleType.setJavaPath(rule.getJavaPath());
            ruleType.setCategory(rule.getCategory());
            if (rule.getConditions() != null && !rule.getConditions().isEmpty()) {
                StringBuilder condBuf = new StringBuilder();
                for (String c : rule.getConditions()) {
                    if (!c.isEmpty()) {
                        condBuf.append(Boolean.TRUE.equals(rule.getUseAndForConditions()) ? "&" : "|");
                    }
                    condBuf.append(c);
                }
                ruleType.setCondition(condBuf.toString());
            }
            if (rule.getSeverity() != null) {
                ruleType.setSeverity(rule.getSeverity());
            }
            ruleType.setAgency(rule.getAgency());
            if (rule.getHistories() != null && !rule.getHistories().isEmpty()) {
                ArrayList<HistoryEventXmlDto> sortedEvents = new ArrayList<HistoryEventXmlDto>();
                for (RuleHistory history : rule.getHistories()) {
                    HistoryEventXmlDto eventType = new HistoryEventXmlDto();
                    if (history.getVersion() != null) {
                        eventType.setVersion(history.getVersion().getRawString());
                    }
                    eventType.setUser(history.getUsername());
                    eventType.setValue(history.getMessage());
                    eventType.setDate(history.getDate());
                    eventType.setRef(history.getReference());
                    sortedEvents.add(eventType);
                }
                sortedEvents.sort((o1, o2) -> {
                    Calendar c1 = Calendar.getInstance();
                    c1.setTime(o1.getDate());
                    Calendar c2 = Calendar.getInstance();
                    c2.setTime(o2.getDate());
                    if (c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5)) {
                        if (o1.getRef() != null && o2.getRef() != null) {
                            return o1.getRef().compareTo(o2.getRef());
                        }
                        return o1.getUser().compareTo(o2.getUser());
                    }
                    return o1.getDate().compareTo(o2.getDate());
                });
                ruleType.setHistoryEvents(sortedEvents);
            }
            rulesType.add(ruleType);
        }
        return rulesType;
    }

    private static List<SetXmlDto> writeValidatorSets(Validator validator) {
        if (validator.getSets() == null || validator.getSets().isEmpty()) {
            return null;
        }
        ArrayList<EmbeddedSet> list = new ArrayList<EmbeddedSet>();
        if (validator.getSets() != null) {
            list.addAll(validator.getSets());
        }
        list.sort((o1, o2) -> o1.getId().compareToIgnoreCase(o2.getId()));
        ArrayList<SetXmlDto> setsType = new ArrayList<SetXmlDto>();
        for (EmbeddedSet set : list) {
            SetXmlDto setType = new SetXmlDto();
            setType.setId(set.getId());
            setType.setName(set.getName());
            setType.setTag(set.getTag());
            setType.setDescription(set.getDescription());
            ArrayList inclusions = new ArrayList(set.getInclusions() == null ? Collections.emptySet() : set.getInclusions());
            Collections.sort(inclusions);
            if (!inclusions.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (String s : inclusions) {
                    buf.append(s).append(",");
                }
                buf.setLength(buf.length() - 1);
                setType.setInclude(buf.toString());
            }
            ArrayList exclusions = new ArrayList(set.getExclusions() == null ? Collections.emptySet() : set.getExclusions());
            Collections.sort(exclusions);
            if (!exclusions.isEmpty()) {
                StringBuilder buf = new StringBuilder();
                for (String s : exclusions) {
                    buf.append(s).append(",");
                }
                buf.setLength(buf.length() - 1);
                setType.setExclude(buf.toString());
            }
            setsType.add(setType);
        }
        return setsType;
    }

    private static XStream createStandaloneSetXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StandaloneSetXmlDriver()){

            protected void setupConverters() {
                this.registerConverter((Converter)new NullConverter(), 10000);
                this.registerConverter((SingleValueConverter)new IntConverter(), 0);
                this.registerConverter((SingleValueConverter)new FloatConverter(), 0);
                this.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
                this.registerConverter((SingleValueConverter)new LongConverter(), 0);
                this.registerConverter((SingleValueConverter)new ShortConverter(), 0);
                this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
                this.registerConverter((SingleValueConverter)new ByteConverter(), 0);
                this.registerConverter((SingleValueConverter)new StringConverter(), 0);
                this.registerConverter((SingleValueConverter)new DateConverter(), 0);
                this.registerConverter((Converter)new CollectionConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new ReflectionConverter(this.getMapper(), this.getReflectionProvider()), -20);
            }
        };
        xstream.autodetectAnnotations(true);
        xstream.alias("set", StandaloneSetXmlDto.class);
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.validation.**"}));
        return xstream;
    }

    public static StandaloneSet loadStandaloneSetFromXml(File file) throws IOException {
        if (file == null) {
            throw new IOException("Unable to load standalone set, target file is null");
        }
        if (!file.exists()) {
            throw new IOException("Unable to load standalone set, target file doesn't exist");
        }
        try (InputStream is = file.getName().toLowerCase().endsWith(".gz") ? new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])) : Files.newInputStream(file.toPath(), new OpenOption[0]);){
            StandaloneSet standaloneSet = ValidationXmlUtils.loadStandaloneSetFromXml(is);
            return standaloneSet;
        }
    }

    public static StandaloneSet loadStandaloneSetFromXml(URL url) throws IOException {
        if (url == null) {
            throw new IOException("Unable to load standalone set, target URL is null");
        }
        try (InputStream is = url.getPath().toLowerCase().endsWith(".gz") ? new GZIPInputStream(url.openStream()) : url.openStream();){
            StandaloneSet standaloneSet = ValidationXmlUtils.loadStandaloneSetFromXml(is);
            return standaloneSet;
        }
    }

    public static StandaloneSet loadStandaloneSetFromXml(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Unable to load standalone set, target input stream is null");
        }
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            StandaloneSet standaloneSet = ValidationXmlUtils.loadStandaloneSetFromXml(reader);
            return standaloneSet;
        }
    }

    public static StandaloneSet loadStandaloneSetFromXml(Reader reader) throws IOException {
        if (reader == null) {
            throw new IOException("Unable to load standalone set, target reader is null");
        }
        try {
            StandaloneSetXmlDto setType = (StandaloneSetXmlDto)ValidationXmlUtils.createStandaloneSetXStream().fromXML(reader);
            StandaloneSet set = new StandaloneSet();
            if (setType.getId() == null) {
                throw new IOException("Set ID is required");
            }
            set.setId(setType.getId());
            set.setName(setType.getName());
            set.setDescription(ValidationXmlUtils.reAlign(setType.getDesc()));
            for (StandaloneSetValidatorXmlDto validatorType : setType.getValidators()) {
                HashMap<String, List<String>> inclusions = new HashMap<String, List<String>>();
                if (validatorType.getId() == null) {
                    throw new IOException("Validator ID is required");
                }
                set.addReferencedValidatorId(validatorType.getId());
                String include = validatorType.getInclude();
                if (include != null && !include.trim().isEmpty()) {
                    ArrayList<String> inc = new ArrayList<String>();
                    for (String s : StringUtils.split((String)include, (char)',')) {
                        inc.add(s.trim());
                    }
                    inclusions.put(validatorType.getId(), inc);
                }
                set.setInclusions(inclusions);
                HashMap<String, List<String>> exclusions = new HashMap<String, List<String>>();
                String exclude = validatorType.getExclude();
                if (exclude != null && !exclude.trim().isEmpty()) {
                    ArrayList<String> exc = new ArrayList<String>();
                    for (String s : StringUtils.split((String)exclude, (char)',')) {
                        exc.add(s.trim());
                    }
                    exclusions.put(validatorType.getId(), exc);
                }
                set.setExclusions(exclusions);
            }
            return set;
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to construct new standalone set instance", e);
        }
    }

    public static void writeStandaloneSetToXml(StandaloneSet set, File file) throws IOException {
        if (file == null) {
            throw new IOException("Unable to write set '" + set.getId() + "', target file is null");
        }
        try (OutputStream os = file.getName().toLowerCase().endsWith(".gz") ? new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])) : Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ValidationXmlUtils.writeStandaloneSetToXml(set, os);
        }
    }

    public static void writeStandaloneSetToXml(StandaloneSet set, OutputStream os) throws IOException {
        if (os == null) {
            throw new IOException("Unable to write set '" + set.getId() + "', target output stream is null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            ValidationXmlUtils.writeStandaloneSetToXml(set, writer);
        }
    }

    public static void writeStandaloneSetToXml(StandaloneSet set, Writer writer) throws IOException {
        if (set == null) {
            throw new IOException("Unable to write NULL set");
        }
        if (writer == null) {
            throw new IOException("Unable to write set '" + set.getId() + "', target writer is null");
        }
        try {
            StandaloneSetXmlDto setType = new StandaloneSetXmlDto();
            setType.setId(set.getId());
            setType.setName(set.getName());
            setType.setDesc(set.getDescription());
            TreeSet<String> validatorIds = new TreeSet<String>();
            if (set.getInclusions() != null) {
                validatorIds.addAll(set.getInclusions().keySet());
            }
            if (set.getExclusions() != null && !set.getExclusions().isEmpty()) {
                validatorIds.addAll(set.getExclusions().keySet());
            }
            ArrayList<StandaloneSetValidatorXmlDto> validators = new ArrayList<StandaloneSetValidatorXmlDto>();
            for (String validatorId : validatorIds) {
                StringBuilder buf;
                List<String> exclusions;
                StandaloneSetValidatorXmlDto validatorType = new StandaloneSetValidatorXmlDto();
                validatorType.setId(validatorId);
                List<String> inclusions = set.getInclusions() == null ? null : set.getInclusions().get(validatorId);
                List<String> list = exclusions = set.getExclusions() == null ? null : set.getExclusions().get(validatorId);
                if (inclusions != null && !inclusions.isEmpty()) {
                    buf = new StringBuilder();
                    for (String s : inclusions) {
                        buf.append(s).append(",");
                    }
                    buf.setLength(buf.length() - 1);
                    validatorType.setInclude(buf.toString());
                }
                if (exclusions != null && !exclusions.isEmpty()) {
                    buf = new StringBuilder();
                    for (String s : exclusions) {
                        buf.append(s).append(",");
                    }
                    buf.setLength(buf.length() - 1);
                    validatorType.setExclude(buf.toString());
                }
                validators.add(validatorType);
            }
            setType.setValidators(validators);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(System.lineSeparator());
            ValidationXmlUtils.createStandaloneSetXStream().toXML((Object)setType, writer);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private static XStream createTestsXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new TestsXmlDriver()){

            protected void setupConverters() {
                this.registerConverter((Converter)new NullConverter(), 10000);
                this.registerConverter((SingleValueConverter)new IntConverter(), 0);
                this.registerConverter((SingleValueConverter)new FloatConverter(), 0);
                this.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
                this.registerConverter((SingleValueConverter)new LongConverter(), 0);
                this.registerConverter((SingleValueConverter)new ShortConverter(), 0);
                this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
                this.registerConverter((SingleValueConverter)new ByteConverter(), 0);
                this.registerConverter((SingleValueConverter)new StringConverter(), 0);
                this.registerConverter((SingleValueConverter)new DateConverter(), 0);
                this.registerConverter((Converter)new CollectionConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new ReflectionConverter(this.getMapper(), this.getReflectionProvider()), -20);
            }
        };
        xstream.autodetectAnnotations(true);
        xstream.alias("tested-validator", TestedValidatorXmlDto.class);
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.validation.**"}));
        return xstream;
    }

    public static ValidatorTests loadTestsFromXml(File file) throws IOException {
        if (file == null) {
            throw new IOException("Unable to load tests suite, target file is null");
        }
        if (!file.exists()) {
            throw new IOException("Unable to load tests suite, target file doesn't exist");
        }
        try (InputStream is = file.getName().toLowerCase().endsWith(".gz") ? new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])) : Files.newInputStream(file.toPath(), new OpenOption[0]);){
            ValidatorTests validatorTests = ValidationXmlUtils.loadTestsFromXml(is);
            return validatorTests;
        }
    }

    public static ValidatorTests loadTestsFromXml(URL url) throws IOException {
        if (url == null) {
            throw new IOException("Unable to load tests suite, target URL is null");
        }
        try (InputStream is = url.getPath().toLowerCase().endsWith(".gz") ? new GZIPInputStream(url.openStream()) : url.openStream();){
            ValidatorTests validatorTests = ValidationXmlUtils.loadTestsFromXml(is);
            return validatorTests;
        }
    }

    public static ValidatorTests loadTestsFromXml(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Unable to load tests suite, target input stream is null");
        }
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            ValidatorTests validatorTests = ValidationXmlUtils.loadTestsFromXml(reader);
            return validatorTests;
        }
    }

    public static ValidatorTests loadTestsFromXml(Reader reader) throws IOException {
        if (reader == null) {
            throw new IOException("Unable to load test suites, target reader is null");
        }
        try {
            TestedValidatorXmlDto validatorTestsType = (TestedValidatorXmlDto)ValidationXmlUtils.createTestsXStream().fromXML(reader);
            ValidatorTests validatorTests = new ValidatorTests();
            validatorTests.setTestedValidatorId(validatorTestsType.getId());
            HashMap<String, RuleTest> tests = new HashMap<String, RuleTest>();
            for (TestXmlDto testType : validatorTestsType.getTest()) {
                RuleTest test = new RuleTest();
                test.setTestedRuleId(testType.getTestId());
                test.setScriptText(ValidationXmlUtils.reAlign(testType.getScript()));
                tests.put(test.getTestedRuleId(), test);
            }
            validatorTests.setTests(tests);
            return validatorTests;
        }
        catch (RuntimeException e) {
            throw new IOException("Unable to construct new tests suite instance", e);
        }
    }

    public static void writeTestsToXml(ValidatorTests tests, File file) throws IOException {
        if (file == null) {
            throw new IOException("Unable to tests suite for '" + tests.getTestedValidatorId() + "', target file is null");
        }
        try (OutputStream os = file.getName().toLowerCase().endsWith(".gz") ? new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])) : Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ValidationXmlUtils.writeTestsToXml(tests, os);
        }
    }

    public static void writeTestsToXml(ValidatorTests tests, OutputStream os) throws IOException {
        if (os == null) {
            throw new IOException("Unable to write tests suite for '" + tests.getTestedValidatorId() + "', target output stream is null");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            ValidationXmlUtils.writeTestsToXml(tests, writer);
        }
    }

    public static void writeTestsToXml(ValidatorTests tests, Writer writer) throws IOException {
        if (tests == null) {
            throw new IOException("Unable to write NULL tests suite");
        }
        if (writer == null) {
            throw new IOException("Unable to write tests suite for '" + tests.getTestedValidatorId() + "', target writer is null");
        }
        try {
            TestedValidatorXmlDto validatorType = new TestedValidatorXmlDto();
            validatorType.setId(tests.getTestedValidatorId());
            if (tests.getTests() != null) {
                ArrayList<RuleTest> sortedTests = new ArrayList<RuleTest>(tests.getTests().values());
                sortedTests.sort((o1, o2) -> {
                    String id1 = o1.getTestedRuleId();
                    String id2 = o2.getTestedRuleId();
                    Matcher m1 = _PATTERN_RULE_ID.matcher(id1);
                    Matcher m2 = _PATTERN_RULE_ID.matcher(id2);
                    if (m1.matches() && m2.matches()) {
                        String prefix1 = m1.group(1);
                        String prefix2 = m2.group(1);
                        String integerPart1 = m1.group(2);
                        String integerPart2 = m2.group(2);
                        String suffix1 = m1.group(3);
                        String suffix2 = m2.group(3);
                        int result = prefix1.compareToIgnoreCase(prefix2);
                        if (result == 0) {
                            Integer i2;
                            Integer i1 = Integer.valueOf(integerPart1);
                            result = i1.compareTo(i2 = Integer.valueOf(integerPart2));
                            if (result == 0) {
                                if (suffix1 == null) {
                                    return -1;
                                }
                                if (suffix2 == null) {
                                    return 1;
                                }
                                return suffix1.compareToIgnoreCase(suffix2);
                            }
                            return result;
                        }
                        return result;
                    }
                    return id1.toUpperCase().compareTo(id2.toUpperCase());
                });
                ArrayList<TestXmlDto> testList = new ArrayList<TestXmlDto>();
                for (RuleTest test : sortedTests) {
                    TestXmlDto testType = new TestXmlDto();
                    testType.setTestId(test.getTestedRuleId());
                    testType.setScript(test.getScriptText());
                    testList.add(testType);
                }
                validatorType.setTest(testList);
            }
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.write(System.lineSeparator());
            ValidationXmlUtils.createTestsXStream().toXML((Object)validatorType, writer);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public static void enableRealignment() {
        _REALIGNMENT_ENABLED = true;
    }

    public static void disableRealignment() {
        _REALIGNMENT_ENABLED = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean targetValidatorXmlExists(URL url) {
        if (url == null) {
            return false;
        }
        try (InputStream is = url.openStream();){
            if (is != null) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException | RuntimeException e) {
            return false;
        }
    }

    public static Map<String, String> getXmlValidatorRootAttributes(URL url) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (url == null) {
            return result;
        }
        Pattern regex1 = Pattern.compile("<validator\\s++([^>]++)>", 40);
        Pattern regex2 = Pattern.compile("(id|name|version|min-engine-version|translated-from)\\s*+=\\s*+['\"]([^'\"]+?)['\"]", 40);
        boolean gzipped = url.getPath().toLowerCase().endsWith(".gz") || url.getPath().toLowerCase().endsWith(".gzip");
        try (InputStream is = gzipped ? new GZIPInputStream(url.openStream()) : url.openStream();){
            byte[] bytes = new byte[1024];
            int n = is.read(bytes);
            while (n > 0) {
                String line = new String(bytes, 0, n, StandardCharsets.UTF_8);
                if (StringUtils.contains((CharSequence)line, (CharSequence)"<validator")) {
                    Matcher m1 = regex1.matcher(line);
                    if (m1.find()) {
                        Matcher m2 = regex2.matcher(m1.group(1).trim().replaceAll("\r?\n", ""));
                        while (m2.find()) {
                            result.put(m2.group(1), m2.group(2));
                        }
                    } else {
                        n = is.read(bytes);
                        m1 = regex1.matcher(line + new String(bytes, 0, n, StandardCharsets.UTF_8));
                        if (m1.find()) {
                            Matcher m2 = regex2.matcher(m1.group(1).trim().replaceAll("\r?\n", ""));
                            while (m2.find()) {
                                result.put(m2.group(1), m2.group(2));
                            }
                        }
                    }
                    break;
                }
                n = is.read(bytes);
            }
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        return result;
    }

    public static String getXmlValidatorHash(URL url) {
        String result;
        if (url == null) {
            return null;
        }
        boolean gzipped = url.getPath().toLowerCase().endsWith(".gz") || url.getPath().toLowerCase().endsWith(".gzip");
        try (InputStream is = gzipped ? new GZIPInputStream(url.openStream()) : url.openStream();){
            result = Hex.encodeHexString((byte[])DigestUtils.updateDigest((MessageDigest)DigestUtils.getDigest((String)"SHA-1"), (InputStream)is).digest());
        }
        catch (IOException | RuntimeException e) {
            return null;
        }
        return result;
    }

    public static String getXmlValidatorId(URL url) {
        return ValidationXmlUtils.getXmlValidatorRootAttributes(url).get(ROOT_ATTR_ID);
    }

    public static String getXmlValidatorName(URL url) {
        return ValidationXmlUtils.getXmlValidatorRootAttributes(url).get(ROOT_ATTR_NAME);
    }

    public static String getXmlValidatorVersion(URL url) {
        return ValidationXmlUtils.getXmlValidatorRootAttributes(url).get(ROOT_ATTR_VERSION);
    }

    public static String trimEmptyLines(String s, boolean trim) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        if (_REALIGNMENT_ENABLED) {
            s = _PATTERN_TAB.matcher((CharSequence)s).replaceAll("    ");
            s = _CONTROL_CHARACTERS_PATTERN.matcher((CharSequence)s).replaceAll("");
            if (!trim) {
                StringBuilder spacesBuffer = new StringBuilder();
                for (int i = 0; i < ((String)s).length() && ((String)s).charAt(i) == ' '; ++i) {
                    spacesBuffer.append(" ");
                }
                s = ((String)s).trim();
                if (spacesBuffer.length() > 0) {
                    s = String.valueOf(spacesBuffer) + (String)s;
                }
            }
        }
        if (trim) {
            s = ((String)s).trim();
        }
        return s;
    }

    public static String reAlign(String toAlign) {
        if (StringUtils.isBlank((CharSequence)toAlign)) {
            return null;
        }
        if (_REALIGNMENT_ENABLED) {
            String s = ValidationXmlUtils.trimEmptyLines(toAlign, false);
            int extraSpaces = Integer.MAX_VALUE;
            try {
                LineNumberReader reader = new LineNumberReader(new StringReader(s));
                String line = reader.readLine();
                while (line != null) {
                    int numSpaces = 0;
                    if (!line.trim().isEmpty()) {
                        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
                            ++numSpaces;
                        }
                        extraSpaces = Math.min(extraSpaces, numSpaces);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException | RuntimeException e) {
                return s;
            }
            if (extraSpaces == 0 || extraSpaces == Integer.MAX_VALUE) {
                return StringUtils.trim((String)s);
            }
            StringBuilder result = new StringBuilder();
            try {
                LineNumberReader reader = new LineNumberReader(new StringReader(s));
                String line = reader.readLine();
                while (line != null) {
                    if (!line.trim().isEmpty()) {
                        result.append(line.substring(extraSpaces)).append("\n");
                    } else {
                        result.append("\n");
                    }
                    line = reader.readLine();
                }
                result.setLength(result.length() - 1);
            }
            catch (Exception e) {
                return s;
            }
            return result.toString().trim();
        }
        return toAlign;
    }
}

