/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.entities;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.RuleHistory;
import com.imsweb.validation.entities.Validator;
import com.imsweb.validation.runtime.ParsedContexts;
import com.imsweb.validation.runtime.ParsedLookups;
import com.imsweb.validation.runtime.ParsedProperties;
import com.imsweb.validation.runtime.RuntimeUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilationFailedException;

public class Rule {
    private static final Pattern _MESSAGE_PATTERN = Pattern.compile("\r?\n");
    protected Long _ruleId;
    protected String _id;
    protected String _name;
    protected String _tag;
    protected String _javaPath;
    protected Integer _severity;
    protected String _message;
    protected String _expression;
    protected String _description;
    protected Set<RuleHistory> _histories;
    protected Validator _validator;
    protected String _category;
    protected Set<String> _conditions = new HashSet<String>();
    protected Boolean _useAndForConditions;
    protected Set<String> _dependencies;
    protected Set<String> _invertedDependencies;
    protected Set<String> _usedProperties;
    protected Set<String> _usedLookupIds;
    protected Set<String> _usedContextKeys;
    protected Boolean _ignored;
    protected String _agency;
    protected Byte _allowOverride;
    protected Boolean _needsReview;
    protected Byte _importEditFlag;
    protected List<Long> _dataEntryTypes;
    protected Byte _dataLevel;

    public Rule() {
        this._histories = new HashSet<RuleHistory>();
        this._dependencies = new HashSet<String>();
        this._invertedDependencies = new HashSet<String>();
        this._usedProperties = new HashSet<String>();
        this._usedLookupIds = new HashSet<String>();
        this._usedContextKeys = new HashSet<String>();
        this._ignored = Boolean.FALSE;
        this._useAndForConditions = Boolean.TRUE;
        this._needsReview = Boolean.FALSE;
    }

    public Long getRuleId() {
        return this._ruleId;
    }

    public void setRuleId(Long ruleId) {
        this._ruleId = ruleId;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getTag() {
        return this._tag;
    }

    public void setTag(String tag) {
        this._tag = tag;
    }

    public String getJavaPath() {
        return this._javaPath;
    }

    public void setJavaPath(String path) {
        this._javaPath = path;
    }

    public Integer getSeverity() {
        return this._severity;
    }

    public void setSeverity(Integer severity) {
        this._severity = severity;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        if (message != null) {
            message = _MESSAGE_PATTERN.matcher(message).replaceAll(" ").trim();
        }
        this._message = message;
    }

    public String getExpression() {
        return this._expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpression(String expression) throws ConstructionException {
        if (!Objects.equals(expression, this._expression)) {
            this._expression = expression;
            Rule rule = this;
            synchronized (rule) {
                try {
                    this._usedProperties.clear();
                    this._usedContextKeys.clear();
                    this._usedLookupIds.clear();
                    ValidationServices.getInstance().parseExpression("rule", this._expression, this._usedProperties, this._usedContextKeys, this._usedLookupIds);
                }
                catch (CompilationFailedException e) {
                    throw new ConstructionException("Unable to parse rule " + this.getId(), e);
                }
            }
        }
    }

    public void setExpression(String expression, ParsedProperties parsedProperties, ParsedContexts parsedContexts, ParsedLookups parsedLookups) throws ConstructionException {
        Set<String> properties = RuntimeUtils.getParsedProperties(parsedProperties, this._id);
        Set<String> contexts = RuntimeUtils.getParsedContexts(parsedContexts, this._id);
        Set<String> lookups = RuntimeUtils.getParsedLookups(parsedLookups, this._id);
        if (properties != null && contexts != null && lookups != null) {
            this._expression = expression;
            this._usedProperties = properties;
            this._usedContextKeys = contexts;
            this._usedLookupIds = lookups;
        } else {
            this.setExpression(expression);
        }
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public Set<RuleHistory> getHistories() {
        return this._histories;
    }

    public void setHistories(Set<RuleHistory> histories) {
        this._histories = histories == null ? new HashSet() : histories;
    }

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public Set<String> getConditions() {
        return this._conditions;
    }

    public void setConditions(Set<String> conditions) {
        this._conditions = conditions;
    }

    public Set<String> getUsedProperties() {
        return this._usedProperties;
    }

    public void setUsedProperties(Set<String> usedProperties) {
        this._usedProperties = usedProperties;
    }

    public Set<String> getUsedLookupIds() {
        return this._usedLookupIds;
    }

    public void setUsedLookupIds(Set<String> usedLookupIds) {
        this._usedLookupIds = usedLookupIds;
    }

    public Set<String> getDependencies() {
        return this._dependencies;
    }

    public void setDependencies(Set<String> dependencies) {
        this._dependencies = dependencies == null ? new HashSet() : dependencies;
    }

    public Set<String> getInvertedDependencies() {
        return this._invertedDependencies;
    }

    public void setInvertedDependencies(Set<String> invertedDependencies) {
        this._invertedDependencies = invertedDependencies == null ? new HashSet() : invertedDependencies;
    }

    public void setValidator(Validator validator) {
        this._validator = validator;
    }

    public Validator getValidator() {
        return this._validator;
    }

    public Boolean getIgnored() {
        return this._ignored;
    }

    public void setIgnored(Boolean ignored) {
        this._ignored = ignored == null ? Boolean.FALSE : ignored;
    }

    public Boolean getUseAndForConditions() {
        return this._useAndForConditions;
    }

    public void setUseAndForConditions(Boolean useAndForConditions) {
        this._useAndForConditions = useAndForConditions == null ? Boolean.TRUE : useAndForConditions;
    }

    public Set<String> getUsedContextKeys() {
        return this._usedContextKeys;
    }

    public void setUsedContextKeys(Set<String> usedContextKeys) {
        this._usedContextKeys = usedContextKeys;
    }

    public String getAgency() {
        return this._agency;
    }

    public void setAgency(String agency) {
        this._agency = agency;
    }

    public Byte getAllowOverride() {
        return this._allowOverride;
    }

    public void setAllowOverride(Byte allowOverride) {
        this._allowOverride = allowOverride;
    }

    public Boolean getNeedsReview() {
        return this._needsReview;
    }

    public void setNeedsReview(Boolean needsReview) {
        this._needsReview = needsReview;
    }

    public Byte getImportEditFlag() {
        return this._importEditFlag;
    }

    public void setImportEditFlag(Byte importEditFlag) {
        this._importEditFlag = importEditFlag;
    }

    public List<Long> getDataEntryTypes() {
        return this._dataEntryTypes;
    }

    public void setDataEntryTypes(List<Long> dataEntryTypes) {
        this._dataEntryTypes = dataEntryTypes;
    }

    public Byte getDataLevel() {
        return this._dataLevel;
    }

    public void setDataLevel(Byte dataLevel) {
        this._dataLevel = dataLevel;
    }

    public String toString() {
        return this.getId() + " {" + this.getMessage() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule rule = (Rule)o;
        if (this._ruleId != null && rule._ruleId != null) {
            return Objects.equals(this._ruleId, rule._ruleId);
        }
        return Objects.equals(this._id, rule._id);
    }

    public int hashCode() {
        if (this._ruleId != null) {
            return Objects.hash(this._ruleId);
        }
        return Objects.hash(this._id);
    }
}

