/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.entities;

import com.imsweb.validation.ValidationContextFunctions;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.Rule;
import com.imsweb.validation.entities.RuleTestResult;
import com.imsweb.validation.functions.TestingContextFunctions;
import groovy.lang.Binding;
import groovy.lang.Script;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RuleTest {
    protected String _testedRuleId;
    protected String _scriptText;
    protected String _translatedScriptText;
    protected Map<Integer, Boolean> _assertions;

    public void setTestedRuleId(String testedRuleId) {
        this._testedRuleId = testedRuleId;
    }

    public void setScriptText(String scriptText) throws IOException {
        this._scriptText = scriptText;
        this._translatedScriptText = scriptText;
        this._assertions = new HashMap<Integer, Boolean>();
        if (scriptText != null && !scriptText.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            LineNumberReader reader = new LineNumberReader(new StringReader(scriptText));
            String line = reader.readLine();
            while (line != null) {
                int count = StringUtils.countMatches((CharSequence)line, (CharSequence)"Testing.assert");
                if (count > 1) {
                    throw new IOException("Line " + reader.getLineNumber() + " contains several assertions!");
                }
                if (count > 0) {
                    int lineNum = reader.getLineNumber();
                    if (line.contains("Testing.assertPass")) {
                        line = line.replace("Testing.assertPass(", "Testing.assertPass(" + lineNum + ", ");
                        this._assertions.put(lineNum, Boolean.TRUE);
                    } else {
                        line = line.replace("Testing.assertFail(", "Testing.assertFail(" + lineNum + ", ");
                        this._assertions.put(lineNum, Boolean.FALSE);
                    }
                }
                buf.append(line).append("\n");
                line = reader.readLine();
            }
            this._translatedScriptText = buf.toString();
        }
    }

    public String getTestedRuleId() {
        return this._testedRuleId;
    }

    public String getScriptText() {
        return this._scriptText;
    }

    public Map<Integer, Boolean> getAssertions() {
        return this._assertions;
    }

    public Map<Integer, List<RuleTestResult>> executeTest() {
        return this.executeTest(new TestingContextFunctions(this, null), null);
    }

    public Map<Integer, List<RuleTestResult>> executeTest(Rule rule) {
        return this.executeTest(new TestingContextFunctions(this, rule), rule);
    }

    public Map<Integer, List<RuleTestResult>> executeTest(TestingContextFunctions context) {
        return this.executeTest(context, null);
    }

    public Map<Integer, List<RuleTestResult>> executeTest(TestingContextFunctions context, Rule rule) {
        if (context == null) {
            context = new TestingContextFunctions(this, rule);
        }
        Script script = ValidationServices.getInstance().compileExpression(this._translatedScriptText);
        Binding binding = new Binding();
        binding.setVariable("Testing", (Object)context);
        binding.setVariable("Functions", (Object)ValidationContextFunctions.getInstance());
        script.setBinding(binding);
        script.run();
        return context.getTestsResults();
    }
}

