/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.entities;

import com.imsweb.validation.ValidationException;
import com.imsweb.validation.entities.RuleFailure;
import com.imsweb.validation.functions.TestingContextFunctions;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RuleTestResult {
    protected Integer _lineNumber;
    protected Integer _assertionIndex;
    protected TestingContextFunctions.AssertionType _assertionType;
    protected Set<String> _assertedFailingProperties;
    protected Boolean _isSuccess;
    protected RuleFailure _ruleFailure;
    protected Object _values;
    protected Map<String, Object> _contextValues;
    protected ValidationException _validationException;
    protected List<String> _log;

    public RuleTestResult(int lineNum, int idx, TestingContextFunctions.AssertionType type, boolean success, RuleFailure failure, Object values, Map<String, Object> contextValues, ValidationException exc, Set<String> f, List<String> l) {
        this._lineNumber = lineNum;
        this._assertionIndex = idx;
        this._assertionType = type;
        this._isSuccess = success;
        this._ruleFailure = failure;
        this._values = values;
        this._contextValues = contextValues;
        this._validationException = exc;
        this._assertedFailingProperties = f;
        this._log = l;
    }

    public Integer getLineNumber() {
        return this._lineNumber;
    }

    public Integer getAssertionIndex() {
        return this._assertionIndex;
    }

    public TestingContextFunctions.AssertionType getAssertionType() {
        return this._assertionType;
    }

    public Set<String> getAssertedFailingProperties() {
        return this._assertedFailingProperties;
    }

    public Boolean isSuccess() {
        return this._isSuccess;
    }

    public RuleFailure getRuleFailure() {
        return this._ruleFailure;
    }

    public Object getValues() {
        return this._values;
    }

    public Map<String, Object> getContextValues() {
        return this._contextValues;
    }

    public ValidationException getValidationException() {
        return this._validationException;
    }

    public List<String> getOutput() {
        return this._log;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RuleTestResult)) {
            return false;
        }
        RuleTestResult other = (RuleTestResult)obj;
        return Objects.equals(this._assertionIndex, other.getAssertionIndex()) && Objects.equals(this._lineNumber, other.getLineNumber());
    }

    public int hashCode() {
        return Objects.hash(this._assertionIndex, this._lineNumber);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Line ").append(this._lineNumber).append(" (Iteration #").append(this._assertionIndex).append("): ");
        if (this._validationException != null) {
            buf.append("ENGINE EXCEPTION - ").append(this._validationException.getMessage());
        } else if (this._ruleFailure != null && this._ruleFailure.getGroovyException() != null) {
            buf.append("EDIT EXCEPTION - ").append(this._ruleFailure.getGroovyException().getMessage());
        } else if (Boolean.TRUE.equals(this._isSuccess)) {
            buf.append("SUCCESS");
        } else if (this._assertionType == TestingContextFunctions.AssertionType.PASS) {
            buf.append("FAILURE - ").append("expected edit to PASS but it FAILED");
        } else if (this._ruleFailure == null) {
            buf.append("FAILURE - ").append("expected edit to FAIL but it PASSED");
        } else {
            HashSet<String> propertiesNotFound = new HashSet<String>();
            for (String prop : this._ruleFailure.getProperties()) {
                if (this._assertedFailingProperties.contains(prop)) continue;
                propertiesNotFound.add(prop);
            }
            buf.append("FAILURE - ").append("expected following ");
            if (propertiesNotFound.size() == 1) {
                buf.append("property");
            } else {
                buf.append("properties");
            }
            buf.append("to be in the failing properties, but didn't find it; got ").append(this._ruleFailure.getProperties());
        }
        return buf.toString();
    }
}

