/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.entities;

import com.imsweb.staging.entities.Schema;
import com.imsweb.validation.ValidationContextFunctions;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.Validatable;
import com.imsweb.validation.functions.StagingContextFunctions;
import com.imsweb.validation.internal.ExtraPropertyEntityHandlerDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;

public class SimpleNaaccrLinesValidatable
implements Validatable {
    public static final String ROOT_PREFIX = "lines";
    public static final String ROOT_PREFIX_UNTRIMMED = "untrimmedlines";
    protected final String _prefix;
    protected final String _alias;
    protected final List<Map<String, String>> _lines;
    protected final Map<String, Object> _context;
    protected final Map<String, String> _currentLine;
    protected final SimpleNaaccrLinesValidatable _parent;
    protected final Map<String, String> _prefixes;
    protected final Map<String, Object> _scopes;
    protected final Set<String> _propertiesWithError;
    protected final boolean _useUntrimmedNotation;

    public SimpleNaaccrLinesValidatable(Map<String, String> map) {
        this(Collections.singletonList(map), null);
    }

    public SimpleNaaccrLinesValidatable(Map<String, String> map, boolean useUntrimmedNotation) {
        this(Collections.singletonList(map), null, useUntrimmedNotation);
    }

    public SimpleNaaccrLinesValidatable(List<Map<String, String>> list) {
        this(list, null);
    }

    public SimpleNaaccrLinesValidatable(List<Map<String, String>> list, boolean useUntrimmedNotation) {
        this(list, null, useUntrimmedNotation);
    }

    public SimpleNaaccrLinesValidatable(List<Map<String, String>> list, Map<String, Object> context) {
        this(list, context, false);
    }

    public SimpleNaaccrLinesValidatable(List<Map<String, String>> list, Map<String, Object> context, boolean useUntrimmedNotation) {
        String rootPrefix;
        if (list == null) {
            throw new IllegalStateException("wrapped entity cannot be null");
        }
        this._prefix = rootPrefix = useUntrimmedNotation ? ROOT_PREFIX_UNTRIMMED : ROOT_PREFIX;
        this._alias = rootPrefix;
        this._lines = list;
        this._currentLine = null;
        this._parent = null;
        this._prefixes = Collections.singletonMap(rootPrefix, rootPrefix);
        this._scopes = new HashMap<String, List<Map<String, String>>>(Collections.singletonMap(rootPrefix, list));
        this._propertiesWithError = new HashSet<String>();
        this._context = context;
        this._useUntrimmedNotation = useUntrimmedNotation;
    }

    private SimpleNaaccrLinesValidatable(SimpleNaaccrLinesValidatable parent, String prefix, Map<String, String> map, Map<String, Object> context, boolean useUntrimmedNotation) {
        this._prefix = prefix;
        this._alias = ValidationServices.getInstance().getAliasForJavaPath(prefix.replaceAll("\\[\\d+]", ""));
        this._lines = null;
        this._currentLine = map;
        this._parent = parent;
        this._prefixes = new HashMap<String, String>(this._parent.getPrefixes());
        this._prefixes.put(this._alias, prefix);
        this._scopes = new HashMap<String, Object>(this._parent.getScope());
        this._scopes.put(this._alias, map);
        this._propertiesWithError = new HashSet<String>();
        this._context = context;
        this._useUntrimmedNotation = useUntrimmedNotation;
        if (ValidationContextFunctions.getInstance() instanceof StagingContextFunctions) {
            Schema schema;
            boolean hasCsSchemaId = this._currentLine.containsKey("_csSchemaId");
            boolean hasTnmSchemaId = this._currentLine.containsKey("_tnmSchemaId");
            boolean hasEodSchemaId = this._currentLine.containsKey("_eodSchemaId");
            boolean hasSite = this._currentLine.containsKey("primarySite");
            boolean hasHist = this._currentLine.containsKey("histologicTypeIcdO3");
            if (!hasTnmSchemaId || hasSite || hasHist) {
                schema = ((StagingContextFunctions)ValidationContextFunctions.getInstance()).getTnmStagingSchema(this._currentLine);
                this._currentLine.put("_tnmSchemaId", schema != null ? schema.getId() : null);
            }
            if (!hasCsSchemaId || hasSite || hasHist) {
                schema = ((StagingContextFunctions)ValidationContextFunctions.getInstance()).getCsStagingSchema(this._currentLine);
                this._currentLine.put("_csSchemaId", schema != null ? schema.getId() : null);
            }
            if (!hasEodSchemaId || hasSite || hasHist) {
                schema = ((StagingContextFunctions)ValidationContextFunctions.getInstance()).getEodStagingSchema(this._currentLine);
                this._currentLine.put("_eodSchemaId", schema != null ? schema.getId() : null);
            }
        }
    }

    @Override
    public List<Validatable> followCollection(String collection) throws IllegalAccessException {
        ArrayList<Validatable> result = new ArrayList<Validatable>();
        if (!"line".equals(collection) && !"untrimmedline".equals(collection) || this._lines == null) {
            throw new IllegalAccessException("This validatable can only work with a single collection called 'line' or 'untrimmedline'");
        }
        for (int i = 0; i < this._lines.size(); ++i) {
            result.add(new SimpleNaaccrLinesValidatable(this, this._prefix + "." + collection + "[" + i + "]", this._lines.get(i), this._context, this._useUntrimmedNotation));
        }
        return result;
    }

    @Override
    public String getDisplayId() {
        Object result = "?";
        if (this._currentLine != null && (result = this._currentLine.get("patientIdNumber")) != null) {
            String tumRecNum = this._currentLine.get("tumorRecordNumber");
            if (tumRecNum != null) {
                result = (String)result + "/" + tumRecNum;
            } else {
                String seqNum = this._currentLine.get("sequenceNumberCentral");
                if (seqNum != null) {
                    result = (String)result + "/" + seqNum;
                }
            }
        }
        return result == null ? "?" : result;
    }

    @Override
    public Long getCurrentTumorId() {
        if (this._currentLine == null) {
            return null;
        }
        String lineNumber = this._currentLine.get("_lineNumber");
        if (lineNumber != null) {
            return Long.valueOf(lineNumber);
        }
        String tumorRecordNumber = this._currentLine.get("tumorRecordNumber");
        if (NumberUtils.isDigits((String)tumorRecordNumber)) {
            return Long.valueOf(tumorRecordNumber);
        }
        String sequenceNumberCentral = this._currentLine.get("sequenceNumberCentral");
        if (NumberUtils.isDigits((String)sequenceNumberCentral)) {
            return Long.valueOf(sequenceNumberCentral);
        }
        return null;
    }

    @Override
    public String getRootLevel() {
        String result = this.getCurrentLevel();
        for (SimpleNaaccrLinesValidatable validatable = this.getParent(); validatable != null; validatable = validatable.getParent()) {
            result = validatable.getCurrentLevel();
        }
        return result;
    }

    @Override
    public String getCurrentLevel() {
        return this._prefix;
    }

    @Override
    public Map<String, Object> getScope() {
        if (this._context != null) {
            this._scopes.putAll(this._context);
        }
        return this._scopes;
    }

    @Override
    public void reportFailureForProperty(String propertyName) {
        int pos;
        if (propertyName != null && (pos = propertyName.indexOf(46)) >= 0) {
            String alias = propertyName.substring(0, pos);
            String name = propertyName.substring(pos + 1);
            String prefix = this._prefixes.get(alias);
            if (prefix != null) {
                this._propertiesWithError.add(prefix + "." + name);
            }
        }
    }

    @Override
    public void forceFailureForProperties(Set<ExtraPropertyEntityHandlerDto> toReport, Set<String> rawProperties) {
        if (this._lines == null) {
            return;
        }
        for (ExtraPropertyEntityHandlerDto extra : toReport) {
            int idx;
            Set<String> props = extra.getProperties();
            if (props == null) {
                props = rawProperties;
            }
            int n = idx = !(extra.getEntity() instanceof Map) ? -1 : this._lines.indexOf(extra.getEntity());
            if (idx == -1) continue;
            for (String prop : props) {
                if (this._useUntrimmedNotation) {
                    this._propertiesWithError.add("untrimmedlines.untrimmedline[" + idx + "]." + prop.replace("untrimmedline.", ""));
                    continue;
                }
                this._propertiesWithError.add("lines.line[" + idx + "]." + prop.replace("line.", ""));
            }
        }
    }

    @Override
    public Set<String> getPropertiesWithError() {
        return this._propertiesWithError;
    }

    @Override
    public void clearPropertiesWithError() {
        this._propertiesWithError.clear();
    }

    private Map<String, String> getPrefixes() {
        return this._prefixes;
    }

    private SimpleNaaccrLinesValidatable getParent() {
        return this._parent;
    }
}

