/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.functions;

import com.imsweb.validation.ValidationEngine;
import com.imsweb.validation.ValidationException;
import com.imsweb.validation.entities.Rule;
import com.imsweb.validation.entities.RuleFailure;
import com.imsweb.validation.entities.RuleTest;
import com.imsweb.validation.entities.RuleTestResult;
import com.imsweb.validation.entities.SimpleMapValidatable;
import com.imsweb.validation.entities.SimpleNaaccrLinesValidatable;
import com.imsweb.validation.entities.Validatable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TestingContextFunctions {
    protected String _ruleId;
    protected Rule _rule;
    protected Map<Integer, List<RuleTestResult>> _tests;
    protected ValidationEngine _engine;

    public TestingContextFunctions(RuleTest test) {
        this(test, null);
    }

    public TestingContextFunctions(RuleTest test, Rule rule) {
        this(test, rule, ValidationEngine.getInstance());
    }

    public TestingContextFunctions(RuleTest test, Rule rule, ValidationEngine engine) {
        this._ruleId = test.getTestedRuleId();
        this._rule = rule;
        this._tests = new TreeMap<Integer, List<RuleTestResult>>();
        this._engine = engine;
    }

    public void assertPass(int lineNumber, Object dataObj) {
        this.assertPass(lineNumber, dataObj, null);
    }

    public void assertPass(int lineNumber, Object dataObj, Map<String, Object> context) {
        OutputStream output = new OutputStream(){
            private final StringBuilder _buf = new StringBuilder();

            @Override
            public void write(int b) {
                this._buf.append((char)b);
            }

            public String toString() {
                return this._buf.toString();
            }
        };
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("out", output);
        try {
            Collection<RuleFailure> results = this.runTest(dataObj, context);
            RuleFailure failure = results.isEmpty() ? null : results.iterator().next();
            boolean success = failure == null;
            this.insertTestingResult(lineNumber, AssertionType.PASS, success, failure, dataObj, context, null, null, output);
        }
        catch (ValidationException e) {
            this.insertTestingResult(lineNumber, AssertionType.PASS, false, null, dataObj, context, e, null, output);
        }
    }

    public void assertFail(int lineNumber, Object dataObj, String ... failingProperties) {
        this.assertFail(lineNumber, dataObj, (Map<String, Object>)null, failingProperties);
    }

    public void assertFail(int lineNumber, Object dataObj, Map<String, Object> context, String ... failingProperties) {
        HashSet<String> props = new HashSet<String>();
        if (failingProperties != null) {
            props.addAll(Arrays.asList(failingProperties));
        }
        OutputStream output = new OutputStream(){
            private final StringBuilder _buf = new StringBuilder();

            @Override
            public void write(int b) {
                this._buf.append((char)b);
            }

            public String toString() {
                return this._buf.toString();
            }
        };
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("out", output);
        try {
            Collection<RuleFailure> results = this.runTest(dataObj, context);
            RuleFailure failure = results.isEmpty() ? null : results.iterator().next();
            boolean success = failure != null && failure.getGroovyException() == null && failure.getProperties().containsAll(props);
            this.insertTestingResult(lineNumber, AssertionType.FAIL, success, failure, dataObj, context, null, props, output);
        }
        catch (ValidationException e) {
            this.insertTestingResult(lineNumber, AssertionType.FAIL, false, null, dataObj, context, e, props, output);
        }
    }

    public List<Map<String, String>> createLines() {
        return new ArrayList<Map<String, String>>();
    }

    public Map<String, String> createLine() {
        return new HashMap<String, String>();
    }

    public Map<String, String> createLine(List<Map<String, String>> lines) {
        Map<String, String> line = this.createLine();
        lines.add(line);
        return line;
    }

    public List<Map<String, String>> createUntrimmedlines() {
        return new ArrayList<Map<String, String>>();
    }

    public Map<String, String> createUntrimmedline() {
        return new HashMap<String, String>();
    }

    public Map<String, String> createUntrimmedline(List<Map<String, String>> untrimmedlines) {
        Map<String, String> untrimmedline = this.createUntrimmedline();
        untrimmedlines.add(untrimmedline);
        return untrimmedline;
    }

    public Map<Integer, List<RuleTestResult>> getTestsResults() {
        return Collections.unmodifiableMap(this._tests);
    }

    protected Collection<RuleFailure> runTest(Object data, Map<String, Object> context) throws ValidationException {
        if (this._rule != null) {
            return this._engine.validate(this.createValidatable(data, context), this._rule);
        }
        return this._engine.validate(this.createValidatable(data, context), this._ruleId);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Validatable createValidatable(Object data, Map<String, Object> context) {
        void var3_10;
        if (data == null) {
            throw new IllegalStateException("Invalid testing data structure: cannot run edit on null object");
        }
        Rule r = this._rule;
        if (r == null) {
            r = this._engine.getRule(this._ruleId);
        }
        if (r == null) throw new IllegalStateException("Unable to find rule '" + this._ruleId + "'");
        String javaPath = r.getJavaPath();
        if (javaPath == null) throw new IllegalStateException("Rule '" + r.getId() + "' doesn't define a java-path");
        if (javaPath.equals("lines") || javaPath.equals("untrimmedlines") || javaPath.equals("lines.line") || javaPath.equals("untrimmedlines.untrimmedline")) {
            boolean useUntrimmedNotation = r.getJavaPath().startsWith("untrimmedlines.");
            if ("lines".equals(javaPath) || "untrimmedlines".equals(javaPath)) {
                if (!(data instanceof List)) throw new IllegalStateException("Invalid testing data structure: expected List, got " + data.getClass().getSimpleName());
                SimpleNaaccrLinesValidatable simpleNaaccrLinesValidatable = new SimpleNaaccrLinesValidatable((List)data, context, useUntrimmedNotation);
                return var3_10;
            } else {
                if (!(data instanceof Map)) throw new IllegalStateException("Invalid testing data structure: expected Map, got " + data.getClass().getSimpleName());
                SimpleNaaccrLinesValidatable simpleNaaccrLinesValidatable = new SimpleNaaccrLinesValidatable(Collections.singletonList((Map)data), context, useUntrimmedNotation);
            }
            return var3_10;
        } else {
            if (!(data instanceof Map)) throw new IllegalStateException("Invalid testing data structure: expected Map, got " + data.getClass().getSimpleName());
            SimpleMapValidatable simpleMapValidatable = new SimpleMapValidatable("?", javaPath, (Map)data, context);
        }
        return var3_10;
    }

    protected void insertTestingResult(int lineNum, AssertionType type, boolean success, RuleFailure failure, Object values, Map<String, Object> contextValues, ValidationException exc, Set<String> f, OutputStream os) {
        List list = this._tests.computeIfAbsent(lineNum, k -> new ArrayList());
        ArrayList<String> log = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new StringReader(os.toString()));
            String line = reader.readLine();
            while (line != null) {
                log.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to redirect output", e);
        }
        list.add(new RuleTestResult(lineNum, list.size() + 1, type, success, failure, this.cloneData(values), contextValues, exc, f, log));
    }

    protected Object cloneData(Object data) {
        Object result;
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            result = this.cloneMap((Map)data);
        } else if (data instanceof List) {
            result = this.cloneList((List)data);
        } else if (this.isSimpleType(data.getClass())) {
            result = data;
        } else {
            throw new IllegalStateException("Unsupported data type: " + data.getClass().getName());
        }
        return result;
    }

    protected Map<String, Object> cloneMap(Map<String, Object> data) {
        String javaPath;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> usedProperties = null;
        Rule r = this._rule;
        if (r == null) {
            r = this._engine.getRule(this._ruleId);
        }
        if (r != null && r.getJavaPath() != null && ((javaPath = r.getJavaPath()).startsWith("lines") || javaPath.startsWith("untrimmedlines"))) {
            usedProperties = new HashSet<String>();
            for (String s : r.getUsedProperties()) {
                usedProperties.add(javaPath.startsWith("lines") ? s.replace("line.", "") : s.replace("untrimmedline.", ""));
            }
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Object obj = entry.getValue();
            if (obj == null) {
                result.put(entry.getKey(), null);
                continue;
            }
            if (obj instanceof Map) {
                result.put(entry.getKey(), this.cloneMap((Map)obj));
                continue;
            }
            if (obj instanceof List) {
                result.put(entry.getKey(), this.cloneList((List)obj));
                continue;
            }
            if (this.isSimpleType(obj.getClass())) {
                if (entry.getKey().startsWith("_") && (usedProperties == null || !usedProperties.contains(entry.getKey()))) continue;
                result.put(entry.getKey(), obj);
                continue;
            }
            throw new IllegalStateException("Unsupported data type: " + obj.getClass().getName());
        }
        return result;
    }

    protected List<Object> cloneList(List<Object> data) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : data) {
            if (obj == null) {
                result.add(null);
                continue;
            }
            if (obj instanceof Map) {
                result.add(this.cloneMap((Map)obj));
                continue;
            }
            if (obj instanceof List) {
                result.add(this.cloneList((List)obj));
                continue;
            }
            if (this.isSimpleType(obj.getClass())) {
                result.add(obj);
                continue;
            }
            throw new IllegalStateException("Unsupported data type: " + obj.getClass().getName());
        }
        return result;
    }

    protected boolean isSimpleType(Class<?> clazz) {
        return String.class.equals(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.equals(clazz) || Date.class.equals(clazz);
    }

    public static String createString(int length) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            buf.append((char)(i % 26 + 65));
        }
        return buf.toString();
    }

    public static Date createDate() {
        return new Date();
    }

    public static Date createDate(int year, int month, int day) {
        return new GregorianCalendar(year, month - 1, day).getTime();
    }

    public static enum AssertionType {
        PASS,
        FAIL;

    }
}

