/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.validation.internal;

import com.imsweb.validation.ConstructionException;
import com.imsweb.validation.InitializationStats;
import com.imsweb.validation.ValidationException;
import com.imsweb.validation.ValidationServices;
import com.imsweb.validation.entities.Rule;
import com.imsweb.validation.entities.Validatable;
import com.imsweb.validation.internal.ExtraPropertyHandlerDto;
import com.imsweb.validation.runtime.CompiledRules;
import com.imsweb.validation.runtime.CompiledRulesBundle;
import com.imsweb.validation.runtime.RuntimeUtils;
import groovy.lang.Binding;
import groovy.lang.Script;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;

public class ExecutableRule {
    private Rule _rule;
    private final Long _internalId;
    private String _id;
    private Set<String> _conditions;
    private Boolean _useAndForConditions;
    private String _javaPath;
    private String _message;
    private Set<String> _dependencies;
    private Boolean _ignored;
    private Set<String> _usedProperties;
    private Boolean _checkForcedEntities;
    private Script _script;
    private final Object _scriptLock = new Object();
    private CompiledRules _compiledRules;
    private Method _compiledRule;
    private List<String> _aliases;

    public ExecutableRule(Rule rule) throws ConstructionException {
        this(rule, null, null);
    }

    public ExecutableRule(Rule rule, CompiledRules compiledRules, InitializationStats stats) throws ConstructionException {
        this._rule = rule;
        this._id = rule.getId();
        this._internalId = rule.getRuleId();
        this._javaPath = rule.getJavaPath();
        this._conditions = rule.getConditions();
        this._useAndForConditions = rule.getUseAndForConditions();
        this._dependencies = rule.getDependencies();
        this._message = rule.getMessage();
        this._ignored = rule.getIgnored() == null ? Boolean.FALSE : rule.getIgnored();
        this._usedProperties = rule.getUsedProperties();
        this._checkForcedEntities = this.computeCheckForcedEntities(rule.getExpression());
        this._compiledRules = compiledRules;
        if (this._compiledRules != null) {
            if (this._compiledRules instanceof CompiledRulesBundle) {
                this._compiledRules = ((CompiledRulesBundle)compiledRules).getCompiledRulesForRuleId(this._id);
            }
            this._compiledRule = RuntimeUtils.findCompiledMethod(this._compiledRules, rule.getId(), this._compiledRules.getMethodParameters().get(rule.getJavaPath()));
            this._aliases = new ArrayList<String>();
            StringBuilder buf = new StringBuilder();
            for (String javaPathPart : StringUtils.split((String)this._javaPath, (char)'.')) {
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(javaPathPart);
                this._aliases.add(ValidationServices.getInstance().getAliasForJavaPath(buf.toString()));
            }
        }
        if (this._compiledRule == null) {
            try {
                this._script = ValidationServices.getInstance().compileExpression(rule.getExpression());
            }
            catch (CompilationFailedException e) {
                throw new ConstructionException("Unable to compile rule " + this._rule.getId(), e);
            }
        }
        if (stats != null) {
            stats.incrementNumEditsLoaded(this._rule.getValidator().getId());
            if (this._compiledRule != null) {
                stats.incrementNumEditsPreCompiled(this._rule.getValidator().getId());
            } else if (this._script != null) {
                stats.incrementNumEditsCompiled(this._rule.getValidator().getId());
            }
        }
    }

    public ExecutableRule(ExecutableRule execRule) {
        this._rule = execRule._rule;
        this._id = execRule._id;
        this._internalId = execRule._internalId;
        this._javaPath = execRule._javaPath;
        this._conditions = execRule._conditions;
        this._useAndForConditions = execRule._useAndForConditions;
        this._dependencies = execRule._dependencies;
        this._message = execRule._message;
        this._ignored = execRule._ignored;
        this._usedProperties = execRule._usedProperties;
        this._script = execRule._script;
        this._compiledRules = execRule._compiledRules;
        this._compiledRule = execRule._compiledRule;
        this._aliases = execRule._aliases;
        this._checkForcedEntities = execRule._checkForcedEntities;
    }

    public Long getInternalId() {
        return this._internalId;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Rule getRule() {
        return this._rule;
    }

    public Set<String> getDependencies() {
        return this._dependencies;
    }

    public String getJavaPath() {
        return this._javaPath;
    }

    public String getMessage() {
        return this._message;
    }

    public Boolean getIgnored() {
        return this._ignored;
    }

    public void setRule(Rule rule) {
        this._rule = rule;
    }

    public void setJavaPath(String javaPath) {
        this._javaPath = javaPath;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setDependencies(Set<String> dependencies) {
        this._dependencies = dependencies;
    }

    public void setIgnored(Boolean ignored) {
        this._ignored = ignored;
    }

    public Boolean getUseAndForConditions() {
        return this._useAndForConditions;
    }

    public void setUseAndForConditions(Boolean useAndForConditions) {
        this._useAndForConditions = useAndForConditions == null ? Boolean.TRUE : useAndForConditions;
    }

    public Set<String> getConditions() {
        return this._conditions;
    }

    public void setConditions(Set<String> conditions) {
        this._conditions = conditions;
    }

    public void setExpression(String expression) throws ConstructionException {
        try {
            HashSet<String> usedProperties = new HashSet<String>();
            HashSet<String> usedContextEntries = new HashSet<String>();
            ValidationServices.getInstance().parseExpression("rule", expression, usedProperties, usedContextEntries, null);
            this._script = ValidationServices.getInstance().compileExpression(expression);
            this._usedProperties = usedProperties;
            this._checkForcedEntities = this.computeCheckForcedEntities(expression);
            this._compiledRules = null;
            this._compiledRule = null;
            this._aliases = null;
        }
        catch (CompilationFailedException e) {
            throw new ConstructionException("Unable to compile rule " + this._id, e);
        }
    }

    private boolean computeCheckForcedEntities(String expression) {
        return expression != null && (expression.contains("forceFailureOnEntity") || expression.contains("forceFailureOnProperty") || expression.contains("ignoreFailureOnProperty"));
    }

    public String toString() {
        return this._id;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean validate(Validatable validatable, Binding binding) throws ValidationException {
        boolean success;
        ExtraPropertyHandlerDto extra = Boolean.TRUE.equals(this._checkForcedEntities) ? new ExtraPropertyHandlerDto() : null;
        ValidationException exception = null;
        try {
            Boolean failingFlag;
            success = this.internalValidate(validatable, binding, extra);
            if (success && (failingFlag = (Boolean)binding.getVariable("__failing_flag")) != null && failingFlag.booleanValue()) {
                success = false;
            }
        }
        catch (ValidationException e) {
            success = false;
            exception = e;
        }
        if (!success) {
            try {
                for (String property : this._usedProperties) {
                    if (extra != null && extra.getIgnoredProperties() != null && extra.getIgnoredProperties().contains(property)) continue;
                    validatable.reportFailureForProperty(property);
                }
                if (extra != null && extra.getForcedProperties() != null) {
                    for (String property : extra.getForcedProperties()) {
                        validatable.reportFailureForProperty(property);
                    }
                }
                if (extra != null && extra.getForcedEntities() != null) {
                    validatable.forceFailureForProperties(extra.getForcedEntities(), this._usedProperties);
                }
            }
            catch (IllegalAccessException e) {
                throw new ValidationException(e.getMessage());
            }
        }
        if (exception != null) {
            throw exception;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalValidate(Validatable validatable, Binding binding, ExtraPropertyHandlerDto extra) throws ValidationException {
        boolean success;
        Object params;
        binding.setVariable("__force_failure_on_entity_key", null);
        binding.setVariable("__force_failure_on_property_key", null);
        binding.setVariable("__ignore_failure_on_property_key", null);
        binding.setVariable("__error_message", null);
        binding.setVariable("__extra_error_messages", null);
        binding.setVariable("__information_messages", null);
        binding.setVariable("__failing_flag", null);
        binding.setVariable("__original_result", null);
        if (this._compiledRule != null) {
            params = new ArrayList<Binding>();
            params.add(binding);
            params.add(binding.getVariable("Context"));
            params.add(binding.getVariable("Functions"));
            for (String alias : this._aliases) {
                params.add(binding.getVariable(alias));
            }
            try {
                success = (Boolean)this._compiledRule.invoke((Object)this._compiledRules, params.toArray(new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ValidationException("Exception invoking method for edit " + this._id, e);
            }
        }
        if (this._script != null) {
            params = this._scriptLock;
            synchronized (params) {
                block22: {
                    this._script.setBinding(binding);
                    try {
                        Object result = this._script.run();
                        if (result instanceof Boolean) {
                            success = (Boolean)result;
                            break block22;
                        }
                        throw new ValidationException("result is not a boolean");
                    }
                    catch (Exception e) {
                        StringBuilder buf = new StringBuilder();
                        if (this._id != null) {
                            buf.append("Unable to execute edit '").append(this._id).append("'");
                            String validated = validatable.getDisplayId();
                            if (validated != null) {
                                buf.append(" on ").append(validatable.getDisplayId()).append(": ");
                            } else {
                                buf.append(": ");
                            }
                        } else {
                            buf.append("Unable to execute edit: ");
                        }
                        buf.append(e.getMessage() == null ? "null reference" : e.getMessage());
                        throw new ValidationException(buf.toString(), e);
                    }
                    finally {
                        this._script.setBinding(null);
                    }
                }
            }
        }
        success = true;
        if (Boolean.TRUE.equals(this._checkForcedEntities)) {
            Object ignoredProperties;
            Object forcedProperties;
            Object forcedEntities = binding.getVariable("__force_failure_on_entity_key");
            if (forcedEntities != null) {
                extra.setForcedEntities((Set)forcedEntities);
            }
            if ((forcedProperties = binding.getVariable("__force_failure_on_property_key")) != null) {
                extra.setForcedProperties((Set)forcedProperties);
            }
            if ((ignoredProperties = binding.getVariable("__ignore_failure_on_property_key")) != null) {
                extra.setIgnoredProperties((Set)ignoredProperties);
            }
        }
        binding.setVariable("__original_result", (Object)success);
        return success;
    }
}

