/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.x12;

import com.imsweb.x12.Separators;
import com.imsweb.x12.mapping.CompositeDefinition;
import com.imsweb.x12.mapping.ElementDefinition;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@XStreamAlias(value="element")
public class Element {
    @XStreamOmitField
    private Separators _separators;
    @XStreamAlias(value="id")
    private String _id;
    @XStreamAlias(value="value")
    private String _value;
    @XStreamAlias(value="subValue")
    private List<String> _subValues = new ArrayList<String>();

    public Element(String id, String value, Separators separators) {
        if (id == null || id.isEmpty()) {
            throw new IllegalStateException("Elements must have a non-null identifier");
        }
        this._separators = separators;
        this.setId(id);
        this.setValue(value == null ? "" : value);
    }

    public Element(String id, String value) {
        if (id == null || id.isEmpty()) {
            throw new IllegalStateException("Elements must have a non-null identifier");
        }
        this._separators = new Separators();
        this.setId(id);
        this.setValue(value == null ? "" : value);
    }

    public Separators getSeparators() {
        return this._separators;
    }

    public List<String> getSubValues() {
        return this._subValues;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        String[] values = this._separators.splitComposite(value);
        if (values != null && values.length >= 1) {
            this._subValues.addAll(Arrays.asList(values));
        }
        this._value = value;
    }

    public int getNumOfSubElements() {
        return this._subValues.size();
    }

    public String getSubElement(int index) {
        if (index < this._subValues.size()) {
            return this._subValues.get(index);
        }
        return null;
    }

    public String toString() {
        return this._value;
    }

    public String toHtml(Optional<ElementDefinition> elementDefinition, List<String> parentIds) {
        ArrayList<String> newParentIds = new ArrayList<String>();
        newParentIds.addAll(parentIds);
        newParentIds.add(this.getId());
        StringBuilder dump = new StringBuilder().append("<div class=\"x12-element\"><p><span class=\"x12-element-name\">");
        if (elementDefinition.isPresent()) {
            dump.append(elementDefinition.get().getName()).append(" (").append(this._id).append("): ");
        } else {
            dump.append(this._id).append(": ");
        }
        return dump.append("</span> <input type=\"text\" name=\"").append(Separators.getIdString(newParentIds)).append("\" value=\"").append(this._value).append("\" /> </p></div>").toString();
    }

    public Map<String, Object> toMap(Optional<ElementDefinition> elementDefinition, Optional<CompositeDefinition> compositeDefinition, List<String> parentIds) {
        HashMap<String, Object> elmMap = new HashMap<String, Object>();
        elmMap.put("parentIds", parentIds);
        elmMap.put("xid", this._id);
        elmMap.put("type", elementDefinition.isPresent() ? "element" : "composite");
        elmMap.put("value", this._value);
        if (elementDefinition.isPresent()) {
            elmMap.put("name", elementDefinition.get().getName());
        } else {
            compositeDefinition.ifPresent(definition -> {
                ArrayList subElements = new ArrayList();
                ArrayList<String> subParentIds = new ArrayList<String>(parentIds);
                subParentIds.add(this._id);
                elmMap.put("name", definition.getName());
                for (int i = 0; i < this.getNumOfSubElements(); ++i) {
                    String subElementVal = this.getSubElement(i);
                    ElementDefinition subElementDefinition = definition.getElements().get(i);
                    HashMap<String, Object> compositeMap = new HashMap<String, Object>();
                    compositeMap.put("name", subElementDefinition.getName());
                    compositeMap.put("parentIds", subParentIds);
                    compositeMap.put("xid", subElementDefinition.getXid());
                    compositeMap.put("type", "compositeValue");
                    compositeMap.put("value", subElementVal);
                    subElements.add(compositeMap);
                }
                elmMap.put("subElements", subElements);
            });
        }
        return elmMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Element element = (Element)o;
        return Objects.equals(this._id, element._id) && Objects.equals(this._value, element._value);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._value);
    }
}

