/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.x12;

import com.imsweb.x12.Segment;
import com.imsweb.x12.Separators;
import com.imsweb.x12.converters.ElementConverter;
import com.imsweb.x12.mapping.LoopDefinition;
import com.imsweb.x12.mapping.Positioned;
import com.imsweb.x12.mapping.SegmentDefinition;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;

@XStreamAlias(value="loop")
public class Loop
implements Iterable<Segment> {
    @XStreamOmitField
    private Separators _separators;
    @XStreamAlias(value="id")
    private String _id;
    @XStreamAlias(value="segments")
    private List<Segment> _segments = new ArrayList<Segment>();
    @XStreamAlias(value="loops")
    private List<Loop> _loops = new ArrayList<Loop>();
    @XStreamOmitField
    private Loop _parent;

    public Loop() {
        this._separators = new Separators();
        this._id = null;
        this._parent = null;
    }

    public Loop(String id) {
        this._separators = new Separators();
        this._id = id;
        this._parent = null;
    }

    public Loop(Separators separators, String id) {
        this._separators = separators;
        this._id = id;
        this._parent = null;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Loop getParent() {
        return this._parent;
    }

    public void setParent(Loop parent) {
        this._parent = parent;
    }

    public Separators getSeparators() {
        return this._separators;
    }

    public void setSeparators(Separators separators) {
        this._separators = separators;
    }

    public List<Segment> getSegments() {
        return this._segments;
    }

    public void setSegments(List<Segment> segments) {
        this._segments = segments;
    }

    public List<Loop> getLoops() {
        return this._loops;
    }

    public void setLoops(List<Loop> loops) {
        this._loops = loops;
    }

    public Loop addLoop(String id) {
        Loop l = new Loop(this._separators, id);
        l.setParent(this);
        this._loops.add(l);
        return l;
    }

    public Loop addLoop(int index, String id) {
        Loop loop = new Loop(this._separators, id);
        this.addLoop(index, loop);
        return loop;
    }

    public void addLoop(int index, Loop loop) {
        loop.setParent(this);
        this._loops.add(index, loop);
    }

    public Segment addSegment() {
        Segment s = new Segment(this._separators);
        this._segments.add(s);
        return s;
    }

    public Segment addSegment(String segment) {
        Segment s = new Segment(this._separators);
        s.addElements(segment);
        this._segments.add(s);
        return s;
    }

    public void addSegment(Segment segment) {
        this._segments.add(segment);
    }

    public Segment addSegment(int index, String segmentText) {
        Segment segment = new Segment(this._separators);
        segment.addElements(segmentText);
        this.addSegment(index, segment);
        return segment;
    }

    public void addSegment(int index, Segment segment) {
        this._segments.add(index, segment);
    }

    public boolean hasLoop(String id) {
        if (this.getId().contains(id)) {
            return true;
        }
        for (Loop l : this.getLoops()) {
            if (id.equals(l.getId())) {
                return true;
            }
            if (!l.hasLoop(id)) continue;
            return true;
        }
        return false;
    }

    public Loop getLoop(String loopId) {
        List<Loop> loops = this.findLoop(loopId);
        if (!loops.isEmpty()) {
            return this.findLoop(loopId).get(0);
        }
        return null;
    }

    public Loop getLoop(String loopId, int index) {
        List<Loop> loops = this.findLoop(loopId);
        if (index < loops.size()) {
            return this.findLoop(loopId).get(index);
        }
        return null;
    }

    public List<Loop> findLoop(String id) {
        ArrayList<Loop> foundLoops = new ArrayList<Loop>();
        for (Loop loop : this.getLoops()) {
            List<Loop> moreLoops;
            if (id.equals(loop.getId())) {
                foundLoops.add(loop);
            }
            if ((moreLoops = loop.findLoop(id)).isEmpty()) continue;
            foundLoops.addAll(moreLoops);
        }
        return foundLoops;
    }

    public List<Loop> findAllLoops(String id) {
        ArrayList<Loop> foundLoops = new ArrayList<Loop>();
        if (this._id != null && this._id.equals(id)) {
            foundLoops.add(this);
        }
        foundLoops.addAll(this.findLoop(id));
        return foundLoops;
    }

    public List<Segment> findSegment(String id) {
        return this._segments.stream().filter(segment -> id.equals(segment.getId())).collect(Collectors.toList());
    }

    public Loop getLoop(int index) {
        if (index < this._loops.size()) {
            return this._loops.get(index);
        }
        return null;
    }

    public Segment getSegment(int index) {
        if (index < this._segments.size()) {
            return this._segments.get(index);
        }
        return null;
    }

    public Segment getSegment(String id) {
        List<Segment> segs = this.findSegment(id);
        if (!segs.isEmpty()) {
            return this.findSegment(id).get(0);
        }
        return null;
    }

    public Segment getSegment(String id, int index) {
        List<Segment> segs = this.findSegment(id);
        if (index < segs.size()) {
            return this.findSegment(id).get(index);
        }
        return null;
    }

    @Override
    public Iterator<Segment> iterator() {
        return this._segments.iterator();
    }

    public Loop removeLoop(int index) {
        return this._loops.remove(index);
    }

    public Segment removeSegment(int index) {
        return this._segments.remove(index);
    }

    public int size() {
        int size = this._segments.size();
        for (Loop loops : this.getLoops()) {
            size += loops.size();
        }
        return size;
    }

    public Loop setLoop(int index, String id) {
        Loop loop = new Loop(this._separators, id);
        loop.setParent(this);
        this._loops.set(index, loop);
        return loop;
    }

    public void setLoop(int index, Loop loop) {
        loop.setParent(this);
        this._loops.set(index, loop);
    }

    public Segment setSegment(int index, String segmentText) {
        Segment segment = new Segment(this._separators);
        segment.addElements(segmentText);
        this._segments.set(index, segment);
        return segment;
    }

    public void setSegment(int index, Segment segment) {
        this._segments.set(index, segment);
    }

    public String getElement(String loopId, int loopIndex, String segmentId, int segIndex, String elementId) {
        Loop requestedLoop = this.getLoop(loopId, loopIndex);
        if (requestedLoop == null) {
            return null;
        }
        Segment requestedSegment = requestedLoop.getSegment(segmentId, segIndex);
        if (requestedSegment == null) {
            return null;
        }
        return requestedSegment.getElementValue(elementId);
    }

    public String getElement(String loopId, String segmentId, String elementId) {
        Loop requestedLoop = this.getLoop(loopId);
        if (requestedLoop == null) {
            return null;
        }
        Segment requestedSegment = requestedLoop.getSegment(segmentId);
        if (requestedSegment == null) {
            return null;
        }
        return requestedSegment.getElementValue(elementId);
    }

    public String getElement(String segmentId, int segIndex, String elementId) {
        Segment requestedSegment = this.getSegment(segmentId, segIndex);
        if (requestedSegment == null) {
            return null;
        }
        return requestedSegment.getElementValue(elementId);
    }

    public String getElement(String segmentId, String elementId) {
        Segment requestedSegment = this.getSegment(segmentId);
        if (requestedSegment == null) {
            return null;
        }
        return requestedSegment.getElementValue(elementId);
    }

    public Loop findTopParentById(String parentId) {
        Loop result = null;
        if (parentId != null) {
            Loop parentLoop;
            for (parentLoop = this._parent; parentLoop != null && !parentId.equals(parentLoop.getId()); parentLoop = parentLoop.getParent()) {
            }
            if (parentLoop != null && parentId.equals(parentLoop.getId())) {
                result = parentLoop;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder dump = new StringBuilder();
        for (Segment segment : this.getSegments()) {
            dump.append(segment.toString());
            dump.append(this._separators.getSegment());
        }
        for (Loop loop : this.getLoops()) {
            dump.append(loop.toString());
        }
        return dump.toString();
    }

    public String toX12String(LoopDefinition loopDefinition) {
        StringBuilder dump = new StringBuilder();
        TreeSet<Positioned> segmentsAndLoops = new TreeSet<Positioned>();
        if (loopDefinition.getLoop() != null) {
            segmentsAndLoops.addAll(loopDefinition.getLoop());
        }
        if (loopDefinition.getSegment() != null) {
            segmentsAndLoops.addAll(loopDefinition.getSegment());
        }
        for (Positioned positioned : segmentsAndLoops) {
            Loop innerLoop;
            int idx;
            if (positioned instanceof SegmentDefinition) {
                Segment segment;
                SegmentDefinition segmentDefinition = (SegmentDefinition)positioned;
                idx = 0;
                while ((segment = this.getSegment(segmentDefinition.getXid(), idx++)) != null) {
                    dump.append(segment);
                    dump.append(this._separators.getSegment());
                    dump.append(this._separators.getLineBreak().getLineBreakString());
                }
                continue;
            }
            if (!(positioned instanceof LoopDefinition)) continue;
            LoopDefinition innerLoopDefinition = (LoopDefinition)positioned;
            idx = 0;
            while ((innerLoop = this.getLoopForPrinting(innerLoopDefinition, idx++)) != null) {
                dump.append(innerLoop.toX12String(innerLoopDefinition));
            }
        }
        return dump.toString();
    }

    public String toHtml(LoopDefinition loopDefinition, List<String> parentIds) {
        StringBuilder dump = new StringBuilder();
        dump.append("<div id=\"").append(Separators.getIdString(parentIds)).append("\" class=\"x12-loop\"><p>");
        dump.append(loopDefinition.getName()).append(" (").append(loopDefinition.getXid()).append(")</p>");
        ArrayList<String> newParentIds = new ArrayList<String>();
        newParentIds.addAll(parentIds);
        newParentIds.add(this.getId());
        TreeSet<Positioned> segmentsAndLoops = new TreeSet<Positioned>();
        if (loopDefinition.getLoop() != null) {
            segmentsAndLoops.addAll(loopDefinition.getLoop());
        }
        if (loopDefinition.getSegment() != null) {
            segmentsAndLoops.addAll(loopDefinition.getSegment());
        }
        for (Positioned positioned : segmentsAndLoops) {
            Loop innerLoop;
            int idx;
            if (positioned instanceof SegmentDefinition) {
                Segment segment;
                SegmentDefinition segmentDefinition = (SegmentDefinition)positioned;
                idx = 0;
                while ((segment = this.getSegment(segmentDefinition.getXid(), idx++)) != null) {
                    dump.append(segment.toHtml(segmentDefinition, newParentIds));
                }
                continue;
            }
            if (!(positioned instanceof LoopDefinition)) continue;
            LoopDefinition innerLoopDefinition = (LoopDefinition)positioned;
            idx = 0;
            while ((innerLoop = this.getLoopForPrinting(innerLoopDefinition, idx++)) != null) {
                dump.append(innerLoop.toHtml(innerLoopDefinition, newParentIds));
            }
        }
        dump.append("</div>");
        return dump.toString();
    }

    public Map<String, Object> toMap(LoopDefinition loopDefinition, List<String> parentIds, int rootLoopIndex, int loopIndex) {
        ArrayList<String> newParentIds = new ArrayList<String>(parentIds);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("parentIds", parentIds);
        res.put("xid", this._id);
        res.put("name", loopDefinition.getName());
        res.put("type", "loop");
        TreeSet<Positioned> segmentsAndLoops = new TreeSet<Positioned>();
        if (loopDefinition.getLoop() != null) {
            segmentsAndLoops.addAll(loopDefinition.getLoop());
        }
        if (loopDefinition.getSegment() != null) {
            segmentsAndLoops.addAll(loopDefinition.getSegment());
        }
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        for (Positioned positioned : segmentsAndLoops) {
            Loop innerLoop;
            int idx;
            if (positioned instanceof SegmentDefinition) {
                Segment segment;
                SegmentDefinition segmentDefinition = (SegmentDefinition)positioned;
                idx = 0;
                while ((segment = this.getSegment(segmentDefinition.getXid(), idx)) != null) {
                    children.add(segment.toMap(segmentDefinition, newParentIds, idx));
                    ++idx;
                }
                continue;
            }
            if (!(positioned instanceof LoopDefinition)) continue;
            LoopDefinition innerLoopDefinition = (LoopDefinition)positioned;
            idx = 0;
            while ((innerLoop = this.getLoopForPrinting(innerLoopDefinition, idx)) != null) {
                children.add(innerLoop.toMap(innerLoopDefinition, newParentIds, rootLoopIndex, idx));
                ++idx;
            }
        }
        if (!children.isEmpty()) {
            res.put("children", children);
        }
        return res;
    }

    private Loop getLoopForPrinting(LoopDefinition loopDefinition, int idx) {
        Loop loop = this.getLoop(loopDefinition.getXid(), idx);
        if (loop != null && this._loops.stream().noneMatch(parentLoop -> parentLoop.getId().equals(loop.getId()))) {
            return null;
        }
        return loop;
    }

    public String toXML() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.autodetectAnnotations(true);
        xstream.useAttributeFor(Loop.class, "_id");
        xstream.useAttributeFor(Segment.class, "_id");
        xstream.registerConverter((Converter)new ElementConverter());
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.x12.**"}));
        StringWriter writer = new StringWriter();
        xstream.marshal((Object)this, (HierarchicalStreamWriter)new PrettyPrintWriter((Writer)writer));
        return writer.toString();
    }

    public String toJson() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver(){

            public HierarchicalStreamWriter createWriter(Writer writer) {
                return new JsonWriter(writer, 1);
            }
        });
        xstream.autodetectAnnotations(true);
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.x12.**"}));
        return xstream.toXML((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Loop segments = (Loop)o;
        return Objects.equals(this._separators, segments._separators) && Objects.equals(this._id, segments._id) && Objects.equals(this._segments, segments._segments) && Objects.equals(this._loops, segments._loops) && Objects.equals(this._parent, segments._parent);
    }

    public int hashCode() {
        return Objects.hash(this._separators, this._id, this._segments, this._loops, this._parent);
    }
}

