/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.x12;

import com.imsweb.x12.Element;
import com.imsweb.x12.Separators;
import com.imsweb.x12.mapping.CompositeDefinition;
import com.imsweb.x12.mapping.ElementDefinition;
import com.imsweb.x12.mapping.SegmentDefinition;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@XStreamAlias(value="segment")
public class Segment
implements Iterable<Element> {
    @XStreamOmitField
    private Separators _separators;
    @XStreamAlias(value="id")
    private String _id;
    @XStreamAlias(value="elements")
    private List<Element> _elements = new ArrayList<Element>();

    public Segment() {
        this._separators = new Separators();
    }

    public Segment(Separators separators) {
        this._separators = separators;
    }

    public Segment(String id) {
        this._id = id;
        this._separators = new Separators();
    }

    public Segment(String id, Separators separators) {
        this._id = id;
        this._separators = separators;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Separators getSeparators() {
        return this._separators;
    }

    public List<Element> getElements() {
        return this._elements;
    }

    public void setElements(List<Element> elements) {
        this._elements = elements;
    }

    public boolean addElement(Element element) {
        return this._elements.add(element);
    }

    public boolean addElement(String id, String value) {
        return this._elements.add(new Element(id, value));
    }

    public boolean appendElement(String elementText) {
        if (this._id == null || elementText == null) {
            throw new IllegalStateException("No segment identifier has been set");
        }
        int elementIdNum = this._elements.size() + 1;
        String elementId = this._elements.size() < 10 ? this._id + "0" + elementIdNum : this._id + elementIdNum;
        return this.addElements(new Element(elementId, elementText, this._separators));
    }

    public boolean addElements(String elementText) {
        String[] elementsStr = this._separators.splitElement(elementText);
        if (elementsStr == null) {
            return false;
        }
        Element[] elements = new Element[elementsStr.length - 1];
        this._id = elementsStr[0];
        for (int i = 1; i < elementsStr.length; ++i) {
            String elementId = i < 10 ? this._id + "0" + i : this._id + i;
            elements[i - 1] = new Element(elementId, elementsStr[i], this._separators);
        }
        return this.addElements(elements);
    }

    public boolean addElements(Element ... elements) {
        for (Element s : elements) {
            if (this._elements.add(s) && this._id != null) continue;
            return false;
        }
        return true;
    }

    public boolean addCompositeElement(String id, String ... compositeElements) {
        StringBuilder dump = new StringBuilder();
        for (String s : compositeElements) {
            dump.append(s);
            dump.append(this._separators.getCompositeElement());
        }
        return this._elements.add(new Element(id, dump.substring(0, dump.length() - 1), this._separators));
    }

    public void addElement(int index, Element element) {
        this._elements.add(index, element);
    }

    public void addCompositeElement(int index, String id, String ... compositeElements) {
        StringBuilder dump = new StringBuilder();
        for (String s : compositeElements) {
            dump.append(s);
            dump.append(this._separators.getCompositeElement());
        }
        this._elements.add(index, new Element(id, dump.substring(0, dump.length() - 1), this._separators));
    }

    public Element getElement(String id) {
        for (Element elem : this._elements) {
            if (!elem.getId().equals(id)) continue;
            return elem;
        }
        return null;
    }

    public String getElementValue(String id) {
        for (Element elem : this._elements) {
            if (!elem.getId().equals(id)) continue;
            return elem.getValue();
        }
        return null;
    }

    public String getElement(String id, int index) {
        for (Element elem : this._elements) {
            if (!elem.getId().equals(id)) continue;
            return elem.getSubElement(index);
        }
        return null;
    }

    public Element removeElement(int index) {
        return this._elements.remove(index - 1);
    }

    public void setSeparators(Separators separators) {
        this._separators = separators;
    }

    public void setElement(int index, String elementText) {
        this._elements.get(index - 1).setValue(elementText);
    }

    public void setCompositeElement(int index, String ... compositeElements) {
        StringBuilder dump = new StringBuilder();
        for (String s : compositeElements) {
            dump.append(s);
            dump.append(this._separators.getCompositeElement());
        }
        this._elements.get(index - 1).setValue(dump.substring(0, dump.length() - 1));
    }

    public int size() {
        return this._elements.size();
    }

    @Override
    public Iterator<Element> iterator() {
        return this._elements.iterator();
    }

    public String toHtml(SegmentDefinition segmentDefinition, List<String> parentIds) {
        ArrayList<String> newParentIds = new ArrayList<String>();
        newParentIds.addAll(parentIds);
        newParentIds.add(this.getId());
        StringBuilder output = new StringBuilder();
        output.append("<div id=\"").append(Separators.getIdString(parentIds)).append("\" class=\"x12-segment\">");
        output.append("<p>").append(segmentDefinition.getName()).append(" (").append(this._id).append(")</p>");
        for (Element e : this._elements) {
            if (segmentDefinition.getElements() != null) {
                Optional<ElementDefinition> elementDef = segmentDefinition.getElements().stream().filter(ed -> ed.getXid().equals(e.getId())).findFirst();
                output.append(e.toHtml(elementDef, newParentIds));
                continue;
            }
            output.append(e.toHtml(Optional.empty(), newParentIds));
        }
        output.append("</div>");
        return output.toString();
    }

    public Map<String, Object> toMap(SegmentDefinition segmentDefinition, List<String> parentIds, int segmentIndex) {
        ArrayList<String> newParentIds = new ArrayList<String>(parentIds);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("parentIds", newParentIds);
        res.put("xid", this._id);
        res.put("name", segmentDefinition.getName());
        res.put("segmentIndex", segmentIndex);
        res.put("type", "segment");
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        for (Element e : this._elements) {
            Optional<ElementDefinition> elementDef = Optional.empty();
            Optional<CompositeDefinition> compositeDef = Optional.empty();
            if (segmentDefinition.getElements() != null) {
                elementDef = segmentDefinition.getElements().stream().filter(ed -> ed.getXid().equals(e.getId())).findFirst();
            }
            if (segmentDefinition.getComposites() != null) {
                compositeDef = segmentDefinition.getComposites().stream().filter(ed -> ed.getXid().equals(e.getId())).findFirst();
            }
            children.add(e.toMap(elementDef, compositeDef, newParentIds));
        }
        if (!children.isEmpty()) {
            res.put("children", children);
        }
        return res;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append(this._id);
        output.append(this._separators.getElement());
        for (Element e : this._elements) {
            output.append(e.toString());
            output.append(this._separators.getElement());
        }
        if (output.length() == 0) {
            return "";
        }
        return output.substring(0, output.length() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment elements = (Segment)o;
        return Objects.equals(this._separators, elements._separators) && Objects.equals(this._id, elements._id) && Objects.equals(this._elements, elements._elements);
    }

    public int hashCode() {
        return Objects.hash(this._separators, this._id, this._elements);
    }
}

