/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.x12;

import com.imsweb.x12.LineBreak;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class Separators {
    public static final String HTML_ID_SEPARATOR = "__";
    private Character _segment;
    private Character _element;
    private Character _composite;
    private Pattern _segmentPattern;
    private Pattern _elementPattern;
    private Pattern _compositePattern;
    private LineBreak _lineBreak;

    public Separators() {
        this.setSegment(Character.valueOf('~'));
        this.setElement(Character.valueOf('*'));
        this.setCompositeElement(Character.valueOf(':'));
        this.setLineBreak(LineBreak.NONE);
    }

    public Separators(Character segment, Character element, Character composite) {
        this.setSegment(segment);
        this.setElement(element);
        this.setCompositeElement(composite);
        this.setLineBreak(LineBreak.NONE);
    }

    public Character getCompositeElement() {
        return this._composite;
    }

    public Character getElement() {
        return this._element;
    }

    public Character getSegment() {
        return this._segment;
    }

    public void setCompositeElement(Character c) {
        this._composite = c;
        this._compositePattern = c == null ? null : Pattern.compile(Pattern.quote(c.toString()));
    }

    public void setElement(Character e) {
        this._element = e;
        this._elementPattern = e == null ? null : Pattern.compile(Pattern.quote(e.toString()));
    }

    public void setSegment(Character s) {
        this._segment = s;
        this._segmentPattern = s == null ? null : Pattern.compile(Pattern.quote(s.toString()));
    }

    public String toString() {
        return "[" + this._segment + "," + this._element + "," + this._composite + "]";
    }

    public String[] splitElement(String line) {
        return line != null && this._elementPattern != null ? this._elementPattern.split(line) : null;
    }

    public String[] splitSegment(String line) {
        return line != null && this._segmentPattern != null ? this._segmentPattern.split(line) : null;
    }

    public String[] splitComposite(String line) {
        return line != null && this._compositePattern != null ? this._compositePattern.split(line) : null;
    }

    public LineBreak getLineBreak() {
        return this._lineBreak;
    }

    public void setLineBreak(LineBreak lineBreak) {
        this._lineBreak = lineBreak;
    }

    public static String getIdString(List<String> idList) {
        StringBuilder sb = new StringBuilder();
        for (String id : idList) {
            if (sb.length() != 0) {
                sb.append(HTML_ID_SEPARATOR);
            }
            sb.append(id);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Separators that = (Separators)o;
        return Objects.equals(this._segment, that._segment) && Objects.equals(this._element, that._element) && Objects.equals(this._composite, that._composite);
    }

    public int hashCode() {
        return Objects.hash(this._segment, this._element, this._composite);
    }
}

