/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.x12.reader;

import com.imsweb.x12.Loop;
import com.imsweb.x12.Segment;
import com.imsweb.x12.Separators;
import com.imsweb.x12.mapping.CompositeDefinition;
import com.imsweb.x12.mapping.ElementDefinition;
import com.imsweb.x12.mapping.LoopDefinition;
import com.imsweb.x12.mapping.SegmentDefinition;
import com.imsweb.x12.mapping.TransactionDefinition;
import com.imsweb.x12.reader.LoopConfig;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class X12Reader {
    private static final int _ISA_LENGTH = 106;
    private static final int _ELEMENT_SEPARATOR_POS = 3;
    private static final int _COMPOSITE_SEPARATOR_POS = 104;
    private static final int _SEGMENT_SEPARATOR_POS = 105;
    private static final String _X091_ANSI_VERSION = "004010X091A1";
    private static final String _X221_ANSI_VERSION = "005010X221A1";
    private static final String _X096_ANSI_VERSION = "004010X096A1";
    private static final String _X097_ANSI_VERSION = "004010X097A1";
    private static final String _X098_ANSI_VERSION = "004010X098A1";
    private static final String _X222_ANSI_VERSION = "005010X222A1";
    private static final String _X223_ANSI_VERSION = "005010X223A2";
    private static final String _X231_ANSI_VERSION = "005010X231A1";
    private static final String _X214_ANSI_VERSION = "005010X214";
    private static final String _X270_271_092_ANSI_VERSION = "004010X092A1";
    private static final String _X212_ANSI_VERSION = "005010X212";
    private static final EnumMap<FileType, String> _TYPES = new EnumMap(FileType.class);
    private List<String> _errors = new ArrayList<String>();
    private final List<String> _fatalErrors = new ArrayList<String>();
    private final List<LoopConfig> _config = new ArrayList<LoopConfig>();
    private final List<Loop> _dataLoops = new ArrayList<Loop>();
    private final Map<String, List<Set<String>>> _childLoopTracker = new HashMap<String, List<Set<String>>>();
    private Separators _separators;
    TransactionDefinition _definition;
    private final FileType _type;

    public X12Reader(FileType type, File file) throws IOException {
        this._type = type;
        this.parse(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset())));
    }

    public X12Reader(FileType type, File file, Charset charset) throws IOException {
        this._type = type;
        this.parse(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset)));
    }

    public X12Reader(FileType type, InputStream input) throws IOException {
        this._type = type;
        this.parse(new BufferedReader(new InputStreamReader(input, Charset.defaultCharset())));
    }

    public X12Reader(FileType type, InputStream input, Charset charset) throws IOException {
        this._type = type;
        this.parse(new BufferedReader(new InputStreamReader(input, charset)));
    }

    public X12Reader(FileType type, Reader reader) throws IOException {
        this._type = type;
        if (!reader.markSupported()) {
            this.parse(new BufferedReader(reader));
        } else {
            this.parse(reader);
        }
    }

    public TransactionDefinition getDefinition() {
        return this._definition;
    }

    public List<Loop> getLoops() {
        return this._dataLoops;
    }

    public List<String> getErrors() {
        return this._errors;
    }

    public List<String> getFatalErrors() {
        return this._fatalErrors;
    }

    public Separators getSeparators() {
        return this._separators;
    }

    private void parse(Reader reader) throws IOException {
        Scanner scanner = new Scanner(reader);
        this._separators = this.getSeparators(reader);
        if (this._separators != null && this.checkVersionsAreConsistent(this._separators, reader)) {
            LoopConfig loopConfig;
            Character segmentSeparator = this._separators.getSegment();
            String quotedSegmentSeparator = Pattern.quote(segmentSeparator.toString());
            scanner.useDelimiter(quotedSegmentSeparator + "\r\n|" + quotedSegmentSeparator + "\n|" + quotedSegmentSeparator);
            ArrayList<String> loopLines = new ArrayList<String>();
            LoopConfig currentLoopConfig = null;
            Loop lastLoopStored = null;
            this._definition = this._type.getDefinition();
            this.getLoopConfiguration(this._definition.getLoop(), null);
            this._errors = new ArrayList<String>();
            String line = scanner.next().trim();
            while (scanner.hasNext()) {
                loopConfig = this.getMatchedLoop(this._separators.splitElement(line), currentLoopConfig == null ? null : currentLoopConfig.getLoopId());
                if (loopConfig == null) {
                    loopLines.add(line);
                } else if (loopConfig.getLastSegmentXid() != null && line.startsWith(loopConfig.getLastSegmentXid().getXid()) && !loopConfig.equals(currentLoopConfig)) {
                    if ((lastLoopStored = this.appendEndingSegment(lastLoopStored, currentLoopConfig, loopConfig, this._separators, line, loopLines)) == null) break;
                    loopLines = new ArrayList();
                    currentLoopConfig = loopConfig;
                } else if (loopConfig.getLoopId().equals(this._definition.getLoop().getXid())) {
                    if (lastLoopStored != null && !loopLines.isEmpty()) {
                        if (this.storeData(currentLoopConfig, loopLines, lastLoopStored, this._separators) == null) break;
                        loopLines = new ArrayList();
                    }
                    currentLoopConfig = loopConfig;
                    lastLoopStored = null;
                    Loop loop = new Loop(null);
                    loop.setSeparators(this._separators);
                    this._dataLoops.add(loop);
                    loopLines.add(line);
                } else {
                    if (currentLoopConfig == null) {
                        this._fatalErrors.add("Current loop is unknown. Bad structure detected");
                        break;
                    }
                    this.updateLoopCounts(loopConfig.getLoopId());
                    if (!loopLines.isEmpty()) {
                        lastLoopStored = this.storeData(currentLoopConfig, loopLines, lastLoopStored, this._separators);
                    }
                    if (lastLoopStored == null) break;
                    loopLines = new ArrayList();
                    loopLines.add(line);
                    currentLoopConfig = loopConfig;
                }
                try {
                    line = scanner.next().trim();
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                    break;
                }
            }
            if (!line.isEmpty() && this._fatalErrors.isEmpty()) {
                if (currentLoopConfig != null) {
                    loopConfig = this.getMatchedLoop(this._separators.splitElement(line), currentLoopConfig.getLoopId());
                    if ((lastLoopStored = this.appendEndingSegment(lastLoopStored, currentLoopConfig, loopConfig, this._separators, line, loopLines)) == null || !this._definition.getLoop().getXid().equals(lastLoopStored.getId())) {
                        this._fatalErrors.add("Unable to find end of transaction");
                    }
                } else {
                    this._fatalErrors.add("Last line of data and we don't know the current loop.");
                }
            }
            if (this._fatalErrors.isEmpty()) {
                this.checkLoopErrors();
            }
        } else {
            this._fatalErrors.add("Unable to process transaction!");
        }
    }

    private Loop appendEndingSegment(Loop lastLoopStored, LoopConfig previousLoopConfig, LoopConfig currentLoopConfig, Separators separators, String currentLine, List<String> loopLines) {
        Loop lastLoopUpdated = null;
        if (!loopLines.isEmpty()) {
            lastLoopStored = this.storeData(previousLoopConfig, loopLines, lastLoopStored, separators);
        }
        if (lastLoopStored != null) {
            Segment segment = new Segment(separators);
            segment.addElements(currentLine);
            lastLoopUpdated = lastLoopStored.findTopParentById(currentLoopConfig.getLoopId());
            if (lastLoopUpdated != null) {
                lastLoopUpdated.addSegment(segment);
            } else {
                this._fatalErrors.add("We found an ending segment but we never stored the first part of the loop!");
            }
        }
        return lastLoopUpdated;
    }

    private void checkLoopErrors() {
        for (LoopConfig lc : this._config) {
            if (TransactionDefinition.Usage.REQUIRED.equals((Object)lc.getLoopUsage()) && lc.getParentLoop() != null && lc.getLoopRepeatCount() != 0 && !this.compareRepeats(lc.getLoopRepeatCount(), lc.getLoopRepeats(), lc.getParentLoop())) {
                this._errors.add(lc.getLoopId() + " appears too many times");
            } else if (TransactionDefinition.Usage.SITUATIONAL.equals((Object)lc.getLoopUsage()) && lc.getLoopRepeatCount() > 0 && lc.getParentLoop() != null && !this.compareRepeats(lc.getLoopRepeatCount(), lc.getLoopRepeats(), lc.getParentLoop())) {
                this._errors.add(lc.getLoopId() + " appears too many times");
            }
            Set<String> requiredChildLoops = new HashSet<String>();
            requiredChildLoops = this.getRequiredChildLoops(this._definition.getLoop(), lc.getLoopId(), requiredChildLoops);
            if (this._childLoopTracker.get(lc.getLoopId()) == null) continue;
            for (int i = 0; i < this._childLoopTracker.get(lc.getLoopId()).size(); ++i) {
                Set<String> childLoops = this._childLoopTracker.get(lc.getLoopId()).get(i);
                for (String ids : requiredChildLoops) {
                    if (childLoops.contains(ids)) continue;
                    this._errors.add(ids + " is required but not found in " + lc.getLoopId() + " iteration #" + (i + 1));
                }
            }
        }
    }

    private Set<String> getRequiredChildLoops(LoopDefinition loop, String id, Set<String> requiredChildList) {
        block4: {
            block3: {
                if (loop.getXid().equals(id)) break block3;
                if (loop.getLoop() == null) break block4;
                for (LoopDefinition subloop : loop.getLoop()) {
                    requiredChildList = this.getRequiredChildLoops(subloop, id, requiredChildList);
                }
                break block4;
            }
            if (loop.getLoop() != null) {
                for (LoopDefinition l : loop.getLoop()) {
                    if (!l.getUsage().equals((Object)TransactionDefinition.Usage.REQUIRED)) continue;
                    requiredChildList.add(l.getXid());
                }
            }
        }
        return requiredChildList;
    }

    private boolean checkVersionsAreConsistent(Separators separators, Reader reader) throws IOException {
        String lineString;
        int versionStartPos;
        int c;
        if (reader == null || separators == null || this._type == null) {
            return false;
        }
        char segmentSeparator = separators.getSegment().charValue();
        char elementSeparator = separators.getElement().charValue();
        StringBuilder line = new StringBuilder();
        while ((c = reader.read()) != -1 && c != segmentSeparator) {
            line.append((char)c);
        }
        String version = null;
        if (c == segmentSeparator && (versionStartPos = (lineString = line.toString()).lastIndexOf(elementSeparator)) != -1) {
            version = lineString.substring(versionStartPos + 1);
        }
        reader.reset();
        boolean result = _TYPES.get((Object)this._type).equals(version);
        if (!result) {
            this._errors.add("ANSI version " + version + " not consistent with version specified " + (Object)((Object)this._type));
        }
        return result;
    }

    private Separators getSeparators(Reader reader) throws IOException {
        boolean isWhiteSpace;
        reader.mark(1);
        char[] firstLine = new char[106];
        int ret = reader.read(firstLine);
        boolean isAlphaNumeric = Character.isDigit(firstLine[105]) || Character.isDigit(firstLine[3]) || Character.isDigit(firstLine[104]) || Character.isLetter(firstLine[105]) || Character.isLetter(firstLine[3]) || Character.isLetter(firstLine[104]);
        boolean bl = isWhiteSpace = Character.isWhitespace(firstLine[105]) || Character.isWhitespace(firstLine[3]) || Character.isWhitespace(firstLine[104]);
        if (ret != 106 || isAlphaNumeric || isWhiteSpace) {
            this._errors.add("Error getting separators");
            return null;
        }
        return new Separators(Character.valueOf(firstLine[105]), Character.valueOf(firstLine[3]), Character.valueOf(firstLine[104]));
    }

    private Loop storeData(LoopConfig currentLoopConfig, List<String> loopLines, Loop lastLoopStored, Separators separators) {
        this.validateLines(loopLines, currentLoopConfig.getLoopId(), separators);
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (String s : loopLines) {
            Segment seg = new Segment(separators);
            seg.addElements(s);
            segments.add(seg);
        }
        Loop newLoop = null;
        if (lastLoopStored == null) {
            Loop topLoop = this._dataLoops.get(this._dataLoops.size() - 1);
            topLoop.setId(currentLoopConfig.getLoopId());
            topLoop.setSeparators(separators);
            segments.forEach(topLoop::addSegment);
            newLoop = topLoop;
            this._childLoopTracker.put(newLoop.getId(), new ArrayList());
            this._childLoopTracker.get(newLoop.getId()).add(new HashSet());
        } else {
            Loop parentLoop = this.findParentLoop(currentLoopConfig, lastLoopStored);
            if (parentLoop == null) {
                LoopConfig parentLoopInfo = null;
                String parentLoopId = currentLoopConfig.getParentLoop();
                for (LoopConfig lc : this._config) {
                    if (lc.getLoopId() == null || !lc.getLoopId().equals(parentLoopId)) continue;
                    parentLoopInfo = lc;
                    break;
                }
                if (parentLoopInfo == null) {
                    this._fatalErrors.add("Parent loop " + parentLoopId + " does not exist in loop configuration!");
                } else if (parentLoopInfo.hasDataSegments()) {
                    this._fatalErrors.add("Parent loop " + parentLoopId + " is missing and should already exist");
                } else {
                    parentLoop = lastLoopStored.findTopParentById(parentLoopInfo.getParentLoop());
                    if (parentLoop == null) {
                        this._fatalErrors.add("Parent loop of " + parentLoopId + " is not found!");
                    } else {
                        newLoop = new Loop(separators, parentLoopInfo.getLoopId());
                        Loop currentLoop = new Loop(separators, currentLoopConfig.getLoopId());
                        segments.forEach(currentLoop::addSegment);
                        newLoop.addLoop(0, currentLoop);
                    }
                }
            } else {
                newLoop = new Loop(separators, currentLoopConfig.getLoopId());
                segments.forEach(newLoop::addSegment);
            }
            if (parentLoop != null) {
                parentLoop.addLoop(parentLoop.getLoops().size(), newLoop);
                if (!newLoop.getId().equals(currentLoopConfig.getLoopId())) {
                    this.updateChildLoopTracker(parentLoop.getId(), newLoop.getId());
                    this.updateChildLoopTracker(newLoop.getId(), newLoop.getLoop(0).getId());
                    newLoop = newLoop.getLoop(0);
                } else {
                    this.updateChildLoopTracker(parentLoop.getId(), newLoop.getId());
                }
            }
            if (parentLoop == null && this._fatalErrors.isEmpty()) {
                this._fatalErrors.add("Something is wrong. Check loop structure.");
            }
        }
        if (newLoop == null) {
            this._fatalErrors.add("Failed to store loop data for " + currentLoopConfig.getLoopId());
        }
        return newLoop;
    }

    private void updateChildLoopTracker(String parentLoopId, String newLoopId) {
        this._childLoopTracker.get(parentLoopId).get(this._childLoopTracker.get(parentLoopId).isEmpty() ? 0 : this._childLoopTracker.get(parentLoopId).size() - 1).add(newLoopId);
        if (!this._childLoopTracker.containsKey(newLoopId)) {
            this._childLoopTracker.put(newLoopId, new ArrayList());
            this._childLoopTracker.get(newLoopId).add(new HashSet());
        } else {
            this._childLoopTracker.get(newLoopId).add(new HashSet());
        }
    }

    private Loop findParentLoop(LoopConfig currentLoopConfig, Loop lastLoopStored) {
        Loop result;
        HashSet<String> parentLoopIds = new HashSet<String>(this.getParentLoopsFromDefinition(this._definition.getLoop(), currentLoopConfig.getLoopId(), new ArrayList<String>()));
        if (parentLoopIds.isEmpty()) {
            result = lastLoopStored;
        } else if (parentLoopIds.size() == 1) {
            result = lastLoopStored.getId().equals(currentLoopConfig.getParentLoop()) ? lastLoopStored : lastLoopStored.findTopParentById(currentLoopConfig.getParentLoop());
        } else {
            result = lastLoopStored;
            while (!parentLoopIds.contains(result.getId())) {
                if (result.getParent() == null) {
                    result = null;
                    break;
                }
                result = result.getParent();
            }
        }
        return result;
    }

    private void getLoopConfiguration(LoopDefinition loop, String parentID) {
        if (!this.containsLoop(loop.getXid())) {
            if (loop.getLoop() != null) {
                LoopConfig loopConfig = new LoopConfig(loop.getXid(), parentID, this.getChildLoops(loop), loop.getRepeat(), loop.getUsage(), loop.getSegment() != null);
                if (loop.getSegment() != null) {
                    loopConfig.setFirstSegmentXid(loop.getSegment().get(0));
                    if (loop.getSegment().size() > 1) {
                        loopConfig.setLastSegmentXid(loop.getSegment().get(loop.getSegment().size() - 1));
                    }
                }
                parentID = loop.getXid();
                this._config.add(loopConfig);
                for (LoopDefinition loops : loop.getLoop()) {
                    this.getLoopConfiguration(loops, parentID);
                }
            } else {
                LoopConfig loopConfig = new LoopConfig(loop.getXid(), parentID, null, loop.getRepeat(), loop.getUsage(), loop.getSegment() != null);
                if (loop.getSegment() != null) {
                    loopConfig.setFirstSegmentXid(loop.getSegment().get(0));
                }
                if (loop.getSegment() != null && loop.getSegment().size() > 1) {
                    loopConfig.setLastSegmentXid(loop.getSegment().get(loop.getSegment().size() - 1));
                }
                this._config.add(loopConfig);
            }
        }
    }

    private List<String> getChildLoops(LoopDefinition loop) {
        return loop.getLoop().stream().map(LoopDefinition::getXid).collect(Collectors.toList());
    }

    private boolean containsLoop(String id) {
        for (LoopConfig loop : this._config) {
            if (!loop.getLoopId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private String getParentLoop(String loopId, String previousLoopId) {
        List<String> parentLoops = new ArrayList<String>();
        List<String> previousParentLoops = new ArrayList<String>();
        parentLoops = this.getParentLoopsFromDefinition(this._definition.getLoop(), loopId, parentLoops);
        previousParentLoops = this.getParentLoopsFromDefinition(this._definition.getLoop(), previousLoopId, previousParentLoops);
        if (previousLoopId != null) {
            for (String parentLoop : parentLoops) {
                if (!previousParentLoops.contains(parentLoop)) continue;
                return parentLoop;
            }
        }
        if (!parentLoops.isEmpty()) {
            return parentLoops.get(0);
        }
        return null;
    }

    private List<String> getParentLoopsFromDefinition(LoopDefinition loop, String id, List<String> parentLoop) {
        if (loop.getLoop() != null) {
            for (LoopDefinition subloop : loop.getLoop()) {
                if (subloop.getXid().equals(id)) {
                    parentLoop.add(loop.getXid());
                }
                parentLoop = this.getParentLoopsFromDefinition(subloop, id, parentLoop);
            }
        }
        return parentLoop;
    }

    private void updateLoopCounts(String loopId) {
        this._config.stream().filter(config -> config.getLoopId().equals(loopId)).forEach(LoopConfig::incrementLoopRepeatCount);
    }

    private LoopConfig getMatchedLoop(String[] tokens, String previousLoopID) {
        LoopConfig result = null;
        if (tokens != null) {
            List<Object> matchedLoops = new ArrayList();
            for (LoopConfig config : this._config) {
                boolean lastIdCheck;
                SegmentDefinition firstId = config.getFirstSegmentXid();
                boolean firstIdCheck = firstId != null && tokens[0].equals(firstId.getXid()) && this.codesValidatedForLoopId(tokens, firstId);
                SegmentDefinition lastId = config.getLastSegmentXid();
                boolean bl = lastIdCheck = lastId != null && tokens[0].equals(lastId.getXid()) && !config.getLoopId().equals(previousLoopID) && this.codesValidatedForLoopId(tokens, lastId);
                if (!firstIdCheck && !lastIdCheck) continue;
                if (this.isChildSegment(previousLoopID, tokens)) {
                    matchedLoops.clear();
                    break;
                }
                if (matchedLoops.stream().map(LoopConfig::getLoopId).collect(Collectors.toList()).contains(config.getLoopId())) continue;
                matchedLoops.add(config);
            }
            if (matchedLoops.size() > 1) {
                result = (matchedLoops = matchedLoops.stream().filter(lc -> lc.getLastSegmentXid() == null || !lc.getLastSegmentXid().getXid().equals(tokens[0]) || !this.codesValidatedForLoopId(tokens, lc.getLastSegmentXid())).collect(Collectors.toList())).isEmpty() ? null : (matchedLoops.size() == 1 ? (LoopConfig)matchedLoops.get(0) : this.getFinalizedMatch(previousLoopID, matchedLoops));
            } else if (matchedLoops.size() == 1) {
                result = (LoopConfig)matchedLoops.get(0);
            }
        } else {
            this._errors.add("Unable to split elements for loop matching!");
        }
        return result;
    }

    private boolean isChildSegment(String previousLoopId, String[] tokens) {
        List<SegmentDefinition> loopSegs = this.getSegmentDefinitions(this._definition.getLoop(), previousLoopId);
        if (loopSegs != null) {
            for (int i = 1; i < loopSegs.size(); ++i) {
                SegmentDefinition seg = loopSegs.get(i);
                if (!seg.getXid().equals(tokens[0])) continue;
                return true;
            }
        }
        return false;
    }

    private LoopConfig getFinalizedMatch(String previousLoopId, List<LoopConfig> matchedLoops) {
        LoopConfig result = null;
        for (LoopConfig lc : this._config) {
            String parentLoop;
            if (!lc.getLoopId().equals(previousLoopId)) continue;
            if (lc.getChildList() != null) {
                result = matchedLoops.stream().filter(matchedLoop -> lc.getChildList().contains(matchedLoop.getLoopId())).findFirst().orElse(null);
            }
            if (result != null || (parentLoop = this.getParentLoop(previousLoopId, null)) == null) break;
            result = matchedLoops.stream().filter(matchedLoop -> parentLoop.equals(this.getParentLoop(matchedLoop.getLoopId(), null))).findFirst().orElse(null);
            break;
        }
        return result;
    }

    private boolean validateLines(List<String> segments, String loopId, Separators separators) {
        List<SegmentDefinition> format = this.getSegmentDefinitions(this._definition.getLoop(), loopId);
        int[] segmentCounter = new int[format.size()];
        boolean lineMatchesFormat = false;
        String previousPos = null;
        for (String segment : segments) {
            int i = 0;
            for (SegmentDefinition segmentConf : format) {
                String[] tokens = separators.splitElement(segment);
                if (tokens != null && tokens[0].equals(segmentConf.getXid()) && this.codesValidated(tokens, segmentConf)) {
                    String currentPos = segmentConf.getPos();
                    if (previousPos != null && Integer.parseInt(previousPos) > Integer.parseInt(currentPos)) {
                        this._errors.add("Segment " + segmentConf.getXid() + " in loop " + loopId + " is not in the correct position.");
                    }
                    int n = i;
                    segmentCounter[n] = segmentCounter[n] + 1;
                    lineMatchesFormat = true;
                    previousPos = currentPos;
                    break;
                }
                if (tokens == null) {
                    this._errors.add("Unable to split elements to validate segment ID!");
                }
                ++i;
            }
            if (!lineMatchesFormat) {
                this._errors.add("Unable to find a matching segment format in loop " + loopId);
            }
            lineMatchesFormat = false;
        }
        return this.validateSegments(segments, format, loopId, segmentCounter, separators);
    }

    private boolean codesValidatedForLoopId(String[] tokens, SegmentDefinition segmentConf) {
        Map<List<String>, Integer> validCodes = this.getValidCodes(segmentConf);
        List<Integer> requiredElements = this.getRequiredElementPositions(segmentConf);
        ArrayList<Integer> positions = new ArrayList<Integer>(validCodes.values());
        ArrayList<List<String>> codes = new ArrayList<List<String>>(validCodes.keySet());
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i] == null || tokens[i].isEmpty() || !positions.contains(i) || !requiredElements.contains(i) || ((List)codes.get(positions.indexOf(i))).contains(tokens[i])) continue;
            return false;
        }
        return true;
    }

    private boolean codesValidated(String[] tokens, SegmentDefinition segmentConf) {
        Map<List<String>, Integer> validCodes = this.getValidCodes(segmentConf);
        ArrayList<Integer> positions = new ArrayList<Integer>(validCodes.values());
        ArrayList<List<String>> codes = new ArrayList<List<String>>(validCodes.keySet());
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i] == null || tokens[i].isEmpty() || !positions.contains(i) || ((List)codes.get(positions.indexOf(i))).contains(tokens[i])) continue;
            return false;
        }
        return true;
    }

    private boolean validateSegments(List<String> segments, List<SegmentDefinition> format, String loopId, int[] segmentCounter, Separators separators) {
        int errorCountInitial = this._errors.size();
        for (int i = 0; i < format.size(); ++i) {
            SegmentDefinition segmentConf = format.get(i);
            if (!(this.checkUsage(segmentConf.getUsage(), segmentCounter[i]) || segmentConf.getXid().equals("IEA") || segmentConf.getXid().equals("GE") || segmentConf.getXid().equals("SE"))) {
                this._errors.add(segmentConf.getXid() + " in loop " + loopId + " is required but not found");
            }
            if (!this.checkRepeats(segmentConf.getMaxUse(), segmentCounter[i])) {
                this._errors.add(segmentConf.getXid() + " in loop " + loopId + " appears too many times");
            }
            for (String s : segments) {
                String[] tokens = separators.splitElement(s);
                if (tokens != null && segmentCounter[i] > 0 && tokens[0].equals(segmentConf.getXid())) {
                    this.checkRequiredElements(tokens, segmentConf, loopId);
                    this.checkRequiredComposites(tokens, segmentConf, loopId);
                    continue;
                }
                if (tokens != null) continue;
                this._errors.add("Unable to split elements for validation!");
            }
        }
        return this._errors.size() - errorCountInitial == 0;
    }

    private boolean checkUsage(TransactionDefinition.Usage usage, Integer count) {
        return !TransactionDefinition.Usage.REQUIRED.equals((Object)usage) || count > 0;
    }

    private boolean checkRepeats(String repeats, Integer count) {
        if (repeats.equals(">1") && count <= 0) {
            return false;
        }
        if (repeats.equals(">1")) {
            return true;
        }
        return count <= Integer.parseInt(repeats);
    }

    private boolean checkRequiredElements(String[] tokens, SegmentDefinition seg, String loopId) {
        for (int requiredPositions : this.getRequiredElementPositions(seg)) {
            if (requiredPositions >= tokens.length) {
                this._errors.add(seg.getXid() + " in loop " + loopId + " element at position " + requiredPositions + " does not exist!!!!");
                return false;
            }
            if (!tokens[requiredPositions].isEmpty()) continue;
            this._errors.add(seg.getXid() + " in loop " + loopId + " is missing a required element at " + requiredPositions);
            return false;
        }
        return true;
    }

    private boolean checkRequiredComposites(String[] tokens, SegmentDefinition seg, String loopId) {
        for (int requiredPositions : this.getRequiredCompositePositions(seg)) {
            if (requiredPositions >= tokens.length) {
                this._errors.add(seg.getXid() + " in loop " + loopId + " composite element at position " + requiredPositions + " does not exist!!!!");
                return false;
            }
            if (!tokens[requiredPositions].isEmpty()) continue;
            this._errors.add(seg.getXid() + " in loop " + loopId + " is missing a required composite element at " + requiredPositions);
            return false;
        }
        return true;
    }

    private boolean compareRepeats(int count, String repeatCondition, String parentId) {
        int parentCount = 1;
        for (LoopConfig lc : this._config) {
            if (!lc.getLoopId().equals(parentId)) continue;
            parentCount = lc.getLoopRepeatCount();
        }
        return repeatCondition.equals(">1") && count > 0 || !repeatCondition.contains(">") && Math.ceil((float)count / (float)parentCount) <= (double)Integer.parseInt(repeatCondition);
    }

    private List<SegmentDefinition> getSegmentDefinitions(LoopDefinition loop, String id) {
        List<SegmentDefinition> segs = new ArrayList<SegmentDefinition>();
        if (!loop.getXid().equals(id)) {
            if (loop.getLoop() != null) {
                LoopDefinition subloop;
                Iterator<LoopDefinition> iterator = loop.getLoop().iterator();
                while (iterator.hasNext() && (segs = this.getSegmentDefinitions(subloop = iterator.next(), id)) != null && segs.isEmpty()) {
                }
            }
        } else {
            return loop.getSegment();
        }
        return segs;
    }

    private Map<List<String>, Integer> getValidCodes(SegmentDefinition seg) {
        List<ElementDefinition> elems = seg.getElements();
        HashMap<List<String>, Integer> codePositionMap = new HashMap<List<String>, Integer>();
        if (elems != null) {
            for (ElementDefinition element : elems) {
                if (element.getValidCodes() == null || element.getValidCodes().getCodes() == null) continue;
                codePositionMap.put(element.getValidCodes().getCodes(), Integer.parseInt(element.getSeq()));
            }
        }
        return codePositionMap;
    }

    private List<Integer> getRequiredElementPositions(SegmentDefinition seg) {
        List<ElementDefinition> elems = seg.getElements();
        ArrayList<Integer> requiredPositions = new ArrayList<Integer>();
        if (elems != null) {
            for (ElementDefinition element : elems) {
                if (!TransactionDefinition.Usage.REQUIRED.equals((Object)element.getUsage())) continue;
                requiredPositions.add(Integer.parseInt(element.getSeq()));
            }
        }
        return requiredPositions;
    }

    private List<Integer> getRequiredCompositePositions(SegmentDefinition seg) {
        List<CompositeDefinition> composites = seg.getComposites();
        ArrayList<Integer> requiredPositions = new ArrayList<Integer>();
        if (composites != null) {
            for (CompositeDefinition comps : composites) {
                if (!comps.getUsage().equals("R")) continue;
                requiredPositions.add(Integer.parseInt(comps.getSeq()));
            }
        }
        return requiredPositions;
    }

    static {
        _TYPES.put(FileType.ANSI835_4010_X091, _X091_ANSI_VERSION);
        _TYPES.put(FileType.ANSI837_4010_X096, _X096_ANSI_VERSION);
        _TYPES.put(FileType.ANSI837_4010_X097, _X097_ANSI_VERSION);
        _TYPES.put(FileType.ANSI837_4010_X098, _X098_ANSI_VERSION);
        _TYPES.put(FileType.ANSI835_5010_X221, _X221_ANSI_VERSION);
        _TYPES.put(FileType.ANSI837_5010_X222, _X222_ANSI_VERSION);
        _TYPES.put(FileType.ANSI837_5010_X223, _X223_ANSI_VERSION);
        _TYPES.put(FileType.ANSI277_5010_X214, _X214_ANSI_VERSION);
        _TYPES.put(FileType.ANSI837_5010_X231, _X231_ANSI_VERSION);
        _TYPES.put(FileType.ANSI270_4010_X092, _X270_271_092_ANSI_VERSION);
        _TYPES.put(FileType.ANSI271_4010_X092, _X270_271_092_ANSI_VERSION);
        _TYPES.put(FileType.ANSI277_5010_X212, _X212_ANSI_VERSION);
    }

    public static enum FileType {
        ANSI835_5010_X221("mapping/835.5010.X221.A1.xml"),
        ANSI835_4010_X091("mapping/835.4010.X091.A1.xml"),
        ANSI837_4010_X096("mapping/837.4010.X096.A1.xml"),
        ANSI837_4010_X097("mapping/837.4010.X097.A1.xml"),
        ANSI837_4010_X098("mapping/837.4010.X098.A1.xml"),
        ANSI837_5010_X222("mapping/837.5010.X222.A1.xml"),
        ANSI837_5010_X223("mapping/837Q3.I.5010.X223.A1.xml"),
        ANSI837_5010_X231("mapping/999.5010.xml"),
        ANSI277_5010_X214("mapping/277.5010.X214.xml"),
        ANSI270_4010_X092("mapping/270.4010.X092.A1.xml"),
        ANSI271_4010_X092("mapping/271.4010.X092.A1.xml"),
        ANSI277_5010_X212("mapping/277.5010.X212.xml");

        private final String _mapping;
        private static final Map<String, TransactionDefinition> _DEFINITIONS;

        private FileType(String mapping) {
            this._mapping = mapping;
        }

        public synchronized TransactionDefinition getDefinition() {
            return _DEFINITIONS.computeIfAbsent(this._mapping, k -> {
                XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
                xstream.autodetectAnnotations(true);
                xstream.alias("transaction", TransactionDefinition.class);
                xstream.addPermission(NoTypePermission.NONE);
                xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.x12.**"}));
                return (TransactionDefinition)xstream.fromXML(Thread.currentThread().getContextClassLoader().getResourceAsStream(this._mapping));
            });
        }

        static {
            _DEFINITIONS = new HashMap<String, TransactionDefinition>();
        }
    }
}

