/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.x12.writer;

import com.imsweb.x12.LineBreak;
import com.imsweb.x12.Loop;
import com.imsweb.x12.Separators;
import com.imsweb.x12.mapping.TransactionDefinition;
import com.imsweb.x12.reader.X12Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class X12Writer {
    private final List<Loop> _dataLoops;
    private final Separators _separators;
    private final TransactionDefinition _definition;

    public X12Writer(X12Reader.FileType fileType, List<Loop> loops, Separators separators) {
        this._dataLoops = loops;
        this._definition = fileType.getDefinition();
        this._separators = separators;
    }

    public X12Writer(X12Reader.FileType fileType, List<Loop> loops) {
        this._dataLoops = loops;
        this._definition = fileType.getDefinition();
        this._separators = new Separators();
    }

    public X12Writer(X12Reader reader) {
        this._dataLoops = reader.getLoops();
        this._definition = reader.getDefinition();
        this._separators = reader.getSeparators();
    }

    public String toX12String() {
        return this.toX12String(LineBreak.NONE);
    }

    public String toX12String(LineBreak lineBreak) {
        this._separators.setLineBreak(lineBreak);
        return this.toX12StringImpl();
    }

    private String toX12StringImpl() {
        StringBuilder builder = new StringBuilder();
        for (Loop loop : this._dataLoops) {
            builder.append(loop.toX12String(this._definition.getLoop()));
            builder.append(this._separators.getLineBreak().getLineBreakString());
        }
        return builder.toString();
    }

    public String toHtml() {
        StringBuilder builder = new StringBuilder();
        for (Loop loop : this._dataLoops) {
            builder.append(loop.toHtml(this._definition.getLoop(), new ArrayList<String>()));
        }
        return builder.toString();
    }

    public List<Map<String, Object>> toListOfMap() {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        int idx = 0;
        for (Loop loop : this._dataLoops) {
            res.add(loop.toMap(this._definition.getLoop(), new ArrayList<String>(), idx, idx));
            ++idx;
        }
        return res;
    }
}

